"""
    Delphix API Gateway

    Delphix API Gateway API  # noqa: E501

    The version of the OpenAPI document: 1.0
    Contact: support@delphix.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from delphix.api.gateway.api_client import ApiClient, Endpoint as _Endpoint
from delphix.api.gateway.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from delphix.api.gateway.model.delete_vdb_parameters import DeleteVDBParameters
from delphix.api.gateway.model.delete_vdb_response import DeleteVDBResponse
from delphix.api.gateway.model.disable_vdb_parameters import DisableVDBParameters
from delphix.api.gateway.model.disable_vdb_response import DisableVDBResponse
from delphix.api.gateway.model.enable_vdb_parameters import EnableVDBParameters
from delphix.api.gateway.model.enable_vdb_response import EnableVDBResponse
from delphix.api.gateway.model.list_vdbs_response import ListVDBsResponse
from delphix.api.gateway.model.provision_vdbby_snapshot_parameters import ProvisionVDBBySnapshotParameters
from delphix.api.gateway.model.provision_vdbby_timestamp_parameters import ProvisionVDBByTimestampParameters
from delphix.api.gateway.model.provision_vdb_response import ProvisionVDBResponse
from delphix.api.gateway.model.refresh_vdbby_snapshot_parameters import RefreshVDBBySnapshotParameters
from delphix.api.gateway.model.refresh_vdbby_snapshot_response import RefreshVDBBySnapshotResponse
from delphix.api.gateway.model.refresh_vdbby_timestamp_parameters import RefreshVDBByTimestampParameters
from delphix.api.gateway.model.refresh_vdbby_timestamp_response import RefreshVDBByTimestampResponse
from delphix.api.gateway.model.rollback_vdbby_snapshot_parameters import RollbackVDBBySnapshotParameters
from delphix.api.gateway.model.rollback_vdbby_snapshot_response import RollbackVDBBySnapshotResponse
from delphix.api.gateway.model.rollback_vdbby_timestamp_parameters import RollbackVDBByTimestampParameters
from delphix.api.gateway.model.rollback_vdbby_timestamp_response import RollbackVDBByTimestampResponse
from delphix.api.gateway.model.start_vdb_response import StartVDBResponse
from delphix.api.gateway.model.stop_vdb_response import StopVDBResponse
from delphix.api.gateway.model.vdb import VDB


class VDBsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __delete_vdb(
            self,
            vdb_id,
            **kwargs
        ):
            """Delete a VDB.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_vdb(vdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_id (str): The ID of the VDB.

            Keyword Args:
                delete_vdb_parameters (DeleteVDBParameters): The parameters to delete a VDB.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DeleteVDBResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_id'] = \
                vdb_id
            return self.call_with_http_info(**kwargs)

        self.delete_vdb = _Endpoint(
            settings={
                'response_type': (DeleteVDBResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/{vdbId}/delete',
                'operation_id': 'delete_vdb',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_id',
                    'delete_vdb_parameters',
                ],
                'required': [
                    'vdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vdb_id':
                        (str,),
                    'delete_vdb_parameters':
                        (DeleteVDBParameters,),
                },
                'attribute_map': {
                    'vdb_id': 'vdbId',
                },
                'location_map': {
                    'vdb_id': 'path',
                    'delete_vdb_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__delete_vdb
        )

        def __disable_vdb(
            self,
            vdb_id,
            **kwargs
        ):
            """Disable a VDB.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.disable_vdb(vdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_id (str): The ID of the VDB.

            Keyword Args:
                disable_vdb_parameters (DisableVDBParameters): The parameters to disable a VDB.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                DisableVDBResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_id'] = \
                vdb_id
            return self.call_with_http_info(**kwargs)

        self.disable_vdb = _Endpoint(
            settings={
                'response_type': (DisableVDBResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/{vdbId}/disable',
                'operation_id': 'disable_vdb',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_id',
                    'disable_vdb_parameters',
                ],
                'required': [
                    'vdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vdb_id':
                        (str,),
                    'disable_vdb_parameters':
                        (DisableVDBParameters,),
                },
                'attribute_map': {
                    'vdb_id': 'vdbId',
                },
                'location_map': {
                    'vdb_id': 'path',
                    'disable_vdb_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__disable_vdb
        )

        def __enable_vdb(
            self,
            vdb_id,
            **kwargs
        ):
            """Enable a VDB.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.enable_vdb(vdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_id (str): The ID of the VDB.

            Keyword Args:
                enable_vdb_parameters (EnableVDBParameters): The parameters to enable a VDB.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                EnableVDBResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_id'] = \
                vdb_id
            return self.call_with_http_info(**kwargs)

        self.enable_vdb = _Endpoint(
            settings={
                'response_type': (EnableVDBResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/{vdbId}/enable',
                'operation_id': 'enable_vdb',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_id',
                    'enable_vdb_parameters',
                ],
                'required': [
                    'vdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vdb_id':
                        (str,),
                    'enable_vdb_parameters':
                        (EnableVDBParameters,),
                },
                'attribute_map': {
                    'vdb_id': 'vdbId',
                },
                'location_map': {
                    'vdb_id': 'path',
                    'enable_vdb_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__enable_vdb
        )

        def __get_vdb_by_id(
            self,
            vdb_id,
            **kwargs
        ):
            """Get a VDB by ID.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_vdb_by_id(vdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_id (str): The ID of the VDB.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                VDB
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_id'] = \
                vdb_id
            return self.call_with_http_info(**kwargs)

        self.get_vdb_by_id = _Endpoint(
            settings={
                'response_type': (VDB,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/{vdbId}',
                'operation_id': 'get_vdb_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_id',
                ],
                'required': [
                    'vdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vdb_id':
                        (str,),
                },
                'attribute_map': {
                    'vdb_id': 'vdbId',
                },
                'location_map': {
                    'vdb_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_vdb_by_id
        )

        def __get_vdbs(
            self,
            **kwargs
        ):
            """List all vdbs.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_vdbs(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListVDBsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_vdbs = _Endpoint(
            settings={
                'response_type': (ListVDBsResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs',
                'operation_id': 'get_vdbs',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_vdbs
        )

        def __provision_vdb_by_snapshot(
            self,
            provision_vdbby_snapshot_parameters,
            **kwargs
        ):
            """Provision a new VDB by snapshot.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.provision_vdb_by_snapshot(provision_vdbby_snapshot_parameters, async_req=True)
            >>> result = thread.get()

            Args:
                provision_vdbby_snapshot_parameters (ProvisionVDBBySnapshotParameters): The parameters to provision a VDB.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ProvisionVDBResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['provision_vdbby_snapshot_parameters'] = \
                provision_vdbby_snapshot_parameters
            return self.call_with_http_info(**kwargs)

        self.provision_vdb_by_snapshot = _Endpoint(
            settings={
                'response_type': (ProvisionVDBResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/provision_by_snapshot',
                'operation_id': 'provision_vdb_by_snapshot',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'provision_vdbby_snapshot_parameters',
                ],
                'required': [
                    'provision_vdbby_snapshot_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'provision_vdbby_snapshot_parameters':
                        (ProvisionVDBBySnapshotParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'provision_vdbby_snapshot_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__provision_vdb_by_snapshot
        )

        def __provision_vdb_by_timestamp(
            self,
            provision_vdbby_timestamp_parameters,
            **kwargs
        ):
            """Provision a new VDB by timestamp.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.provision_vdb_by_timestamp(provision_vdbby_timestamp_parameters, async_req=True)
            >>> result = thread.get()

            Args:
                provision_vdbby_timestamp_parameters (ProvisionVDBByTimestampParameters): The parameters to provision a VDB.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ProvisionVDBResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['provision_vdbby_timestamp_parameters'] = \
                provision_vdbby_timestamp_parameters
            return self.call_with_http_info(**kwargs)

        self.provision_vdb_by_timestamp = _Endpoint(
            settings={
                'response_type': (ProvisionVDBResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/provision_by_timestamp',
                'operation_id': 'provision_vdb_by_timestamp',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'provision_vdbby_timestamp_parameters',
                ],
                'required': [
                    'provision_vdbby_timestamp_parameters',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'provision_vdbby_timestamp_parameters':
                        (ProvisionVDBByTimestampParameters,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'provision_vdbby_timestamp_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__provision_vdb_by_timestamp
        )

        def __refresh_vdb_by_snapshot(
            self,
            vdb_id,
            **kwargs
        ):
            """Refresh a VDB by snapshot.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.refresh_vdb_by_snapshot(vdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_id (str): The ID of the VDB.

            Keyword Args:
                refresh_vdbby_snapshot_parameters (RefreshVDBBySnapshotParameters): The parameters to refresh a VDB.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RefreshVDBBySnapshotResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_id'] = \
                vdb_id
            return self.call_with_http_info(**kwargs)

        self.refresh_vdb_by_snapshot = _Endpoint(
            settings={
                'response_type': (RefreshVDBBySnapshotResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/{vdbId}/refresh_by_snapshot',
                'operation_id': 'refresh_vdb_by_snapshot',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_id',
                    'refresh_vdbby_snapshot_parameters',
                ],
                'required': [
                    'vdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vdb_id':
                        (str,),
                    'refresh_vdbby_snapshot_parameters':
                        (RefreshVDBBySnapshotParameters,),
                },
                'attribute_map': {
                    'vdb_id': 'vdbId',
                },
                'location_map': {
                    'vdb_id': 'path',
                    'refresh_vdbby_snapshot_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__refresh_vdb_by_snapshot
        )

        def __refresh_vdb_by_timestamp(
            self,
            vdb_id,
            **kwargs
        ):
            """Refresh a VDB by timestamp.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.refresh_vdb_by_timestamp(vdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_id (str): The ID of the VDB.

            Keyword Args:
                refresh_vdbby_timestamp_parameters (RefreshVDBByTimestampParameters): The parameters to refresh a VDB.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RefreshVDBByTimestampResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_id'] = \
                vdb_id
            return self.call_with_http_info(**kwargs)

        self.refresh_vdb_by_timestamp = _Endpoint(
            settings={
                'response_type': (RefreshVDBByTimestampResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/{vdbId}/refresh_by_timestamp',
                'operation_id': 'refresh_vdb_by_timestamp',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_id',
                    'refresh_vdbby_timestamp_parameters',
                ],
                'required': [
                    'vdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vdb_id':
                        (str,),
                    'refresh_vdbby_timestamp_parameters':
                        (RefreshVDBByTimestampParameters,),
                },
                'attribute_map': {
                    'vdb_id': 'vdbId',
                },
                'location_map': {
                    'vdb_id': 'path',
                    'refresh_vdbby_timestamp_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__refresh_vdb_by_timestamp
        )

        def __rollback_vdb_by_snapshot(
            self,
            vdb_id,
            **kwargs
        ):
            """Rollback a VDB by snapshot.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.rollback_vdb_by_snapshot(vdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_id (str): The ID of the VDB.

            Keyword Args:
                rollback_vdbby_snapshot_parameters (RollbackVDBBySnapshotParameters): The parameters to rollback a VDB.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RollbackVDBBySnapshotResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_id'] = \
                vdb_id
            return self.call_with_http_info(**kwargs)

        self.rollback_vdb_by_snapshot = _Endpoint(
            settings={
                'response_type': (RollbackVDBBySnapshotResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/{vdbId}/rollback_by_snapshot',
                'operation_id': 'rollback_vdb_by_snapshot',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_id',
                    'rollback_vdbby_snapshot_parameters',
                ],
                'required': [
                    'vdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vdb_id':
                        (str,),
                    'rollback_vdbby_snapshot_parameters':
                        (RollbackVDBBySnapshotParameters,),
                },
                'attribute_map': {
                    'vdb_id': 'vdbId',
                },
                'location_map': {
                    'vdb_id': 'path',
                    'rollback_vdbby_snapshot_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__rollback_vdb_by_snapshot
        )

        def __rollback_vdb_by_timestamp(
            self,
            vdb_id,
            **kwargs
        ):
            """Rollback a VDB by timestamp.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.rollback_vdb_by_timestamp(vdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_id (str): The ID of the VDB.

            Keyword Args:
                rollback_vdbby_timestamp_parameters (RollbackVDBByTimestampParameters): The parameters to rollback a VDB.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RollbackVDBByTimestampResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_id'] = \
                vdb_id
            return self.call_with_http_info(**kwargs)

        self.rollback_vdb_by_timestamp = _Endpoint(
            settings={
                'response_type': (RollbackVDBByTimestampResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/{vdbId}/rollback_by_timestamp',
                'operation_id': 'rollback_vdb_by_timestamp',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_id',
                    'rollback_vdbby_timestamp_parameters',
                ],
                'required': [
                    'vdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vdb_id':
                        (str,),
                    'rollback_vdbby_timestamp_parameters':
                        (RollbackVDBByTimestampParameters,),
                },
                'attribute_map': {
                    'vdb_id': 'vdbId',
                },
                'location_map': {
                    'vdb_id': 'path',
                    'rollback_vdbby_timestamp_parameters': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__rollback_vdb_by_timestamp
        )

        def __start_vdb(
            self,
            vdb_id,
            **kwargs
        ):
            """Start a VDB.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.start_vdb(vdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_id (str): The ID of the VDB.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StartVDBResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_id'] = \
                vdb_id
            return self.call_with_http_info(**kwargs)

        self.start_vdb = _Endpoint(
            settings={
                'response_type': (StartVDBResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/{vdbId}/start',
                'operation_id': 'start_vdb',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_id',
                ],
                'required': [
                    'vdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vdb_id':
                        (str,),
                },
                'attribute_map': {
                    'vdb_id': 'vdbId',
                },
                'location_map': {
                    'vdb_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__start_vdb
        )

        def __stop_vdb(
            self,
            vdb_id,
            **kwargs
        ):
            """Stop a VDB.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.stop_vdb(vdb_id, async_req=True)
            >>> result = thread.get()

            Args:
                vdb_id (str): The ID of the VDB.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                StopVDBResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vdb_id'] = \
                vdb_id
            return self.call_with_http_info(**kwargs)

        self.stop_vdb = _Endpoint(
            settings={
                'response_type': (StopVDBResponse,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/vdbs/{vdbId}/stop',
                'operation_id': 'stop_vdb',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'vdb_id',
                ],
                'required': [
                    'vdb_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'vdb_id',
                ]
            },
            root_map={
                'validations': {
                    ('vdb_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vdb_id':
                        (str,),
                },
                'attribute_map': {
                    'vdb_id': 'vdbId',
                },
                'location_map': {
                    'vdb_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__stop_vdb
        )
