"""
    Delphix API Gateway

    Delphix API Gateway API  # noqa: E501

    The version of the OpenAPI document: 1.0
    Contact: support@delphix.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from delphix.api.gateway.api_client import ApiClient, Endpoint as _Endpoint
from delphix.api.gateway.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from delphix.api.gateway.model.engine_registration_parameter import EngineRegistrationParameter
from delphix.api.gateway.model.hashicorp_vault import HashicorpVault
from delphix.api.gateway.model.registered_engine import RegisteredEngine
from delphix.api.gateway.model.registered_engine_user import RegisteredEngineUser


class ManagementApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __add_registered_engine_user(
            self,
            engine_id,
            **kwargs
        ):
            """Associate a new engine user to a registered engine.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_registered_engine_user(engine_id, async_req=True)
            >>> result = thread.get()

            Args:
                engine_id (int): Numeric ID of the registered engine.

            Keyword Args:
                registered_engine_user (RegisteredEngineUser): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RegisteredEngineUser
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['engine_id'] = \
                engine_id
            return self.call_with_http_info(**kwargs)

        self.add_registered_engine_user = _Endpoint(
            settings={
                'response_type': (RegisteredEngineUser,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/management/engines/{engineId}/users',
                'operation_id': 'add_registered_engine_user',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'engine_id',
                    'registered_engine_user',
                ],
                'required': [
                    'engine_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'engine_id',
                ]
            },
            root_map={
                'validations': {
                    ('engine_id',): {

                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'engine_id':
                        (int,),
                    'registered_engine_user':
                        (RegisteredEngineUser,),
                },
                'attribute_map': {
                    'engine_id': 'engineId',
                },
                'location_map': {
                    'engine_id': 'path',
                    'registered_engine_user': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__add_registered_engine_user
        )

        def __create_hashicorp_vault(
            self,
            hashicorp_vault,
            **kwargs
        ):
            """Configure a new Hashicorp Vault  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_hashicorp_vault(hashicorp_vault, async_req=True)
            >>> result = thread.get()

            Args:
                hashicorp_vault (HashicorpVault):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HashicorpVault
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hashicorp_vault'] = \
                hashicorp_vault
            return self.call_with_http_info(**kwargs)

        self.create_hashicorp_vault = _Endpoint(
            settings={
                'response_type': (HashicorpVault,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/management/vaults/hashicorp',
                'operation_id': 'create_hashicorp_vault',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hashicorp_vault',
                ],
                'required': [
                    'hashicorp_vault',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hashicorp_vault':
                        (HashicorpVault,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'hashicorp_vault': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_hashicorp_vault
        )

        def __delete_hashicorp_vault(
            self,
            vault_id,
            **kwargs
        ):
            """Delete a Hashicorp vault by id  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hashicorp_vault(vault_id, async_req=True)
            >>> result = thread.get()

            Args:
                vault_id (int): Numeric ID of the Hashicorp vault

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vault_id'] = \
                vault_id
            return self.call_with_http_info(**kwargs)

        self.delete_hashicorp_vault = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/management/vaults/hashicorp/{vaultId}',
                'operation_id': 'delete_hashicorp_vault',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'vault_id',
                ],
                'required': [
                    'vault_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vault_id':
                        (int,),
                },
                'attribute_map': {
                    'vault_id': 'vaultId',
                },
                'location_map': {
                    'vault_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_hashicorp_vault
        )

        def __delete_registered_engine_user(
            self,
            engine_id,
            user_id,
            **kwargs
        ):
            """Remove a user from the list of users associated to a registered engine.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_registered_engine_user(engine_id, user_id, async_req=True)
            >>> result = thread.get()

            Args:
                engine_id (int): Numeric ID of the registered engine.
                user_id (int): The ID of the registered engine user.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['engine_id'] = \
                engine_id
            kwargs['user_id'] = \
                user_id
            return self.call_with_http_info(**kwargs)

        self.delete_registered_engine_user = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/management/engines/{engineId}/users/{userId}',
                'operation_id': 'delete_registered_engine_user',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'engine_id',
                    'user_id',
                ],
                'required': [
                    'engine_id',
                    'user_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'engine_id',
                    'user_id',
                ]
            },
            root_map={
                'validations': {
                    ('engine_id',): {

                        'inclusive_minimum': 1,
                    },
                    ('user_id',): {

                        'min_length': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'engine_id':
                        (int,),
                    'user_id':
                        (int,),
                },
                'attribute_map': {
                    'engine_id': 'engineId',
                    'user_id': 'userId',
                },
                'location_map': {
                    'engine_id': 'path',
                    'user_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_registered_engine_user
        )

        def __get_hashicorp_vault(
            self,
            vault_id,
            **kwargs
        ):
            """Get a Hashicorp vault by id  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hashicorp_vault(vault_id, async_req=True)
            >>> result = thread.get()

            Args:
                vault_id (int): Numeric ID of the Hashicorp vault

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HashicorpVault
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['vault_id'] = \
                vault_id
            return self.call_with_http_info(**kwargs)

        self.get_hashicorp_vault = _Endpoint(
            settings={
                'response_type': (HashicorpVault,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/management/vaults/hashicorp/{vaultId}',
                'operation_id': 'get_hashicorp_vault',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'vault_id',
                ],
                'required': [
                    'vault_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'vault_id':
                        (int,),
                },
                'attribute_map': {
                    'vault_id': 'vaultId',
                },
                'location_map': {
                    'vault_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hashicorp_vault
        )

        def __get_hashicorp_vaults(
            self,
            **kwargs
        ):
            """Returns a list of configured Hashicorp vaults.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hashicorp_vaults(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                [HashicorpVault]
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_hashicorp_vaults = _Endpoint(
            settings={
                'response_type': ([HashicorpVault],),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/management/vaults/hashicorp',
                'operation_id': 'get_hashicorp_vaults',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hashicorp_vaults
        )

        def __get_registered_engine(
            self,
            engine_id,
            **kwargs
        ):
            """Returns a registered engine by ID.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_registered_engine(engine_id, async_req=True)
            >>> result = thread.get()

            Args:
                engine_id (int): Numeric ID of the registered engine.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RegisteredEngine
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['engine_id'] = \
                engine_id
            return self.call_with_http_info(**kwargs)

        self.get_registered_engine = _Endpoint(
            settings={
                'response_type': (RegisteredEngine,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/management/engines/{engineId}',
                'operation_id': 'get_registered_engine',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'engine_id',
                ],
                'required': [
                    'engine_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'engine_id',
                ]
            },
            root_map={
                'validations': {
                    ('engine_id',): {

                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'engine_id':
                        (int,),
                },
                'attribute_map': {
                    'engine_id': 'engineId',
                },
                'location_map': {
                    'engine_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_registered_engine
        )

        def __get_registered_engine_users(
            self,
            engine_id,
            **kwargs
        ):
            """Returns the list of users associated to an registered engine.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_registered_engine_users(engine_id, async_req=True)
            >>> result = thread.get()

            Args:
                engine_id (int): Numeric ID of the registered engine.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                [RegisteredEngineUser]
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['engine_id'] = \
                engine_id
            return self.call_with_http_info(**kwargs)

        self.get_registered_engine_users = _Endpoint(
            settings={
                'response_type': ([RegisteredEngineUser],),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/management/engines/{engineId}/users',
                'operation_id': 'get_registered_engine_users',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'engine_id',
                ],
                'required': [
                    'engine_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'engine_id',
                ]
            },
            root_map={
                'validations': {
                    ('engine_id',): {

                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'engine_id':
                        (int,),
                },
                'attribute_map': {
                    'engine_id': 'engineId',
                },
                'location_map': {
                    'engine_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_registered_engine_users
        )

        def __get_registered_engines(
            self,
            **kwargs
        ):
            """Returns a list of registered engines.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_registered_engines(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                [RegisteredEngine]
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_registered_engines = _Endpoint(
            settings={
                'response_type': ([RegisteredEngine],),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/management/engines',
                'operation_id': 'get_registered_engines',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                },
                'attribute_map': {
                },
                'location_map': {
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_registered_engines
        )

        def __register_engine(
            self,
            engine_registration_parameter,
            **kwargs
        ):
            """Register an engine.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.register_engine(engine_registration_parameter, async_req=True)
            >>> result = thread.get()

            Args:
                engine_registration_parameter (EngineRegistrationParameter): The parameters to register an engine.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RegisteredEngine
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['engine_registration_parameter'] = \
                engine_registration_parameter
            return self.call_with_http_info(**kwargs)

        self.register_engine = _Endpoint(
            settings={
                'response_type': (RegisteredEngine,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/management/engines',
                'operation_id': 'register_engine',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'engine_registration_parameter',
                ],
                'required': [
                    'engine_registration_parameter',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'engine_registration_parameter':
                        (EngineRegistrationParameter,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'engine_registration_parameter': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__register_engine
        )

        def __unregister_engine(
            self,
            engine_id,
            **kwargs
        ):
            """Unregister an engine.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.unregister_engine(engine_id, async_req=True)
            >>> result = thread.get()

            Args:
                engine_id (int): Numeric ID of the registered engine.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['engine_id'] = \
                engine_id
            return self.call_with_http_info(**kwargs)

        self.unregister_engine = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/management/engines/{engineId}',
                'operation_id': 'unregister_engine',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'engine_id',
                ],
                'required': [
                    'engine_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'engine_id',
                ]
            },
            root_map={
                'validations': {
                    ('engine_id',): {

                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'engine_id':
                        (int,),
                },
                'attribute_map': {
                    'engine_id': 'engineId',
                },
                'location_map': {
                    'engine_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client,
            callable=__unregister_engine
        )

        def __update_registered_engine(
            self,
            engine_id,
            registered_engine,
            **kwargs
        ):
            """Update a registered engine.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_registered_engine(engine_id, registered_engine, async_req=True)
            >>> result = thread.get()

            Args:
                engine_id (int): Numeric ID of the registered engine.
                registered_engine (RegisteredEngine): The updated registration engine information.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RegisteredEngine
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['engine_id'] = \
                engine_id
            kwargs['registered_engine'] = \
                registered_engine
            return self.call_with_http_info(**kwargs)

        self.update_registered_engine = _Endpoint(
            settings={
                'response_type': (RegisteredEngine,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/management/engines/{engineId}',
                'operation_id': 'update_registered_engine',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'engine_id',
                    'registered_engine',
                ],
                'required': [
                    'engine_id',
                    'registered_engine',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'engine_id',
                ]
            },
            root_map={
                'validations': {
                    ('engine_id',): {

                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'engine_id':
                        (int,),
                    'registered_engine':
                        (RegisteredEngine,),
                },
                'attribute_map': {
                    'engine_id': 'engineId',
                },
                'location_map': {
                    'engine_id': 'path',
                    'registered_engine': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_registered_engine
        )
