# delphix-api-gateway
Delphix API Gateway API

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0
- Package version: 1.0.6
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://support.delphix.com](https://support.delphix.com)

## Requirements.

Python >= 3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import delphix.api.gateway
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import delphix.api.gateway
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import delphix.api.gateway
from pprint import pprint
from delphix.api.gateway.api import api_clients_api
from delphix.api.gateway.model.api_client import ApiClient
from delphix.api.gateway.model.api_client_create_parameter import ApiClientCreateParameter
from delphix.api.gateway.model.api_client_create_response import ApiClientCreateResponse
# Defining the host is optional and defaults to http://localhost/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = delphix.api.gateway.Configuration(
    host = "http://localhost/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'


# Enter a context with an instance of the API client
with delphix.api.gateway.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = api_clients_api.ApiClientsApi(api_client)
    api_client_create_parameter = ApiClientCreateParameter(
        name="name_example",
        generate_api_key=True,
        api_client_id="api_client_id_example",
        is_admin=False,
        engine_users_mapping=[
            EngineUserMapping(
                engine_id=1,
                engine_user_id=1,
            ),
        ],
    ) # ApiClientCreateParameter | 

    try:
        # Create a new API Client. 
        api_response = api_instance.create_api_client(api_client_create_parameter)
        pprint(api_response)
    except delphix.api.gateway.ApiException as e:
        print("Exception when calling ApiClientsApi->create_api_client: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ApiClientsApi* | [**create_api_client**](docs/ApiClientsApi.md#create_api_client) | **POST** /management/api-clients | Create a new API Client. 
*ApiClientsApi* | [**delete_api_client**](docs/ApiClientsApi.md#delete_api_client) | **DELETE** /management/api-clients/{id} | Delete an API client
*ApiClientsApi* | [**get_api_client**](docs/ApiClientsApi.md#get_api_client) | **GET** /management/api-clients/{id} | Get an API client by id
*ApiClientsApi* | [**get_api_clients**](docs/ApiClientsApi.md#get_api_clients) | **GET** /management/api-clients | Returns a list of API clients.
*ApiClientsApi* | [**update_api_client**](docs/ApiClientsApi.md#update_api_client) | **PUT** /management/api-clients/{id} | Update an Api client. 
*BookmarksApi* | [**create_bookmark**](docs/BookmarksApi.md#create_bookmark) | **POST** /bookmarks | Create a bookmark at the current time.
*BookmarksApi* | [**delete_bookmark**](docs/BookmarksApi.md#delete_bookmark) | **DELETE** /bookmarks/{bookmarkId} | Delete a bookmark.
*BookmarksApi* | [**get_bookmark_by_id**](docs/BookmarksApi.md#get_bookmark_by_id) | **GET** /bookmarks/{bookmarkId} | Get a bookmark by ID.
*BookmarksApi* | [**get_bookmarks**](docs/BookmarksApi.md#get_bookmarks) | **GET** /bookmarks | List all bookmarks.
*BookmarksApi* | [**restore_bookmark**](docs/BookmarksApi.md#restore_bookmark) | **POST** /bookmarks/{bookmarkId}/restore | Restore VDBs to the bookmark creation time.
*DSourcesApi* | [**get_dsource_by_id**](docs/DSourcesApi.md#get_dsource_by_id) | **GET** /dsources/{dsourceId} | Get a dSource by ID.
*DSourcesApi* | [**get_dsources**](docs/DSourcesApi.md#get_dsources) | **GET** /dsources | List all dSources.
*EnginesApi* | [**get_engine_by_id**](docs/EnginesApi.md#get_engine_by_id) | **GET** /engines/{engineId} | Returns an engine by ID.
*EnginesApi* | [**get_engines**](docs/EnginesApi.md#get_engines) | **GET** /engines | List all engines.
*EnvironmentsApi* | [**get_environment_by_id**](docs/EnvironmentsApi.md#get_environment_by_id) | **GET** /environments/{environmentId} | Returns an environment by ID.
*EnvironmentsApi* | [**get_environments**](docs/EnvironmentsApi.md#get_environments) | **GET** /environments | List all environments.
*JobsApi* | [**get_job_by_id**](docs/JobsApi.md#get_job_by_id) | **GET** /jobs/{jobId} | Returns an job by ID.
*ManagementApi* | [**add_registered_engine_user**](docs/ManagementApi.md#add_registered_engine_user) | **POST** /management/engines/{engineId}/users | Associate a new engine user to a registered engine.
*ManagementApi* | [**create_hashicorp_vault**](docs/ManagementApi.md#create_hashicorp_vault) | **POST** /management/vaults/hashicorp | Configure a new Hashicorp Vault
*ManagementApi* | [**delete_hashicorp_vault**](docs/ManagementApi.md#delete_hashicorp_vault) | **DELETE** /management/vaults/hashicorp/{vaultId} | Delete a Hashicorp vault by id
*ManagementApi* | [**delete_registered_engine_user**](docs/ManagementApi.md#delete_registered_engine_user) | **DELETE** /management/engines/{engineId}/users/{userId} | Remove a user from the list of users associated to a registered engine.
*ManagementApi* | [**get_hashicorp_vault**](docs/ManagementApi.md#get_hashicorp_vault) | **GET** /management/vaults/hashicorp/{vaultId} | Get a Hashicorp vault by id
*ManagementApi* | [**get_hashicorp_vaults**](docs/ManagementApi.md#get_hashicorp_vaults) | **GET** /management/vaults/hashicorp | Returns a list of configured Hashicorp vaults.
*ManagementApi* | [**get_registered_engine**](docs/ManagementApi.md#get_registered_engine) | **GET** /management/engines/{engineId} | Returns a registered engine by ID.
*ManagementApi* | [**get_registered_engine_users**](docs/ManagementApi.md#get_registered_engine_users) | **GET** /management/engines/{engineId}/users | Returns the list of users associated to an registered engine.
*ManagementApi* | [**get_registered_engines**](docs/ManagementApi.md#get_registered_engines) | **GET** /management/engines | Returns a list of registered engines.
*ManagementApi* | [**register_engine**](docs/ManagementApi.md#register_engine) | **POST** /management/engines | Register an engine.
*ManagementApi* | [**unregister_engine**](docs/ManagementApi.md#unregister_engine) | **DELETE** /management/engines/{engineId} | Unregister an engine.
*ManagementApi* | [**update_registered_engine**](docs/ManagementApi.md#update_registered_engine) | **PUT** /management/engines/{engineId} | Update a registered engine.
*SnapshotsApi* | [**get_snapshot_by_id**](docs/SnapshotsApi.md#get_snapshot_by_id) | **GET** /snapshots/{snapshotId} | Get a Snapshot by ID.
*SnapshotsApi* | [**get_snapshots**](docs/SnapshotsApi.md#get_snapshots) | **GET** /snapshots | List Snapshots for a dSource or VDB.
*SourcesApi* | [**get_source_by_id**](docs/SourcesApi.md#get_source_by_id) | **GET** /sources/{sourceId} | Get a source by ID.
*SourcesApi* | [**get_sources**](docs/SourcesApi.md#get_sources) | **GET** /sources | List all sources.
*VDBsApi* | [**delete_vdb**](docs/VDBsApi.md#delete_vdb) | **POST** /vdbs/{vdbId}/delete | Delete a VDB.
*VDBsApi* | [**disable_vdb**](docs/VDBsApi.md#disable_vdb) | **POST** /vdbs/{vdbId}/disable | Disable a VDB.
*VDBsApi* | [**enable_vdb**](docs/VDBsApi.md#enable_vdb) | **POST** /vdbs/{vdbId}/enable | Enable a VDB.
*VDBsApi* | [**get_vdb_by_id**](docs/VDBsApi.md#get_vdb_by_id) | **GET** /vdbs/{vdbId} | Get a VDB by ID.
*VDBsApi* | [**get_vdbs**](docs/VDBsApi.md#get_vdbs) | **GET** /vdbs | List all vdbs.
*VDBsApi* | [**provision_vdb_by_snapshot**](docs/VDBsApi.md#provision_vdb_by_snapshot) | **POST** /vdbs/provision_by_snapshot | Provision a new VDB by snapshot.
*VDBsApi* | [**provision_vdb_by_timestamp**](docs/VDBsApi.md#provision_vdb_by_timestamp) | **POST** /vdbs/provision_by_timestamp | Provision a new VDB by timestamp.
*VDBsApi* | [**refresh_vdb_by_snapshot**](docs/VDBsApi.md#refresh_vdb_by_snapshot) | **POST** /vdbs/{vdbId}/refresh_by_snapshot | Refresh a VDB by snapshot.
*VDBsApi* | [**refresh_vdb_by_timestamp**](docs/VDBsApi.md#refresh_vdb_by_timestamp) | **POST** /vdbs/{vdbId}/refresh_by_timestamp | Refresh a VDB by timestamp.
*VDBsApi* | [**rollback_vdb_by_snapshot**](docs/VDBsApi.md#rollback_vdb_by_snapshot) | **POST** /vdbs/{vdbId}/rollback_by_snapshot | Rollback a VDB by snapshot.
*VDBsApi* | [**rollback_vdb_by_timestamp**](docs/VDBsApi.md#rollback_vdb_by_timestamp) | **POST** /vdbs/{vdbId}/rollback_by_timestamp | Rollback a VDB by timestamp.
*VDBsApi* | [**start_vdb**](docs/VDBsApi.md#start_vdb) | **POST** /vdbs/{vdbId}/start | Start a VDB.
*VDBsApi* | [**stop_vdb**](docs/VDBsApi.md#stop_vdb) | **POST** /vdbs/{vdbId}/stop | Stop a VDB.


## Documentation For Models

 - [ApiClient](docs/ApiClient.md)
 - [ApiClientCreateParameter](docs/ApiClientCreateParameter.md)
 - [ApiClientCreateResponse](docs/ApiClientCreateResponse.md)
 - [BaseProvisionVDBParameters](docs/BaseProvisionVDBParameters.md)
 - [Bookmark](docs/Bookmark.md)
 - [CreateBookmarkResponse](docs/CreateBookmarkResponse.md)
 - [DSource](docs/DSource.md)
 - [DataPointBySnapshotParameters](docs/DataPointBySnapshotParameters.md)
 - [DataPointByTimestampParameters](docs/DataPointByTimestampParameters.md)
 - [DeleteVDBParameters](docs/DeleteVDBParameters.md)
 - [DeleteVDBResponse](docs/DeleteVDBResponse.md)
 - [DisableVDBParameters](docs/DisableVDBParameters.md)
 - [DisableVDBResponse](docs/DisableVDBResponse.md)
 - [EnableVDBParameters](docs/EnableVDBParameters.md)
 - [EnableVDBResponse](docs/EnableVDBResponse.md)
 - [Engine](docs/Engine.md)
 - [EngineRegistrationParameter](docs/EngineRegistrationParameter.md)
 - [EngineUserMapping](docs/EngineUserMapping.md)
 - [Environment](docs/Environment.md)
 - [Error](docs/Error.md)
 - [Errors](docs/Errors.md)
 - [HashicorpVault](docs/HashicorpVault.md)
 - [Hook](docs/Hook.md)
 - [Host](docs/Host.md)
 - [Job](docs/Job.md)
 - [JobId](docs/JobId.md)
 - [ListBookmarksResponse](docs/ListBookmarksResponse.md)
 - [ListDSourcesResponse](docs/ListDSourcesResponse.md)
 - [ListEnginesResponse](docs/ListEnginesResponse.md)
 - [ListEnvironmentsResponse](docs/ListEnvironmentsResponse.md)
 - [ListSnaphotsResponse](docs/ListSnaphotsResponse.md)
 - [ListSourcesResponse](docs/ListSourcesResponse.md)
 - [ListVDBsResponse](docs/ListVDBsResponse.md)
 - [PaginatedResponseMetadata](docs/PaginatedResponseMetadata.md)
 - [ProvisionVDBBySnapshotParameters](docs/ProvisionVDBBySnapshotParameters.md)
 - [ProvisionVDBByTimestampParameters](docs/ProvisionVDBByTimestampParameters.md)
 - [ProvisionVDBByTimestampParametersAllOf](docs/ProvisionVDBByTimestampParametersAllOf.md)
 - [ProvisionVDBResponse](docs/ProvisionVDBResponse.md)
 - [RefreshVDBBySnapshotParameters](docs/RefreshVDBBySnapshotParameters.md)
 - [RefreshVDBBySnapshotResponse](docs/RefreshVDBBySnapshotResponse.md)
 - [RefreshVDBByTimestampParameters](docs/RefreshVDBByTimestampParameters.md)
 - [RefreshVDBByTimestampResponse](docs/RefreshVDBByTimestampResponse.md)
 - [RegisteredEngine](docs/RegisteredEngine.md)
 - [RegisteredEngineUser](docs/RegisteredEngineUser.md)
 - [RestoreBookmarkResponse](docs/RestoreBookmarkResponse.md)
 - [RollbackVDBBySnapshotParameters](docs/RollbackVDBBySnapshotParameters.md)
 - [RollbackVDBBySnapshotResponse](docs/RollbackVDBBySnapshotResponse.md)
 - [RollbackVDBByTimestampParameters](docs/RollbackVDBByTimestampParameters.md)
 - [RollbackVDBByTimestampResponse](docs/RollbackVDBByTimestampResponse.md)
 - [Snapshot](docs/Snapshot.md)
 - [Source](docs/Source.md)
 - [StartVDBResponse](docs/StartVDBResponse.md)
 - [StopVDBResponse](docs/StopVDBResponse.md)
 - [VDB](docs/VDB.md)


## Documentation For Authorization


## ApiKeyAuth

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Author

support@delphix.com


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in delphix.api.gateway.apis and delphix.api.gateway.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from delphix.api.gateway.api.default_api import DefaultApi`
- `from delphix.api.gateway.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import delphix.api.gateway
from delphix.api.gateway.apis import *
from delphix.api.gateway.models import *
```

