"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccessLogDeliveryBucket = exports.Suppress = void 0;
const s3 = require("@aws-cdk/aws-s3");
const cdk = require("@aws-cdk/core");
class Suppress {
    static bucket(construct, rulesToSuppress) {
        const cfnResource = construct === null || construct === void 0 ? void 0 : construct.node.defaultChild;
        cfnResource === null || cfnResource === void 0 ? void 0 : cfnResource.addMetadata('cdk_nag', { rules_to_suppress: rulesToSuppress });
    }
    static securityGroup(construct, rulesToSuppress) {
        const cfnResource = construct === null || construct === void 0 ? void 0 : construct.node.defaultChild;
        cfnResource === null || cfnResource === void 0 ? void 0 : cfnResource.addMetadata('cdk_nag', { rules_to_suppress: rulesToSuppress });
    }
    static iamPolicy(construct, rulesToSuppress) {
        const cfnResource = construct === null || construct === void 0 ? void 0 : construct.node.defaultChild;
        cfnResource === null || cfnResource === void 0 ? void 0 : cfnResource.addMetadata('cdk_nag', { rules_to_suppress: rulesToSuppress });
    }
}
exports.Suppress = Suppress;
/**
 * The generic access log and log delivery bucket.
 */
class AccessLogDeliveryBucket extends cdk.Construct {
    constructor(scope, id, props = {}) {
        var _a;
        super(scope, id);
        this.bucket = new s3.Bucket(this, id, {
            encryption: s3.BucketEncryption.S3_MANAGED,
            accessControl: s3.BucketAccessControl.LOG_DELIVERY_WRITE,
            serverAccessLogsPrefix: (_a = props.serverAccessLogsPrefix) !== null && _a !== void 0 ? _a : 'access-log-',
            blockPublicAccess: {
                blockPublicAcls: true,
                blockPublicPolicy: true,
                ignorePublicAcls: true,
                restrictPublicBuckets: true,
            },
        });
        Suppress.bucket(this.bucket, [
            { id: 'AwsSolutions-S1', reason: 'implicitly set current bucket as the acces log bucket' },
        ]);
    }
}
exports.AccessLogDeliveryBucket = AccessLogDeliveryBucket;
//# sourceMappingURL=data:application/json;base64,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