# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pyyoutube',
 'pyyoutube.models',
 'pyyoutube.utils',
 'tests',
 'tests.apis',
 'tests.models',
 'tests.utils']

package_data = \
{'': ['*']}

install_requires = \
['aiohttp>=3.8.0,<4.0.0',
 'dataclasses-json>=0.5.3,<0.6.0',
 'isodate>=0.6.0,<0.7.0',
 'requests-oauthlib>=1.3.0,<2.0.0',
 'requests>=2.24.0,<3.0.0']

setup_kwargs = {
    'name': 'python-youtube-async',
    'version': '0.8.1',
    'description': 'A Python wrapper around for YouTube Data API.',
    'long_description': 'Python YouTube\n\nA Python wrapper around for YouTube Data API V3.\n\n.. image:: https://github.com/niwla23/python-youtube-async/workflows/Test/badge.svg\n    :target: https://github.com/niwla23/python-youtube-async/actions\n\n.. image:: https://img.shields.io/badge/Docs-passing-brightgreen\n    :target: https://sns-sdks.github.io/python-youtube/\n    :alt: Documentation Status\n\n.. image:: https://codecov.io/gh/niwla23/python-youtube-async/branch/master/graph/badge.svg\n    :target: https://codecov.io/gh/niwla23/python-youtube-async\n\n.. image:: https://img.shields.io/pypi/v/python-youtube.svg\n    :target: https://img.shields.io/pypi/v/python-youtube\n\n======\nTHANKS\n======\n\nInspired by `Python-Twitter <https://github.com/bear/python-twitter>`_.\n\nThanks a lot for Python-Twitter Developers.\n\n============\nIntroduction\n============\n\nLibrary provides an easy way to use YouTube Data API V3.\n\n=============\nDocumentation\n=============\n\nYou can view the latest ``python-youtube-async`` documentation at: https://sns-sdks.github.io/python-youtube/.\n\nAlso view the full ``YouTube DATA API`` docs at: https://developers.google.com/youtube/v3/docs/.\n\n==========\nInstalling\n==========\n\nYou can install this lib from PyPI:\n\n.. code:: shell\n\n    pip install --upgrade python-youtube\n    # ✨🍰✨\n\n=====\nUsing\n=====\n\nThe API is exposed via the ``pyyoutube.Api`` class.\n\n-----------\nINSTANTIATE\n-----------\n\nThere provide two method to create instance the ``pyyoutube.Api``.\n\nYou can just initialize with an api key:\n\n.. code-block:: python\n\n    >>> from pyyoutube import Api\n    >>> api = Api(api_key="your api key")\n\nIf you want to get some authorization data. you need to initialize with an access token:\n\n.. code-block:: python\n\n    >>> from pyyoutube import Api\n    >>> api = Api(access_token=\'your api key\')\n\nYou can read the docs to see how to get an access token.\n\nOr you can ask for user to do oauth flow:\n\n.. code-block:: python\n\n    >>> from pyyoutube import Api\n    >>> api = Api(client_id="client key", client_secret="client secret")\n    # Get authorization url\n    >>> api.get_authorization_url()\n    (\'https://accounts.google.com/o/oauth2/v2/auth?response_type=code&client_id=id&redirect_uri=https%3A%2F%2Flocalhost%2F&scope=scope&state=PyYouTube&access_type=offline&prompt=select_account\', \'PyYouTube\')\n    # user to do\n    # copy the response url\n    >>> api.generate_access_token(authorization_response="link for response")\n    AccessToken(access_token=\'token\', expires_in=3599, token_type=\'Bearer\')\n\nNow you can use the instance to get data from YouTube.\n\n------------\nCHANNEL DATA\n------------\n\nThe library provides several ways to get channel\'s data.\n\nIf a channel is not found, the property ``items`` will return with blank list.\n\nYou can use channel id:\n\n.. code-block:: python\n\n    >>> channel_by_id = api.get_channel_info(channel_id="UC_x5XG1OV2P6uZZ5FSM9Ttw")\n    >>> channel_by_id.items\n    [Channel(kind=\'youtube#channel\', id=\'UC_x5XG1OV2P6uZZ5FSM9Ttw\')]\n    >>> channel_by_id.items[0].to_dict()\n    {\'kind\': \'youtube#channel\',\n     \'etag\': \'"j6xRRd8dTPVVptg711_CSPADRfg/AW8QEqbNRoIJv9KuzCIg0CG6aJA"\',\n     \'id\': \'UC_x5XG1OV2P6uZZ5FSM9Ttw\',\n     \'snippet\': {\'title\': \'Google Developers\',\n      \'description\': \'The Google Developers channel features talks from events, educational series, best practices, tips, and the latest updates across our products and platforms.\',\n      \'customUrl\': \'googlecode\',\n      \'publishedAt\': \'2007-08-23T00:34:43.000Z\',\n      \'thumbnails\': {\'default\': {\'url\': \'https://yt3.ggpht.com/a/AGF-l78iFtAxyRZcUBzG91kbKMES19z-zGW5KT20_g=s88-c-k-c0xffffffff-no-rj-mo\',\n        \'width\': 88,\n        \'height\': 88},\n       \'medium\': {\'url\': \'https://yt3.ggpht.com/a/AGF-l78iFtAxyRZcUBzG91kbKMES19z-zGW5KT20_g=s240-c-k-c0xffffffff-no-rj-mo\',\n        \'width\': 240,\n        \'height\': 240},\n       \'high\': {\'url\': \'https://yt3.ggpht.com/a/AGF-l78iFtAxyRZcUBzG91kbKMES19z-zGW5KT20_g=s800-c-k-c0xffffffff-no-rj-mo\',\n        \'width\': 800,\n        \'height\': 800},\n       \'standard\': None,\n       \'maxres\': None},\n      \'defaultLanguage\': None,\n      \'localized\': {\'title\': \'Google Developers\',\n       \'description\': \'The Google Developers channel features talks from events, educational series, best practices, tips, and the latest updates across our products and platforms.\'},\n      \'country\': \'US\'},\n      ...\n      }\n\nYou can pass a channel id with comma-separated id string or a list, tuple or set of ids to get multiple channels.\nMany methods also provide this functionality.\n\nwith ids:\n\n.. code-block:: python\n\n    >>> channel_by_ids = api.get_channel_info(channel_id="UC_x5XG1OV2P6uZZ5FSM9Ttw,UCa-vrCLQHviTOVnEKDOdetQ")\n    >>> channel_by_ids.items\n    [Channel(kind=\'youtube#channel\', id=\'UC_x5XG1OV2P6uZZ5FSM9Ttw\'),\n     Channel(kind=\'youtube#channel\', id=\'UCa-vrCLQHviTOVnEKDOdetQ\')]\n\nYou can also use channel name:\n\n.. code-block:: python\n\n    >>> channel_by_name = api.get_channel_info(channel_name="GoogleDevelopers")\n    >>> channel_by_name.items[0]\n    Channel(kind=\'youtube#channel\', id=\'UC_x5XG1OV2P6uZZ5FSM9Ttw\')\n\nIf you have authorized, you can get your channels:\n\n.. code-block:: python\n\n    >>> channel_by_mine = api_with_authorization.get_channel_info(mine=True)\n    >>> channel_by_mine.items[0]\n    Channel(kind=\'youtube#channel\', id=\'UCa-vrCLQHviTOVnEKDOdetQ\')\n\n.. note::\n    To get your channel, you must do authorization first, otherwise you will get an error.\n\n--------\nPLAYLIST\n--------\n\nThere are methods to get playlists by playlist id, channel id or get your own playlists.\n\nGet playlists by id:\n\n.. code-block:: python\n\n    >>> playlists_by_id = api.get_playlist_by_id(playlist_id="PLOU2XLYxmsIKpaV8h0AGE05so0fAwwfTw")\n    >>> playlists_by_id.items\n    [Playlist(kind=\'youtube#playlist\', id=\'PLOU2XLYxmsIKpaV8h0AGE05so0fAwwfTw\')]\n\nGet playlists by channel (If you want to get all of atarget channel\'s playlists, just provide the parameter ``count=None``):\n\n.. code-block:: python\n\n    >>> playlists_by_channel = api.get_playlists(channel_id="UC_x5XG1OV2P6uZZ5FSM9Ttw")\n    >>> playlists_by_channel.items\n    [Playlist(kind=\'youtube#playlist\', id=\'PLOU2XLYxmsIKpaV8h0AGE05so0fAwwfTw\'),\n     Playlist(kind=\'youtube#playlist\', id=\'PLOU2XLYxmsIJO83u2UmyC8ud41AvUnhgj\'),\n     Playlist(kind=\'youtube#playlist\', id=\'PLOU2XLYxmsILfV1LiUhDjbh1jkFjQWrYB\'),\n     Playlist(kind=\'youtube#playlist\', id=\'PLOU2XLYxmsIKNr3Wfhm8o0TSojW7hEPPY\'),\n     Playlist(kind=\'youtube#playlist\', id=\'PLOU2XLYxmsIJ8ItHmK4bRlY4GCzMgXLAJ\')]\n\nGet your playlists(this requires authorization):\n\n.. code:: python\n\n    playlists_by_mine = api.get_playlists(mine=True)\n\n-------------\nPLAYLIST ITEM\n-------------\n\nSimilarly, you can get playlist items by playlist item id or playlist id.\n\nGet playlist items by id:\n\n.. code-block:: python\n\n    >>> playlist_item_by_id = api.get_playlist_item_by_id(playlist_item_id="UExPVTJYTFl4bXNJS3BhVjhoMEFHRTA"\n    ...     "1c28wZkF3d2ZUdy41NkI0NEY2RDEwNTU3Q0M2")\n\n    >>> playlist_item_by_id.items\n    [PlaylistItem(kind=\'youtube#playlistItem\', id=\'UExPVTJYTFl4bXNJS3BhVjhoMEFHRTA1c28wZkF3d2ZUdy41NkI0NEY2RDEwNTU3Q0M2\')]\n\n\nGet playlist items by playlist id (If you want to get target playlist all items, just provide the parameter ``count=None``):\n\n.. code-block:: python\n\n    >>> playlist_item_by_playlist = api.get_playlist_items(playlist_id="PLOU2XLYxmsIKpaV8h0AGE05so0fAwwfTw", count=2)\n\n    >>> playlist_item_by_playlist.items\n    [PlaylistItem(kind=\'youtube#playlistItem\', id=\'UExPVTJYTFl4bXNJS3BhVjhoMEFHRTA1c28wZkF3d2ZUdy41NkI0NEY2RDEwNTU3Q0M2\'),\n     PlaylistItem(kind=\'youtube#playlistItem\', id=\'UExPVTJYTFl4bXNJS3BhVjhoMEFHRTA1c28wZkF3d2ZUdy4yODlGNEE0NkRGMEEzMEQy\')]\n    >>> playlist_item_by_id.items[0].snippet.resourceId\n    ResourceId(kind=\'youtube#video\', videoId=\'CvTApw9X8aA\')\n\n-----\nVIDEO\n-----\n\nYou can get a video\'s information by several methods.\n\nGet videos by video id(s):\n\n.. code-block:: python\n\n    >>> video_by_id = api.get_video_by_id(video_id="CvTApw9X8aA")\n\n    >>> video_by_id\n    VideoListResponse(kind=\'youtube#videoListResponse\')\n\n    >>> video_by_id.items\n    [Video(kind=\'youtube#video\', id=\'CvTApw9X8aA\')]\n\n\nGet videos by chart (If you want to get all videos, just provide the parameter ``count=None``):\n\n.. code-block:: python\n\n    >>> video_by_chart = api.get_videos_by_chart(chart="mostPopular", region_code="US", count=2)\n\n    >>> video_by_chart.items\n    [Video(kind=\'youtube#video\', id=\'RwnN2FVaHmw\'),\n     Video(kind=\'youtube#video\', id=\'hDeuSfo_Ys0\')]\n\n\nGet videos by your rating (this requires authorization, also if you want to get all videos, just provide the parameter ``count=None``):\n\n.. code:: python\n\n    videos_by_rating = api.get_videos_by_myrating(rating="like", count=2)\n\n--------------\nCOMMENT THREAD\n--------------\n\nYou can get comment thread information by id or some filter.\n\nGet comment thread by id(s):\n\n.. code-block:: python\n\n    >>> ct_by_id = api.get_comment_thread_by_id(comment_thread_id=\'Ugz097FRhsQy5CVhAjp4AaABAg,UgzhytyP79_Pwa\n    ... Dd4UB4AaABAg\')\n\n    >>> ct_by_id.items\n    [CommentThread(kind=\'youtube#commentThread\', id=\'Ugz097FRhsQy5CVhAjp4AaABAg\'),\n     CommentThread(kind=\'youtube#commentThread\', id=\'UgzhytyP79_PwaDd4UB4AaABAg\')]\n\nGet all comment threads related to a channel (including comment threads for the channel\'s video, also if you want to get all comment threads, just provide the parameter ``count=None``):\n\n.. code-block:: python\n\n    >>> ct_by_all = api.get_comment_threads(all_to_channel_id="UC_x5XG1OV2P6uZZ5FSM9Ttw", count=2)\n\n    >>> ct_by_all.items\n    [CommentThread(kind=\'youtube#commentThread\', id=\'UgwlB_Cza9WtzUWahYN4AaABAg\'),\n     CommentThread(kind=\'youtube#commentThread\', id=\'UgyvoQJ2LsxCBwGEpMB4AaABAg\')]\n\nGet comment threads only for the channel (If you want to get all comment threads, just provide the parameter ``count=None``):\n\n.. code-block:: python\n\n    >>> ct_by_channel = api.get_comment_threads(channel_id="UC_x5XG1OV2P6uZZ5FSM9Ttw", count=2)\n\n    >>> ct_by_channel.items\n    [CommentThread(kind=\'youtube#commentThread\', id=\'UgyUBI0HsgL9emxcZpR4AaABAg\'),\n     CommentThread(kind=\'youtube#commentThread\', id=\'Ugzi3lkqDPfIOirGFLh4AaABAg\')]\n\nGet comment threads only for the video (If you want to get all comment threads, just provide the parameter ``count=None``):\n\n.. code-block:: python\n\n    >>> ct_by_video = api.get_comment_threads(video_id="D-lhorsDlUQ", count=2)\n\n    >>> ct_by_video.items\n    [CommentThread(kind=\'youtube#commentThread\', id=\'UgydxWWoeA7F1OdqypJ4AaABAg\'),\n     CommentThread(kind=\'youtube#commentThread\', id=\'UgxKREWxIgDrw8w2e_Z4AaABAg\')]\n\n-------\nCOMMENT\n-------\n\nYou can get comment information by id or use the top-level comment id to get replies.\n\n.. note::\n    The reply has the same structure as a comment.\n\nGet comments by id(s):\n\n.. code-block:: python\n\n    >>> comment_by_id = api.get_comment_by_id(comment_id=\'UgxKREWxIgDrw8w2e_Z4AaABAg,UgyrVQaFfEdvaSzstj14Aa\n    ... ABAg\')\n\n    >>> comment_by_id.items\n    [Comment(kind=\'youtube#comment\', id=\'UgxKREWxIgDrw8w2e_Z4AaABAg\', snippet=CommentSnippet(authorDisplayName=\'Hieu Nguyen\', likeCount=0)),\n     Comment(kind=\'youtube#comment\', id=\'UgyrVQaFfEdvaSzstj14AaABAg\', snippet=CommentSnippet(authorDisplayName=\'Mani Kanta\', likeCount=0))]\n\nGet replies by comment id (If you want to get all comments, just provide the parameter ``count=None``):\n\n.. code-block:: python\n\n    >>> comment_by_parent = api.get_comments(parent_id="UgwYjZXfNCUTKPq9CZp4AaABAg")\n\n    >>> comment_by_parent.items\n    [Comment(kind=\'youtube#comment\', id=\'UgwYjZXfNCUTKPq9CZp4AaABAg.8yxhlQJogG18yz_cXK9Kcj\', snippet=CommentSnippet(authorDisplayName=\'Marlon López\', likeCount=0))]\n\n--------------\nVIDEO CATEGORY\n--------------\n\nYou can get video category with id or region.\n\nGet video categories with id(s):\n\n.. code-block:: python\n\n    >>> video_category_by_id = api.get_video_categories(category_id="17,18")\n\n    >>> video_category_by_id.items\n    [VideoCategory(kind=\'youtube#videoCategory\', id=\'17\'),\n     VideoCategory(kind=\'youtube#videoCategory\', id=\'18\')]\n\nGet video categories with region code:\n\n.. code-block:: python\n\n    >>> video_categories_by_region = api.get_video_categories(region_code="US")\n\n    >>> video_categories_by_region.items\n    [VideoCategory(kind=\'youtube#videoCategory\', id=\'1\'),\n     VideoCategory(kind=\'youtube#videoCategory\', id=\'2\'),\n     VideoCategory(kind=\'youtube#videoCategory\', id=\'10\'),\n     VideoCategory(kind=\'youtube#videoCategory\', id=\'15\'),\n     ...]\n\n-------------\nSUBSCRIPTIONS\n-------------\n\nYou can get subscription information by id, by point channel, or your own.\n\n.. note::\n    If you want to get the subscriptions not set to public, you need do authorization first and get the access token.\n    You can see the demo `A demo for get my subscription <examples/subscription.py>`_.\n\nTo get subscription info by id(s), this needs your token to have the permission for the subscriptions belonging to a channel or user:\n\n.. code-block:: python\n\n    >>> r = api.get_subscription_by_id(\n    ...         subscription_id=[\n    ...             "zqShTXi-2-Tx7TtwQqhCBwViE_j9IEgnmRmPnqJljxo",\n    ...             "zqShTXi-2-Rya5uUxEp3ZsPI3fZrFQnSXNQCwvHBGGo"])\n    >>> r\n    SubscriptionListResponse(kind=\'youtube#subscriptionListResponse\')\n    >>> r.items\n    [Subscription(kind=\'youtube#subscription\', id=\'zqShTXi-2-Tx7TtwQqhCBwViE_j9IEgnmRmPnqJljxo\', snippet=SubscriptionSnippet(title=\'PyCon 2015\', description=\'\')),\n     Subscription(kind=\'youtube#subscription\', id=\'zqShTXi-2-Rya5uUxEp3ZsPI3fZrFQnSXNQCwvHBGGo\', snippet=SubscriptionSnippet(title=\'ikaros-life\', description=\'This is a test channel.\'))]\n\nGet your own subscriptions, this need you do authorization first or give the authorized access token:\n\n.. code-block:: python\n\n    >>> r = api.get_subscription_by_me(\n    ...         mine=True,\n    ...         parts=["id", "snippet"],\n    ...         count=2\n    ... )\n    >>> r\n    SubscriptionListResponse(kind=\'youtube#subscriptionListResponse\')\n    >>> r.items\n    [Subscription(kind=\'youtube#subscription\', id=\'zqShTXi-2-Tx7TtwQqhCBwtJ-Aho6DZeutqZiP4Q79Q\', snippet=SubscriptionSnippet(title=\'Next Day Video\', description=\'\')),\n     Subscription(kind=\'youtube#subscription\', id=\'zqShTXi-2-Tx7TtwQqhCBwViE_j9IEgnmRmPnqJljxo\', snippet=SubscriptionSnippet(title=\'PyCon 2015\', description=\'\'))]\n\nGet public channel\'s subscriptions:\n\n.. code-block:: python\n\n    >>> r = api.get_subscription_by_channel(\n    ...      channel_id="UCAuUUnT6oDeKwE6v1NGQxug",\n    ...      parts="id,snippet",\n    ...      count=2\n    ... )\n    >>> r\n    SubscriptionListResponse(kind=\'youtube#subscriptionListResponse\')\n    >>> r.items\n    [Subscription(kind=\'youtube#subscription\', id=\'FMP3Mleijt-52zZDGkHtR5KhwkvCcdQKWWWIA1j5eGc\', snippet=SubscriptionSnippet(title=\'TEDx Talks\', description="TEDx is an international community that organizes TED-style events anywhere and everywhere -- celebrating locally-driven ideas and elevating them to a global stage. TEDx events are produced independently of TED conferences, each event curates speakers on their own, but based on TED\'s format and rules.\\n\\nFor more information on using TED for commercial purposes (e.g. employee learning, in a film, or in an online course), please submit a media request using the link below.")),\n     Subscription(kind=\'youtube#subscription\', id=\'FMP3Mleijt_ZKvy5M-HhRlsqI4wXY7VmP5g8lvmRhVU\', snippet=SubscriptionSnippet(title=\'TED Residency\', description=\'The TED Residency program is an incubator for breakthrough ideas. It is free and open to all via a semi-annual competitive application. Those chosen as TED Residents spend four months at TED headquarters in New York City, working on their idea. Selection criteria include the strength of their idea, their character, and their ability to bring a fresh perspective and positive contribution to the diverse TED community.\'))]\n\n\n----------\nACTIVITIES\n----------\n\nYou can get activities by channel id. You can also get your own activities after you have completed authorization.\n\nGet public channel activities:\n\n.. code-block:: python\n\n    >>> r = api.get_activities_by_channel(channel_id="UC_x5XG1OV2P6uZZ5FSM9Ttw", count=2)\n    >>> r\n    ActivityListResponse(kind=\'youtube#activityListResponse\')\n    >>> r.items\n    [Activity(kind=\'youtube#activity\', id=\'MTUxNTc3NzM2MDAyODIxOTQxNDM0NjAwMA==\', snippet=ActivitySnippet(title=\'2019 Year in Review - The Developer Show\', description=\'Here to bring you the latest developer news from across Google this year is Developer Advocate Timothy Jordan. In this last week of the year, we’re taking a look back at some of the coolest and biggest announcements we covered in 2019! \\n\\nFollow Google Developers on Instagram → https://goo.gle/googledevs\\n\\nWatch more #DevShow → https://goo.gle/GDevShow\\nSubscribe to Google Developers → https://goo.gle/developers\')),\n     Activity(kind=\'youtube#activity\', id=\'MTUxNTc3MTI4NzIzODIxOTQxNDM0NzI4MA==\', snippet=ActivitySnippet(title=\'GDE Promo - Lara Martin\', description=\'Meet Lara Martin, a Flutter/Dart Google Developers Expert and get inspired by her journey. Watch now for a preview of her story! #GDESpotlights #IncludedWithGoogle\\n\\nLearn about the GDE program → https://goo.gle/2qWOvAy\\n\\nGoogle Developers Experts → https://goo.gle/GDE\\nSubscribe to Google Developers → https://goo.gle/developers\'))]\n\n\nGet your activities:\n\n.. code-block:: python\n\n    >>> r = api_with_token.get_activities_by_me()\n    >>> r.items\n    [Activity(kind=\'youtube#activity\', id=\'MTUxNTc0OTk2MjI3NDE0MjYwMDY1NjAwODA=\', snippet=ActivitySnippet(title=\'华山日出\', description=\'冷冷的山头\')),\n     Activity(kind=\'youtube#activity\', id=\'MTUxNTc0OTk1OTAyNDE0MjYwMDY1NTc2NDg=\', snippet=ActivitySnippet(title=\'海上日出\', description=\'美美美\'))]\n\nGet your video captions:\n\n.. code-block:: python\n\n    >>> r = api.get_captions_by_video(video_id="oHR3wURdJ94", parts=["id", "snippet"])\n    >>> r\n    CaptionListResponse(kind=\'youtube#captionListResponse\')\n    >>> r.items\n    [Caption(kind=\'youtube#caption\', id=\'SwPOvp0r7kd9ttt_XhcHdZthMwXG7Z0I\', snippet=CaptionSnippet(videoId=\'oHR3wURdJ94\', lastUpdated=\'2020-01-14T09:40:49.981Z\')),\n     Caption(kind=\'youtube#caption\', id=\'fPMuDm722CIRcUAT3NTPQHQZJZJxt39kU7JvrHk8Kzs=\', snippet=CaptionSnippet(videoId=\'oHR3wURdJ94\', lastUpdated=\'2020-01-14T09:39:46.991Z\'))]\n\n\nIf you already have caption id(s), you can get video caption by id(s):\n\n.. code-block:: python\n\n    >>> r = api.get_captions_by_video(video_id="oHR3wURdJ94", parts=["id", "snippet"], caption_id="SwPOvp0r7kd9ttt_XhcHdZthMwXG7Z0I")\n    >>> r\n    CaptionListResponse(kind=\'youtube#captionListResponse\')\n    >>> r.items\n    [Caption(kind=\'youtube#caption\', id=\'SwPOvp0r7kd9ttt_XhcHdZthMwXG7Z0I\', snippet=CaptionSnippet(videoId=\'oHR3wURdJ94\', lastUpdated=\'2020-01-14T09:40:49.981Z\'))]\n\n----------------\nCHANNEL SECTIONS\n----------------\n\nYou can get channel sections by self id or belonged channel id or your own channel.\n\nGet channel sections by channel id:\n\n.. code-block:: python\n\n    >>> r = api.get_channel_sections_by_channel(channel_id="UC_x5XG1OV2P6uZZ5FSM9Ttw")\n    >>>> r\n    ChannelSectionResponse(kind=\'youtube#channelSectionListResponse\')\n    >>> r.items\n    [ChannelSection(kind=\'youtube#channelSection\', id=\'UC_x5XG1OV2P6uZZ5FSM9Ttw.e-Fk7vMPqLE\'),\n     ChannelSection(kind=\'youtube#channelSection\', id=\'UC_x5XG1OV2P6uZZ5FSM9Ttw.B8DTd9ZXJqM\'),\n     ChannelSection(kind=\'youtube#channelSection\', id=\'UC_x5XG1OV2P6uZZ5FSM9Ttw.MfvRjkWLxgk\'),\n     ChannelSection(kind=\'youtube#channelSection\', id=\'UC_x5XG1OV2P6uZZ5FSM9Ttw.fEjJOXRoWwg\'),\n     ChannelSection(kind=\'youtube#channelSection\', id=\'UC_x5XG1OV2P6uZZ5FSM9Ttw.PvTmxDBxtLs\'),\n     ChannelSection(kind=\'youtube#channelSection\', id=\'UC_x5XG1OV2P6uZZ5FSM9Ttw.pmcIOsL7s98\'),\n     ChannelSection(kind=\'youtube#channelSection\', id=\'UC_x5XG1OV2P6uZZ5FSM9Ttw.c3r3vYf9uD0\'),\n     ChannelSection(kind=\'youtube#channelSection\', id=\'UC_x5XG1OV2P6uZZ5FSM9Ttw.ZJpkBl-mXfM\'),\n     ChannelSection(kind=\'youtube#channelSection\', id=\'UC_x5XG1OV2P6uZZ5FSM9Ttw.9_wU0qhEPR8\'),\n     ChannelSection(kind=\'youtube#channelSection\', id=\'UC_x5XG1OV2P6uZZ5FSM9Ttw.npYvuMz0_es\')]\n\nGet authorized user\'s channel sections:\n\n.. code-block:: python\n\n    >>> r = api.get_channel_sections_by_channel(mine=True)\n    >>> r.items\n    [ChannelSection(kind=\'youtube#channelSection\', id=\'UCa-vrCLQHviTOVnEKDOdetQ.jNQXAC9IVRw\'),\n     ChannelSection(kind=\'youtube#channelSection\', id=\'UCa-vrCLQHviTOVnEKDOdetQ.LeAltgu_pbM\'),\n     ChannelSection(kind=\'youtube#channelSection\', id=\'UCa-vrCLQHviTOVnEKDOdetQ.nGzAI5pLbMY\')]\n\nGet channel section detail info by id:\n\n.. code-block:: python\n\n    >>> r = api.get_channel_section_by_id(section_id="UC_x5XG1OV2P6uZZ5FSM9Ttw.e-Fk7vMPqLE")\n    >>> r\n    ChannelSectionResponse(kind=\'youtube#channelSectionListResponse\')\n    >>> r1.items\n    [ChannelSection(kind=\'youtube#channelSection\', id=\'UC_x5XG1OV2P6uZZ5FSM9Ttw.e-Fk7vMPqLE\')]\n\n-------------\nI18N RESOURCE\n-------------\n\nYou can get a list of content regions that the YouTube website supports:\n\n.. code-block:: python\n\n    >>> r = api.get_i18n_regions(parts=["snippet"])\n    >>> r.items\n    [I18nRegion(kind=\'youtube#i18nRegion\', id=\'DZ\', snippet=I18nRegionSnippet(gl=\'DZ\', name=\'Algeria\')),\n     I18nRegion(kind=\'youtube#i18nRegion\', id=\'AR\', snippet=I18nRegionSnippet(gl=\'AR\', name=\'Argentina\')),\n     I18nRegion(kind=\'youtube#i18nRegion\', id=\'AU\', snippet=I18nRegionSnippet(gl=\'AU\', name=\'Australia\'))\n     ...]\n\nYou can get a list of application languages that the YouTube website supports:\n\n.. code-block:: python\n\n    >>> r = api.get_i18n_languages(parts=["snippet"])\n    >>> r.items\n    [I18nLanguage(kind=\'youtube#i18nLanguage\', id=\'af\', snippet=I18nLanguageSnippet(hl=\'af\', name=\'Afrikaans\')),\n     I18nLanguage(kind=\'youtube#i18nLanguage\', id=\'az\', snippet=I18nLanguageSnippet(hl=\'az\', name=\'Azerbaijani\')),\n     I18nLanguage(kind=\'youtube#i18nLanguage\', id=\'id\', snippet=I18nLanguageSnippet(hl=\'id\', name=\'Indonesian\')),\n     ...]\n\n\n-------\nMEMBER\n-------\n\nThe API request must be authorized by the channel owner.\n\nYou can retrieve a list of members (formerly known as "sponsors") for a channel:\n\n.. code-block:: python\n\n    >>> r = api_with_token.get_members(parts=["snippet"])\n    >>> r.items\n    [MemberListResponse(kind=\'youtube#memberListResponse\'),\n     MemberListResponse(kind=\'youtube#memberListResponse\')]\n\n\n----------------\nMEMBERSHIP LEVEL\n----------------\n\nThe API request must be authorized by the channel owner.\n\nYou can retrieve a list membership levels for a channel:\n\n.. code-block:: python\n\n    >>> r = api_with_token.get_membership_levels(parts=["snippet"])\n    >>> r.items\n    [MembershipsLevelListResponse(kind=\'youtube#membershipsLevelListResponse\'),\n     MembershipsLevelListResponse(kind=\'youtube#membershipsLevelListResponse\')]\n\n\n-------------------------\nVIDEO ABUSE REPORT REASON\n-------------------------\n\nYou can retrieve a list of reasons that can be used to report abusive videos:\n\n.. code-block:: python\n\n    >>> r = api_with_token.get_video_abuse_report_reason(parts=["snippet"])\n    >>> r.items\n    [VideoAbuseReportReason(kind=\'youtube#videoAbuseReportReason\'),\n     VideoAbuseReportReason(kind=\'youtube#videoAbuseReportReason\')]\n\n------\nSEARCH\n------\n\nYou can use those methods to search the video,playlist,channel data. For more info, you can see the `Search Request Docs <https://developers.google.com/youtube/v3/docs/search/list>`_ .\n\nYou can search different type of resource with keywords:\n\n.. code-block:: python\n\n    >>> r = api.search_by_keywords(q="surfing", search_type=["channel","video", "playlist"], count=5, limit=5)\n    >>> r.items\n    [SearchResult(kind=\'youtube#searchResult\'),\n     SearchResult(kind=\'youtube#searchResult\'),\n     SearchResult(kind=\'youtube#searchResult\'),\n     SearchResult(kind=\'youtube#searchResult\'),\n     SearchResult(kind=\'youtube#searchResult\')]\n\nYou can search your app send videos:\n\n.. code-block:: python\n\n    >>> r = api_with_token.search_by_developer(q="news", count=1)\n    >>> r.items\n    [SearchResult(kind=\'youtube#searchResult\')]\n\nYou can search your videos:\n\n.. code-block:: python\n\n    >>> r = api_with_token.search_by_mine(q="news", count=1)\n    >>> r.items\n    [SearchResult(kind=\'youtube#searchResult\')]\n\nOr you can build your request using the ``search`` method:\n\n.. code-block:: python\n\n    >>> r = api.search(\n    ...     location="21.5922529, -158.1147114",\n    ...     location_radius="10mi",\n    ...     q="surfing",\n    ...     parts=["snippet"],\n    ...     count=5,\n    ...     published_after="2020-02-01T00:00:00Z",\n    ...     published_before="2020-03-01T00:00:00Z",\n    ...     safe_search="moderate",\n    ...     search_type="video")\n    >>> r.items\n    [SearchResult(kind=\'youtube#searchResult\'),\n     SearchResult(kind=\'youtube#searchResult\'),\n     SearchResult(kind=\'youtube#searchResult\'),\n     SearchResult(kind=\'youtube#searchResult\'),\n     SearchResult(kind=\'youtube#searchResult\')]\n\n    >>> r = api.search(\n    ...     event_type="live",\n    ...     q="news",\n    ...     count=3,\n    ...     parts=["snippet"],\n    ...     search_type="video",\n    ...     topic_id="/m/09s1f",\n    ...     order="viewCount")\n    >>> r.items\n    [SearchResult(kind=\'youtube#searchResult\'),\n     SearchResult(kind=\'youtube#searchResult\'),\n     SearchResult(kind=\'youtube#searchResult\')]\n\n====\nTODO\n====\n\nThe following apis are now available:\n\n- OAuth Flow\n- Channel Info\n- Playlist Info\n- PlaylistItem Info\n- Video Info\n- Comment Thread Info\n- Comment Info\n- Video Categories Info\n- Subscriptions Info\n- Activities Info\n- Captions Info\n- Channel Sections Info\n- Search Requests and simple usage.\n- Members Info\n- Membership Level Info\n\nDoing\n\n- Update, Insert and so on.\n',
    'author': 'ikaroskun',
    'author_email': 'merle.liukun@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/niwla23/python-youtube-async',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
