"use strict";
/**
 *  Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DynamoDBStreamToLambdaToElasticSearchAndKibana = void 0;
const aws_dynamodb_stream_lambda_1 = require("@aws-solutions-constructs/aws-dynamodb-stream-lambda");
const aws_lambda_elasticsearch_kibana_1 = require("@aws-solutions-constructs/aws-lambda-elasticsearch-kibana");
const core_1 = require("@aws-cdk/core");
class DynamoDBStreamToLambdaToElasticSearchAndKibana extends core_1.Construct {
    /**
     * @summary Constructs a new instance of the LambdaToDynamoDB class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {DynamoDBStreamToLambdaToElasticSearchAndKibanaProps} props - user provided props for the construct
     * @since 0.8.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        const _props1 = {
            deployLambda: props.deployLambda,
            existingLambdaObj: props.existingLambdaObj,
            lambdaFunctionProps: props.lambdaFunctionProps,
            dynamoEventSourceProps: props.dynamoEventSourceProps,
            dynamoTableProps: props.dynamoTableProps,
            existingTableObj: props.existingTableObj
        };
        this.dynamoDBStreamToLambda = new aws_dynamodb_stream_lambda_1.DynamoDBStreamToLambda(this, 'DynamoDBStreamToLambda', _props1);
        this.lambdaFunction = this.dynamoDBStreamToLambda.lambdaFunction;
        const _props2 = {
            deployLambda: false,
            existingLambdaObj: this.lambdaFunction,
            domainName: props.domainName,
            esDomainProps: props.esDomainProps
        };
        this.lambdaToElasticSearchAndKibana = new aws_lambda_elasticsearch_kibana_1.LambdaToElasticSearchAndKibana(this, 'LambdaToElasticSearch', _props2);
        this.dynamoTable = this.dynamoDBStreamToLambda.dynamoTable;
        this.userPool = this.lambdaToElasticSearchAndKibana.userPool;
        this.userPoolClient = this.lambdaToElasticSearchAndKibana.userPoolClient;
        this.identityPool = this.lambdaToElasticSearchAndKibana.identityPool;
        this.elasticsearchDomain = this.lambdaToElasticSearchAndKibana.elasticsearchDomain;
        this.cloudwatchAlarms = this.lambdaToElasticSearchAndKibana.cloudwatchAlarms;
    }
}
exports.DynamoDBStreamToLambdaToElasticSearchAndKibana = DynamoDBStreamToLambdaToElasticSearchAndKibana;
//# sourceMappingURL=data:application/json;base64,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