# coding: utf8
#
# Copyright 2022 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-oracle-attach-source-parameters.json
#
# Do not edit this file manually!
#

from __future__ import unicode_literals

from delphixpy.v1_7_1.web.objects.AttachSourceParameters import AttachSourceParameters
from delphixpy.v1_7_1 import factory
from delphixpy.v1_7_1 import common

class __Undef(object):
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

try:
    TEXT_TYPE = unicode
except NameError:
    TEXT_TYPE = str

class OracleAttachSourceParameters(AttachSourceParameters):
    """
    *(extends* :py:class:`v1_7_1.web.vo.AttachSourceParameters` *)* Represents
    the Oracle specific parameters of an attach request.
    """
    def __init__(self, undef_enabled=True):
        super(OracleAttachSourceParameters, self).__init__()
        self._type = ("OracleAttachSourceParameters", True)
        self._allow_archivelog_not_found = (self.__undef__, True)
        self._allow_missing_resetlogs = (self.__undef__, True)
        self._allow_recreated_controlfile = (self.__undef__, True)
        self._db_credentials = (self.__undef__, True)
        self._db_user = (self.__undef__, True)
        self._double_sync = (self.__undef__, True)
        self._environment_user = (self.__undef__, True)
        self._link_now = (self.__undef__, True)
        self._source = (self.__undef__, True)

    API_VERSION = "1.7.1"

    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super(OracleAttachSourceParameters, cls).from_dict(data, dirty, undef_enabled)
        obj._allow_archivelog_not_found = (data.get("allowArchivelogNotFound", obj.__undef__), dirty)
        if obj._allow_archivelog_not_found[0] is not None and obj._allow_archivelog_not_found[0] is not obj.__undef__:
            assert isinstance(obj._allow_archivelog_not_found[0], bool), ("Expected one of ['boolean'], but got %s of type %s" % (obj._allow_archivelog_not_found[0], type(obj._allow_archivelog_not_found[0])))
            common.validate_format(obj._allow_archivelog_not_found[0], "None", None, None)
        obj._allow_missing_resetlogs = (data.get("allowMissingResetlogs", obj.__undef__), dirty)
        if obj._allow_missing_resetlogs[0] is not None and obj._allow_missing_resetlogs[0] is not obj.__undef__:
            assert isinstance(obj._allow_missing_resetlogs[0], bool), ("Expected one of ['boolean'], but got %s of type %s" % (obj._allow_missing_resetlogs[0], type(obj._allow_missing_resetlogs[0])))
            common.validate_format(obj._allow_missing_resetlogs[0], "None", None, None)
        obj._allow_recreated_controlfile = (data.get("allowRecreatedControlfile", obj.__undef__), dirty)
        if obj._allow_recreated_controlfile[0] is not None and obj._allow_recreated_controlfile[0] is not obj.__undef__:
            assert isinstance(obj._allow_recreated_controlfile[0], bool), ("Expected one of ['boolean'], but got %s of type %s" % (obj._allow_recreated_controlfile[0], type(obj._allow_recreated_controlfile[0])))
            common.validate_format(obj._allow_recreated_controlfile[0], "None", None, None)
        if "dbCredentials" not in data:
            raise ValueError("Missing required property \"dbCredentials\".")
        if "dbCredentials" in data and data["dbCredentials"] is not None:
            obj._db_credentials = (factory.create_object(data["dbCredentials"], "PasswordCredential"), dirty)
            factory.validate_type(obj._db_credentials[0], "PasswordCredential")
        else:
            obj._db_credentials = (obj.__undef__, dirty)
        if "dbUser" not in data:
            raise ValueError("Missing required property \"dbUser\".")
        obj._db_user = (data.get("dbUser", obj.__undef__), dirty)
        if obj._db_user[0] is not None and obj._db_user[0] is not obj.__undef__:
            assert isinstance(obj._db_user[0], TEXT_TYPE), ("Expected one of ['string'], but got %s of type %s" % (obj._db_user[0], type(obj._db_user[0])))
            common.validate_format(obj._db_user[0], "None", None, None)
        obj._double_sync = (data.get("doubleSync", obj.__undef__), dirty)
        if obj._double_sync[0] is not None and obj._double_sync[0] is not obj.__undef__:
            assert isinstance(obj._double_sync[0], bool), ("Expected one of ['boolean'], but got %s of type %s" % (obj._double_sync[0], type(obj._double_sync[0])))
            common.validate_format(obj._double_sync[0], "None", None, None)
        if "environmentUser" not in data:
            raise ValueError("Missing required property \"environmentUser\".")
        obj._environment_user = (data.get("environmentUser", obj.__undef__), dirty)
        if obj._environment_user[0] is not None and obj._environment_user[0] is not obj.__undef__:
            assert isinstance(obj._environment_user[0], TEXT_TYPE), ("Expected one of ['string'], but got %s of type %s" % (obj._environment_user[0], type(obj._environment_user[0])))
            common.validate_format(obj._environment_user[0], "objectReference", None, None)
        obj._link_now = (data.get("linkNow", obj.__undef__), dirty)
        if obj._link_now[0] is not None and obj._link_now[0] is not obj.__undef__:
            assert isinstance(obj._link_now[0], bool), ("Expected one of ['boolean'], but got %s of type %s" % (obj._link_now[0], type(obj._link_now[0])))
            common.validate_format(obj._link_now[0], "None", None, None)
        if "source" not in data:
            raise ValueError("Missing required property \"source\".")
        if "source" in data and data["source"] is not None:
            obj._source = (factory.create_object(data["source"], "OracleLinkedSource"), dirty)
            factory.validate_type(obj._source[0], "OracleLinkedSource")
        else:
            obj._source = (obj.__undef__, dirty)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super(OracleAttachSourceParameters, self).to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "allow_archivelog_not_found" == "type" or (self.allow_archivelog_not_found is not self.__undef__ and (not (dirty and not self._allow_archivelog_not_found[1]) or isinstance(self.allow_archivelog_not_found, list) or belongs_to_parent)):
            dct["allowArchivelogNotFound"] = dictify(self.allow_archivelog_not_found)
        elif belongs_to_parent and self.allow_archivelog_not_found is self.__undef__:
            dct["allowArchivelogNotFound"] = False
        if "allow_missing_resetlogs" == "type" or (self.allow_missing_resetlogs is not self.__undef__ and (not (dirty and not self._allow_missing_resetlogs[1]) or isinstance(self.allow_missing_resetlogs, list) or belongs_to_parent)):
            dct["allowMissingResetlogs"] = dictify(self.allow_missing_resetlogs)
        elif belongs_to_parent and self.allow_missing_resetlogs is self.__undef__:
            dct["allowMissingResetlogs"] = False
        if "allow_recreated_controlfile" == "type" or (self.allow_recreated_controlfile is not self.__undef__ and (not (dirty and not self._allow_recreated_controlfile[1]) or isinstance(self.allow_recreated_controlfile, list) or belongs_to_parent)):
            dct["allowRecreatedControlfile"] = dictify(self.allow_recreated_controlfile)
        elif belongs_to_parent and self.allow_recreated_controlfile is self.__undef__:
            dct["allowRecreatedControlfile"] = False
        if "db_credentials" == "type" or (self.db_credentials is not self.__undef__ and (not (dirty and not self._db_credentials[1]) or isinstance(self.db_credentials, list) or belongs_to_parent)):
            dct["dbCredentials"] = dictify(self.db_credentials, prop_is_list_or_vo=True)
        if "db_user" == "type" or (self.db_user is not self.__undef__ and (not (dirty and not self._db_user[1]) or isinstance(self.db_user, list) or belongs_to_parent)):
            dct["dbUser"] = dictify(self.db_user)
        if "double_sync" == "type" or (self.double_sync is not self.__undef__ and (not (dirty and not self._double_sync[1]) or isinstance(self.double_sync, list) or belongs_to_parent)):
            dct["doubleSync"] = dictify(self.double_sync)
        elif belongs_to_parent and self.double_sync is self.__undef__:
            dct["doubleSync"] = False
        if "environment_user" == "type" or (self.environment_user is not self.__undef__ and (not (dirty and not self._environment_user[1]) or isinstance(self.environment_user, list) or belongs_to_parent)):
            dct["environmentUser"] = dictify(self.environment_user)
        if "link_now" == "type" or (self.link_now is not self.__undef__ and (not (dirty and not self._link_now[1]) or isinstance(self.link_now, list) or belongs_to_parent)):
            dct["linkNow"] = dictify(self.link_now)
        if "source" == "type" or (self.source is not self.__undef__ and (not (dirty and not self._source[1]) or isinstance(self.source, list) or belongs_to_parent)):
            dct["source"] = dictify(self.source, prop_is_list_or_vo=True)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._allow_archivelog_not_found = (self._allow_archivelog_not_found[0], True)
        self._allow_missing_resetlogs = (self._allow_missing_resetlogs[0], True)
        self._allow_recreated_controlfile = (self._allow_recreated_controlfile[0], True)
        self._db_credentials = (self._db_credentials[0], True)
        self._db_user = (self._db_user[0], True)
        self._double_sync = (self._double_sync[0], True)
        self._environment_user = (self._environment_user[0], True)
        self._link_now = (self._link_now[0], True)
        self._source = (self._source[0], True)

    def is_dirty(self):
        return any([self._allow_archivelog_not_found[1], self._allow_missing_resetlogs[1], self._allow_recreated_controlfile[1], self._db_credentials[1], self._db_user[1], self._double_sync[1], self._environment_user[1], self._link_now[1], self._source[1]])

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, OracleAttachSourceParameters):
            return False
        return super(OracleAttachSourceParameters, self).__eq__(other) and \
               self.allow_archivelog_not_found == other.allow_archivelog_not_found and \
               self.allow_missing_resetlogs == other.allow_missing_resetlogs and \
               self.allow_recreated_controlfile == other.allow_recreated_controlfile and \
               self.db_credentials == other.db_credentials and \
               self.db_user == other.db_user and \
               self.double_sync == other.double_sync and \
               self.environment_user == other.environment_user and \
               self.link_now == other.link_now and \
               self.source == other.source

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def allow_archivelog_not_found(self):
        """
        True if attach should succeed even if the last archived log of the
        original database is not found in the current controlfile, as long as
        the database SCN is ahead of the SCN of the last archived log. Use this
        option with extreme caution. Attached database must be the same
        database to avoid data corruption later on.

        :rtype: ``bool``
        """
        return self._allow_archivelog_not_found[0]

    @allow_archivelog_not_found.setter
    def allow_archivelog_not_found(self, value):
        self._allow_archivelog_not_found = (value, True)

    @property
    def allow_missing_resetlogs(self):
        """
        True if attach should succeed even if the resetlogs of the original
        database does not match the resetlogs of the new database, the
        resetlogs information of the original database is not a parent
        incarnation of the current resetlogs because the controlfile has been
        recreated and the incarnation table is incomplete. As the controfile
        has been recreated, the creation time should also not match and
        allowRecreatedControlfile=true must be also used, otherwise this option
        is ignored. Use this option with extreme caution. Attached database
        must be the same database to avoid data corruption later on.

        :rtype: ``bool``
        """
        return self._allow_missing_resetlogs[0]

    @allow_missing_resetlogs.setter
    def allow_missing_resetlogs(self, value):
        self._allow_missing_resetlogs = (value, True)

    @property
    def allow_recreated_controlfile(self):
        """
        True if attach should succeed even if the creation time of the original
        database does not match the creation time of the new database. This
        parameter is necessary when the controlfile has been recreated. Use
        this option with extreme caution. Attached database must be the same
        database to avoid data corruption later on.

        :rtype: ``bool``
        """
        return self._allow_recreated_controlfile[0]

    @allow_recreated_controlfile.setter
    def allow_recreated_controlfile(self, value):
        self._allow_recreated_controlfile = (value, True)

    @property
    def db_credentials(self):
        """
        The password for the DB user.

        :rtype: :py:class:`v1_7_1.web.vo.PasswordCredential`
        """
        return self._db_credentials[0]

    @db_credentials.setter
    def db_credentials(self, value):
        self._db_credentials = (value, True)

    @property
    def db_user(self):
        """
        The name of the DB user.

        :rtype: ``TEXT_TYPE``
        """
        return self._db_user[0]

    @db_user.setter
    def db_user(self, value):
        self._db_user = (value, True)

    @property
    def double_sync(self):
        """
        True if two SnapSyncs should be performed in immediate succession to
        reduce the number of logs required to provision the snapshot. This may
        significantly reduce the time necessary to provision from a snapshot.

        :rtype: ``bool``
        """
        return self._double_sync[0]

    @double_sync.setter
    def double_sync(self, value):
        self._double_sync = (value, True)

    @property
    def environment_user(self):
        """
        Information about the os user to use for attaching source.

        :rtype: ``TEXT_TYPE``
        """
        return self._environment_user[0]

    @environment_user.setter
    def environment_user(self, value):
        self._environment_user = (value, True)

    @property
    def link_now(self):
        """
        True if snapshot should be performed after attach is completed.

        :rtype: ``bool``
        """
        return self._link_now[0]

    @link_now.setter
    def link_now(self, value):
        self._link_now = (value, True)

    @property
    def source(self):
        """
        Source to link the container to. This must reference an existing source
        config.

        :rtype: :py:class:`v1_7_1.web.vo.OracleLinkedSource`
        """
        return self._source[0]

    @source.setter
    def source(self, value):
        self._source = (value, True)

