# coding: utf8
#
# Copyright 2022 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-locale-settings.json
#
# Do not edit this file manually!
#

from __future__ import unicode_literals

from delphixpy.v1_6_2.web.objects.UserObject import UserObject
from delphixpy.v1_6_2 import common

class __Undef(object):
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

try:
    TEXT_TYPE = unicode
except NameError:
    TEXT_TYPE = str

class LocaleSettings(UserObject):
    """
    *(extends* :py:class:`v1_6_2.web.vo.UserObject` *)* Global locale settings.
    """
    def __init__(self, undef_enabled=True):
        super(LocaleSettings, self).__init__()
        self._type = ("LocaleSettings", True)
        self._locale = (self.__undef__, True)

    API_VERSION = "1.6.2"

    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super(LocaleSettings, cls).from_dict(data, dirty, undef_enabled)
        obj._locale = (data.get("locale", obj.__undef__), dirty)
        if obj._locale[0] is not None and obj._locale[0] is not obj.__undef__:
            assert isinstance(obj._locale[0], TEXT_TYPE), ("Expected one of ['string'], but got %s of type %s" % (obj._locale[0], type(obj._locale[0])))
            common.validate_format(obj._locale[0], "locale", None, None)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super(LocaleSettings, self).to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "locale" == "type" or (self.locale is not self.__undef__ and (not (dirty and not self._locale[1]) or isinstance(self.locale, list) or belongs_to_parent)):
            dct["locale"] = dictify(self.locale)
        elif belongs_to_parent and self.locale is self.__undef__:
            dct["locale"] = "en-US"
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._locale = (self._locale[0], True)

    def is_dirty(self):
        return any([self._locale[1]])

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, LocaleSettings):
            return False
        return super(LocaleSettings, self).__eq__(other) and \
               self.locale == other.locale

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def locale(self):
        """
        *(default value: en-US)* System default locale as an IETF BCP 47
        language tag, defaults to 'en-US'.

        :rtype: ``TEXT_TYPE``
        """
        return self._locale[0]

    @locale.setter
    def locale(self, value):
        self._locale = (value, True)

