# coding: utf8
#
# Copyright 2022 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-container.json
#
# Do not edit this file manually!
#

from __future__ import unicode_literals

from delphixpy.v1_4_0.web.objects.NamedUserObject import NamedUserObject
from delphixpy.v1_4_0 import factory
from delphixpy.v1_4_0 import common

class __Undef(object):
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

try:
    TEXT_TYPE = unicode
except NameError:
    TEXT_TYPE = str

class Container(NamedUserObject):
    """
    *(extends* :py:class:`v1_4_0.web.vo.NamedUserObject` *)* A container
    holding data.
    """
    def __init__(self, undef_enabled=True):
        super(Container, self).__init__()
        self._type = ("Container", True)
        self._current_timeflow = (self.__undef__, True)
        self._description = (self.__undef__, True)
        self._group = (self.__undef__, True)
        self._masked = (self.__undef__, True)
        self._performance_mode = (self.__undef__, True)
        self._provision_container = (self.__undef__, True)
        self._runtime = (self.__undef__, True)

    API_VERSION = "1.4.0"

    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super(Container, cls).from_dict(data, dirty, undef_enabled)
        obj._current_timeflow = (data.get("currentTimeflow", obj.__undef__), dirty)
        if obj._current_timeflow[0] is not None and obj._current_timeflow[0] is not obj.__undef__:
            assert isinstance(obj._current_timeflow[0], TEXT_TYPE), ("Expected one of ['string'], but got %s of type %s" % (obj._current_timeflow[0], type(obj._current_timeflow[0])))
            common.validate_format(obj._current_timeflow[0], "objectReference", None, None)
        obj._description = (data.get("description", obj.__undef__), dirty)
        if obj._description[0] is not None and obj._description[0] is not obj.__undef__:
            assert isinstance(obj._description[0], TEXT_TYPE), ("Expected one of ['string'], but got %s of type %s" % (obj._description[0], type(obj._description[0])))
            common.validate_format(obj._description[0], "None", None, 1024)
        obj._group = (data.get("group", obj.__undef__), dirty)
        if obj._group[0] is not None and obj._group[0] is not obj.__undef__:
            assert isinstance(obj._group[0], TEXT_TYPE), ("Expected one of ['string'], but got %s of type %s" % (obj._group[0], type(obj._group[0])))
            common.validate_format(obj._group[0], "objectReference", None, None)
        obj._masked = (data.get("masked", obj.__undef__), dirty)
        if obj._masked[0] is not None and obj._masked[0] is not obj.__undef__:
            assert isinstance(obj._masked[0], bool), ("Expected one of ['boolean'], but got %s of type %s" % (obj._masked[0], type(obj._masked[0])))
            common.validate_format(obj._masked[0], "None", None, None)
        obj._performance_mode = (data.get("performanceMode", obj.__undef__), dirty)
        if obj._performance_mode[0] is not None and obj._performance_mode[0] is not obj.__undef__:
            assert isinstance(obj._performance_mode[0], bool), ("Expected one of ['boolean'], but got %s of type %s" % (obj._performance_mode[0], type(obj._performance_mode[0])))
            common.validate_format(obj._performance_mode[0], "None", None, None)
        obj._provision_container = (data.get("provisionContainer", obj.__undef__), dirty)
        if obj._provision_container[0] is not None and obj._provision_container[0] is not obj.__undef__:
            assert isinstance(obj._provision_container[0], TEXT_TYPE), ("Expected one of ['string'], but got %s of type %s" % (obj._provision_container[0], type(obj._provision_container[0])))
            common.validate_format(obj._provision_container[0], "objectReference", None, None)
        if "runtime" in data and data["runtime"] is not None:
            obj._runtime = (factory.create_object(data["runtime"], "DBContainerRuntime"), dirty)
            factory.validate_type(obj._runtime[0], "DBContainerRuntime")
        else:
            obj._runtime = (obj.__undef__, dirty)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super(Container, self).to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "current_timeflow" == "type" or (self.current_timeflow is not self.__undef__ and (not (dirty and not self._current_timeflow[1]))):
            dct["currentTimeflow"] = dictify(self.current_timeflow)
        if "description" == "type" or (self.description is not self.__undef__ and (not (dirty and not self._description[1]) or isinstance(self.description, list) or belongs_to_parent)):
            dct["description"] = dictify(self.description)
        if "group" == "type" or (self.group is not self.__undef__ and (not (dirty and not self._group[1]) or isinstance(self.group, list) or belongs_to_parent)):
            dct["group"] = dictify(self.group)
        if "masked" == "type" or (self.masked is not self.__undef__ and (not (dirty and not self._masked[1]) or isinstance(self.masked, list) or belongs_to_parent)):
            dct["masked"] = dictify(self.masked)
        if "performance_mode" == "type" or (self.performance_mode is not self.__undef__ and (not (dirty and not self._performance_mode[1]) or isinstance(self.performance_mode, list) or belongs_to_parent)):
            dct["performanceMode"] = dictify(self.performance_mode)
        if "provision_container" == "type" or (self.provision_container is not self.__undef__ and (not (dirty and not self._provision_container[1]))):
            dct["provisionContainer"] = dictify(self.provision_container)
        if "runtime" == "type" or (self.runtime is not self.__undef__ and (not (dirty and not self._runtime[1]))):
            dct["runtime"] = dictify(self.runtime)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._current_timeflow = (self._current_timeflow[0], True)
        self._description = (self._description[0], True)
        self._group = (self._group[0], True)
        self._masked = (self._masked[0], True)
        self._performance_mode = (self._performance_mode[0], True)
        self._provision_container = (self._provision_container[0], True)
        self._runtime = (self._runtime[0], True)

    def is_dirty(self):
        return any([self._current_timeflow[1], self._description[1], self._group[1], self._masked[1], self._performance_mode[1], self._provision_container[1], self._runtime[1]])

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, Container):
            return False
        return super(Container, self).__eq__(other) and \
               self.current_timeflow == other.current_timeflow and \
               self.description == other.description and \
               self.group == other.group and \
               self.masked == other.masked and \
               self.performance_mode == other.performance_mode and \
               self.provision_container == other.provision_container and \
               self.runtime == other.runtime

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def current_timeflow(self):
        """
        A reference to the currently active timeflow for this container.

        :rtype: ``TEXT_TYPE``
        """
        return self._current_timeflow[0]

    @current_timeflow.setter
    def current_timeflow(self, value):
        self._current_timeflow = (value, True)

    @property
    def description(self):
        """
        Optional user-provided description for the container.

        :rtype: ``TEXT_TYPE``
        """
        return self._description[0]

    @description.setter
    def description(self, value):
        self._description = (value, True)

    @property
    def group(self):
        """
        A reference to the group containing this container.

        :rtype: ``TEXT_TYPE``
        """
        return self._group[0]

    @group.setter
    def group(self, value):
        self._group = (value, True)

    @property
    def masked(self):
        """
        Whether this container has the masked bit set.

        :rtype: ``bool``
        """
        return self._masked[0]

    @masked.setter
    def masked(self, value):
        self._masked = (value, True)

    @property
    def performance_mode(self):
        """
        Whether to enable high performance mode.

        :rtype: ``bool``
        """
        return self._performance_mode[0]

    @performance_mode.setter
    def performance_mode(self, value):
        self._performance_mode = (value, True)

    @property
    def provision_container(self):
        """
        A reference to the container this container was provisioned from.

        :rtype: ``TEXT_TYPE``
        """
        return self._provision_container[0]

    @provision_container.setter
    def provision_container(self, value):
        self._provision_container = (value, True)

    @property
    def runtime(self):
        """
        Runtime properties of this container.

        :rtype: :py:class:`v1_4_0.web.vo.DBContainerRuntime`
        """
        return self._runtime[0]

    @runtime.setter
    def runtime(self, value):
        self._runtime = (value, True)

