# Pybashrc file. Create your command-line accessible python functions here.
def _hidden_print_function(*args):
	"""This function will be ignored by pybashrc, and will not be available from the
	command line.

	However, other functions can still use it.
	"""
	print(args)


def test_pybashrc(first_argument: str, second_argument: str = "second_argument"):
	"""Default test function that simply prints its input arguments. This only serves as
	an example of how to define pybashrc functions.

	Arguments:
		- first_argument (str): The first argument.
		- second_argument (str): The second argument, which has a default value.
	"""
	_hidden_print_function("This is the pybash default test function.")
	_hidden_print_function(f"Provided arguments: {first_argument}, {second_argument}")


def custom_function(param):
	print("Hell yeah boii")




# THE CODE BELOW IS GENERATED BY PYBASHRC
import inspect
import os
from pathlib import Path

_INSTALL_DIR = Path(os.environ["PYBASHRC_INSTALL_DIR"])

_FUNCTIONS = {
	k: v
	for (k, v) in locals().items()
	if not k.startswith("_") and inspect.isfunction(v)
}


def _get_function_info(func):
	string = f"{func.__name__}{inspect.signature(func)}"
	if func.__doc__:
		string += f"\n	{func.__doc__}"
	return string


def _update_aliases():
	aliases = (_INSTALL_DIR / "alias_template").read_text()
	for name in _FUNCTIONS.keys():
		aliases += f"alias {name}='pybash {name}'\n"
	(_INSTALL_DIR / ".pybashrc_aliases").write_text(aliases)


if __name__ == "__main__":
	import sys

	if len(sys.argv) < 2:
		print("Available functions:")
		for function in _FUNCTIONS.values():
			print(f"- {_get_function_info(function)}")
		exit(0)

	name = sys.argv[1]

	# System command not intended to be accessed by the user
	if name == "_update_aliases":
		_update_aliases()
		exit(0)

	# Parse arguments and keyword arguments
	args = []
	kwargs = {}
	for arg in sys.argv[2:]:
		if "=" in arg:
			key, value = arg.split("=")
			kwargs[key] = value
		else:
			args.append(arg)

	if name in _FUNCTIONS.keys():
		_FUNCTIONS[name](*args, **kwargs)
	else:
		raise ValueError(f"pybashrc received unknown function name {name}!")
