import * as s3 from '@aws-cdk/aws-s3';
import * as cdk from '@aws-cdk/core';
interface ruleToSuppress {
    readonly id: string;
    readonly reason: string;
}
export declare class Suppress {
    static bucket(construct: cdk.Construct, rulesToSuppress: ruleToSuppress[]): void;
    static securityGroup(construct: cdk.Construct, rulesToSuppress: ruleToSuppress[]): void;
    static iamPolicy(construct: cdk.Construct, rulesToSuppress: ruleToSuppress[]): void;
}
export interface BucketProps {
    readonly serverAccessLogsPrefix?: string;
}
/**
 * The generic access log and log delivery bucket.
 */
export declare class AccessLogDeliveryBucket extends cdk.Construct {
    readonly bucket: s3.Bucket;
    constructor(scope: cdk.Construct, id: string, props?: BucketProps);
}
export {};
