# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, StrictBool, StrictFloat, StrictInt, StrictStr

class ManagedAccountUpdateRequest(BaseModel):
    """
    ManagedAccountUpdateRequest
    """
    account_number: Optional[StrictStr] = None
    apr: Optional[Union[StrictFloat, StrictInt]] = None
    apy: Optional[Union[StrictFloat, StrictInt]] = None
    available_balance: Optional[Union[StrictFloat, StrictInt]] = None
    available_credit: Optional[Union[StrictFloat, StrictInt]] = None
    balance: Optional[Union[StrictFloat, StrictInt]] = None
    cash_surrender_value: Optional[Union[StrictFloat, StrictInt]] = None
    credit_limit: Optional[Union[StrictFloat, StrictInt]] = None
    currency_code: Optional[StrictStr] = None
    day_payment_is_due: Optional[StrictInt] = None
    death_benefit: Optional[StrictInt] = None
    id: Optional[StrictStr] = None
    interest_rate: Optional[Union[StrictFloat, StrictInt]] = None
    is_closed: Optional[StrictBool] = None
    is_hidden: Optional[StrictBool] = None
    last_payment: Optional[Union[StrictFloat, StrictInt]] = None
    last_payment_at: Optional[StrictStr] = None
    loan_amount: Optional[Union[StrictFloat, StrictInt]] = None
    matures_on: Optional[StrictStr] = None
    metadata: Optional[StrictStr] = None
    minimum_balance: Optional[Union[StrictFloat, StrictInt]] = None
    minimum_payment: Optional[Union[StrictFloat, StrictInt]] = None
    name: Optional[StrictStr] = None
    nickname: Optional[StrictStr] = None
    original_balance: Optional[Union[StrictFloat, StrictInt]] = None
    payment_due_at: Optional[StrictStr] = None
    payoff_balance: Optional[Union[StrictFloat, StrictInt]] = None
    routing_number: Optional[StrictStr] = None
    started_on: Optional[StrictStr] = None
    subtype: Optional[StrictStr] = None
    type: Optional[StrictStr] = None
    __properties = ["account_number", "apr", "apy", "available_balance", "available_credit", "balance", "cash_surrender_value", "credit_limit", "currency_code", "day_payment_is_due", "death_benefit", "id", "interest_rate", "is_closed", "is_hidden", "last_payment", "last_payment_at", "loan_amount", "matures_on", "metadata", "minimum_balance", "minimum_payment", "name", "nickname", "original_balance", "payment_due_at", "payoff_balance", "routing_number", "started_on", "subtype", "type"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ManagedAccountUpdateRequest:
        """Create an instance of ManagedAccountUpdateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ManagedAccountUpdateRequest:
        """Create an instance of ManagedAccountUpdateRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ManagedAccountUpdateRequest.parse_obj(obj)

        _obj = ManagedAccountUpdateRequest.parse_obj({
            "account_number": obj.get("account_number"),
            "apr": obj.get("apr"),
            "apy": obj.get("apy"),
            "available_balance": obj.get("available_balance"),
            "available_credit": obj.get("available_credit"),
            "balance": obj.get("balance"),
            "cash_surrender_value": obj.get("cash_surrender_value"),
            "credit_limit": obj.get("credit_limit"),
            "currency_code": obj.get("currency_code"),
            "day_payment_is_due": obj.get("day_payment_is_due"),
            "death_benefit": obj.get("death_benefit"),
            "id": obj.get("id"),
            "interest_rate": obj.get("interest_rate"),
            "is_closed": obj.get("is_closed"),
            "is_hidden": obj.get("is_hidden"),
            "last_payment": obj.get("last_payment"),
            "last_payment_at": obj.get("last_payment_at"),
            "loan_amount": obj.get("loan_amount"),
            "matures_on": obj.get("matures_on"),
            "metadata": obj.get("metadata"),
            "minimum_balance": obj.get("minimum_balance"),
            "minimum_payment": obj.get("minimum_payment"),
            "name": obj.get("name"),
            "nickname": obj.get("nickname"),
            "original_balance": obj.get("original_balance"),
            "payment_due_at": obj.get("payment_due_at"),
            "payoff_balance": obj.get("payoff_balance"),
            "routing_number": obj.get("routing_number"),
            "started_on": obj.get("started_on"),
            "subtype": obj.get("subtype"),
            "type": obj.get("type")
        })
        return _obj


