# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, StrictInt, StrictStr

class CredentialResponse(BaseModel):
    """
    CredentialResponse
    """
    display_order: Optional[StrictInt] = None
    field_name: Optional[StrictStr] = None
    field_type: Optional[StrictStr] = None
    guid: Optional[StrictStr] = None
    label: Optional[StrictStr] = None
    type: Optional[StrictStr] = None
    __properties = ["display_order", "field_name", "field_type", "guid", "label", "type"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CredentialResponse:
        """Create an instance of CredentialResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if display_order (nullable) is None
        # and __fields_set__ contains the field
        if self.display_order is None and "display_order" in self.__fields_set__:
            _dict['display_order'] = None

        # set to None if field_name (nullable) is None
        # and __fields_set__ contains the field
        if self.field_name is None and "field_name" in self.__fields_set__:
            _dict['field_name'] = None

        # set to None if field_type (nullable) is None
        # and __fields_set__ contains the field
        if self.field_type is None and "field_type" in self.__fields_set__:
            _dict['field_type'] = None

        # set to None if guid (nullable) is None
        # and __fields_set__ contains the field
        if self.guid is None and "guid" in self.__fields_set__:
            _dict['guid'] = None

        # set to None if label (nullable) is None
        # and __fields_set__ contains the field
        if self.label is None and "label" in self.__fields_set__:
            _dict['label'] = None

        # set to None if type (nullable) is None
        # and __fields_set__ contains the field
        if self.type is None and "type" in self.__fields_set__:
            _dict['type'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CredentialResponse:
        """Create an instance of CredentialResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CredentialResponse.parse_obj(obj)

        _obj = CredentialResponse.parse_obj({
            "display_order": obj.get("display_order"),
            "field_name": obj.get("field_name"),
            "field_type": obj.get("field_type"),
            "guid": obj.get("guid"),
            "label": obj.get("label"),
            "type": obj.get("type")
        })
        return _obj


