# coding: utf-8

"""
    MX Platform API

    The MX Platform API is a powerful, fully-featured API designed to make aggregating and enhancing financial data easy and reliable. It can seamlessly connect your app or website to tens of thousands of financial institutions.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError

from typing_extensions import Annotated
from pydantic import Field, StrictInt, StrictStr

from typing import Optional

from mx_platform_python.models.accounts_response_body import AccountsResponseBody
from mx_platform_python.models.categories_response_body import CategoriesResponseBody
from mx_platform_python.models.insight_response import InsightResponse
from mx_platform_python.models.insight_response_body import InsightResponseBody
from mx_platform_python.models.insight_update_request import InsightUpdateRequest
from mx_platform_python.models.insights_response_body import InsightsResponseBody
from mx_platform_python.models.merchants_response_body import MerchantsResponseBody
from mx_platform_python.models.scheduled_payments_response_body import ScheduledPaymentsResponseBody
from mx_platform_python.models.transactions_response_body import TransactionsResponseBody

from mx_platform_python.api_client import ApiClient
from mx_platform_python.api_response import ApiResponse
from mx_platform_python.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class InsightsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def list_accounts_insight(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for the user. Defined by MX.")], insight_guid : Annotated[StrictStr, Field(..., description="The unique identifier for the insight. Defined by MX.")], page : Annotated[Optional[StrictInt], Field(description="Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="Specify records per page.")] = None, **kwargs) -> AccountsResponseBody:  # noqa: E501
        """List all accounts associated with an insight.  # noqa: E501

        Use this endpoint to list all the accounts associated with the insight.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_accounts_insight(user_guid, insight_guid, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for the user. Defined by MX. (required)
        :type user_guid: str
        :param insight_guid: The unique identifier for the insight. Defined by MX. (required)
        :type insight_guid: str
        :param page: Specify current page.
        :type page: int
        :param records_per_page: Specify records per page.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AccountsResponseBody
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_accounts_insight_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.list_accounts_insight_with_http_info(user_guid, insight_guid, page, records_per_page, **kwargs)  # noqa: E501

    @validate_arguments
    def list_accounts_insight_with_http_info(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for the user. Defined by MX.")], insight_guid : Annotated[StrictStr, Field(..., description="The unique identifier for the insight. Defined by MX.")], page : Annotated[Optional[StrictInt], Field(description="Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="Specify records per page.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List all accounts associated with an insight.  # noqa: E501

        Use this endpoint to list all the accounts associated with the insight.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_accounts_insight_with_http_info(user_guid, insight_guid, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for the user. Defined by MX. (required)
        :type user_guid: str
        :param insight_guid: The unique identifier for the insight. Defined by MX. (required)
        :type insight_guid: str
        :param page: Specify current page.
        :type page: int
        :param records_per_page: Specify records per page.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AccountsResponseBody, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_guid',
            'insight_guid',
            'page',
            'records_per_page'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_accounts_insight" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']

        if _params['insight_guid']:
            _path_params['insight_guid'] = _params['insight_guid']


        # process the query parameters
        _query_params = []
        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('records_per_page') is not None:  # noqa: E501
            _query_params.append(('records_per_page', _params['records_per_page']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "AccountsResponseBody",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/insights/{insight_guid}/accounts', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_categories_insight(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for the user. Defined by MX.")], insight_guid : Annotated[StrictStr, Field(..., description="The unique identifier for the insight. Defined by MX.")], page : Annotated[Optional[StrictInt], Field(description="Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="Specify records per page.")] = None, **kwargs) -> CategoriesResponseBody:  # noqa: E501
        """List all categories associated with an insight.  # noqa: E501

        Use this endpoint to list all the categories associated with the insight.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_categories_insight(user_guid, insight_guid, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for the user. Defined by MX. (required)
        :type user_guid: str
        :param insight_guid: The unique identifier for the insight. Defined by MX. (required)
        :type insight_guid: str
        :param page: Specify current page.
        :type page: int
        :param records_per_page: Specify records per page.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CategoriesResponseBody
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_categories_insight_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.list_categories_insight_with_http_info(user_guid, insight_guid, page, records_per_page, **kwargs)  # noqa: E501

    @validate_arguments
    def list_categories_insight_with_http_info(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for the user. Defined by MX.")], insight_guid : Annotated[StrictStr, Field(..., description="The unique identifier for the insight. Defined by MX.")], page : Annotated[Optional[StrictInt], Field(description="Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="Specify records per page.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List all categories associated with an insight.  # noqa: E501

        Use this endpoint to list all the categories associated with the insight.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_categories_insight_with_http_info(user_guid, insight_guid, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for the user. Defined by MX. (required)
        :type user_guid: str
        :param insight_guid: The unique identifier for the insight. Defined by MX. (required)
        :type insight_guid: str
        :param page: Specify current page.
        :type page: int
        :param records_per_page: Specify records per page.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CategoriesResponseBody, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_guid',
            'insight_guid',
            'page',
            'records_per_page'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_categories_insight" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']

        if _params['insight_guid']:
            _path_params['insight_guid'] = _params['insight_guid']


        # process the query parameters
        _query_params = []
        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('records_per_page') is not None:  # noqa: E501
            _query_params.append(('records_per_page', _params['records_per_page']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "CategoriesResponseBody",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/insights/{insight_guid}/categories', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_insights_by_account(self, account_guid : Annotated[StrictStr, Field(..., description="The unique id for the `account`.")], user_guid : Annotated[StrictStr, Field(..., description="The unique id for the `user`.")], page : Annotated[Optional[StrictInt], Field(description="Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="Specify records per page.")] = None, **kwargs) -> InsightsResponseBody:  # noqa: E501
        """List insights by account  # noqa: E501

        Use this endpoint to list all insights associated with a specified account GUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_insights_by_account(account_guid, user_guid, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param account_guid: The unique id for the `account`. (required)
        :type account_guid: str
        :param user_guid: The unique id for the `user`. (required)
        :type user_guid: str
        :param page: Specify current page.
        :type page: int
        :param records_per_page: Specify records per page.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: InsightsResponseBody
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_insights_by_account_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.list_insights_by_account_with_http_info(account_guid, user_guid, page, records_per_page, **kwargs)  # noqa: E501

    @validate_arguments
    def list_insights_by_account_with_http_info(self, account_guid : Annotated[StrictStr, Field(..., description="The unique id for the `account`.")], user_guid : Annotated[StrictStr, Field(..., description="The unique id for the `user`.")], page : Annotated[Optional[StrictInt], Field(description="Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="Specify records per page.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List insights by account  # noqa: E501

        Use this endpoint to list all insights associated with a specified account GUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_insights_by_account_with_http_info(account_guid, user_guid, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param account_guid: The unique id for the `account`. (required)
        :type account_guid: str
        :param user_guid: The unique id for the `user`. (required)
        :type user_guid: str
        :param page: Specify current page.
        :type page: int
        :param records_per_page: Specify records per page.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(InsightsResponseBody, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'account_guid',
            'user_guid',
            'page',
            'records_per_page'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_insights_by_account" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['account_guid']:
            _path_params['account_guid'] = _params['account_guid']

        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']


        # process the query parameters
        _query_params = []
        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('records_per_page') is not None:  # noqa: E501
            _query_params.append(('records_per_page', _params['records_per_page']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "InsightsResponseBody",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/accounts/{account_guid}/insights', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_insights_user(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for the user. Defined by MX.")], page : Annotated[Optional[StrictInt], Field(description="Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="Specify records per page.")] = None, **kwargs) -> InsightsResponseBody:  # noqa: E501
        """List all insights for a user.  # noqa: E501

        Use this endpoint to list all the insights associated with the user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_insights_user(user_guid, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for the user. Defined by MX. (required)
        :type user_guid: str
        :param page: Specify current page.
        :type page: int
        :param records_per_page: Specify records per page.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: InsightsResponseBody
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_insights_user_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.list_insights_user_with_http_info(user_guid, page, records_per_page, **kwargs)  # noqa: E501

    @validate_arguments
    def list_insights_user_with_http_info(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for the user. Defined by MX.")], page : Annotated[Optional[StrictInt], Field(description="Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="Specify records per page.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List all insights for a user.  # noqa: E501

        Use this endpoint to list all the insights associated with the user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_insights_user_with_http_info(user_guid, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for the user. Defined by MX. (required)
        :type user_guid: str
        :param page: Specify current page.
        :type page: int
        :param records_per_page: Specify records per page.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(InsightsResponseBody, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_guid',
            'page',
            'records_per_page'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_insights_user" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']


        # process the query parameters
        _query_params = []
        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('records_per_page') is not None:  # noqa: E501
            _query_params.append(('records_per_page', _params['records_per_page']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "InsightsResponseBody",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/insights', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_merchants_insight(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for the user. Defined by MX.")], insight_guid : Annotated[StrictStr, Field(..., description="The unique identifier for the insight. Defined by MX.")], page : Annotated[Optional[StrictInt], Field(description="Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="Specify records per page.")] = None, **kwargs) -> MerchantsResponseBody:  # noqa: E501
        """List all merchants associated with an insight.  # noqa: E501

        Use this endpoint to list all the merchants associated with the insight.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_merchants_insight(user_guid, insight_guid, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for the user. Defined by MX. (required)
        :type user_guid: str
        :param insight_guid: The unique identifier for the insight. Defined by MX. (required)
        :type insight_guid: str
        :param page: Specify current page.
        :type page: int
        :param records_per_page: Specify records per page.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: MerchantsResponseBody
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_merchants_insight_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.list_merchants_insight_with_http_info(user_guid, insight_guid, page, records_per_page, **kwargs)  # noqa: E501

    @validate_arguments
    def list_merchants_insight_with_http_info(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for the user. Defined by MX.")], insight_guid : Annotated[StrictStr, Field(..., description="The unique identifier for the insight. Defined by MX.")], page : Annotated[Optional[StrictInt], Field(description="Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="Specify records per page.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List all merchants associated with an insight.  # noqa: E501

        Use this endpoint to list all the merchants associated with the insight.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_merchants_insight_with_http_info(user_guid, insight_guid, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for the user. Defined by MX. (required)
        :type user_guid: str
        :param insight_guid: The unique identifier for the insight. Defined by MX. (required)
        :type insight_guid: str
        :param page: Specify current page.
        :type page: int
        :param records_per_page: Specify records per page.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(MerchantsResponseBody, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_guid',
            'insight_guid',
            'page',
            'records_per_page'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_merchants_insight" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']

        if _params['insight_guid']:
            _path_params['insight_guid'] = _params['insight_guid']


        # process the query parameters
        _query_params = []
        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('records_per_page') is not None:  # noqa: E501
            _query_params.append(('records_per_page', _params['records_per_page']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "MerchantsResponseBody",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/insights/{insight_guid}/merchants', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_scheduled_payments_insight(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for the user. Defined by MX.")], insight_guid : Annotated[StrictStr, Field(..., description="The unique identifier for the insight. Defined by MX.")], page : Annotated[Optional[StrictInt], Field(description="Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="Specify records per page.")] = None, **kwargs) -> ScheduledPaymentsResponseBody:  # noqa: E501
        """List all scheduled payments associated with an insight  # noqa: E501

        Use this endpoint to list all the scheduled payments associated with the insight.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_scheduled_payments_insight(user_guid, insight_guid, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for the user. Defined by MX. (required)
        :type user_guid: str
        :param insight_guid: The unique identifier for the insight. Defined by MX. (required)
        :type insight_guid: str
        :param page: Specify current page.
        :type page: int
        :param records_per_page: Specify records per page.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ScheduledPaymentsResponseBody
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_scheduled_payments_insight_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.list_scheduled_payments_insight_with_http_info(user_guid, insight_guid, page, records_per_page, **kwargs)  # noqa: E501

    @validate_arguments
    def list_scheduled_payments_insight_with_http_info(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for the user. Defined by MX.")], insight_guid : Annotated[StrictStr, Field(..., description="The unique identifier for the insight. Defined by MX.")], page : Annotated[Optional[StrictInt], Field(description="Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="Specify records per page.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List all scheduled payments associated with an insight  # noqa: E501

        Use this endpoint to list all the scheduled payments associated with the insight.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_scheduled_payments_insight_with_http_info(user_guid, insight_guid, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for the user. Defined by MX. (required)
        :type user_guid: str
        :param insight_guid: The unique identifier for the insight. Defined by MX. (required)
        :type insight_guid: str
        :param page: Specify current page.
        :type page: int
        :param records_per_page: Specify records per page.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ScheduledPaymentsResponseBody, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_guid',
            'insight_guid',
            'page',
            'records_per_page'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_scheduled_payments_insight" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']

        if _params['insight_guid']:
            _path_params['insight_guid'] = _params['insight_guid']


        # process the query parameters
        _query_params = []
        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('records_per_page') is not None:  # noqa: E501
            _query_params.append(('records_per_page', _params['records_per_page']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "ScheduledPaymentsResponseBody",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/insights/{insight_guid}/scheduled_payments', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_transactions_insight(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for the user. Defined by MX.")], insight_guid : Annotated[StrictStr, Field(..., description="The unique identifier for the insight. Defined by MX.")], page : Annotated[Optional[StrictInt], Field(description="Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="Specify records per page.")] = None, **kwargs) -> TransactionsResponseBody:  # noqa: E501
        """List all transactions associated with an insight.  # noqa: E501

        Use this endpoint to list all the transactions associated with the insight.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_transactions_insight(user_guid, insight_guid, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for the user. Defined by MX. (required)
        :type user_guid: str
        :param insight_guid: The unique identifier for the insight. Defined by MX. (required)
        :type insight_guid: str
        :param page: Specify current page.
        :type page: int
        :param records_per_page: Specify records per page.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TransactionsResponseBody
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_transactions_insight_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.list_transactions_insight_with_http_info(user_guid, insight_guid, page, records_per_page, **kwargs)  # noqa: E501

    @validate_arguments
    def list_transactions_insight_with_http_info(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for the user. Defined by MX.")], insight_guid : Annotated[StrictStr, Field(..., description="The unique identifier for the insight. Defined by MX.")], page : Annotated[Optional[StrictInt], Field(description="Specify current page.")] = None, records_per_page : Annotated[Optional[StrictInt], Field(description="Specify records per page.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """List all transactions associated with an insight.  # noqa: E501

        Use this endpoint to list all the transactions associated with the insight.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_transactions_insight_with_http_info(user_guid, insight_guid, page, records_per_page, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for the user. Defined by MX. (required)
        :type user_guid: str
        :param insight_guid: The unique identifier for the insight. Defined by MX. (required)
        :type insight_guid: str
        :param page: Specify current page.
        :type page: int
        :param records_per_page: Specify records per page.
        :type records_per_page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TransactionsResponseBody, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_guid',
            'insight_guid',
            'page',
            'records_per_page'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_transactions_insight" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']

        if _params['insight_guid']:
            _path_params['insight_guid'] = _params['insight_guid']


        # process the query parameters
        _query_params = []
        if _params.get('page') is not None:  # noqa: E501
            _query_params.append(('page', _params['page']))

        if _params.get('records_per_page') is not None:  # noqa: E501
            _query_params.append(('records_per_page', _params['records_per_page']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "TransactionsResponseBody",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/insights/{insight_guid}/transactions', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def read_insights_user(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for the user. Defined by MX.")], insight_guid : Annotated[StrictStr, Field(..., description="The unique identifier for the insight. Defined by MX.")], **kwargs) -> InsightResponseBody:  # noqa: E501
        """Read a specific insight.  # noqa: E501

        Use this endpoint to read the attributes of a specific insight according to its unique GUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_insights_user(user_guid, insight_guid, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for the user. Defined by MX. (required)
        :type user_guid: str
        :param insight_guid: The unique identifier for the insight. Defined by MX. (required)
        :type insight_guid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: InsightResponseBody
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the read_insights_user_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.read_insights_user_with_http_info(user_guid, insight_guid, **kwargs)  # noqa: E501

    @validate_arguments
    def read_insights_user_with_http_info(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for the user. Defined by MX.")], insight_guid : Annotated[StrictStr, Field(..., description="The unique identifier for the insight. Defined by MX.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Read a specific insight.  # noqa: E501

        Use this endpoint to read the attributes of a specific insight according to its unique GUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_insights_user_with_http_info(user_guid, insight_guid, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for the user. Defined by MX. (required)
        :type user_guid: str
        :param insight_guid: The unique identifier for the insight. Defined by MX. (required)
        :type insight_guid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(InsightResponseBody, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_guid',
            'insight_guid'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_insights_user" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']

        if _params['insight_guid']:
            _path_params['insight_guid'] = _params['insight_guid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "InsightResponseBody",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/insights{insight_guid}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_insight(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for the user. Defined by MX.")], insight_guid : Annotated[StrictStr, Field(..., description="The unique identifier for the insight. Defined by MX.")], insight_update_request : Annotated[InsightUpdateRequest, Field(..., description="The insight to be updated (None of these parameters are required, but the user object cannot be empty.)")], **kwargs) -> InsightResponse:  # noqa: E501
        """Update insight  # noqa: E501

        Use this endpoint to update the attributes of a particular insight according to its unique GUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_insight(user_guid, insight_guid, insight_update_request, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for the user. Defined by MX. (required)
        :type user_guid: str
        :param insight_guid: The unique identifier for the insight. Defined by MX. (required)
        :type insight_guid: str
        :param insight_update_request: The insight to be updated (None of these parameters are required, but the user object cannot be empty.) (required)
        :type insight_update_request: InsightUpdateRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request.
               If one number provided, it will be total request
               timeout. It can also be a pair (tuple) of
               (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: InsightResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the update_insight_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        return self.update_insight_with_http_info(user_guid, insight_guid, insight_update_request, **kwargs)  # noqa: E501

    @validate_arguments
    def update_insight_with_http_info(self, user_guid : Annotated[StrictStr, Field(..., description="The unique identifier for the user. Defined by MX.")], insight_guid : Annotated[StrictStr, Field(..., description="The unique identifier for the insight. Defined by MX.")], insight_update_request : Annotated[InsightUpdateRequest, Field(..., description="The insight to be updated (None of these parameters are required, but the user object cannot be empty.)")], **kwargs) -> ApiResponse:  # noqa: E501
        """Update insight  # noqa: E501

        Use this endpoint to update the attributes of a particular insight according to its unique GUID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_insight_with_http_info(user_guid, insight_guid, insight_update_request, async_req=True)
        >>> result = thread.get()

        :param user_guid: The unique identifier for the user. Defined by MX. (required)
        :type user_guid: str
        :param insight_guid: The unique identifier for the insight. Defined by MX. (required)
        :type insight_guid: str
        :param insight_update_request: The insight to be updated (None of these parameters are required, but the user object cannot be empty.) (required)
        :type insight_update_request: InsightUpdateRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(InsightResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'user_guid',
            'insight_guid',
            'insight_update_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_insight" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['user_guid']:
            _path_params['user_guid'] = _params['user_guid']

        if _params['insight_guid']:
            _path_params['insight_guid'] = _params['insight_guid']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['insight_update_request'] is not None:
            _body_params = _params['insight_update_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.mx.api.v1+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "InsightResponse",
        }

        return self.api_client.call_api(
            '/users/{user_guid}/insights{insight_guid}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
