# splitit-web-python-sdk
Splitit's API

This Python package is automatically generated by the [Konfig](https://konfigthis.com):

- API version: 1.0.0
- Package version: 1.1.0

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/konfig-dev/splitit-web-sdks/tree/main/python.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/konfig-dev/splitit-web-sdks/tree/main/python.git`)

Then import the package:
```python
import splitit_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import splitit_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import splitit_client
from pprint import pprint
from splitit_client.api import installment_plan_api
from splitit_client.model.failed_response import FailedResponse
from splitit_client.model.installment_plan_cancel_response import InstallmentPlanCancelResponse
from splitit_client.model.installment_plan_create_request import InstallmentPlanCreateRequest
from splitit_client.model.installment_plan_get_response import InstallmentPlanGetResponse
from splitit_client.model.installment_plan_model import InstallmentPlanModel
from splitit_client.model.installment_plan_refund_request import InstallmentPlanRefundRequest
from splitit_client.model.installment_plan_refund_response import InstallmentPlanRefundResponse
from splitit_client.model.installment_plan_update_request_by_identifier import InstallmentPlanUpdateRequestByIdentifier
from splitit_client.model.installment_plan_update_response import InstallmentPlanUpdateResponse
from splitit_client.model.plan_error_response import PlanErrorResponse
from splitit_client.model.update_order_request import UpdateOrderRequest
from splitit_client.model.verify_authorization_response import VerifyAuthorizationResponse
# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.
client_id = os.environ["CLIENT_ID"]
client_secret = os.environ["CLIENT_SECRET"]
configuration = splitit_client.Configuration(
    # Defining the host is optional and defaults to https://web-api-v3.sandbox.splitit.com
    # See configuration.py for a list of all supported configuration parameters.
    host = 'https://web-api-v3.sandbox.splitit.com'
    client_id=client_id,
    client_secret=client_secret
)


# Enter a context with an instance of the API client
with splitit_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = installment_plan_api.InstallmentPlanApi(api_client)
    installment_plan_number = "installmentPlanNumber_example" # str | 
    x_splitit_idempotency_key = "X-Splitit-IdempotencyKey_example" # str | 

    try:
        api_response = api_instance.cancel(installment_plan_number, x_splitit_idempotency_key)
        pprint(api_response)
    except splitit_client.ApiException as e:
        print("Exception when calling InstallmentPlanApi->cancel: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://web-api-v3.sandbox.splitit.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*InstallmentPlanApi* | [**cancel**](docs/InstallmentPlanApi.md#cancel) | **POST** /api/installmentplans/{installmentPlanNumber}/cancel | 
*InstallmentPlanApi* | [**get**](docs/InstallmentPlanApi.md#get) | **GET** /api/installmentplans/{installmentPlanNumber} | 
*InstallmentPlanApi* | [**post**](docs/InstallmentPlanApi.md#post) | **POST** /api/installmentplans | 
*InstallmentPlanApi* | [**refund**](docs/InstallmentPlanApi.md#refund) | **POST** /api/installmentplans/{installmentPlanNumber}/refund | 
*InstallmentPlanApi* | [**search**](docs/InstallmentPlanApi.md#search) | **GET** /api/installmentplans/search | 
*InstallmentPlanApi* | [**update_order**](docs/InstallmentPlanApi.md#update_order) | **PUT** /api/installmentplans/{installmentPlanNumber}/updateorder | 
*InstallmentPlanApi* | [**update_order2**](docs/InstallmentPlanApi.md#update_order2) | **PUT** /api/installmentplans/updateorder | 
*InstallmentPlanApi* | [**verify_authorization**](docs/InstallmentPlanApi.md#verify_authorization) | **GET** /api/installmentplans/{installmentPlanNumber}/verifyauthorization | 


## Documentation For Models

 - [AddressData](docs/AddressData.md)
 - [AddressDataModel](docs/AddressDataModel.md)
 - [AuthorizationModel](docs/AuthorizationModel.md)
 - [CardData](docs/CardData.md)
 - [Error](docs/Error.md)
 - [ErrorExtended](docs/ErrorExtended.md)
 - [ErrorExtendedAllOf](docs/ErrorExtendedAllOf.md)
 - [FailedResponse](docs/FailedResponse.md)
 - [FailedResponseAllOf](docs/FailedResponseAllOf.md)
 - [GwAuthorizationStatus](docs/GwAuthorizationStatus.md)
 - [IdentifierContract](docs/IdentifierContract.md)
 - [Installment](docs/Installment.md)
 - [InstallmentPlanCancelResponse](docs/InstallmentPlanCancelResponse.md)
 - [InstallmentPlanCreateRequest](docs/InstallmentPlanCreateRequest.md)
 - [InstallmentPlanGetResponse](docs/InstallmentPlanGetResponse.md)
 - [InstallmentPlanGetResponseAllOf](docs/InstallmentPlanGetResponseAllOf.md)
 - [InstallmentPlanModel](docs/InstallmentPlanModel.md)
 - [InstallmentPlanModelAllOf](docs/InstallmentPlanModelAllOf.md)
 - [InstallmentPlanRefundRequest](docs/InstallmentPlanRefundRequest.md)
 - [InstallmentPlanRefundResponse](docs/InstallmentPlanRefundResponse.md)
 - [InstallmentPlanRefundResponseAllOf](docs/InstallmentPlanRefundResponseAllOf.md)
 - [InstallmentPlanUpdateRequest](docs/InstallmentPlanUpdateRequest.md)
 - [InstallmentPlanUpdateRequestByIdentifier](docs/InstallmentPlanUpdateRequestByIdentifier.md)
 - [InstallmentPlanUpdateRequestByIdentifierAllOf](docs/InstallmentPlanUpdateRequestByIdentifierAllOf.md)
 - [InstallmentPlanUpdateResponse](docs/InstallmentPlanUpdateResponse.md)
 - [InstallmentPlanUpdateResponseAllOf](docs/InstallmentPlanUpdateResponseAllOf.md)
 - [InstallmentStatus](docs/InstallmentStatus.md)
 - [LinksData](docs/LinksData.md)
 - [PaymentMethodModel](docs/PaymentMethodModel.md)
 - [PaymentMethodType](docs/PaymentMethodType.md)
 - [PlanDataModel](docs/PlanDataModel.md)
 - [PlanErrorResponse](docs/PlanErrorResponse.md)
 - [PlanErrorResponseAllOf](docs/PlanErrorResponseAllOf.md)
 - [PlanStatus](docs/PlanStatus.md)
 - [PurchaseMethod](docs/PurchaseMethod.md)
 - [RedirectionEndpointsModel](docs/RedirectionEndpointsModel.md)
 - [RefundStrategy](docs/RefundStrategy.md)
 - [RefundSummary](docs/RefundSummary.md)
 - [ResponseV2](docs/ResponseV2.md)
 - [ShippingStatus](docs/ShippingStatus.md)
 - [ShippingStatus2](docs/ShippingStatus2.md)
 - [ShopperData](docs/ShopperData.md)
 - [TestModes](docs/TestModes.md)
 - [ThreeDsRedirectData](docs/ThreeDsRedirectData.md)
 - [UpdateOrderRequest](docs/UpdateOrderRequest.md)
 - [VerifyAuthorizationResponse](docs/VerifyAuthorizationResponse.md)
 - [VerifyAuthorizationResponseAllOf](docs/VerifyAuthorizationResponseAllOf.md)


## Documentation For Authorization


## bearer

- **Type**: OAuth
- **Flow**: application
- **Authorization URL**: 
- **Scopes**: 
 - **api.v3**: 


## Author




## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in splitit_client.apis and splitit_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from splitit_client.api.default_api import DefaultApi`
- `from splitit_client.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import splitit_client
from splitit_client.apis import *
from splitit_client.models import *
```

