"""
    The Plaid API

    The Plaid REST API. Please see https://plaid.com/docs/api for more details.  # noqa: E501
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from plaid.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)

def lazy_import():
    from plaid.model.transfer_event_type import TransferEventType
    from plaid.model.transfer_failure import TransferFailure
    from plaid.model.transfer_type import TransferType
    globals()['TransferEventType'] = TransferEventType
    globals()['TransferFailure'] = TransferFailure
    globals()['TransferType'] = TransferType


class TransferEvent(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
        ('event_id',): {
            'inclusive_minimum': 0,
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'event_id': (int,),  # noqa: E501
            'timestamp': (datetime,),  # noqa: E501
            'event_type': (TransferEventType,),  # noqa: E501
            'account_id': (str,),  # noqa: E501
            'transfer_id': (str,),  # noqa: E501
            'origination_account_id': (str, none_type,),  # noqa: E501
            'transfer_type': (TransferType,),  # noqa: E501
            'transfer_amount': (str,),  # noqa: E501
            'failure_reason': (TransferFailure,),  # noqa: E501
            'sweep_id': (str, none_type,),  # noqa: E501
            'sweep_amount': (str, none_type,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'event_id': 'event_id',  # noqa: E501
        'timestamp': 'timestamp',  # noqa: E501
        'event_type': 'event_type',  # noqa: E501
        'account_id': 'account_id',  # noqa: E501
        'transfer_id': 'transfer_id',  # noqa: E501
        'origination_account_id': 'origination_account_id',  # noqa: E501
        'transfer_type': 'transfer_type',  # noqa: E501
        'transfer_amount': 'transfer_amount',  # noqa: E501
        'failure_reason': 'failure_reason',  # noqa: E501
        'sweep_id': 'sweep_id',  # noqa: E501
        'sweep_amount': 'sweep_amount',  # noqa: E501
    }

    _composed_schemas = {}

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, event_id, timestamp, event_type, account_id, transfer_id, origination_account_id, transfer_type, transfer_amount, failure_reason, sweep_id, sweep_amount, *args, **kwargs):  # noqa: E501
        """TransferEvent - a model defined in OpenAPI

        Args:
            event_id (int): Plaid’s unique identifier for this event. IDs are sequential unsigned 64-bit integers.
            timestamp (datetime): The datetime when this event occurred. This will be of the form `2006-01-02T15:04:05Z`.
            event_type (TransferEventType):
            account_id (str): The account ID associated with the transfer.
            transfer_id (str): Plaid’s unique identifier for a transfer.
            origination_account_id (str, none_type): The ID of the origination account that this balance belongs to.
            transfer_type (TransferType):
            transfer_amount (str): The amount of the transfer (decimal string with two digits of precision e.g. \"10.00\").
            failure_reason (TransferFailure):
            sweep_id (str, none_type): Plaid’s unique identifier for a sweep.
            sweep_amount (str, none_type): A signed amount of how much was `swept` or `return_swept` (decimal string with two digits of precision e.g. \"-5.50\").

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.event_id = event_id
        self.timestamp = timestamp
        self.event_type = event_type
        self.account_id = account_id
        self.transfer_id = transfer_id
        self.origination_account_id = origination_account_id
        self.transfer_type = transfer_type
        self.transfer_amount = transfer_amount
        self.failure_reason = failure_reason
        self.sweep_id = sweep_id
        self.sweep_amount = sweep_amount
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
