import * as codepipeline from '@aws-cdk/aws-codepipeline';
import * as cdk from '@aws-cdk/core';
import { Construct } from 'constructs';
/**
 * A Jenkins provider.
 *
 * If you want to create a new Jenkins provider managed alongside your CDK code,
 * instantiate the {@link JenkinsProvider} class directly.
 *
 * If you want to reference an already registered provider,
 * use the {@link JenkinsProvider#fromJenkinsProviderAttributes} method.
 *
 * @stability stable
 */
export interface IJenkinsProvider extends cdk.IConstruct {
    /**
     * @stability stable
     */
    readonly providerName: string;
    /**
     * @stability stable
     */
    readonly serverUrl: string;
    /**
     * @stability stable
     */
    readonly version: string;
    /**
     * Registers a Jenkins Provider for the build category.
     * This method will be automatically called when creating
     * a {@link JenkinsAction},
     * so you should never need to call it explicitly.
     *
     * @internal
     */
    _registerBuildProvider(): void;
    /**
     * Registers a Jenkins Provider for the test category.
     * This method will be automatically called when creating
     * a {@link JenkinsTestAction},
     * so you should never need to call it explicitly.
     *
     * @internal
     */
    _registerTestProvider(): void;
}
/**
 * Properties for importing an existing Jenkins provider.
 *
 * @stability stable
 */
export interface JenkinsProviderAttributes {
    /**
     * The name of the Jenkins provider that you set in the AWS CodePipeline plugin configuration of your Jenkins project.
     *
     * @stability stable
     * @example
     *
     * 'MyJenkinsProvider'
     */
    readonly providerName: string;
    /**
     * The base URL of your Jenkins server.
     *
     * @stability stable
     * @example
     *
     * 'http://myjenkins.com:8080'
     */
    readonly serverUrl: string;
    /**
     * The version of your provider.
     *
     * @default '1'
     * @stability stable
     */
    readonly version?: string;
}
/**
 * @stability stable
 */
export interface JenkinsProviderProps {
    /**
     * The name of the Jenkins provider that you set in the AWS CodePipeline plugin configuration of your Jenkins project.
     *
     * @stability stable
     * @example
     *
     * 'MyJenkinsProvider'
     */
    readonly providerName: string;
    /**
     * The base URL of your Jenkins server.
     *
     * @stability stable
     * @example
     *
     * 'http://myjenkins.com:8080'
     */
    readonly serverUrl: string;
    /**
     * The version of your provider.
     *
     * @default '1'
     * @stability stable
     */
    readonly version?: string;
    /**
     * Whether to immediately register a Jenkins Provider for the build category.
     *
     * The Provider will always be registered if you create a {@link JenkinsAction}.
     *
     * @default false
     * @stability stable
     */
    readonly forBuild?: boolean;
    /**
     * Whether to immediately register a Jenkins Provider for the test category.
     *
     * The Provider will always be registered if you create a {@link JenkinsTestAction}.
     *
     * @default false
     * @stability stable
     */
    readonly forTest?: boolean;
}
/**
 * @stability stable
 */
export declare abstract class BaseJenkinsProvider extends cdk.Construct implements IJenkinsProvider {
    /**
     * @stability stable
     */
    abstract readonly providerName: string;
    /**
     * @stability stable
     */
    abstract readonly serverUrl: string;
    /**
     * @stability stable
     */
    readonly version: string;
    /**
     * @stability stable
     */
    protected constructor(scope: Construct, id: string, version?: string);
    /**
     * @internal
     */
    abstract _registerBuildProvider(): void;
    /**
     * @internal
     */
    abstract _registerTestProvider(): void;
}
/**
 * A class representing Jenkins providers.
 *
 * @see #import
 * @stability stable
 */
export declare class JenkinsProvider extends BaseJenkinsProvider {
    /**
     * Import a Jenkins provider registered either outside the CDK, or in a different CDK Stack.
     *
     * @param scope the parent Construct for the new provider.
     * @param id the identifier of the new provider Construct.
     * @param attrs the properties used to identify the existing provider.
     * @returns a new Construct representing a reference to an existing Jenkins provider
     * @stability stable
     */
    static fromJenkinsProviderAttributes(scope: Construct, id: string, attrs: JenkinsProviderAttributes): IJenkinsProvider;
    /**
     * @stability stable
     */
    readonly providerName: string;
    /**
     * @stability stable
     */
    readonly serverUrl: string;
    private buildIncluded;
    private testIncluded;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: JenkinsProviderProps);
    /**
     * @internal
     */
    _registerBuildProvider(): void;
    /**
     * @internal
     */
    _registerTestProvider(): void;
    private registerJenkinsCustomAction;
}
export declare const jenkinsArtifactsBounds: codepipeline.ActionArtifactBounds;
