"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpenApiGatewayLambdaApi = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_apigateway_1 = require("aws-cdk-lib/aws-apigateway");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const api_gateway_integrations_1 = require("./utils/api-gateway-integrations");
/**
 * A construct for creating an api gateway api based on the definition in the OpenAPI spec.
 */
class OpenApiGatewayLambdaApi extends aws_apigateway_1.SpecRestApi {
    constructor(scope, id, props) {
        const { integrations, spec, ...options } = props;
        // Create the api gateway resources from the spec, augmenting the spec with the properties specific to api gateway
        // such as integrations or auth types
        super(scope, id, {
            apiDefinition: aws_apigateway_1.ApiDefinition.fromInline(api_gateway_integrations_1.prepareApiSpec(scope, spec, props)),
            ...options,
        });
        // Grant API Gateway permission to invoke each lambda which implements the integration
        Object.entries(integrations).forEach(([operationName, integration]) => {
            new aws_lambda_1.CfnPermission(this, `LambdaPermission-${operationName}`, {
                action: "lambda:InvokeFunction",
                principal: "apigateway.amazonaws.com",
                functionName: integration.function.functionName,
                sourceArn: aws_cdk_lib_1.Stack.of(this).formatArn({
                    service: "execute-api",
                    resource: this.restApiId,
                    resourceName: "*/*",
                }),
            });
        });
    }
}
exports.OpenApiGatewayLambdaApi = OpenApiGatewayLambdaApi;
_a = JSII_RTTI_SYMBOL_1;
OpenApiGatewayLambdaApi[_a] = { fqn: "@aws-prototyping-sdk/open-api-gateway.OpenApiGatewayLambdaApi", version: "0.0.93" };
//# sourceMappingURL=data:application/json;base64,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