// THIS FILE IS GENERATED BY api-generator, DO NOT EDIT DIRECTLY!
//
use crate::http_client::HttpClient;
use pyo3::prelude::*;
pub(super) fn create_module(py: Python<'_>) -> PyResult<&PyModule> {
    let m = PyModule::new(py, "resumable_upload_v2_complete_multipart_upload")?;
    m.add_class::<Client>()?;
    Ok(m)
}
#[doc = "在将所有数据分片都上传完成后，必须调用 completeMultipartUpload API 来完成整个文件的 Multipart Upload。用户需要提供有效数据的分片列表（包括 PartNumber 和调用 uploadPart API 服务端返回的 Etag）。服务端收到用户提交的分片列表后，会逐一验证每个数据分片的有效性。当所有的数据分片验证通过后，会把这些数据分片组合成一个完整的对象"]
# [pyclass (extends = HttpClient)]
#[pyo3(
    text_signature = "(/, http_caller = None, use_https = None, appended_user_agent = None, request_retrier = None, backoff = None, chooser = None, resolver = None, uploading_progress = None, receive_response_status = None, receive_response_header = None, to_resolve_domain = None, domain_resolved = None, to_choose_ips = None, ips_chosen = None, before_request_signed = None, after_request_signed = None, response_ok = None, response_error = None, before_backoff = None, after_backoff = None)"
)]
#[derive(Clone)]
struct Client;
#[pymethods]
impl Client {
    #[new]
    #[args(
        http_caller = "None",
        use_https = "None",
        appended_user_agent = "None",
        request_retrier = "None",
        backoff = "None",
        chooser = "None",
        resolver = "None",
        uploading_progress = "None",
        receive_response_status = "None",
        receive_response_header = "None",
        to_resolve_domain = "None",
        domain_resolved = "None",
        to_choose_ips = "None",
        ips_chosen = "None",
        before_request_signed = "None",
        after_request_signed = "None",
        response_ok = "None",
        response_error = "None",
        before_backoff = "None",
        after_backoff = "None"
    )]
    #[allow(clippy::too_many_arguments)]
    pub(crate) fn new(
        http_caller: Option<crate::http::HttpCaller>,
        use_https: Option<bool>,
        appended_user_agent: Option<&str>,
        request_retrier: Option<crate::http_client::RequestRetrier>,
        backoff: Option<crate::http_client::Backoff>,
        chooser: Option<crate::http_client::Chooser>,
        resolver: Option<crate::http_client::Resolver>,
        uploading_progress: Option<PyObject>,
        receive_response_status: Option<PyObject>,
        receive_response_header: Option<PyObject>,
        to_resolve_domain: Option<PyObject>,
        domain_resolved: Option<PyObject>,
        to_choose_ips: Option<PyObject>,
        ips_chosen: Option<PyObject>,
        before_request_signed: Option<PyObject>,
        after_request_signed: Option<PyObject>,
        response_ok: Option<PyObject>,
        response_error: Option<PyObject>,
        before_backoff: Option<PyObject>,
        after_backoff: Option<PyObject>,
    ) -> PyResult<(Self, HttpClient)> {
        let client = HttpClient::new(
            http_caller,
            use_https,
            appended_user_agent,
            request_retrier,
            backoff,
            chooser,
            resolver,
            uploading_progress,
            receive_response_status,
            receive_response_header,
            to_resolve_domain,
            domain_resolved,
            to_choose_ips,
            ips_chosen,
            before_request_signed,
            after_request_signed,
            response_ok,
            response_error,
            before_backoff,
            after_backoff,
        )?;
        Ok((Self, client))
    }
    #[doc = "发出阻塞请求"]
    #[pyo3(
        text_signature = "(endpoints, upload_token, /, use_https = None, version = None, headers = None, query = None, query_pairs = None, appended_user_agent = None, bucket_name = None, object_name = None, upload_id = None, json = None, uploading_progress = None, receive_response_status = None, receive_response_header = None, to_resolve_domain = None, domain_resolved = None, to_choose_ips = None, ips_chosen = None, before_request_signed = None, after_request_signed = None, response_ok = None, response_error = None, before_backoff = None, after_backoff = None)"
    )]
    #[args(
        r#use_https = "None",
        r#version = "None",
        r#headers = "None",
        r#query = "None",
        r#query_pairs = "None",
        r#appended_user_agent = "None",
        r#bucket_name = "None",
        r#object_name = "None",
        r#upload_id = "None",
        r#json = "None",
        r#uploading_progress = "None",
        r#receive_response_status = "None",
        r#receive_response_header = "None",
        r#to_resolve_domain = "None",
        r#domain_resolved = "None",
        r#to_choose_ips = "None",
        r#ips_chosen = "None",
        r#before_request_signed = "None",
        r#after_request_signed = "None",
        r#response_ok = "None",
        r#response_error = "None",
        r#before_backoff = "None",
        r#after_backoff = "None"
    )]
    #[allow(clippy::too_many_arguments)]
    fn call(
        self_: PyRef<'_, Self>,
        r#endpoints: PyObject,
        r#upload_token: crate::upload_token::UploadTokenProvider,
        r#use_https: Option<bool>,
        r#version: Option<crate::http::Version>,
        r#headers: Option<std::collections::HashMap<String, String>>,
        r#query: Option<String>,
        r#query_pairs: Option<PyObject>,
        r#appended_user_agent: Option<String>,
        r#bucket_name: Option<String>,
        r#object_name: Option<String>,
        r#upload_id: Option<String>,
        r#json: Option<PyObject>,
        r#uploading_progress: Option<PyObject>,
        r#receive_response_status: Option<PyObject>,
        r#receive_response_header: Option<PyObject>,
        r#to_resolve_domain: Option<PyObject>,
        r#domain_resolved: Option<PyObject>,
        r#to_choose_ips: Option<PyObject>,
        r#ips_chosen: Option<PyObject>,
        r#before_request_signed: Option<PyObject>,
        r#after_request_signed: Option<PyObject>,
        r#response_ok: Option<PyObject>,
        r#response_error: Option<PyObject>,
        r#before_backoff: Option<PyObject>,
        r#after_backoff: Option<PyObject>,
        py: Python<'_>,
    ) -> PyResult<Py<crate::http_client::JsonResponse>> {
        let super_ = self_.into_super();
        let (resp, parts) = super_._call(
            "POST".to_owned(),
            endpoints,
            Some(vec![crate::http_client::ServiceName::r#Up]),
            use_https,
            version,
            {
                let mut segments = vec!["/buckets".to_owned()];
                segments.extend({
                    let mut segments = vec![];
                    if let Some(r#bucket_name) = r#bucket_name {
                        segments.push(r#bucket_name);
                    }
                    segments
                });
                segments.extend({
                    let mut segments = vec!["objects".to_owned()];
                    segments.push(
                        r#object_name
                            .map(|s| qiniu_sdk::utils::base64::urlsafe(s.as_bytes()))
                            .unwrap_or_else(|| "~".to_owned()),
                    );
                    segments
                });
                segments.extend({
                    let mut segments = vec!["uploads".to_owned()];
                    if let Some(r#upload_id) = r#upload_id {
                        segments.push(r#upload_id);
                    }
                    segments
                });
                Some(segments.join("/"))
            },
            headers,
            Some(true),
            None,
            query,
            query_pairs,
            appended_user_agent,
            Some(crate::http_client::Authorization::from(
                qiniu_sdk::http_client::Authorization::uptoken(upload_token),
            )),
            Some(crate::http_client::Idempotent::r#Default),
            None,
            None,
            None,
            None,
            r#json,
            None,
            None,
            uploading_progress,
            receive_response_status,
            receive_response_header,
            to_resolve_domain,
            domain_resolved,
            to_choose_ips,
            ips_chosen,
            before_request_signed,
            after_request_signed,
            response_ok,
            response_error,
            before_backoff,
            after_backoff,
            py,
        )?;
        {
            let mut body = resp;
            let json = crate::http_client::JsonResponse::from(body.parse_json()?);
            Py::new(py, (json, parts))
        }
    }
    #[doc = "发出异步请求"]
    #[pyo3(
        text_signature = "(endpoints, upload_token, /, use_https = None, version = None, headers = None, query = None, query_pairs = None, appended_user_agent = None, bucket_name = None, object_name = None, upload_id = None, json = None, uploading_progress = None, receive_response_status = None, receive_response_header = None, to_resolve_domain = None, domain_resolved = None, to_choose_ips = None, ips_chosen = None, before_request_signed = None, after_request_signed = None, response_ok = None, response_error = None, before_backoff = None, after_backoff = None)"
    )]
    #[args(
        r#use_https = "None",
        r#version = "None",
        r#headers = "None",
        r#query = "None",
        r#query_pairs = "None",
        r#appended_user_agent = "None",
        r#bucket_name = "None",
        r#object_name = "None",
        r#upload_id = "None",
        r#json = "None",
        r#uploading_progress = "None",
        r#receive_response_status = "None",
        r#receive_response_header = "None",
        r#to_resolve_domain = "None",
        r#domain_resolved = "None",
        r#to_choose_ips = "None",
        r#ips_chosen = "None",
        r#before_request_signed = "None",
        r#after_request_signed = "None",
        r#response_ok = "None",
        r#response_error = "None",
        r#before_backoff = "None",
        r#after_backoff = "None"
    )]
    #[allow(clippy::too_many_arguments)]
    fn async_call<'p>(
        self_: PyRef<'p, Self>,
        r#endpoints: PyObject,
        r#upload_token: crate::upload_token::UploadTokenProvider,
        r#use_https: Option<bool>,
        r#version: Option<crate::http::Version>,
        r#headers: Option<std::collections::HashMap<String, String>>,
        r#query: Option<String>,
        r#query_pairs: Option<PyObject>,
        r#appended_user_agent: Option<String>,
        r#bucket_name: Option<String>,
        r#object_name: Option<String>,
        r#upload_id: Option<String>,
        r#json: Option<PyObject>,
        r#uploading_progress: Option<PyObject>,
        r#receive_response_status: Option<PyObject>,
        r#receive_response_header: Option<PyObject>,
        r#to_resolve_domain: Option<PyObject>,
        r#domain_resolved: Option<PyObject>,
        r#to_choose_ips: Option<PyObject>,
        r#ips_chosen: Option<PyObject>,
        r#before_request_signed: Option<PyObject>,
        r#after_request_signed: Option<PyObject>,
        r#response_ok: Option<PyObject>,
        r#response_error: Option<PyObject>,
        r#before_backoff: Option<PyObject>,
        r#after_backoff: Option<PyObject>,
        py: Python<'p>,
    ) -> PyResult<&'p PyAny> {
        let http_client = self_.into_super().to_owned();
        pyo3_asyncio::async_std::future_into_py(py, async move {
            let (resp, parts) = http_client
                ._async_call(
                    "POST".to_owned(),
                    endpoints,
                    Some(vec![crate::http_client::ServiceName::r#Up]),
                    use_https,
                    version,
                    {
                        let mut segments = vec!["/buckets".to_owned()];
                        segments.extend({
                            let mut segments = vec![];
                            if let Some(r#bucket_name) = r#bucket_name {
                                segments.push(r#bucket_name);
                            }
                            segments
                        });
                        segments.extend({
                            let mut segments = vec!["objects".to_owned()];
                            segments.push(
                                r#object_name
                                    .map(|s| qiniu_sdk::utils::base64::urlsafe(s.as_bytes()))
                                    .unwrap_or_else(|| "~".to_owned()),
                            );
                            segments
                        });
                        segments.extend({
                            let mut segments = vec!["uploads".to_owned()];
                            if let Some(r#upload_id) = r#upload_id {
                                segments.push(r#upload_id);
                            }
                            segments
                        });
                        Some(segments.join("/"))
                    },
                    headers,
                    Some(true),
                    None,
                    query,
                    query_pairs,
                    appended_user_agent,
                    Some(crate::http_client::Authorization::from(
                        qiniu_sdk::http_client::Authorization::uptoken(upload_token),
                    )),
                    Some(crate::http_client::Idempotent::r#Default),
                    None,
                    None,
                    None,
                    None,
                    r#json,
                    None,
                    None,
                    uploading_progress,
                    receive_response_status,
                    receive_response_header,
                    to_resolve_domain,
                    domain_resolved,
                    to_choose_ips,
                    ips_chosen,
                    before_request_signed,
                    after_request_signed,
                    response_ok,
                    response_error,
                    before_backoff,
                    after_backoff,
                )
                .await?;
            {
                let mut body = resp;
                let json = crate::http_client::JsonResponse::from(body._parse_json().await?);
                Python::with_gil(|py| Py::new(py, (json, parts)))
            }
        })
    }
}
