# -*- coding: utf-8 -*-

"""
firstlanguage

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

import json
import dateutil.parser
import jsonpickle

from tests.controllers.controller_test_base import ControllerTestBase
from tests.test_helper import TestHelper
from tests.http_response_catcher import HttpResponseCatcher
from firstlanguage_python.api_helper import APIHelper
from firstlanguage_python.controllers.advanced_api_controller import AdvancedAPIsController


class AdvancedAPIsControllerTests(ControllerTestBase):

    @classmethod
    def setUpClass(cls):
        super(AdvancedAPIsControllerTests, cls).setUpClass()
        cls.response_catcher = HttpResponseCatcher()
        cls.controller = AdvancedAPIsController(cls.config, cls.response_catcher)

    # # Stemmer : Defintion and it's usage
    #
    ## Languages covered:
    def test_get_qa(self):
        # Parameters for the API call
        reqbody='{ "input":{ "question":"எவை மூன்றும் எப்போதும் ஒன்றாகவே இருக்கும்?", "lang":"ta", "context": "உப்பு, புளி, மிளகாய் மூன்றும் எப்போதும் ஒன்றாகவே இருக்கும். ஒருநாள், “குழம்பிற்கு யார் முக்கியம்? நீயா! நானா!” என்று சண்டை போட்டன. மூன்று பேரும் தனிதனியாகச் சென்று குழம்பில் சேரலாம் என்று முடிவு செய்தன. முதல் நாள், உப்பு மட்டும் குழம்பில் சேர்ந்து கொண்டது. “ஆ! ஒரே உப்பு! வாயில் வைக்க முடியவில்லை!” என்று எல்லோரும் கத்தினார்கள்" } }'

        body = jsonpickle.decode(reqbody)
        #body = None

        # Perform the API call through the SDK function
        result = self.controller.get_qa(body)

        # Test response code
        self.assertEquals(self.response_catcher.response.status_code, 200)

        # Test headers
        expected_headers = {}
        expected_headers['content-type'] = 'application/json; charset=utf-8'

        self.assertTrue(TestHelper.match_headers(expected_headers, self.response_catcher.response.headers))

        
        # Test whether the captured response is as we expected
        self.assertIsNotNone(result)
        expected_body = APIHelper.json_deserialize('{"score":0.028566665947437286,"start":0,"end":20,"answer":"உப்பு, '
            'புளி, மிளகாய்"}')
        received_body = APIHelper.json_deserialize(self.response_catcher.response.text)
        self.assertTrue(TestHelper.match_body(expected_body, received_body))


    # # NER : Defintion and it's usage
    #
    ## Languages covered:
    def test_get_ner(self):
        # Parameters for the API call
        
        reqbody='{  "input":{ "lang":"ar", "text": "إسمي محمد وأسكن في برلين" }}'

        body = jsonpickle.decode(reqbody)
        #body = None

        # Perform the API call through the SDK function
        result = self.controller.get_ner(body)
        
        # Test response code
        self.assertEquals(self.response_catcher.response.status_code, 200)

        # Test headers
        expected_headers = {}
        expected_headers['content-type'] = 'application/json; charset=utf-8'

        self.assertTrue(TestHelper.match_headers(expected_headers, self.response_catcher.response.headers))

        
        # Test whether the captured response is as we expected
        self.assertIsNotNone(result)
        expected_body = APIHelper.json_deserialize('[{"entity_group":"PER","word":"محمد","start":"4","end":"9"},{"enti'
            'ty_group":"LOC","word":"برلين","start":"18","end":"24"}]')
        received_body = APIHelper.json_deserialize(self.response_catcher.response.text)
        self.assertTrue(TestHelper.match_body(expected_body, received_body))


