# -*- coding: utf-8 -*-

"""
firstlanguage

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from firstlanguage_python.api_helper import APIHelper
from firstlanguage_python.configuration import Server
from firstlanguage_python.controllers.base_controller import BaseController
from firstlanguage_python.http.auth.custom_header_auth import CustomHeaderAuth
from firstlanguage_python.models.responsestem import Responsestem
from firstlanguage_python.models.responselemma import Responselemma
from firstlanguage_python.models.responsemorph import Responsemorph
from firstlanguage_python.models.responsepo import Responsepo
from firstlanguage_python.exceptions.errors_exception import ErrorsException
from firstlanguage_python.exceptions.api_stemmer_426_error_exception import ApiStemmer426ErrorException
from firstlanguage_python.exceptions.api_lemmatize_426_error_exception import ApiLemmatize426ErrorException
from firstlanguage_python.exceptions.api_morph_426_error_exception import ApiMorph426ErrorException
from firstlanguage_python.exceptions.api_postag_426_error_exception import ApiPostag426ErrorException


class BasicAPIsController(BaseController):

    """A Controller to access Endpoints in the firstlanguage API."""

    def __init__(self, config, call_back=None):
        super(BasicAPIsController, self).__init__(config, call_back)

    def get_stemmer(self,
                    body):
        """Does a POST request to /api/stemmer.

        # Stemmer : Defintion and it's usage
         A word takes different inflectional forms. For instance, the word,
         "Compute" can take the forms, "computing", "computation",  and
         "computerize". The NLP applications such as Search Engines and
         Information Extraction would want to store the base or stem of the
         word, i.e "Compute" instead of accomodating all its inflected forms.
         This will yield in dimensionality reduction and incerases the
         efficiency of the system. The stemmer cuts the prefix and suffix of a
         word. 
         # Languages covered:
          Our stemmer works for the following  26 languages. Our stemmer works
          using the snowball stemmer algorithm which is also known as Porter 2
          Stemming algorithm. 
          1. Tamil
          2. Hindi
          3. English
          4. Arabic
          5. Basque
          6. Catalan
          7. Danish
          8. Dutch
          9. Finnish
          10.  French
          11. German
          12. Greek
          13. Hungarian
          14. Indonesian
          15. Irish
          16. Italian
          17. Lithuanian
          18. Nepali
          19. Norwegian
          20. Portuguese
          21. Romanian
          22. Russian
          23. Serbian
          24. Spanish
          25. Swedish
          26. Turkish

        Args:
            body (object): Add a JSON Input as per the schema defined below

        Returns:
            list of Responsestem: Response from the API. Stemmed output.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/api/stemmer'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'Content-Type': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.post(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        CustomHeaderAuth.apply(self.config, _request)
        _response = self.execute_request(_request)
        print(_response.status_code)
        # Endpoint and global error handling using HTTP status codes.
        if _response.status_code == 400:
            raise ErrorsException('Error output', _response)
        elif _response.status_code == 426:
            raise ApiStemmer426ErrorException('Please use HTTPS protocol', _response)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(_response.text, Responsestem.from_dictionary)

        return decoded

    def get_lemma(self,
                  body):
        """Does a POST request to /api/lemmatize.

        # Stemmer : Defintion and it's usage
        # Languages covered:

        Args:
            body (object): Add a JSON Input as per the schema defined below

        Returns:
            list of Responselemma: Response from the API. Lemmatized output.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/api/lemmatize'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'Content-Type': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.post(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        CustomHeaderAuth.apply(self.config, _request)
        _response = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _response.status_code == 400:
            raise ErrorsException('Error output', _response)
        elif _response.status_code == 426:
            raise ApiLemmatize426ErrorException('Please use HTTPS protocol', _response)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(_response.text, Responselemma.from_dictionary)

        return decoded

    def get_morph(self,
                  body):
        """Does a POST request to /api/morph.

        # Stemmer : Defintion and it's usage
        # Languages covered:

        Args:
            body (object): Add a JSON Input as per the schema defined below

        Returns:
            Responsemorph: Response from the API. Morphological output.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/api/morph'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'Content-Type': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.post(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        CustomHeaderAuth.apply(self.config, _request)
        _response = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _response.status_code == 400:
            raise ErrorsException('Error output', _response)
        elif _response.status_code == 426:
            raise ApiMorph426ErrorException('Please use HTTPS protocol', _response)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(_response.text, Responsemorph.from_dictionary)

        return decoded

    def get_postag(self,
                   body):
        """Does a POST request to /api/postag.

         **So, What is a POS Tagger?**
          Parts Of Speech Tagger, which is shortly known as POS Tagger is a
          software that automatically finds the word classes, when a text
          input is given. The text input can be a word, a sentence or a set of
          sentences. The word classes are the grammatical categories such as,
          Noun, Verb, Adverb etc. These category assigned to each word is a
          tag. A set of tags, each indicating a grammatical category is
          called, "tagsets". POS tagging is a mandatory pre processing for
          most of the Natural Language Processing Applications such as,
          Information Extraction, Information Retreival systems and Summary
          generation systems.
        **Is POS Tagger, a language-independent software?**
        No. A POS Tagger is a language-dependent software as the grammar rules
        will differ for every language. For instance, A word ending with "ing"
        might indicate a Verb" in English but this will not be applicable for
        other languages.
        **For what languages, our  POS Tagger API will work?**
        At present, our POS Tagger API works for English and Tami Languages.
        Soon we will extend the APIs to accomodate more languages. 
        **How Precise are our POS Tagger API?**
        will update accuracy metrics soon .....

        Args:
            body (object): Add a JSON Input as per the schema defined below

        Returns:
            list of Responsepo: Response from the API. POSTAG output.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/api/postag'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'Content-Type': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.post(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        CustomHeaderAuth.apply(self.config, _request)
        _response = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _response.status_code == 400:
            raise ErrorsException('Error output', _response)
        elif _response.status_code == 426:
            raise ApiPostag426ErrorException('Please use HTTPS protocol', _response)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(_response.text, Responsepo.from_dictionary)

        return decoded
