"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SmithyApiGatewayTsProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const open_api_gateway_ts_project_1 = require("./open-api-gateway-ts-project");
const setup_smithy_build_1 = require("./smithy/setup-smithy-build");
/**
 * Synthesizes a Typescript Project with a Smithy model, generated clients, a CDK construct for deploying the API
 * with API Gateway, and generated lambda handler wrappers for type-safe handling of requests.
 *
 * @pjid smithy-api-gateway-ts
 */
class SmithyApiGatewayTsProject extends open_api_gateway_ts_project_1.OpenApiGatewayTsProject {
    constructor(options) {
        super(options);
    }
    preConstruct(options) {
        const { generatedSpecFilePath } = setup_smithy_build_1.setupSmithyBuild(this, 
        // Options are the same as those in the constructor, so it is safe to cast to SmithyApiGatewayProjectOptions
        options);
        return {
            ...options,
            specFile: generatedSpecFilePath,
        };
    }
}
exports.SmithyApiGatewayTsProject = SmithyApiGatewayTsProject;
_a = JSII_RTTI_SYMBOL_1;
SmithyApiGatewayTsProject[_a] = { fqn: "@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayTsProject", version: "0.14.20" };
//# sourceMappingURL=data:application/json;base64,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