# AUTOGENERATED! DO NOT EDIT! File to edit: ../00_node.ipynb.

# %% auto 0
__all__ = ['Node']

# %% ../00_node.ipynb 4
from fastcore.test import * 

# %% ../00_node.ipynb 6
class Node:
    "A node"
    
    def __init__(self, 
                 id_: int = None, # a unique id for the node
                 input:tuple = None, # the input to the function represented by the node
                 output:any = None, # the output of the function represented by the node
                 depth: int = None, # the depth of the node in the graph (starting at 0)
                 discovered:int = None, # the time the node was first discovered in the graph traversal
                 finish: int = None,): # the time the node (and its descendants) were finished being explored in the graph traversal
        self.id_ = id_
        self.input = input
        self.output = output
        self.depth = depth
        self.discovered = discovered
        self.finish = finish
        
    def __repr__(self):
        return '<Node {}> f{}={} d={}, f={}'.format(self.id_, self.input, self.output, self.discovered, self.finish)
    
    def __str__(self):
        return self.__repr__()
    
    def __eq__(self, other:'Node'):
        return type(self) == type(other) and self.id_ == other.id_
