"use strict";
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
Object.defineProperty(exports, "__esModule", { value: true });
exports.ParsedSpec = void 0;
const path = require("path");
const projen_1 = require("projen");
const util_1 = require("projen/lib/util");
/**
 * Component for parsing the yaml OpenAPI spec as a single json object, resolving references etc.
 */
class ParsedSpec extends projen_1.Component {
    constructor(project, options) {
        super(project);
        this.options = options;
    }
    synthesize() {
        super.synthesize();
        // Parse the spec and write to the target output path
        util_1.exec(`./parse-openapi-spec --specPath=${this.options.specPath} --outputPath=${this.options.outputPath}`, {
            cwd: path.resolve(__dirname, "..", "..", "..", "..", "scripts", "parser"),
        });
    }
}
exports.ParsedSpec = ParsedSpec;
//# sourceMappingURL=data:application/json;base64,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