import * as codepipeline from '@aws-cdk/aws-codepipeline';
import * as sns from '@aws-cdk/aws-sns';
import { Action } from './action';
import { Construct } from '@aws-cdk/core';
/**
 * Construction properties of the {@link ManualApprovalAction}.
 *
 * @stability stable
 */
export interface ManualApprovalActionProps extends codepipeline.CommonAwsActionProps {
    /**
     * Optional SNS topic to send notifications to when an approval is pending.
     *
     * @stability stable
     */
    readonly notificationTopic?: sns.ITopic;
    /**
     * A list of email addresses to subscribe to notifications when this Action is pending approval.
     *
     * If this has been provided, but not `notificationTopic`,
     * a new Topic will be created.
     *
     * @stability stable
     */
    readonly notifyEmails?: string[];
    /**
     * Any additional information that you want to include in the notification email message.
     *
     * @stability stable
     */
    readonly additionalInformation?: string;
    /**
     * URL you want to provide to the reviewer as part of the approval request.
     *
     * @default - the approval request will not have an external link
     * @stability stable
     */
    readonly externalEntityLink?: string;
}
/**
 * Manual approval action.
 *
 * @stability stable
 */
export declare class ManualApprovalAction extends Action {
    /**
     * The SNS Topic passed when constructing the Action.
     * If no Topic was passed, but `notifyEmails` were provided,
     * a new Topic will be created.
     */
    private _notificationTopic?;
    private readonly props;
    /**
     * @stability stable
     */
    constructor(props: ManualApprovalActionProps);
    /**
     * @stability stable
     */
    get notificationTopic(): sns.ITopic | undefined;
    /**
     * This is a renamed version of the {@link IAction.bind} method.
     *
     * @stability stable
     */
    protected bound(scope: Construct, _stage: codepipeline.IStage, options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
}
