/**
 * BuildSpec for CodeBuild projects.
 */
export declare abstract class BuildSpec {
    /**
     *
     */
    static fromObject(value: {
        [key: string]: any;
    }): BuildSpec;
    /**
     * Use a file from the source as buildspec.
     *
     * Use this if you want to use a file different from 'buildspec.yml'`
     */
    static fromSourceFilename(filename: string): BuildSpec;
    /**
     * Whether the buildspec is directly available or deferred until build-time.
     */
    abstract readonly isImmediate: boolean;
    /**
     *
     */
    protected constructor();
    /**
     * Render the represented BuildSpec.
     */
    abstract toBuildSpec(): string;
}
/**
 * Merge two buildspecs into a new BuildSpec
 *
 * NOTE: will currently only merge commands, not artifact
 * declarations, environment variables, secrets, or any
 * other configuration elements.
 *
 * Internal for now because it's not complete/good enough
 * to expose on the objects directly, but we need to it to
 * keep feature-parity for Project.
 *
 * @internal
 */
export declare function mergeBuildSpecs(lhs: BuildSpec, rhs: BuildSpec): BuildSpec;
