"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const s3 = require("@aws-cdk/aws-s3");
const sns = require("@aws-cdk/aws-sns");
const cdk = require("@aws-cdk/core");
const notif = require("../lib");
test('asBucketNotificationDestination adds bucket permissions only once for each bucket', () => {
    const stack = new cdk.Stack();
    const topic = new sns.Topic(stack, 'MyTopic');
    const bucket = new s3.Bucket(stack, 'Bucket');
    const bucket2 = new s3.Bucket(stack, 'Bucket2');
    new notif.SnsDestination(topic).bind(bucket, bucket);
    new notif.SnsDestination(topic).bind(bucket, bucket);
    // another bucket will be added to the topic policy
    new notif.SnsDestination(topic).bind(bucket2, bucket2);
    expect(stack).toMatchTemplate({
        Resources: {
            Bucket83908E77: {
                Type: 'AWS::S3::Bucket',
                DeletionPolicy: 'Retain',
                UpdateReplacePolicy: 'Retain',
            },
            Bucket25524B414: {
                Type: 'AWS::S3::Bucket',
                DeletionPolicy: 'Retain',
                UpdateReplacePolicy: 'Retain',
            },
            MyTopic86869434: {
                Type: 'AWS::SNS::Topic',
            },
            MyTopicPolicy12A5EC17: {
                Type: 'AWS::SNS::TopicPolicy',
                Properties: {
                    PolicyDocument: {
                        Statement: [
                            {
                                Action: 'sns:Publish',
                                Condition: {
                                    ArnLike: {
                                        'aws:SourceArn': { 'Fn::GetAtt': ['Bucket83908E77', 'Arn'] },
                                    },
                                },
                                Effect: 'Allow',
                                Principal: {
                                    Service: 's3.amazonaws.com',
                                },
                                Resource: {
                                    Ref: 'MyTopic86869434',
                                },
                                Sid: '0',
                            },
                            {
                                Action: 'sns:Publish',
                                Condition: {
                                    ArnLike: {
                                        'aws:SourceArn': { 'Fn::GetAtt': ['Bucket25524B414', 'Arn'] },
                                    },
                                },
                                Effect: 'Allow',
                                Principal: {
                                    Service: 's3.amazonaws.com',
                                },
                                Resource: {
                                    Ref: 'MyTopic86869434',
                                },
                                Sid: '1',
                            },
                        ],
                        Version: '2012-10-17',
                    },
                    Topics: [
                        {
                            Ref: 'MyTopic86869434',
                        },
                    ],
                },
            },
        },
    });
});
//# sourceMappingURL=data:application/json;base64,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