"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// import { SynthUtils } from '@aws-cdk/assert';
require("@aws-cdk/assert/jest");
const lambda = require("@aws-cdk/aws-lambda");
const s3 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
const s3n = require("../../lib");
test('lambda as notification target', () => {
    // GIVEN
    const stack = new core_1.Stack();
    const bucketA = new s3.Bucket(stack, 'MyBucket');
    const fn = new lambda.Function(stack, 'MyFunction', {
        runtime: lambda.Runtime.NODEJS_10_X,
        handler: 'index.handler',
        code: lambda.Code.fromInline('foo'),
    });
    // WHEN
    bucketA.addObjectCreatedNotification(new s3n.LambdaDestination(fn), { suffix: '.png' });
    // THEN
    expect(stack).toHaveResource('AWS::Lambda::Permission', {
        Action: 'lambda:InvokeFunction',
        FunctionName: { 'Fn::GetAtt': ['MyFunction3BAA72D1', 'Arn'] },
        Principal: 's3.amazonaws.com',
        SourceAccount: { Ref: 'AWS::AccountId' },
        SourceArn: { 'Fn::GetAtt': ['MyBucketF68F3FF0', 'Arn'] },
    });
    expect(stack).toHaveResource('Custom::S3BucketNotifications', {
        NotificationConfiguration: {
            LambdaFunctionConfigurations: [
                {
                    Events: ['s3:ObjectCreated:*'],
                    Filter: {
                        Key: {
                            FilterRules: [{ Name: 'suffix', Value: '.png' }],
                        },
                    },
                    LambdaFunctionArn: { 'Fn::GetAtt': ['MyFunction3BAA72D1', 'Arn'] },
                },
            ],
        },
    });
});
test('lambda as notification target specified by function arn', () => {
    // GIVEN
    const stack = new core_1.Stack();
    const bucketA = new s3.Bucket(stack, 'MyBucket');
    const fn = lambda.Function.fromFunctionArn(stack, 'MyFunction', 'arn:aws:lambda:us-east-1:123456789012:function:ProcessKinesisRecords');
    // WHEN
    bucketA.addObjectCreatedNotification(new s3n.LambdaDestination(fn), { suffix: '.png' });
    // THEN
    expect(stack).toHaveResource('Custom::S3BucketNotifications', {
        NotificationConfiguration: {
            LambdaFunctionConfigurations: [
                {
                    Events: ['s3:ObjectCreated:*'],
                    Filter: {
                        Key: {
                            FilterRules: [{ Name: 'suffix', Value: '.png' }],
                        },
                    },
                    LambdaFunctionArn: 'arn:aws:lambda:us-east-1:123456789012:function:ProcessKinesisRecords',
                },
            ],
        },
    });
});
//# sourceMappingURL=data:application/json;base64,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