"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("@aws-cdk/aws-iam");
const s3 = require("@aws-cdk/aws-s3");
/**
 * Use an SNS topic as a bucket notification destination
 */
class SnsDestination {
    constructor(topic) {
        this.topic = topic;
    }
    bind(_scope, bucket) {
        this.topic.addToResourcePolicy(new iam.PolicyStatement({
            principals: [new iam.ServicePrincipal('s3.amazonaws.com')],
            actions: ['sns:Publish'],
            resources: [this.topic.topicArn],
            conditions: {
                ArnLike: { 'aws:SourceArn': bucket.bucketArn },
            },
        }));
        return {
            arn: this.topic.topicArn,
            type: s3.BucketNotificationDestinationType.TOPIC,
            dependencies: [this.topic],
        };
    }
}
exports.SnsDestination = SnsDestination;
//# sourceMappingURL=data:application/json;base64,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