"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("@aws-cdk/aws-iam");
const s3 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
/**
 * Use a Lambda function as a bucket notification destination
 */
class LambdaDestination {
    constructor(fn) {
        this.fn = fn;
    }
    bind(_scope, bucket) {
        const permissionId = `AllowBucketNotificationsFrom${bucket.node.uniqueId}`;
        if (this.fn.node.tryFindChild(permissionId) === undefined) {
            this.fn.addPermission(permissionId, {
                sourceAccount: core_1.Stack.of(bucket).account,
                principal: new iam.ServicePrincipal('s3.amazonaws.com'),
                sourceArn: bucket.bucketArn,
            });
        }
        // if we have a permission resource for this relationship, add it as a dependency
        // to the bucket notifications resource, so it will be created first.
        const permission = this.fn.node.tryFindChild(permissionId);
        return {
            type: s3.BucketNotificationDestinationType.LAMBDA,
            arn: this.fn.functionArn,
            dependencies: permission ? [permission] : undefined,
        };
    }
}
exports.LambdaDestination = LambdaDestination;
//# sourceMappingURL=data:application/json;base64,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