"""
Django settings for django_boilerplate project.

Generated by 'django-admin startproject' using Django 3.1.

For more information on this file, see
https://docs.djangoproject.com/en/3.1/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/3.1/ref/settings/
"""
import os
import sys
from pathlib import Path
from environ import Env

env = Env(
    # set casting, default value
    DEBUG=(bool, False),
    ADMIN_URL=(str, 'admin/'),
    TIME_ZONE=(str, 'Asia/Phnom_Penh'),
    SECRET_KEY=(str, 'S3cRétH3rë'),
    LANGUAGE_CODE=(str, 'en-us'),
    ALLOWED_HOSTS=(str, '* '),
    DJANGO_STATIC_HOST=(str, '')
)

Env.read_env()

# Build paths inside the project like this: BASE_DIR / 'subdir'.
BASE_DIR = Path(__file__).resolve(strict=True).parent.parent

# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/3.1/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = env('SECRET_KEY')

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = env('DEBUG')

ALLOWED_HOSTS = env('ALLOWED_HOSTS').split(" ")

# Application definition

INSTALLED_APPS = [
    'whitenoise.runserver_nostatic',
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    # Applications defined here
    'constance',
    'constance.backends.database',
    'core',
    'dj_database_url',
    'django_extensions',
    # Add Rest Framework with OAuth 2
    'rest_framework',
    'rest_framework.authtoken',
    'rest_auth',
    'oauth2_provider',
    'corsheaders',
    # Add Swagger for Rest Framework
    'drf_yasg',
]

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'whitenoise.middleware.WhiteNoiseMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
    'corsheaders.middleware.CorsMiddleware',
    'oauth2_provider.middleware.OAuth2TokenMiddleware'
]

ROOT_URLCONF = 'django_boilerplate.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

WSGI_APPLICATION = 'django_boilerplate.wsgi.application'

# Database
# https://docs.djangoproject.com/en/3.1/ref/settings/#databases

DATABASES = {
    'default': env.db(),
    'extra': env.db('SQLITE_URL', default='sqlite:////tmp/db.sqlite3'),
}

CACHES = {
    'default': env.cache(),
    'redis': env.cache('REDIS_URL')
}

# Password validation
# https://docs.djangoproject.com/en/3.1/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]

# Internationalization
# https://docs.djangoproject.com/en/3.1/topics/i18n/

LANGUAGE_CODE = env('LANGUAGE_CODE')

TIME_ZONE = env('TIME_ZONE')

USE_I18N = True

USE_L10N = True

USE_TZ = True

# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/3.1/howto/static-files/

WHITENOISE_INDEX_FILE = True

CONSTANCE_BACKEND = 'constance.backends.database.DatabaseBackend'

CONSTANCE_ADDITIONAL_FIELDS = {
    'image_field': ['django.forms.ImageField', {}],
    'yes_no_null_select': ['django.forms.fields.ChoiceField', {
        'widget': 'django.forms.Select',
        'choices': ((None, "-----"), ("yes", "Yes"), ("no", "No"))
    }],
}

CONSTANCE_CONFIG = {
    'SITE_NAME': ('My Title', 'Website title'),
    'SITE_DESCRIPTION': ('My Description', 'Website description'),
    'LOGO_IMAGE': ('logo.png', 'Company logo', 'image_field'),
    'MY_SELECT_KEY': ('yes', 'select yes or no', 'yes_no_null_select'),
    'THEME': ('light-blue', 'Website theme'),
}

CONSTANCE_CONFIG_FIELDSETS = {
    'Site Options': {
        'fields': ('SITE_NAME', 'SITE_DESCRIPTION', 'LOGO_IMAGE', 'MY_SELECT_KEY'),
        'collapse': True
    },
    'Theme Options': ('THEME',),
}

STATIC_ROOT = os.path.join(BASE_DIR, 'staticfiles')
STATIC_HOST = env('DJANGO_STATIC_HOST')

STATICFILES_STORAGE = 'whitenoise.storage.CompressedManifestStaticFilesStorage'

STATIC_URL = STATIC_HOST + '/static/'

REST_FRAMEWORK = {
    "DEFAULT_AUTHENTICATION_CLASSES": [
        "oauth2_provider.contrib.rest_framework.OAuth2Authentication",
        "rest_framework.authentication.BasicAuthentication",
        "rest_framework.authentication.TokenAuthentication",
        # "rest_framework.authentication.SessionAuthentication",
    ],
    'DEFAULT_PERMISSION_CLASSES': [
        'rest_framework.permissions.IsAuthenticated',
        'rest_framework.permissions.DjangoModelPermissionsOrAnonReadOnly'
    ],
    "DEFAULT_RENDERER_CLASSES": [
        "rest_framework.renderers.JSONRenderer",
        "rest_framework.renderers.BrowsableAPIRenderer",
    ],
    "DEFAULT_PARSER_CLASSES": [
        "rest_framework.parsers.JSONParser",
        "rest_framework.parsers.FormParser",
        "rest_framework.parsers.MultiPartParser",
        "rest_framework.parsers.FileUploadParser",
    ],
    "DEFAULT_SCHEMA_CLASS": "rest_framework.schemas.coreapi.AutoSchema",
    "DEFAULT_PAGINATION_CLASS": "rest_framework.pagination.PageNumberPagination",
    "PAGE_SIZE": 2,
}

CORS_ORIGIN_ALLOW_ALL = True

OAUTH2_PROVIDER = {
    "SCOPES": {
        "read": "Read scope",
        "write": "Write scope",
        "admin": "Grands read and write access to administrative information"
    },
    # Set all request and authentication use JSON with Raw
    # "OAUTH2_BACKEND_CLASS": "oauth2_provider.oauth2_backends.JSONOAuthLibCore",
}

SWAGGER_SETTINGS = {
    "USE_SESSION_AUTH": False,
    "OAUTH2_CONFIG": {
        "appName": os.environ.get("API_NAME"),
        "clientId": os.environ.get("CLIENT_ID"),
        "clientSecret": os.environ.get("CLIENT_SECRET"),
    },
    "SECURITY_DEFINITIONS": {
        # "basic": {"type": "basic"},
        # "api_key": {"type": "apiKey", "name": "Authorization", "in": "header"},
        "oauth2": {
            "type": "oauth2",
            "flow": "password",
            "tokenUrl": os.environ.get("TOKEN_URL"),
            "scopes": OAUTH2_PROVIDER.get("SCOPES"),
        }
    },
    # "APIS_SORTER": "alpha",
    "DOC_EXPANSION": "list",
    "JSON_EDITOR": True,
    "OPERATIONS_SORTER": "method",
    "SHOW_REQUEST_HEADERS": True,
}
