"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DynamoDBStreamToLambdaToElasticSearchAndKibana = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const core_1 = require("@aws-cdk/core");
const aws_dynamodbstreams_lambda_elasticsearch_kibana_1 = require("@aws-solutions-constructs/aws-dynamodbstreams-lambda-elasticsearch-kibana");
class DynamoDBStreamToLambdaToElasticSearchAndKibana extends core_1.Construct {
    /**
     * @summary Constructs a new instance of the LambdaToDynamoDB class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {DynamoDBStreamToLambdaToElasticSearchAndKibanaProps} props - user provided props for the construct
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        const convertedProps = { ...props };
        // W (for 'wrapped') is added to the id so that the id's of the constructs with the old and new names don't collide
        // If this character pushes you beyond the 64 character limit, just import the new named construct and instantiate
        // it in place of the older named version. They are functionally identical, aside from the types no other changes
        // will be required.  (eg - new DynamoDBStreamsToLambdaToElasticSearchAndKibana instead of DynamoDBStreamToLambdaToElasticSearchAndKibana)
        const wrappedConstruct = new aws_dynamodbstreams_lambda_elasticsearch_kibana_1.DynamoDBStreamsToLambdaToElasticSearchAndKibana(this, `${id}W`, convertedProps);
        this.lambdaFunction = wrappedConstruct.lambdaFunction;
        this.dynamoTable = wrappedConstruct.dynamoTable;
        this.dynamoTableInterface = wrappedConstruct.dynamoTableInterface;
        this.userPool = wrappedConstruct.userPool;
        this.userPoolClient = wrappedConstruct.userPoolClient;
        this.identityPool = wrappedConstruct.identityPool;
        this.elasticsearchDomain = wrappedConstruct.elasticsearchDomain;
        this.elasticsearchRole = wrappedConstruct.elasticsearchRole;
        this.cloudwatchAlarms = wrappedConstruct.cloudwatchAlarms;
    }
}
exports.DynamoDBStreamToLambdaToElasticSearchAndKibana = DynamoDBStreamToLambdaToElasticSearchAndKibana;
_a = JSII_RTTI_SYMBOL_1;
DynamoDBStreamToLambdaToElasticSearchAndKibana[_a] = { fqn: "@aws-solutions-constructs/aws-dynamodb-stream-lambda-elasticsearch-kibana.DynamoDBStreamToLambdaToElasticSearchAndKibana", version: "1.173.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbmRleC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQW9CQSx3RkFBd0Y7QUFDeEYsd0NBQTBDO0FBRTFDLCtJQUE0STtBQTJFNUksTUFBYSw4Q0FBK0MsU0FBUSxnQkFBUztJQVczRTs7Ozs7O09BTUc7SUFDSCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQTBEO1FBQ2xHLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFDakIsTUFBTSxjQUFjLEdBQXdELEVBQUUsR0FBRyxLQUFLLEVBQUUsQ0FBQztRQUV6RixtSEFBbUg7UUFDbkgsa0hBQWtIO1FBQ2xILGlIQUFpSDtRQUNqSCwwSUFBMEk7UUFDMUksTUFBTSxnQkFBZ0IsR0FBbUQsSUFBSSxpR0FBK0MsQ0FDMUgsSUFBSSxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsY0FBYyxDQUFDLENBQUM7UUFFbEMsSUFBSSxDQUFDLGNBQWMsR0FBRyxnQkFBZ0IsQ0FBQyxjQUFjLENBQUM7UUFDdEQsSUFBSSxDQUFDLFdBQVcsR0FBRyxnQkFBZ0IsQ0FBQyxXQUFXLENBQUM7UUFDaEQsSUFBSSxDQUFDLG9CQUFvQixHQUFHLGdCQUFnQixDQUFDLG9CQUFvQixDQUFDO1FBQ2xFLElBQUksQ0FBQyxRQUFRLEdBQUcsZ0JBQWdCLENBQUMsUUFBUSxDQUFDO1FBQzFDLElBQUksQ0FBQyxjQUFjLEdBQUcsZ0JBQWdCLENBQUMsY0FBYyxDQUFDO1FBQ3RELElBQUksQ0FBQyxZQUFZLEdBQUcsZ0JBQWdCLENBQUMsWUFBWSxDQUFDO1FBQ2xELElBQUksQ0FBQyxtQkFBbUIsR0FBRyxnQkFBZ0IsQ0FBQyxtQkFBbUIsQ0FBQztRQUNoRSxJQUFJLENBQUMsaUJBQWlCLEdBQUcsZ0JBQWdCLENBQUMsaUJBQWlCLENBQUM7UUFDNUQsSUFBSSxDQUFDLGdCQUFnQixHQUFHLGdCQUFnQixDQUFDLGdCQUFnQixDQUFDO0lBQzVELENBQUM7O0FBdENILHdHQXVDQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogIENvcHlyaWdodCAyMDIyIEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogIExpY2Vuc2VkIHVuZGVyIHRoZSBBcGFjaGUgTGljZW5zZSwgVmVyc2lvbiAyLjAgKHRoZSBcIkxpY2Vuc2VcIikuIFlvdSBtYXkgbm90IHVzZSB0aGlzIGZpbGUgZXhjZXB0IGluIGNvbXBsaWFuY2VcbiAqICB3aXRoIHRoZSBMaWNlbnNlLiBBIGNvcHkgb2YgdGhlIExpY2Vuc2UgaXMgbG9jYXRlZCBhdFxuICpcbiAqICAgICAgaHR0cDovL3d3dy5hcGFjaGUub3JnL2xpY2Vuc2VzL0xJQ0VOU0UtMi4wXG4gKlxuICogIG9yIGluIHRoZSAnbGljZW5zZScgZmlsZSBhY2NvbXBhbnlpbmcgdGhpcyBmaWxlLiBUaGlzIGZpbGUgaXMgZGlzdHJpYnV0ZWQgb24gYW4gJ0FTIElTJyBCQVNJUywgV0lUSE9VVCBXQVJSQU5USUVTXG4gKiAgT1IgQ09ORElUSU9OUyBPRiBBTlkgS0lORCwgZXhwcmVzcyBvciBpbXBsaWVkLiBTZWUgdGhlIExpY2Vuc2UgZm9yIHRoZSBzcGVjaWZpYyBsYW5ndWFnZSBnb3Zlcm5pbmcgcGVybWlzc2lvbnNcbiAqICBhbmQgbGltaXRhdGlvbnMgdW5kZXIgdGhlIExpY2Vuc2UuXG4gKi9cblxuaW1wb3J0ICogYXMgbGFtYmRhIGZyb20gJ0Bhd3MtY2RrL2F3cy1sYW1iZGEnO1xuaW1wb3J0ICogYXMgZWxhc3RpY3NlYXJjaCBmcm9tICdAYXdzLWNkay9hd3MtZWxhc3RpY3NlYXJjaCc7XG5pbXBvcnQgKiBhcyBpYW0gZnJvbSAnQGF3cy1jZGsvYXdzLWlhbSc7XG5pbXBvcnQgeyBEeW5hbW9FdmVudFNvdXJjZVByb3BzIH0gZnJvbSAnQGF3cy1jZGsvYXdzLWxhbWJkYS1ldmVudC1zb3VyY2VzJztcbmltcG9ydCAqIGFzIGR5bmFtb2RiIGZyb20gJ0Bhd3MtY2RrL2F3cy1keW5hbW9kYic7XG5pbXBvcnQgKiBhcyBjb2duaXRvIGZyb20gJ0Bhd3MtY2RrL2F3cy1jb2duaXRvJztcbmltcG9ydCAqIGFzIGNsb3Vkd2F0Y2ggZnJvbSAnQGF3cy1jZGsvYXdzLWNsb3Vkd2F0Y2gnO1xuLy8gTm90ZTogVG8gZW5zdXJlIENES3YyIGNvbXBhdGliaWxpdHksIGtlZXAgdGhlIGltcG9ydCBzdGF0ZW1lbnQgZm9yIENvbnN0cnVjdCBzZXBhcmF0ZVxuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgKiBhcyBzcXMgZnJvbSAnQGF3cy1jZGsvYXdzLXNxcyc7XG5pbXBvcnQgeyBEeW5hbW9EQlN0cmVhbXNUb0xhbWJkYVRvRWxhc3RpY1NlYXJjaEFuZEtpYmFuYSB9IGZyb20gXCJAYXdzLXNvbHV0aW9ucy1jb25zdHJ1Y3RzL2F3cy1keW5hbW9kYnN0cmVhbXMtbGFtYmRhLWVsYXN0aWNzZWFyY2gta2liYW5hXCI7XG5cbi8qKlxuICogQHN1bW1hcnkgVGhlIHByb3BlcnRpZXMgZm9yIHRoZSBEeW5hbW9EQlN0cmVhbVRvTGFtYmRhVG9FbGFzdGNpU2VhcmNoQW5kS2liYW5hIENvbnN0cnVjdFxuICovXG5leHBvcnQgaW50ZXJmYWNlIER5bmFtb0RCU3RyZWFtVG9MYW1iZGFUb0VsYXN0aWNTZWFyY2hBbmRLaWJhbmFQcm9wcyB7XG4gIC8qKlxuICAgKiBFeGlzdGluZyBpbnN0YW5jZSBvZiBMYW1iZGEgRnVuY3Rpb24gb2JqZWN0LCBwcm92aWRpbmcgYm90aCB0aGlzIGFuZCBgbGFtYmRhRnVuY3Rpb25Qcm9wc2Agd2lsbCBjYXVzZSBhbiBlcnJvci5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBOb25lXG4gICAqL1xuICByZWFkb25seSBleGlzdGluZ0xhbWJkYU9iaj86IGxhbWJkYS5GdW5jdGlvbixcbiAgLyoqXG4gICAqIFVzZXIgcHJvdmlkZWQgcHJvcHMgdG8gb3ZlcnJpZGUgdGhlIGRlZmF1bHQgcHJvcHMgZm9yIHRoZSBMYW1iZGEgZnVuY3Rpb24uXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gRGVmYXVsdCBwcm9wcyBhcmUgdXNlZFxuICAgKi9cbiAgcmVhZG9ubHkgbGFtYmRhRnVuY3Rpb25Qcm9wcz86IGxhbWJkYS5GdW5jdGlvblByb3BzLFxuICAvKipcbiAgICogT3B0aW9uYWwgdXNlciBwcm92aWRlZCBwcm9wcyB0byBvdmVycmlkZSB0aGUgZGVmYXVsdCBwcm9wc1xuICAgKlxuICAgKiBAZGVmYXVsdCAtIERlZmF1bHQgcHJvcHMgYXJlIHVzZWRcbiAgICovXG4gIHJlYWRvbmx5IGR5bmFtb1RhYmxlUHJvcHM/OiBkeW5hbW9kYi5UYWJsZVByb3BzLFxuICAvKipcbiAgICogRXhpc3RpbmcgaW5zdGFuY2Ugb2YgRHluYW1vREIgdGFibGUgb2JqZWN0LCBwcm92aWRpbmcgYm90aCB0aGlzIGFuZCBgZHluYW1vVGFibGVQcm9wc2Agd2lsbCBjYXVzZSBhbiBlcnJvci5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBOb25lXG4gICAqL1xuICByZWFkb25seSBleGlzdGluZ1RhYmxlSW50ZXJmYWNlPzogZHluYW1vZGIuSVRhYmxlLFxuICAvKipcbiAgICogT3B0aW9uYWwgdXNlciBwcm92aWRlZCBwcm9wcyB0byBvdmVycmlkZSB0aGUgZGVmYXVsdCBwcm9wc1xuICAgKlxuICAgKiBAZGVmYXVsdCAtIERlZmF1bHQgcHJvcHMgYXJlIHVzZWRcbiAgICovXG4gIHJlYWRvbmx5IGR5bmFtb0V2ZW50U291cmNlUHJvcHM/OiBEeW5hbW9FdmVudFNvdXJjZVByb3BzLFxuICAvKipcbiAgICogT3B0aW9uYWwgdXNlciBwcm92aWRlZCBwcm9wcyB0byBvdmVycmlkZSB0aGUgZGVmYXVsdCBwcm9wcyBmb3IgdGhlIEFQSSBHYXRld2F5LlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIERlZmF1bHQgcHJvcHMgYXJlIHVzZWRcbiAgICovXG4gIHJlYWRvbmx5IGVzRG9tYWluUHJvcHM/OiBlbGFzdGljc2VhcmNoLkNmbkRvbWFpblByb3BzLFxuICAvKipcbiAgICogQ29nbml0byAmIEVTIERvbWFpbiBOYW1lXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gTm9uZVxuICAgKi9cbiAgcmVhZG9ubHkgZG9tYWluTmFtZTogc3RyaW5nLFxuICAvKipcbiAgICogT3B0aW9uYWwgQ29nbml0byBEb21haW4gTmFtZSwgaWYgcHJvdmlkZWQgaXQgd2lsbCBiZSB1c2VkIGZvciBDb2duaXRvIERvbWFpbiwgYW5kIGRvbWFpbk5hbWUgd2lsbCBiZSB1c2VkIGZvciB0aGUgRWxhc3RpY3NlYXJjaCBEb21haW5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBOb25lXG4gICAqL1xuICByZWFkb25seSBjb2duaXRvRG9tYWluTmFtZT86IHN0cmluZyxcbiAgLyoqXG4gICAqIFdoZXRoZXIgdG8gZGVwbG95IGEgU1FTIGRlYWQgbGV0dGVyIHF1ZXVlIHdoZW4gYSBkYXRhIHJlY29yZCByZWFjaGVzIHRoZSBNYXhpbXVtIFJldHJ5IEF0dGVtcHRzIG9yIE1heGltdW0gUmVjb3JkIEFnZSxcbiAgICogaXRzIG1ldGFkYXRhIGxpa2Ugc2hhcmQgSUQgYW5kIHN0cmVhbSBBUk4gd2lsbCBiZSBzZW50IHRvIGFuIFNRUyBxdWV1ZS5cbiAgICpcbiAgICogQGRlZmF1bHQgLSB0cnVlLlxuICAgKi9cbiAgcmVhZG9ubHkgZGVwbG95U3FzRGxxUXVldWU/OiBib29sZWFuLFxuICAvKipcbiAgICogT3B0aW9uYWwgdXNlciBwcm92aWRlZCBwcm9wZXJ0aWVzIGZvciB0aGUgU1FTIGRlYWQgbGV0dGVyIHF1ZXVlXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gRGVmYXVsdCBwcm9wcyBhcmUgdXNlZFxuICAgKi9cbiAgcmVhZG9ubHkgc3FzRGxxUXVldWVQcm9wcz86IHNxcy5RdWV1ZVByb3BzLFxuICAvKipcbiAgICogV2hldGhlciB0byBjcmVhdGUgcmVjb21tZW5kZWQgQ2xvdWRXYXRjaCBhbGFybXNcbiAgICpcbiAgICogQGRlZmF1bHQgLSBBbGFybXMgYXJlIGNyZWF0ZWRcbiAgICovXG4gIHJlYWRvbmx5IGNyZWF0ZUNsb3VkV2F0Y2hBbGFybXM/OiBib29sZWFuXG59XG5cbmV4cG9ydCBjbGFzcyBEeW5hbW9EQlN0cmVhbVRvTGFtYmRhVG9FbGFzdGljU2VhcmNoQW5kS2liYW5hIGV4dGVuZHMgQ29uc3RydWN0IHtcbiAgcHVibGljIHJlYWRvbmx5IGxhbWJkYUZ1bmN0aW9uOiBsYW1iZGEuRnVuY3Rpb247XG4gIHB1YmxpYyByZWFkb25seSBkeW5hbW9UYWJsZUludGVyZmFjZTogZHluYW1vZGIuSVRhYmxlO1xuICBwdWJsaWMgcmVhZG9ubHkgZHluYW1vVGFibGU/OiBkeW5hbW9kYi5UYWJsZTtcbiAgcHVibGljIHJlYWRvbmx5IHVzZXJQb29sOiBjb2duaXRvLlVzZXJQb29sO1xuICBwdWJsaWMgcmVhZG9ubHkgdXNlclBvb2xDbGllbnQ6IGNvZ25pdG8uVXNlclBvb2xDbGllbnQ7XG4gIHB1YmxpYyByZWFkb25seSBpZGVudGl0eVBvb2w6IGNvZ25pdG8uQ2ZuSWRlbnRpdHlQb29sO1xuICBwdWJsaWMgcmVhZG9ubHkgZWxhc3RpY3NlYXJjaERvbWFpbjogZWxhc3RpY3NlYXJjaC5DZm5Eb21haW47XG4gIHB1YmxpYyByZWFkb25seSBlbGFzdGljc2VhcmNoUm9sZTogaWFtLlJvbGU7XG4gIHB1YmxpYyByZWFkb25seSBjbG91ZHdhdGNoQWxhcm1zPzogY2xvdWR3YXRjaC5BbGFybVtdO1xuXG4gIC8qKlxuICAgKiBAc3VtbWFyeSBDb25zdHJ1Y3RzIGEgbmV3IGluc3RhbmNlIG9mIHRoZSBMYW1iZGFUb0R5bmFtb0RCIGNsYXNzLlxuICAgKiBAcGFyYW0ge2Nkay5BcHB9IHNjb3BlIC0gcmVwcmVzZW50cyB0aGUgc2NvcGUgZm9yIGFsbCB0aGUgcmVzb3VyY2VzLlxuICAgKiBAcGFyYW0ge3N0cmluZ30gaWQgLSB0aGlzIGlzIGEgYSBzY29wZS11bmlxdWUgaWQuXG4gICAqIEBwYXJhbSB7RHluYW1vREJTdHJlYW1Ub0xhbWJkYVRvRWxhc3RpY1NlYXJjaEFuZEtpYmFuYVByb3BzfSBwcm9wcyAtIHVzZXIgcHJvdmlkZWQgcHJvcHMgZm9yIHRoZSBjb25zdHJ1Y3RcbiAgICogQGFjY2VzcyBwdWJsaWNcbiAgICovXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBEeW5hbW9EQlN0cmVhbVRvTGFtYmRhVG9FbGFzdGljU2VhcmNoQW5kS2liYW5hUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuICAgIGNvbnN0IGNvbnZlcnRlZFByb3BzOiBEeW5hbW9EQlN0cmVhbVRvTGFtYmRhVG9FbGFzdGljU2VhcmNoQW5kS2liYW5hUHJvcHMgPSB7IC4uLnByb3BzIH07XG5cbiAgICAvLyBXIChmb3IgJ3dyYXBwZWQnKSBpcyBhZGRlZCB0byB0aGUgaWQgc28gdGhhdCB0aGUgaWQncyBvZiB0aGUgY29uc3RydWN0cyB3aXRoIHRoZSBvbGQgYW5kIG5ldyBuYW1lcyBkb24ndCBjb2xsaWRlXG4gICAgLy8gSWYgdGhpcyBjaGFyYWN0ZXIgcHVzaGVzIHlvdSBiZXlvbmQgdGhlIDY0IGNoYXJhY3RlciBsaW1pdCwganVzdCBpbXBvcnQgdGhlIG5ldyBuYW1lZCBjb25zdHJ1Y3QgYW5kIGluc3RhbnRpYXRlXG4gICAgLy8gaXQgaW4gcGxhY2Ugb2YgdGhlIG9sZGVyIG5hbWVkIHZlcnNpb24uIFRoZXkgYXJlIGZ1bmN0aW9uYWxseSBpZGVudGljYWwsIGFzaWRlIGZyb20gdGhlIHR5cGVzIG5vIG90aGVyIGNoYW5nZXNcbiAgICAvLyB3aWxsIGJlIHJlcXVpcmVkLiAgKGVnIC0gbmV3IER5bmFtb0RCU3RyZWFtc1RvTGFtYmRhVG9FbGFzdGljU2VhcmNoQW5kS2liYW5hIGluc3RlYWQgb2YgRHluYW1vREJTdHJlYW1Ub0xhbWJkYVRvRWxhc3RpY1NlYXJjaEFuZEtpYmFuYSlcbiAgICBjb25zdCB3cmFwcGVkQ29uc3RydWN0OiBEeW5hbW9EQlN0cmVhbVRvTGFtYmRhVG9FbGFzdGljU2VhcmNoQW5kS2liYW5hID0gbmV3IER5bmFtb0RCU3RyZWFtc1RvTGFtYmRhVG9FbGFzdGljU2VhcmNoQW5kS2liYW5hKFxuICAgICAgdGhpcywgYCR7aWR9V2AsIGNvbnZlcnRlZFByb3BzKTtcblxuICAgIHRoaXMubGFtYmRhRnVuY3Rpb24gPSB3cmFwcGVkQ29uc3RydWN0LmxhbWJkYUZ1bmN0aW9uO1xuICAgIHRoaXMuZHluYW1vVGFibGUgPSB3cmFwcGVkQ29uc3RydWN0LmR5bmFtb1RhYmxlO1xuICAgIHRoaXMuZHluYW1vVGFibGVJbnRlcmZhY2UgPSB3cmFwcGVkQ29uc3RydWN0LmR5bmFtb1RhYmxlSW50ZXJmYWNlO1xuICAgIHRoaXMudXNlclBvb2wgPSB3cmFwcGVkQ29uc3RydWN0LnVzZXJQb29sO1xuICAgIHRoaXMudXNlclBvb2xDbGllbnQgPSB3cmFwcGVkQ29uc3RydWN0LnVzZXJQb29sQ2xpZW50O1xuICAgIHRoaXMuaWRlbnRpdHlQb29sID0gd3JhcHBlZENvbnN0cnVjdC5pZGVudGl0eVBvb2w7XG4gICAgdGhpcy5lbGFzdGljc2VhcmNoRG9tYWluID0gd3JhcHBlZENvbnN0cnVjdC5lbGFzdGljc2VhcmNoRG9tYWluO1xuICAgIHRoaXMuZWxhc3RpY3NlYXJjaFJvbGUgPSB3cmFwcGVkQ29uc3RydWN0LmVsYXN0aWNzZWFyY2hSb2xlO1xuICAgIHRoaXMuY2xvdWR3YXRjaEFsYXJtcyA9IHdyYXBwZWRDb25zdHJ1Y3QuY2xvdWR3YXRjaEFsYXJtcztcbiAgfVxufVxuIl19