"use strict";
var _a, _b, _c, _d, _e, _f;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Authorizers = exports.IamAuthorizer = exports.NoneAuthorizer = exports.CustomAuthorizer = exports.CustomAuthorizerType = exports.CognitoAuthorizer = exports.Authorizer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
const aws_apigateway_1 = require("aws-cdk-lib/aws-apigateway");
const constants_1 = require("../prepare-spec-event-handler/constants");
/**
 * An authorizer for authorizing API requests
 */
class Authorizer {
    constructor(props) {
        this.authorizerId = props.authorizerId;
        this.authorizationType = props.authorizationType;
        this.authorizationScopes = props.authorizationScopes;
    }
}
exports.Authorizer = Authorizer;
_a = JSII_RTTI_SYMBOL_1;
Authorizer[_a] = { fqn: "@aws-prototyping-sdk/open-api-gateway.Authorizer", version: "0.12.4" };
/**
 * An authorizer that uses Cognito identity or access tokens.
 */
class CognitoAuthorizer extends Authorizer {
    constructor(props) {
        super({
            authorizerId: props.authorizerId,
            authorizationType: aws_apigateway_1.AuthorizationType.COGNITO,
            authorizationScopes: props.authorizationScopes,
        });
        this.userPools = props.userPools;
    }
    /**
     * Returns this authorizer with scopes applied, intended for usage in individual operations where scopes may differ
     * on a per-operation basis
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes
     * @param authorizationScopes the scopes to apply
     */
    withScopes(...authorizationScopes) {
        return new CognitoAuthorizer({
            authorizerId: this.authorizerId,
            userPools: this.userPools,
            authorizationScopes,
        });
    }
}
exports.CognitoAuthorizer = CognitoAuthorizer;
_b = JSII_RTTI_SYMBOL_1;
CognitoAuthorizer[_b] = { fqn: "@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer", version: "0.12.4" };
/**
 * The type of custom authorizer
 * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-type
 */
var CustomAuthorizerType;
(function (CustomAuthorizerType) {
    /**
     * A custom authorizer that uses a Lambda function.
     */
    CustomAuthorizerType["TOKEN"] = "token";
    /**
     * An authorizer that uses a Lambda function using incoming request parameters.
     */
    CustomAuthorizerType["REQUEST"] = "request";
})(CustomAuthorizerType = exports.CustomAuthorizerType || (exports.CustomAuthorizerType = {}));
// The default time to cache the custom authorizer result
const DEFAULT_CUSTOM_AUTHORIZER_RESULT_TTL_SECONDS = 300;
/**
 * An authorizer that uses a lambda function to authorize requests
 */
class CustomAuthorizer extends Authorizer {
    constructor(props) {
        super({
            authorizerId: props.authorizerId,
            authorizationType: aws_apigateway_1.AuthorizationType.CUSTOM,
        });
        this.function = props.function;
        this.type = props.type ?? CustomAuthorizerType.TOKEN;
        this.identitySource =
            props.identitySource ?? "method.request.header.Authorization";
        this.authorizerResultTtlInSeconds =
            props.authorizerResultTtlInSeconds ??
                DEFAULT_CUSTOM_AUTHORIZER_RESULT_TTL_SECONDS;
    }
}
exports.CustomAuthorizer = CustomAuthorizer;
_c = JSII_RTTI_SYMBOL_1;
CustomAuthorizer[_c] = { fqn: "@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer", version: "0.12.4" };
/**
 * No authorizer
 */
class NoneAuthorizer extends Authorizer {
    constructor() {
        super({
            authorizerId: constants_1.DefaultAuthorizerIds.NONE,
            authorizationType: aws_apigateway_1.AuthorizationType.NONE,
        });
    }
}
exports.NoneAuthorizer = NoneAuthorizer;
_d = JSII_RTTI_SYMBOL_1;
NoneAuthorizer[_d] = { fqn: "@aws-prototyping-sdk/open-api-gateway.NoneAuthorizer", version: "0.12.4" };
/**
 * An IAM authorizer
 */
class IamAuthorizer extends Authorizer {
    constructor() {
        super({
            authorizerId: constants_1.DefaultAuthorizerIds.IAM,
            authorizationType: aws_apigateway_1.AuthorizationType.IAM,
        });
    }
}
exports.IamAuthorizer = IamAuthorizer;
_e = JSII_RTTI_SYMBOL_1;
IamAuthorizer[_e] = { fqn: "@aws-prototyping-sdk/open-api-gateway.IamAuthorizer", version: "0.12.4" };
/**
 * Class used to construct authorizers for use in the OpenApiGatewayLambdaApi construct
 */
class Authorizers {
    /**
     * An IAM authorizer which uses AWS signature version 4 to authorize requests
     */
    static iam() {
        return new IamAuthorizer();
    }
    /**
     * No authorizer
     */
    static none() {
        return new NoneAuthorizer();
    }
    /**
     * A Cognito User Pools authorizer
     */
    static cognito(props) {
        return new CognitoAuthorizer(props);
    }
    /**
     * A custom authorizer
     */
    static custom(props) {
        return new CustomAuthorizer(props);
    }
}
exports.Authorizers = Authorizers;
_f = JSII_RTTI_SYMBOL_1;
Authorizers[_f] = { fqn: "@aws-prototyping-sdk/open-api-gateway.Authorizers", version: "0.12.4" };
//# sourceMappingURL=data:application/json;base64,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