import * as iam from '@aws-cdk/aws-iam';
import * as s3 from '@aws-cdk/aws-s3';
import * as cdk from '@aws-cdk/core';
import { Construct } from 'constructs';
/**
 * The interface representing the ReportGroup resource - either an existing one, imported using the {@link ReportGroup.fromReportGroupName} method, or a new one, created with the {@link ReportGroup} class.
 *
 * @stability stable
 */
export interface IReportGroup extends cdk.IResource {
    /**
     * The ARN of the ReportGroup.
     *
     * @stability stable
     * @attribute true
     */
    readonly reportGroupArn: string;
    /**
     * The name of the ReportGroup.
     *
     * @stability stable
     * @attribute true
     */
    readonly reportGroupName: string;
    /**
     * Grants the given entity permissions to write (that is, upload reports to) this report group.
     *
     * @stability stable
     */
    grantWrite(identity: iam.IGrantable): iam.Grant;
}
declare abstract class ReportGroupBase extends cdk.Resource implements IReportGroup {
    abstract readonly reportGroupArn: string;
    abstract readonly reportGroupName: string;
    protected abstract readonly exportBucket?: s3.IBucket;
    /**
     * Grants the given entity permissions to write (that is, upload reports to) this report group.
     *
     * @stability stable
     */
    grantWrite(identity: iam.IGrantable): iam.Grant;
}
/**
 * Construction properties for {@link ReportGroup}.
 *
 * @stability stable
 */
export interface ReportGroupProps {
    /**
     * The physical name of the report group.
     *
     * @default - CloudFormation-generated name
     * @stability stable
     */
    readonly reportGroupName?: string;
    /**
     * An optional S3 bucket to export the reports to.
     *
     * @default - the reports will not be exported
     * @stability stable
     */
    readonly exportBucket?: s3.IBucket;
    /**
     * Whether to output the report files into the export bucket as-is, or create a ZIP from them before doing the export.
     *
     * Ignored if {@link exportBucket} has not been provided.
     *
     * @default - false (the files will not be ZIPped)
     * @stability stable
     */
    readonly zipExport?: boolean;
    /**
     * What to do when this resource is deleted from a stack.
     *
     * As CodeBuild does not allow deleting a ResourceGroup that has reports inside of it,
     * this is set to retain the resource by default.
     *
     * @default RemovalPolicy.RETAIN
     * @stability stable
     */
    readonly removalPolicy?: cdk.RemovalPolicy;
}
/**
 * The ReportGroup resource class.
 *
 * @stability stable
 */
export declare class ReportGroup extends ReportGroupBase {
    /**
     * Reference an existing ReportGroup, defined outside of the CDK code, by name.
     *
     * @stability stable
     */
    static fromReportGroupName(scope: Construct, id: string, reportGroupName: string): IReportGroup;
    /**
     * The ARN of the ReportGroup.
     *
     * @stability stable
     */
    readonly reportGroupArn: string;
    /**
     * The name of the ReportGroup.
     *
     * @stability stable
     */
    readonly reportGroupName: string;
    /**
     * @stability stable
     */
    protected readonly exportBucket?: s3.IBucket;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: ReportGroupProps);
}
export {};
