# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from Tea.converter import TeaConverter


class BatchAddDeviceGroupRelationsRequestDevice(TeaModel):
    def __init__(self, product_key=None, device_name=None):
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class BatchAddDeviceGroupRelationsRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, group_id=None,
                 real_tenant_id=None, real_tripartite_key=None, device=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.group_id = TeaConverter.to_unicode(group_id)  # type: unicode
        self.real_tenant_id = TeaConverter.to_unicode(real_tenant_id)  # type: unicode
        self.real_tripartite_key = TeaConverter.to_unicode(real_tripartite_key)  # type: unicode
        self.device = device  # type: list[BatchAddDeviceGroupRelationsRequestDevice]

    def validate(self):
        if self.device:
            for k in self.device:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        result['Device'] = []
        if self.device is not None:
            for k in self.device:
                result['Device'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        self.device = []
        if m.get('Device') is not None:
            for k in m.get('Device'):
                temp_model = BatchAddDeviceGroupRelationsRequestDevice()
                self.device.append(temp_model.from_map(k))
        return self


class BatchAddDeviceGroupRelationsResponseBody(TeaModel):
    def __init__(self, valid_device_count=None, success_added_device_count=None, request_id=None,
                 exceed_ten_group_device_count=None, error_message=None, already_related_group_device_count=None, code=None, success=None):
        self.valid_device_count = valid_device_count  # type: int
        self.success_added_device_count = success_added_device_count  # type: int
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.exceed_ten_group_device_count = exceed_ten_group_device_count  # type: int
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.already_related_group_device_count = already_related_group_device_count  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.valid_device_count is not None:
            result['ValidDeviceCount'] = self.valid_device_count
        if self.success_added_device_count is not None:
            result['SuccessAddedDeviceCount'] = self.success_added_device_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.exceed_ten_group_device_count is not None:
            result['ExceedTenGroupDeviceCount'] = self.exceed_ten_group_device_count
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.already_related_group_device_count is not None:
            result['AlreadyRelatedGroupDeviceCount'] = self.already_related_group_device_count
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ValidDeviceCount') is not None:
            self.valid_device_count = m.get('ValidDeviceCount')
        if m.get('SuccessAddedDeviceCount') is not None:
            self.success_added_device_count = m.get('SuccessAddedDeviceCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ExceedTenGroupDeviceCount') is not None:
            self.exceed_ten_group_device_count = m.get('ExceedTenGroupDeviceCount')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('AlreadyRelatedGroupDeviceCount') is not None:
            self.already_related_group_device_count = m.get('AlreadyRelatedGroupDeviceCount')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchAddDeviceGroupRelationsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: BatchAddDeviceGroupRelationsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchAddDeviceGroupRelationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchAddThingTopoRequestTopoAddItem(TeaModel):
    def __init__(self, product_key=None, device_name=None, sign=None, timestamp=None, sign_method=None,
                 client_id=None):
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.sign = TeaConverter.to_unicode(sign)  # type: unicode
        self.timestamp = TeaConverter.to_unicode(timestamp)  # type: unicode
        self.sign_method = TeaConverter.to_unicode(sign_method)  # type: unicode
        self.client_id = TeaConverter.to_unicode(client_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.sign is not None:
            result['Sign'] = self.sign
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.sign_method is not None:
            result['SignMethod'] = self.sign_method
        if self.client_id is not None:
            result['ClientId'] = self.client_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Sign') is not None:
            self.sign = m.get('Sign')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('SignMethod') is not None:
            self.sign_method = m.get('SignMethod')
        if m.get('ClientId') is not None:
            self.client_id = m.get('ClientId')
        return self


class BatchAddThingTopoRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, gw_product_key=None, ext=None,
                 gw_device_name=None, topo_add_item=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.gw_product_key = TeaConverter.to_unicode(gw_product_key)  # type: unicode
        self.ext = ext  # type: dict[unicode, any]
        self.gw_device_name = TeaConverter.to_unicode(gw_device_name)  # type: unicode
        self.topo_add_item = topo_add_item  # type: list[BatchAddThingTopoRequestTopoAddItem]

    def validate(self):
        if self.topo_add_item:
            for k in self.topo_add_item:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.gw_product_key is not None:
            result['GwProductKey'] = self.gw_product_key
        if self.ext is not None:
            result['Ext'] = self.ext
        if self.gw_device_name is not None:
            result['GwDeviceName'] = self.gw_device_name
        result['TopoAddItem'] = []
        if self.topo_add_item is not None:
            for k in self.topo_add_item:
                result['TopoAddItem'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GwProductKey') is not None:
            self.gw_product_key = m.get('GwProductKey')
        if m.get('Ext') is not None:
            self.ext = m.get('Ext')
        if m.get('GwDeviceName') is not None:
            self.gw_device_name = m.get('GwDeviceName')
        self.topo_add_item = []
        if m.get('TopoAddItem') is not None:
            for k in m.get('TopoAddItem'):
                temp_model = BatchAddThingTopoRequestTopoAddItem()
                self.topo_add_item.append(temp_model.from_map(k))
        return self


class BatchAddThingTopoShrinkRequestTopoAddItem(TeaModel):
    def __init__(self, product_key=None, device_name=None, sign=None, timestamp=None, sign_method=None,
                 client_id=None):
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.sign = TeaConverter.to_unicode(sign)  # type: unicode
        self.timestamp = TeaConverter.to_unicode(timestamp)  # type: unicode
        self.sign_method = TeaConverter.to_unicode(sign_method)  # type: unicode
        self.client_id = TeaConverter.to_unicode(client_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.sign is not None:
            result['Sign'] = self.sign
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.sign_method is not None:
            result['SignMethod'] = self.sign_method
        if self.client_id is not None:
            result['ClientId'] = self.client_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Sign') is not None:
            self.sign = m.get('Sign')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('SignMethod') is not None:
            self.sign_method = m.get('SignMethod')
        if m.get('ClientId') is not None:
            self.client_id = m.get('ClientId')
        return self


class BatchAddThingTopoShrinkRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, gw_product_key=None,
                 ext_shrink=None, gw_device_name=None, topo_add_item=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.gw_product_key = TeaConverter.to_unicode(gw_product_key)  # type: unicode
        self.ext_shrink = TeaConverter.to_unicode(ext_shrink)  # type: unicode
        self.gw_device_name = TeaConverter.to_unicode(gw_device_name)  # type: unicode
        self.topo_add_item = topo_add_item  # type: list[BatchAddThingTopoShrinkRequestTopoAddItem]

    def validate(self):
        if self.topo_add_item:
            for k in self.topo_add_item:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.gw_product_key is not None:
            result['GwProductKey'] = self.gw_product_key
        if self.ext_shrink is not None:
            result['Ext'] = self.ext_shrink
        if self.gw_device_name is not None:
            result['GwDeviceName'] = self.gw_device_name
        result['TopoAddItem'] = []
        if self.topo_add_item is not None:
            for k in self.topo_add_item:
                result['TopoAddItem'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GwProductKey') is not None:
            self.gw_product_key = m.get('GwProductKey')
        if m.get('Ext') is not None:
            self.ext_shrink = m.get('Ext')
        if m.get('GwDeviceName') is not None:
            self.gw_device_name = m.get('GwDeviceName')
        self.topo_add_item = []
        if m.get('TopoAddItem') is not None:
            for k in m.get('TopoAddItem'):
                temp_model = BatchAddThingTopoShrinkRequestTopoAddItem()
                self.topo_add_item.append(temp_model.from_map(k))
        return self


class BatchAddThingTopoResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchAddThingTopoResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: BatchAddThingTopoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchAddThingTopoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchBindDeviceToEdgeInstanceWithDriverRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, instance_id=None, driver_id=None,
                 iot_ids=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode
        self.iot_ids = iot_ids  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchBindDeviceToEdgeInstanceWithDriverResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchBindDeviceToEdgeInstanceWithDriverResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: BatchBindDeviceToEdgeInstanceWithDriverResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchBindDeviceToEdgeInstanceWithDriverResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchCheckDeviceNamesRequestDeviceNameList(TeaModel):
    def __init__(self, device_nickname=None, device_name=None):
        self.device_nickname = TeaConverter.to_unicode(device_nickname)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.device_nickname is not None:
            result['DeviceNickname'] = self.device_nickname
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceNickname') is not None:
            self.device_nickname = m.get('DeviceNickname')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class BatchCheckDeviceNamesRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, product_key=None,
                 device_name=None, device_name_list=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = device_name  # type: list[unicode]
        self.device_name_list = device_name_list  # type: list[BatchCheckDeviceNamesRequestDeviceNameList]

    def validate(self):
        if self.device_name_list:
            for k in self.device_name_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        result['DeviceNameList'] = []
        if self.device_name_list is not None:
            for k in self.device_name_list:
                result['DeviceNameList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        self.device_name_list = []
        if m.get('DeviceNameList') is not None:
            for k in m.get('DeviceNameList'):
                temp_model = BatchCheckDeviceNamesRequestDeviceNameList()
                self.device_name_list.append(temp_model.from_map(k))
        return self


class BatchCheckDeviceNamesResponseBodyDataInvalidDeviceNameList(TeaModel):
    def __init__(self, invalid_device_name=None):
        self.invalid_device_name = invalid_device_name  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.invalid_device_name is not None:
            result['InvalidDeviceName'] = self.invalid_device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InvalidDeviceName') is not None:
            self.invalid_device_name = m.get('InvalidDeviceName')
        return self


class BatchCheckDeviceNamesResponseBodyDataInvalidDeviceNicknameList(TeaModel):
    def __init__(self, invalid_device_nickname=None):
        self.invalid_device_nickname = invalid_device_nickname  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.invalid_device_nickname is not None:
            result['InvalidDeviceNickname'] = self.invalid_device_nickname
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InvalidDeviceNickname') is not None:
            self.invalid_device_nickname = m.get('InvalidDeviceNickname')
        return self


class BatchCheckDeviceNamesResponseBodyData(TeaModel):
    def __init__(self, apply_id=None, invalid_device_name_list=None, invalid_device_nickname_list=None):
        self.apply_id = apply_id  # type: long
        self.invalid_device_name_list = invalid_device_name_list  # type: BatchCheckDeviceNamesResponseBodyDataInvalidDeviceNameList
        self.invalid_device_nickname_list = invalid_device_nickname_list  # type: BatchCheckDeviceNamesResponseBodyDataInvalidDeviceNicknameList

    def validate(self):
        if self.invalid_device_name_list:
            self.invalid_device_name_list.validate()
        if self.invalid_device_nickname_list:
            self.invalid_device_nickname_list.validate()

    def to_map(self):
        result = dict()
        if self.apply_id is not None:
            result['ApplyId'] = self.apply_id
        if self.invalid_device_name_list is not None:
            result['InvalidDeviceNameList'] = self.invalid_device_name_list.to_map()
        if self.invalid_device_nickname_list is not None:
            result['InvalidDeviceNicknameList'] = self.invalid_device_nickname_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApplyId') is not None:
            self.apply_id = m.get('ApplyId')
        if m.get('InvalidDeviceNameList') is not None:
            temp_model = BatchCheckDeviceNamesResponseBodyDataInvalidDeviceNameList()
            self.invalid_device_name_list = temp_model.from_map(m['InvalidDeviceNameList'])
        if m.get('InvalidDeviceNicknameList') is not None:
            temp_model = BatchCheckDeviceNamesResponseBodyDataInvalidDeviceNicknameList()
            self.invalid_device_nickname_list = temp_model.from_map(m['InvalidDeviceNicknameList'])
        return self


class BatchCheckDeviceNamesResponseBody(TeaModel):
    def __init__(self, request_id=None, data=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.data = data  # type: BatchCheckDeviceNamesResponseBodyData
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = BatchCheckDeviceNamesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchCheckDeviceNamesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: BatchCheckDeviceNamesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchCheckDeviceNamesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchClearEdgeInstanceDeviceConfigRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, instance_id=None, iot_ids=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.iot_ids = iot_ids  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchClearEdgeInstanceDeviceConfigResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchClearEdgeInstanceDeviceConfigResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: BatchClearEdgeInstanceDeviceConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchClearEdgeInstanceDeviceConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchDeleteDeviceGroupRelationsRequestDevice(TeaModel):
    def __init__(self, product_key=None, device_name=None):
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class BatchDeleteDeviceGroupRelationsRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, group_id=None,
                 real_tenant_id=None, real_tripartite_key=None, device=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.group_id = TeaConverter.to_unicode(group_id)  # type: unicode
        self.real_tenant_id = TeaConverter.to_unicode(real_tenant_id)  # type: unicode
        self.real_tripartite_key = TeaConverter.to_unicode(real_tripartite_key)  # type: unicode
        self.device = device  # type: list[BatchDeleteDeviceGroupRelationsRequestDevice]

    def validate(self):
        if self.device:
            for k in self.device:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        result['Device'] = []
        if self.device is not None:
            for k in self.device:
                result['Device'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        self.device = []
        if m.get('Device') is not None:
            for k in m.get('Device'):
                temp_model = BatchDeleteDeviceGroupRelationsRequestDevice()
                self.device.append(temp_model.from_map(k))
        return self


class BatchDeleteDeviceGroupRelationsResponseBody(TeaModel):
    def __init__(self, valid_device_count=None, request_id=None, success_device_count=None, error_message=None,
                 already_related_group_device_count=None, code=None, success=None):
        self.valid_device_count = valid_device_count  # type: int
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success_device_count = success_device_count  # type: int
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.already_related_group_device_count = already_related_group_device_count  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.valid_device_count is not None:
            result['ValidDeviceCount'] = self.valid_device_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success_device_count is not None:
            result['SuccessDeviceCount'] = self.success_device_count
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.already_related_group_device_count is not None:
            result['AlreadyRelatedGroupDeviceCount'] = self.already_related_group_device_count
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ValidDeviceCount') is not None:
            self.valid_device_count = m.get('ValidDeviceCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SuccessDeviceCount') is not None:
            self.success_device_count = m.get('SuccessDeviceCount')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('AlreadyRelatedGroupDeviceCount') is not None:
            self.already_related_group_device_count = m.get('AlreadyRelatedGroupDeviceCount')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchDeleteDeviceGroupRelationsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: BatchDeleteDeviceGroupRelationsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchDeleteDeviceGroupRelationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchDeleteEdgeInstanceChannelRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, instance_id=None, driver_id=None,
                 channel_ids=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode
        self.channel_ids = channel_ids  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.channel_ids is not None:
            result['ChannelIds'] = self.channel_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('ChannelIds') is not None:
            self.channel_ids = m.get('ChannelIds')
        return self


class BatchDeleteEdgeInstanceChannelResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchDeleteEdgeInstanceChannelResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: BatchDeleteEdgeInstanceChannelResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchDeleteEdgeInstanceChannelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetDeviceBindStatusRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, iot_ids=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.iot_ids = iot_ids  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchGetDeviceBindStatusResponseBodyData(TeaModel):
    def __init__(self, bind_status=None, iot_id=None):
        self.bind_status = bind_status  # type: int
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.bind_status is not None:
            result['BindStatus'] = self.bind_status
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BindStatus') is not None:
            self.bind_status = m.get('BindStatus')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BatchGetDeviceBindStatusResponseBody(TeaModel):
    def __init__(self, request_id=None, data=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.data = data  # type: list[BatchGetDeviceBindStatusResponseBodyData]
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = BatchGetDeviceBindStatusResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchGetDeviceBindStatusResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: BatchGetDeviceBindStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchGetDeviceBindStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetDeviceStateRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, product_key=None,
                 device_name=None, iot_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = device_name  # type: list[unicode]
        self.iot_id = iot_id  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BatchGetDeviceStateResponseBodyDeviceStatusListDeviceStatus(TeaModel):
    def __init__(self, status=None, last_online_time=None, device_name=None, device_id=None, as_address=None,
                 iot_id=None):
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.last_online_time = TeaConverter.to_unicode(last_online_time)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.device_id = TeaConverter.to_unicode(device_id)  # type: unicode
        self.as_address = TeaConverter.to_unicode(as_address)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.last_online_time is not None:
            result['LastOnlineTime'] = self.last_online_time
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.as_address is not None:
            result['AsAddress'] = self.as_address
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('LastOnlineTime') is not None:
            self.last_online_time = m.get('LastOnlineTime')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('AsAddress') is not None:
            self.as_address = m.get('AsAddress')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BatchGetDeviceStateResponseBodyDeviceStatusList(TeaModel):
    def __init__(self, device_status=None):
        self.device_status = device_status  # type: list[BatchGetDeviceStateResponseBodyDeviceStatusListDeviceStatus]

    def validate(self):
        if self.device_status:
            for k in self.device_status:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['DeviceStatus'] = []
        if self.device_status is not None:
            for k in self.device_status:
                result['DeviceStatus'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.device_status = []
        if m.get('DeviceStatus') is not None:
            for k in m.get('DeviceStatus'):
                temp_model = BatchGetDeviceStateResponseBodyDeviceStatusListDeviceStatus()
                self.device_status.append(temp_model.from_map(k))
        return self


class BatchGetDeviceStateResponseBody(TeaModel):
    def __init__(self, request_id=None, device_status_list=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.device_status_list = device_status_list  # type: BatchGetDeviceStateResponseBodyDeviceStatusList
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.device_status_list:
            self.device_status_list.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.device_status_list is not None:
            result['DeviceStatusList'] = self.device_status_list.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('DeviceStatusList') is not None:
            temp_model = BatchGetDeviceStateResponseBodyDeviceStatusList()
            self.device_status_list = temp_model.from_map(m['DeviceStatusList'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchGetDeviceStateResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: BatchGetDeviceStateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchGetDeviceStateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetEdgeDriverRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, driver_ids=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.driver_ids = driver_ids  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.driver_ids is not None:
            result['DriverIds'] = self.driver_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DriverIds') is not None:
            self.driver_ids = m.get('DriverIds')
        return self


class BatchGetEdgeDriverResponseBodyDriverList(TeaModel):
    def __init__(self, gmt_create_timestamp=None, type=None, cpu_arch=None, driver_id=None, is_built_in=None,
                 gmt_modified_timestamp=None, runtime=None, driver_name=None, driver_protocol=None):
        self.gmt_create_timestamp = gmt_create_timestamp  # type: long
        self.type = type  # type: int
        self.cpu_arch = TeaConverter.to_unicode(cpu_arch)  # type: unicode
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode
        self.is_built_in = is_built_in  # type: bool
        self.gmt_modified_timestamp = gmt_modified_timestamp  # type: long
        self.runtime = TeaConverter.to_unicode(runtime)  # type: unicode
        self.driver_name = TeaConverter.to_unicode(driver_name)  # type: unicode
        self.driver_protocol = TeaConverter.to_unicode(driver_protocol)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.type is not None:
            result['Type'] = self.type
        if self.cpu_arch is not None:
            result['CpuArch'] = self.cpu_arch
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.is_built_in is not None:
            result['IsBuiltIn'] = self.is_built_in
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.runtime is not None:
            result['Runtime'] = self.runtime
        if self.driver_name is not None:
            result['DriverName'] = self.driver_name
        if self.driver_protocol is not None:
            result['DriverProtocol'] = self.driver_protocol
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('CpuArch') is not None:
            self.cpu_arch = m.get('CpuArch')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('IsBuiltIn') is not None:
            self.is_built_in = m.get('IsBuiltIn')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('Runtime') is not None:
            self.runtime = m.get('Runtime')
        if m.get('DriverName') is not None:
            self.driver_name = m.get('DriverName')
        if m.get('DriverProtocol') is not None:
            self.driver_protocol = m.get('DriverProtocol')
        return self


class BatchGetEdgeDriverResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, driver_list=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.driver_list = driver_list  # type: list[BatchGetEdgeDriverResponseBodyDriverList]
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.driver_list:
            for k in self.driver_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        result['DriverList'] = []
        if self.driver_list is not None:
            for k in self.driver_list:
                result['DriverList'].append(k.to_map() if k else None)
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        self.driver_list = []
        if m.get('DriverList') is not None:
            for k in m.get('DriverList'):
                temp_model = BatchGetEdgeDriverResponseBodyDriverList()
                self.driver_list.append(temp_model.from_map(k))
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchGetEdgeDriverResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: BatchGetEdgeDriverResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchGetEdgeDriverResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetEdgeInstanceChannelRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, instance_id=None, driver_id=None,
                 channel_ids=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode
        self.channel_ids = channel_ids  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.channel_ids is not None:
            result['ChannelIds'] = self.channel_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('ChannelIds') is not None:
            self.channel_ids = m.get('ChannelIds')
        return self


class BatchGetEdgeInstanceChannelResponseBodyDataChannelConfigListConfig(TeaModel):
    def __init__(self, key=None, config_id=None, format=None, content=None):
        self.key = TeaConverter.to_unicode(key)  # type: unicode
        self.config_id = TeaConverter.to_unicode(config_id)  # type: unicode
        self.format = TeaConverter.to_unicode(format)  # type: unicode
        self.content = TeaConverter.to_unicode(content)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.config_id is not None:
            result['ConfigId'] = self.config_id
        if self.format is not None:
            result['Format'] = self.format
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('ConfigId') is not None:
            self.config_id = m.get('ConfigId')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class BatchGetEdgeInstanceChannelResponseBodyDataChannelConfigList(TeaModel):
    def __init__(self, config=None):
        self.config = config  # type: list[BatchGetEdgeInstanceChannelResponseBodyDataChannelConfigListConfig]

    def validate(self):
        if self.config:
            for k in self.config:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Config'] = []
        if self.config is not None:
            for k in self.config:
                result['Config'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.config = []
        if m.get('Config') is not None:
            for k in m.get('Config'):
                temp_model = BatchGetEdgeInstanceChannelResponseBodyDataChannelConfigListConfig()
                self.config.append(temp_model.from_map(k))
        return self


class BatchGetEdgeInstanceChannelResponseBodyDataChannel(TeaModel):
    def __init__(self, channel_name=None, channel_id=None, config_list=None):
        self.channel_name = TeaConverter.to_unicode(channel_name)  # type: unicode
        self.channel_id = TeaConverter.to_unicode(channel_id)  # type: unicode
        self.config_list = config_list  # type: BatchGetEdgeInstanceChannelResponseBodyDataChannelConfigList

    def validate(self):
        if self.config_list:
            self.config_list.validate()

    def to_map(self):
        result = dict()
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.config_list is not None:
            result['ConfigList'] = self.config_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ConfigList') is not None:
            temp_model = BatchGetEdgeInstanceChannelResponseBodyDataChannelConfigList()
            self.config_list = temp_model.from_map(m['ConfigList'])
        return self


class BatchGetEdgeInstanceChannelResponseBodyData(TeaModel):
    def __init__(self, channel=None):
        self.channel = channel  # type: list[BatchGetEdgeInstanceChannelResponseBodyDataChannel]

    def validate(self):
        if self.channel:
            for k in self.channel:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Channel'] = []
        if self.channel is not None:
            for k in self.channel:
                result['Channel'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.channel = []
        if m.get('Channel') is not None:
            for k in m.get('Channel'):
                temp_model = BatchGetEdgeInstanceChannelResponseBodyDataChannel()
                self.channel.append(temp_model.from_map(k))
        return self


class BatchGetEdgeInstanceChannelResponseBody(TeaModel):
    def __init__(self, request_id=None, data=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.data = data  # type: BatchGetEdgeInstanceChannelResponseBodyData
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = BatchGetEdgeInstanceChannelResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchGetEdgeInstanceChannelResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: BatchGetEdgeInstanceChannelResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchGetEdgeInstanceChannelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetEdgeInstanceDeviceChannelRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, instance_id=None, driver_id=None,
                 iot_ids=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode
        self.iot_ids = iot_ids  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchGetEdgeInstanceDeviceChannelResponseBodyDeviceChannelList(TeaModel):
    def __init__(self, channel_name=None, channel_id=None, iot_id=None):
        self.channel_name = TeaConverter.to_unicode(channel_name)  # type: unicode
        self.channel_id = TeaConverter.to_unicode(channel_id)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BatchGetEdgeInstanceDeviceChannelResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None, device_channel_list=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool
        self.device_channel_list = device_channel_list  # type: list[BatchGetEdgeInstanceDeviceChannelResponseBodyDeviceChannelList]

    def validate(self):
        if self.device_channel_list:
            for k in self.device_channel_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        result['DeviceChannelList'] = []
        if self.device_channel_list is not None:
            for k in self.device_channel_list:
                result['DeviceChannelList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        self.device_channel_list = []
        if m.get('DeviceChannelList') is not None:
            for k in m.get('DeviceChannelList'):
                temp_model = BatchGetEdgeInstanceDeviceChannelResponseBodyDeviceChannelList()
                self.device_channel_list.append(temp_model.from_map(k))
        return self


class BatchGetEdgeInstanceDeviceChannelResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: BatchGetEdgeInstanceDeviceChannelResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchGetEdgeInstanceDeviceChannelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetEdgeInstanceDeviceConfigRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, instance_id=None, iot_ids=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.iot_ids = iot_ids  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchGetEdgeInstanceDeviceConfigResponseBodyDeviceConfigListConfig(TeaModel):
    def __init__(self, content=None, format=None):
        self.content = TeaConverter.to_unicode(content)  # type: unicode
        self.format = TeaConverter.to_unicode(format)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.format is not None:
            result['Format'] = self.format
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        return self


class BatchGetEdgeInstanceDeviceConfigResponseBodyDeviceConfigList(TeaModel):
    def __init__(self, config=None, iot_id=None):
        self.config = config  # type: BatchGetEdgeInstanceDeviceConfigResponseBodyDeviceConfigListConfig
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode

    def validate(self):
        if self.config:
            self.config.validate()

    def to_map(self):
        result = dict()
        if self.config is not None:
            result['Config'] = self.config.to_map()
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Config') is not None:
            temp_model = BatchGetEdgeInstanceDeviceConfigResponseBodyDeviceConfigListConfig()
            self.config = temp_model.from_map(m['Config'])
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BatchGetEdgeInstanceDeviceConfigResponseBody(TeaModel):
    def __init__(self, device_config_list=None, request_id=None, error_message=None, code=None, success=None):
        self.device_config_list = device_config_list  # type: list[BatchGetEdgeInstanceDeviceConfigResponseBodyDeviceConfigList]
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.device_config_list:
            for k in self.device_config_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['DeviceConfigList'] = []
        if self.device_config_list is not None:
            for k in self.device_config_list:
                result['DeviceConfigList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.device_config_list = []
        if m.get('DeviceConfigList') is not None:
            for k in m.get('DeviceConfigList'):
                temp_model = BatchGetEdgeInstanceDeviceConfigResponseBodyDeviceConfigList()
                self.device_config_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchGetEdgeInstanceDeviceConfigResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: BatchGetEdgeInstanceDeviceConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchGetEdgeInstanceDeviceConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetEdgeInstanceDeviceDriverRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, instance_id=None, iot_ids=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.iot_ids = iot_ids  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchGetEdgeInstanceDeviceDriverResponseBodyDeviceDriverList(TeaModel):
    def __init__(self, driver_id=None, iot_id=None):
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BatchGetEdgeInstanceDeviceDriverResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, device_driver_list=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.device_driver_list = device_driver_list  # type: list[BatchGetEdgeInstanceDeviceDriverResponseBodyDeviceDriverList]
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.device_driver_list:
            for k in self.device_driver_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        result['DeviceDriverList'] = []
        if self.device_driver_list is not None:
            for k in self.device_driver_list:
                result['DeviceDriverList'].append(k.to_map() if k else None)
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        self.device_driver_list = []
        if m.get('DeviceDriverList') is not None:
            for k in m.get('DeviceDriverList'):
                temp_model = BatchGetEdgeInstanceDeviceDriverResponseBodyDeviceDriverList()
                self.device_driver_list.append(temp_model.from_map(k))
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchGetEdgeInstanceDeviceDriverResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: BatchGetEdgeInstanceDeviceDriverResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchGetEdgeInstanceDeviceDriverResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchGetEdgeInstanceDriverConfigsRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, instance_id=None, driver_ids=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.driver_ids = driver_ids  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_ids is not None:
            result['DriverIds'] = self.driver_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverIds') is not None:
            self.driver_ids = m.get('DriverIds')
        return self


class BatchGetEdgeInstanceDriverConfigsResponseBodyDriverConfigListConfigList(TeaModel):
    def __init__(self, key=None, config_id=None, format=None, content=None):
        self.key = TeaConverter.to_unicode(key)  # type: unicode
        self.config_id = TeaConverter.to_unicode(config_id)  # type: unicode
        self.format = TeaConverter.to_unicode(format)  # type: unicode
        self.content = TeaConverter.to_unicode(content)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.config_id is not None:
            result['ConfigId'] = self.config_id
        if self.format is not None:
            result['Format'] = self.format
        if self.content is not None:
            result['Content'] = self.content
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('ConfigId') is not None:
            self.config_id = m.get('ConfigId')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        return self


class BatchGetEdgeInstanceDriverConfigsResponseBodyDriverConfigList(TeaModel):
    def __init__(self, driver_id=None, config_list=None):
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode
        self.config_list = config_list  # type: list[BatchGetEdgeInstanceDriverConfigsResponseBodyDriverConfigListConfigList]

    def validate(self):
        if self.config_list:
            for k in self.config_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        result['ConfigList'] = []
        if self.config_list is not None:
            for k in self.config_list:
                result['ConfigList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        self.config_list = []
        if m.get('ConfigList') is not None:
            for k in m.get('ConfigList'):
                temp_model = BatchGetEdgeInstanceDriverConfigsResponseBodyDriverConfigListConfigList()
                self.config_list.append(temp_model.from_map(k))
        return self


class BatchGetEdgeInstanceDriverConfigsResponseBody(TeaModel):
    def __init__(self, request_id=None, driver_config_list=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.driver_config_list = driver_config_list  # type: list[BatchGetEdgeInstanceDriverConfigsResponseBodyDriverConfigList]
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.driver_config_list:
            for k in self.driver_config_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['DriverConfigList'] = []
        if self.driver_config_list is not None:
            for k in self.driver_config_list:
                result['DriverConfigList'].append(k.to_map() if k else None)
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.driver_config_list = []
        if m.get('DriverConfigList') is not None:
            for k in m.get('DriverConfigList'):
                temp_model = BatchGetEdgeInstanceDriverConfigsResponseBodyDriverConfigList()
                self.driver_config_list.append(temp_model.from_map(k))
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchGetEdgeInstanceDriverConfigsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: BatchGetEdgeInstanceDriverConfigsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchGetEdgeInstanceDriverConfigsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchPubRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, product_key=None, qos=None,
                 topic_short_name=None, message_content=None, device_name=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.qos = qos  # type: int
        self.topic_short_name = TeaConverter.to_unicode(topic_short_name)  # type: unicode
        self.message_content = TeaConverter.to_unicode(message_content)  # type: unicode
        self.device_name = device_name  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.qos is not None:
            result['Qos'] = self.qos
        if self.topic_short_name is not None:
            result['TopicShortName'] = self.topic_short_name
        if self.message_content is not None:
            result['MessageContent'] = self.message_content
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Qos') is not None:
            self.qos = m.get('Qos')
        if m.get('TopicShortName') is not None:
            self.topic_short_name = m.get('TopicShortName')
        if m.get('MessageContent') is not None:
            self.message_content = m.get('MessageContent')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class BatchPubResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchPubResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: BatchPubResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchPubResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchQueryDeviceDetailRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, product_key=None, iot_instance_id=None,
                 real_tenant_id=None, real_tripartite_key=None, device_name=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.real_tenant_id = TeaConverter.to_unicode(real_tenant_id)  # type: unicode
        self.real_tripartite_key = TeaConverter.to_unicode(real_tripartite_key)  # type: unicode
        self.device_name = device_name  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class BatchQueryDeviceDetailResponseBodyDataData(TeaModel):
    def __init__(self, status=None, utc_active=None, product_name=None, device_name=None, firmware_version=None,
                 utc_create=None, product_key=None, node_type=None, region=None, device_secret=None, gmt_active=None,
                 gmt_create=None, nickname=None, iot_id=None):
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.utc_active = TeaConverter.to_unicode(utc_active)  # type: unicode
        self.product_name = TeaConverter.to_unicode(product_name)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.firmware_version = TeaConverter.to_unicode(firmware_version)  # type: unicode
        self.utc_create = TeaConverter.to_unicode(utc_create)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.node_type = node_type  # type: int
        self.region = TeaConverter.to_unicode(region)  # type: unicode
        self.device_secret = TeaConverter.to_unicode(device_secret)  # type: unicode
        self.gmt_active = TeaConverter.to_unicode(gmt_active)  # type: unicode
        self.gmt_create = TeaConverter.to_unicode(gmt_create)  # type: unicode
        self.nickname = TeaConverter.to_unicode(nickname)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.utc_active is not None:
            result['UtcActive'] = self.utc_active
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.firmware_version is not None:
            result['FirmwareVersion'] = self.firmware_version
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.region is not None:
            result['Region'] = self.region
        if self.device_secret is not None:
            result['DeviceSecret'] = self.device_secret
        if self.gmt_active is not None:
            result['GmtActive'] = self.gmt_active
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.nickname is not None:
            result['Nickname'] = self.nickname
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UtcActive') is not None:
            self.utc_active = m.get('UtcActive')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('FirmwareVersion') is not None:
            self.firmware_version = m.get('FirmwareVersion')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('DeviceSecret') is not None:
            self.device_secret = m.get('DeviceSecret')
        if m.get('GmtActive') is not None:
            self.gmt_active = m.get('GmtActive')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('Nickname') is not None:
            self.nickname = m.get('Nickname')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BatchQueryDeviceDetailResponseBodyData(TeaModel):
    def __init__(self, data=None):
        self.data = data  # type: list[BatchQueryDeviceDetailResponseBodyDataData]

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = BatchQueryDeviceDetailResponseBodyDataData()
                self.data.append(temp_model.from_map(k))
        return self


class BatchQueryDeviceDetailResponseBody(TeaModel):
    def __init__(self, request_id=None, data=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.data = data  # type: BatchQueryDeviceDetailResponseBodyData
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = BatchQueryDeviceDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchQueryDeviceDetailResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: BatchQueryDeviceDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchQueryDeviceDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchRegisterDeviceRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, product_key=None, count=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.count = count  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.count is not None:
            result['Count'] = self.count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        return self


class BatchRegisterDeviceResponseBodyData(TeaModel):
    def __init__(self, apply_id=None):
        self.apply_id = apply_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.apply_id is not None:
            result['ApplyId'] = self.apply_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApplyId') is not None:
            self.apply_id = m.get('ApplyId')
        return self


class BatchRegisterDeviceResponseBody(TeaModel):
    def __init__(self, request_id=None, data=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.data = data  # type: BatchRegisterDeviceResponseBodyData
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = BatchRegisterDeviceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchRegisterDeviceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: BatchRegisterDeviceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchRegisterDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchRegisterDeviceWithApplyIdRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, product_key=None, apply_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.apply_id = apply_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.apply_id is not None:
            result['ApplyId'] = self.apply_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ApplyId') is not None:
            self.apply_id = m.get('ApplyId')
        return self


class BatchRegisterDeviceWithApplyIdResponseBodyData(TeaModel):
    def __init__(self, apply_id=None):
        self.apply_id = apply_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.apply_id is not None:
            result['ApplyId'] = self.apply_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApplyId') is not None:
            self.apply_id = m.get('ApplyId')
        return self


class BatchRegisterDeviceWithApplyIdResponseBody(TeaModel):
    def __init__(self, request_id=None, data=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.data = data  # type: BatchRegisterDeviceWithApplyIdResponseBodyData
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = BatchRegisterDeviceWithApplyIdResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchRegisterDeviceWithApplyIdResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: BatchRegisterDeviceWithApplyIdResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchRegisterDeviceWithApplyIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchSetEdgeInstanceDeviceChannelRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, instance_id=None, driver_id=None,
                 channel_id=None, iot_ids=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode
        self.channel_id = TeaConverter.to_unicode(channel_id)  # type: unicode
        self.iot_ids = iot_ids  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchSetEdgeInstanceDeviceChannelResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchSetEdgeInstanceDeviceChannelResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: BatchSetEdgeInstanceDeviceChannelResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchSetEdgeInstanceDeviceChannelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchSetEdgeInstanceDeviceConfigRequestDeviceConfigs(TeaModel):
    def __init__(self, content=None, iot_id=None):
        self.content = TeaConverter.to_unicode(content)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BatchSetEdgeInstanceDeviceConfigRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, instance_id=None,
                 device_configs=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.device_configs = device_configs  # type: list[BatchSetEdgeInstanceDeviceConfigRequestDeviceConfigs]

    def validate(self):
        if self.device_configs:
            for k in self.device_configs:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        result['DeviceConfigs'] = []
        if self.device_configs is not None:
            for k in self.device_configs:
                result['DeviceConfigs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        self.device_configs = []
        if m.get('DeviceConfigs') is not None:
            for k in m.get('DeviceConfigs'):
                temp_model = BatchSetEdgeInstanceDeviceConfigRequestDeviceConfigs()
                self.device_configs.append(temp_model.from_map(k))
        return self


class BatchSetEdgeInstanceDeviceConfigResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchSetEdgeInstanceDeviceConfigResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: BatchSetEdgeInstanceDeviceConfigResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchSetEdgeInstanceDeviceConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchUnbindDeviceFromEdgeInstanceRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, instance_id=None, iot_ids=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.iot_ids = iot_ids  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.iot_ids is not None:
            result['IotIds'] = self.iot_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IotIds') is not None:
            self.iot_ids = m.get('IotIds')
        return self


class BatchUnbindDeviceFromEdgeInstanceResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchUnbindDeviceFromEdgeInstanceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: BatchUnbindDeviceFromEdgeInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchUnbindDeviceFromEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchUpdateDeviceNicknameRequestDeviceNicknameInfo(TeaModel):
    def __init__(self, product_key=None, device_name=None, nickname=None, iot_id=None):
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.nickname = TeaConverter.to_unicode(nickname)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.nickname is not None:
            result['Nickname'] = self.nickname
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Nickname') is not None:
            self.nickname = m.get('Nickname')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BatchUpdateDeviceNicknameRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, real_tenant_id=None,
                 real_tripartite_key=None, device_nickname_info=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.real_tenant_id = TeaConverter.to_unicode(real_tenant_id)  # type: unicode
        self.real_tripartite_key = TeaConverter.to_unicode(real_tripartite_key)  # type: unicode
        self.device_nickname_info = device_nickname_info  # type: list[BatchUpdateDeviceNicknameRequestDeviceNicknameInfo]

    def validate(self):
        if self.device_nickname_info:
            for k in self.device_nickname_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        result['DeviceNicknameInfo'] = []
        if self.device_nickname_info is not None:
            for k in self.device_nickname_info:
                result['DeviceNicknameInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        self.device_nickname_info = []
        if m.get('DeviceNicknameInfo') is not None:
            for k in m.get('DeviceNicknameInfo'):
                temp_model = BatchUpdateDeviceNicknameRequestDeviceNicknameInfo()
                self.device_nickname_info.append(temp_model.from_map(k))
        return self


class BatchUpdateDeviceNicknameResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchUpdateDeviceNicknameResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: BatchUpdateDeviceNicknameResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BatchUpdateDeviceNicknameResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindApplicationToEdgeInstanceRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, instance_id=None,
                 application_id=None, application_version=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.application_id = TeaConverter.to_unicode(application_id)  # type: unicode
        self.application_version = TeaConverter.to_unicode(application_version)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.application_version is not None:
            result['ApplicationVersion'] = self.application_version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('ApplicationVersion') is not None:
            self.application_version = m.get('ApplicationVersion')
        return self


class BindApplicationToEdgeInstanceResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BindApplicationToEdgeInstanceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: BindApplicationToEdgeInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BindApplicationToEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindDriverToEdgeInstanceRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, instance_id=None, driver_id=None,
                 driver_version=None, order_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode
        self.driver_version = TeaConverter.to_unicode(driver_version)  # type: unicode
        self.order_id = TeaConverter.to_unicode(order_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        return self


class BindDriverToEdgeInstanceResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BindDriverToEdgeInstanceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: BindDriverToEdgeInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BindDriverToEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindGatewayToEdgeInstanceRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, instance_id=None,
                 product_key=None, device_name=None, iot_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class BindGatewayToEdgeInstanceResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BindGatewayToEdgeInstanceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: BindGatewayToEdgeInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BindGatewayToEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindRoleToEdgeInstanceRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, instance_id=None, role_arn=None,
                 role_name=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.role_arn = TeaConverter.to_unicode(role_arn)  # type: unicode
        self.role_name = TeaConverter.to_unicode(role_name)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        if self.role_name is not None:
            result['RoleName'] = self.role_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        if m.get('RoleName') is not None:
            self.role_name = m.get('RoleName')
        return self


class BindRoleToEdgeInstanceResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BindRoleToEdgeInstanceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: BindRoleToEdgeInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BindRoleToEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindSceneRuleToEdgeInstanceRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, instance_id=None, rule_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.rule_id = TeaConverter.to_unicode(rule_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class BindSceneRuleToEdgeInstanceResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BindSceneRuleToEdgeInstanceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: BindSceneRuleToEdgeInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BindSceneRuleToEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelJobRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, job_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class CancelJobResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CancelJobResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CancelJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CancelJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelOTAStrategyByJobRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, job_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class CancelOTAStrategyByJobResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CancelOTAStrategyByJobResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CancelOTAStrategyByJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CancelOTAStrategyByJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelOTATaskByDeviceRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, firmware_id=None,
                 product_key=None, job_id=None, device_name=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.firmware_id = TeaConverter.to_unicode(firmware_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.device_name = device_name  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class CancelOTATaskByDeviceResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CancelOTATaskByDeviceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CancelOTATaskByDeviceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CancelOTATaskByDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelOTATaskByJobRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, job_id=None,
                 cancel_scheduled_task=None, cancel_queued_task=None, cancel_in_progress_task=None, cancel_notified_task=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.cancel_scheduled_task = cancel_scheduled_task  # type: bool
        self.cancel_queued_task = cancel_queued_task  # type: bool
        self.cancel_in_progress_task = cancel_in_progress_task  # type: bool
        self.cancel_notified_task = cancel_notified_task  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.cancel_scheduled_task is not None:
            result['CancelScheduledTask'] = self.cancel_scheduled_task
        if self.cancel_queued_task is not None:
            result['CancelQueuedTask'] = self.cancel_queued_task
        if self.cancel_in_progress_task is not None:
            result['CancelInProgressTask'] = self.cancel_in_progress_task
        if self.cancel_notified_task is not None:
            result['CancelNotifiedTask'] = self.cancel_notified_task
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('CancelScheduledTask') is not None:
            self.cancel_scheduled_task = m.get('CancelScheduledTask')
        if m.get('CancelQueuedTask') is not None:
            self.cancel_queued_task = m.get('CancelQueuedTask')
        if m.get('CancelInProgressTask') is not None:
            self.cancel_in_progress_task = m.get('CancelInProgressTask')
        if m.get('CancelNotifiedTask') is not None:
            self.cancel_notified_task = m.get('CancelNotifiedTask')
        return self


class CancelOTATaskByJobResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CancelOTATaskByJobResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CancelOTATaskByJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CancelOTATaskByJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ClearEdgeInstanceDriverConfigsRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, instance_id=None, driver_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        return self


class ClearEdgeInstanceDriverConfigsResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ClearEdgeInstanceDriverConfigsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: ClearEdgeInstanceDriverConfigsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ClearEdgeInstanceDriverConfigsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CloseEdgeInstanceDeploymentRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, instance_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class CloseEdgeInstanceDeploymentResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CloseEdgeInstanceDeploymentResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CloseEdgeInstanceDeploymentResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CloseEdgeInstanceDeploymentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CopyThingModelRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, resource_group_id=None,
                 source_product_key=None, target_product_key=None, source_model_version=None, real_tenant_id=None,
                 real_tripartite_key=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.resource_group_id = TeaConverter.to_unicode(resource_group_id)  # type: unicode
        self.source_product_key = TeaConverter.to_unicode(source_product_key)  # type: unicode
        self.target_product_key = TeaConverter.to_unicode(target_product_key)  # type: unicode
        self.source_model_version = TeaConverter.to_unicode(source_model_version)  # type: unicode
        self.real_tenant_id = TeaConverter.to_unicode(real_tenant_id)  # type: unicode
        self.real_tripartite_key = TeaConverter.to_unicode(real_tripartite_key)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.source_product_key is not None:
            result['SourceProductKey'] = self.source_product_key
        if self.target_product_key is not None:
            result['TargetProductKey'] = self.target_product_key
        if self.source_model_version is not None:
            result['SourceModelVersion'] = self.source_model_version
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SourceProductKey') is not None:
            self.source_product_key = m.get('SourceProductKey')
        if m.get('TargetProductKey') is not None:
            self.target_product_key = m.get('TargetProductKey')
        if m.get('SourceModelVersion') is not None:
            self.source_model_version = m.get('SourceModelVersion')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        return self


class CopyThingModelResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CopyThingModelResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CopyThingModelResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CopyThingModelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateConsumerGroupRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, group_name=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.group_name = TeaConverter.to_unicode(group_name)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class CreateConsumerGroupResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None, group_id=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool
        self.group_id = TeaConverter.to_unicode(group_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class CreateConsumerGroupResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CreateConsumerGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateConsumerGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateConsumerGroupSubscribeRelationRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, consumer_group_id=None, iot_instance_id=None,
                 product_key=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.consumer_group_id = TeaConverter.to_unicode(consumer_group_id)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.consumer_group_id is not None:
            result['ConsumerGroupId'] = self.consumer_group_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('ConsumerGroupId') is not None:
            self.consumer_group_id = m.get('ConsumerGroupId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class CreateConsumerGroupSubscribeRelationResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateConsumerGroupSubscribeRelationResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CreateConsumerGroupSubscribeRelationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateConsumerGroupSubscribeRelationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDataAPIServiceRequestRequestParam(TeaModel):
    def __init__(self, type=None, required=None, example=None, name=None, desc=None):
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.required = required  # type: bool
        self.example = TeaConverter.to_unicode(example)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.desc = TeaConverter.to_unicode(desc)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.required is not None:
            result['Required'] = self.required
        if self.example is not None:
            result['Example'] = self.example
        if self.name is not None:
            result['Name'] = self.name
        if self.desc is not None:
            result['Desc'] = self.desc
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Required') is not None:
            self.required = m.get('Required')
        if m.get('Example') is not None:
            self.example = m.get('Example')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        return self


class CreateDataAPIServiceRequestResponseParam(TeaModel):
    def __init__(self, type=None, required=None, example=None, name=None, desc=None):
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.required = required  # type: bool
        self.example = TeaConverter.to_unicode(example)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.desc = TeaConverter.to_unicode(desc)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.required is not None:
            result['Required'] = self.required
        if self.example is not None:
            result['Example'] = self.example
        if self.name is not None:
            result['Name'] = self.name
        if self.desc is not None:
            result['Desc'] = self.desc
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Required') is not None:
            self.required = m.get('Required')
        if m.get('Example') is not None:
            self.example = m.get('Example')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        return self


class CreateDataAPIServiceRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, display_name=None, origin_sql=None, desc=None,
                 template_sql=None, api_path=None, iot_instance_id=None, request_param=None, response_param=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.display_name = TeaConverter.to_unicode(display_name)  # type: unicode
        self.origin_sql = TeaConverter.to_unicode(origin_sql)  # type: unicode
        self.desc = TeaConverter.to_unicode(desc)  # type: unicode
        self.template_sql = TeaConverter.to_unicode(template_sql)  # type: unicode
        self.api_path = TeaConverter.to_unicode(api_path)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.request_param = request_param  # type: list[CreateDataAPIServiceRequestRequestParam]
        self.response_param = response_param  # type: list[CreateDataAPIServiceRequestResponseParam]

    def validate(self):
        if self.request_param:
            for k in self.request_param:
                if k:
                    k.validate()
        if self.response_param:
            for k in self.response_param:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.origin_sql is not None:
            result['OriginSql'] = self.origin_sql
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.template_sql is not None:
            result['TemplateSql'] = self.template_sql
        if self.api_path is not None:
            result['ApiPath'] = self.api_path
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        result['RequestParam'] = []
        if self.request_param is not None:
            for k in self.request_param:
                result['RequestParam'].append(k.to_map() if k else None)
        result['ResponseParam'] = []
        if self.response_param is not None:
            for k in self.response_param:
                result['ResponseParam'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('OriginSql') is not None:
            self.origin_sql = m.get('OriginSql')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('TemplateSql') is not None:
            self.template_sql = m.get('TemplateSql')
        if m.get('ApiPath') is not None:
            self.api_path = m.get('ApiPath')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        self.request_param = []
        if m.get('RequestParam') is not None:
            for k in m.get('RequestParam'):
                temp_model = CreateDataAPIServiceRequestRequestParam()
                self.request_param.append(temp_model.from_map(k))
        self.response_param = []
        if m.get('ResponseParam') is not None:
            for k in m.get('ResponseParam'):
                temp_model = CreateDataAPIServiceRequestResponseParam()
                self.response_param.append(temp_model.from_map(k))
        return self


class CreateDataAPIServiceResponseBodyData(TeaModel):
    def __init__(self, api_srn=None, create_time=None, last_update_time=None):
        self.api_srn = TeaConverter.to_unicode(api_srn)  # type: unicode
        self.create_time = create_time  # type: long
        self.last_update_time = last_update_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_srn is not None:
            result['ApiSrn'] = self.api_srn
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.last_update_time is not None:
            result['LastUpdateTime'] = self.last_update_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiSrn') is not None:
            self.api_srn = m.get('ApiSrn')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('LastUpdateTime') is not None:
            self.last_update_time = m.get('LastUpdateTime')
        return self


class CreateDataAPIServiceResponseBody(TeaModel):
    def __init__(self, request_id=None, data=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.data = data  # type: CreateDataAPIServiceResponseBodyData
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = CreateDataAPIServiceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDataAPIServiceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CreateDataAPIServiceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDataAPIServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDeviceGroupRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, super_group_id=None,
                 group_desc=None, group_name=None, real_tenant_id=None, real_tripartite_key=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.super_group_id = TeaConverter.to_unicode(super_group_id)  # type: unicode
        self.group_desc = TeaConverter.to_unicode(group_desc)  # type: unicode
        self.group_name = TeaConverter.to_unicode(group_name)  # type: unicode
        self.real_tenant_id = TeaConverter.to_unicode(real_tenant_id)  # type: unicode
        self.real_tripartite_key = TeaConverter.to_unicode(real_tripartite_key)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.super_group_id is not None:
            result['SuperGroupId'] = self.super_group_id
        if self.group_desc is not None:
            result['GroupDesc'] = self.group_desc
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('SuperGroupId') is not None:
            self.super_group_id = m.get('SuperGroupId')
        if m.get('GroupDesc') is not None:
            self.group_desc = m.get('GroupDesc')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        return self


class CreateDeviceGroupResponseBodyData(TeaModel):
    def __init__(self, group_id=None, group_name=None, utc_create=None, group_desc=None):
        self.group_id = TeaConverter.to_unicode(group_id)  # type: unicode
        self.group_name = TeaConverter.to_unicode(group_name)  # type: unicode
        self.utc_create = TeaConverter.to_unicode(utc_create)  # type: unicode
        self.group_desc = TeaConverter.to_unicode(group_desc)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.group_desc is not None:
            result['GroupDesc'] = self.group_desc
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('GroupDesc') is not None:
            self.group_desc = m.get('GroupDesc')
        return self


class CreateDeviceGroupResponseBody(TeaModel):
    def __init__(self, request_id=None, data=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.data = data  # type: CreateDeviceGroupResponseBodyData
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = CreateDeviceGroupResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDeviceGroupResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CreateDeviceGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateDeviceGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEdgeDriverRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, driver_name=None,
                 driver_protocol=None, runtime=None, cpu_arch=None, is_built_in=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.driver_name = TeaConverter.to_unicode(driver_name)  # type: unicode
        self.driver_protocol = TeaConverter.to_unicode(driver_protocol)  # type: unicode
        self.runtime = TeaConverter.to_unicode(runtime)  # type: unicode
        self.cpu_arch = TeaConverter.to_unicode(cpu_arch)  # type: unicode
        self.is_built_in = is_built_in  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.driver_name is not None:
            result['DriverName'] = self.driver_name
        if self.driver_protocol is not None:
            result['DriverProtocol'] = self.driver_protocol
        if self.runtime is not None:
            result['Runtime'] = self.runtime
        if self.cpu_arch is not None:
            result['CpuArch'] = self.cpu_arch
        if self.is_built_in is not None:
            result['IsBuiltIn'] = self.is_built_in
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DriverName') is not None:
            self.driver_name = m.get('DriverName')
        if m.get('DriverProtocol') is not None:
            self.driver_protocol = m.get('DriverProtocol')
        if m.get('Runtime') is not None:
            self.runtime = m.get('Runtime')
        if m.get('CpuArch') is not None:
            self.cpu_arch = m.get('CpuArch')
        if m.get('IsBuiltIn') is not None:
            self.is_built_in = m.get('IsBuiltIn')
        return self


class CreateEdgeDriverResponseBody(TeaModel):
    def __init__(self, driver_id=None, request_id=None, error_message=None, code=None, success=None):
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateEdgeDriverResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CreateEdgeDriverResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateEdgeDriverResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEdgeDriverVersionRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, driver_id=None,
                 driver_version=None, edge_version=None, description=None, source_config=None, driver_config=None,
                 container_config=None, config_check_rule=None, argument=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode
        self.driver_version = TeaConverter.to_unicode(driver_version)  # type: unicode
        self.edge_version = TeaConverter.to_unicode(edge_version)  # type: unicode
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.source_config = TeaConverter.to_unicode(source_config)  # type: unicode
        self.driver_config = TeaConverter.to_unicode(driver_config)  # type: unicode
        self.container_config = TeaConverter.to_unicode(container_config)  # type: unicode
        self.config_check_rule = TeaConverter.to_unicode(config_check_rule)  # type: unicode
        self.argument = TeaConverter.to_unicode(argument)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        if self.edge_version is not None:
            result['EdgeVersion'] = self.edge_version
        if self.description is not None:
            result['Description'] = self.description
        if self.source_config is not None:
            result['SourceConfig'] = self.source_config
        if self.driver_config is not None:
            result['DriverConfig'] = self.driver_config
        if self.container_config is not None:
            result['ContainerConfig'] = self.container_config
        if self.config_check_rule is not None:
            result['ConfigCheckRule'] = self.config_check_rule
        if self.argument is not None:
            result['Argument'] = self.argument
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        if m.get('EdgeVersion') is not None:
            self.edge_version = m.get('EdgeVersion')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('SourceConfig') is not None:
            self.source_config = m.get('SourceConfig')
        if m.get('DriverConfig') is not None:
            self.driver_config = m.get('DriverConfig')
        if m.get('ContainerConfig') is not None:
            self.container_config = m.get('ContainerConfig')
        if m.get('ConfigCheckRule') is not None:
            self.config_check_rule = m.get('ConfigCheckRule')
        if m.get('Argument') is not None:
            self.argument = m.get('Argument')
        return self


class CreateEdgeDriverVersionResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateEdgeDriverVersionResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CreateEdgeDriverVersionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateEdgeDriverVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEdgeInstanceRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, name=None, tags=None, spec=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.tags = TeaConverter.to_unicode(tags)  # type: unicode
        self.spec = spec  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.spec is not None:
            result['Spec'] = self.spec
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        return self


class CreateEdgeInstanceResponseBody(TeaModel):
    def __init__(self, request_id=None, instance_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateEdgeInstanceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CreateEdgeInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEdgeInstanceChannelRequestConfigs(TeaModel):
    def __init__(self, key=None, content=None, format=None):
        self.key = TeaConverter.to_unicode(key)  # type: unicode
        self.content = TeaConverter.to_unicode(content)  # type: unicode
        self.format = TeaConverter.to_unicode(format)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.content is not None:
            result['Content'] = self.content
        if self.format is not None:
            result['Format'] = self.format
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Format') is not None:
            self.format = m.get('Format')
        return self


class CreateEdgeInstanceChannelRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, instance_id=None, driver_id=None,
                 channel_name=None, configs=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode
        self.channel_name = TeaConverter.to_unicode(channel_name)  # type: unicode
        self.configs = configs  # type: list[CreateEdgeInstanceChannelRequestConfigs]

    def validate(self):
        if self.configs:
            for k in self.configs:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.channel_name is not None:
            result['ChannelName'] = self.channel_name
        result['Configs'] = []
        if self.configs is not None:
            for k in self.configs:
                result['Configs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('ChannelName') is not None:
            self.channel_name = m.get('ChannelName')
        self.configs = []
        if m.get('Configs') is not None:
            for k in m.get('Configs'):
                temp_model = CreateEdgeInstanceChannelRequestConfigs()
                self.configs.append(temp_model.from_map(k))
        return self


class CreateEdgeInstanceChannelResponseBody(TeaModel):
    def __init__(self, request_id=None, data=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.data = TeaConverter.to_unicode(data)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateEdgeInstanceChannelResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CreateEdgeInstanceChannelResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateEdgeInstanceChannelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEdgeInstanceDeploymentRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, instance_id=None, type=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.type = TeaConverter.to_unicode(type)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateEdgeInstanceDeploymentResponseBody(TeaModel):
    def __init__(self, deployment_id=None, request_id=None, error_message=None, code=None, success=None):
        self.deployment_id = TeaConverter.to_unicode(deployment_id)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.deployment_id is not None:
            result['DeploymentId'] = self.deployment_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeploymentId') is not None:
            self.deployment_id = m.get('DeploymentId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateEdgeInstanceDeploymentResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CreateEdgeInstanceDeploymentResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateEdgeInstanceDeploymentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEdgeOssPreSignedAddressRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, resource_id=None, file_name=None, iot_instance_id=None,
                 type=None, instance_id=None, resource_version=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.resource_id = TeaConverter.to_unicode(resource_id)  # type: unicode
        self.file_name = TeaConverter.to_unicode(file_name)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.resource_version = TeaConverter.to_unicode(resource_version)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.type is not None:
            result['Type'] = self.type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.resource_version is not None:
            result['ResourceVersion'] = self.resource_version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ResourceVersion') is not None:
            self.resource_version = m.get('ResourceVersion')
        return self


class CreateEdgeOssPreSignedAddressResponseBodyData(TeaModel):
    def __init__(self, oss_address=None, oss_pre_signed_address=None):
        self.oss_address = TeaConverter.to_unicode(oss_address)  # type: unicode
        self.oss_pre_signed_address = TeaConverter.to_unicode(oss_pre_signed_address)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.oss_address is not None:
            result['OssAddress'] = self.oss_address
        if self.oss_pre_signed_address is not None:
            result['OssPreSignedAddress'] = self.oss_pre_signed_address
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OssAddress') is not None:
            self.oss_address = m.get('OssAddress')
        if m.get('OssPreSignedAddress') is not None:
            self.oss_pre_signed_address = m.get('OssPreSignedAddress')
        return self


class CreateEdgeOssPreSignedAddressResponseBody(TeaModel):
    def __init__(self, request_id=None, data=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.data = data  # type: CreateEdgeOssPreSignedAddressResponseBodyData
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = CreateEdgeOssPreSignedAddressResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateEdgeOssPreSignedAddressResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CreateEdgeOssPreSignedAddressResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateEdgeOssPreSignedAddressResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateJobRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, description=None,
                 job_document=None, type=None, job_file=None, job_name=None, timeout_config=None, rollout_config=None,
                 target_config=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.job_document = TeaConverter.to_unicode(job_document)  # type: unicode
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.job_file = job_file  # type: dict[unicode, any]
        self.job_name = TeaConverter.to_unicode(job_name)  # type: unicode
        self.timeout_config = timeout_config  # type: dict[unicode, any]
        self.rollout_config = rollout_config  # type: dict[unicode, any]
        self.target_config = target_config  # type: dict[unicode, any]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.description is not None:
            result['Description'] = self.description
        if self.job_document is not None:
            result['JobDocument'] = self.job_document
        if self.type is not None:
            result['Type'] = self.type
        if self.job_file is not None:
            result['JobFile'] = self.job_file
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.timeout_config is not None:
            result['TimeoutConfig'] = self.timeout_config
        if self.rollout_config is not None:
            result['RolloutConfig'] = self.rollout_config
        if self.target_config is not None:
            result['TargetConfig'] = self.target_config
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('JobDocument') is not None:
            self.job_document = m.get('JobDocument')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('JobFile') is not None:
            self.job_file = m.get('JobFile')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('TimeoutConfig') is not None:
            self.timeout_config = m.get('TimeoutConfig')
        if m.get('RolloutConfig') is not None:
            self.rollout_config = m.get('RolloutConfig')
        if m.get('TargetConfig') is not None:
            self.target_config = m.get('TargetConfig')
        return self


class CreateJobShrinkRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, description=None,
                 job_document=None, type=None, job_file_shrink=None, job_name=None, timeout_config_shrink=None,
                 rollout_config_shrink=None, target_config_shrink=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.job_document = TeaConverter.to_unicode(job_document)  # type: unicode
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.job_file_shrink = TeaConverter.to_unicode(job_file_shrink)  # type: unicode
        self.job_name = TeaConverter.to_unicode(job_name)  # type: unicode
        self.timeout_config_shrink = TeaConverter.to_unicode(timeout_config_shrink)  # type: unicode
        self.rollout_config_shrink = TeaConverter.to_unicode(rollout_config_shrink)  # type: unicode
        self.target_config_shrink = TeaConverter.to_unicode(target_config_shrink)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.description is not None:
            result['Description'] = self.description
        if self.job_document is not None:
            result['JobDocument'] = self.job_document
        if self.type is not None:
            result['Type'] = self.type
        if self.job_file_shrink is not None:
            result['JobFile'] = self.job_file_shrink
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.timeout_config_shrink is not None:
            result['TimeoutConfig'] = self.timeout_config_shrink
        if self.rollout_config_shrink is not None:
            result['RolloutConfig'] = self.rollout_config_shrink
        if self.target_config_shrink is not None:
            result['TargetConfig'] = self.target_config_shrink
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('JobDocument') is not None:
            self.job_document = m.get('JobDocument')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('JobFile') is not None:
            self.job_file_shrink = m.get('JobFile')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('TimeoutConfig') is not None:
            self.timeout_config_shrink = m.get('TimeoutConfig')
        if m.get('RolloutConfig') is not None:
            self.rollout_config_shrink = m.get('RolloutConfig')
        if m.get('TargetConfig') is not None:
            self.target_config_shrink = m.get('TargetConfig')
        return self


class CreateJobResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None, job_id=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class CreateJobResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CreateJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLoRaNodesTaskRequestDeviceInfo(TeaModel):
    def __init__(self, dev_eui=None, pin_code=None):
        self.dev_eui = TeaConverter.to_unicode(dev_eui)  # type: unicode
        self.pin_code = TeaConverter.to_unicode(pin_code)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.dev_eui is not None:
            result['DevEui'] = self.dev_eui
        if self.pin_code is not None:
            result['PinCode'] = self.pin_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DevEui') is not None:
            self.dev_eui = m.get('DevEui')
        if m.get('PinCode') is not None:
            self.pin_code = m.get('PinCode')
        return self


class CreateLoRaNodesTaskRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, product_key=None,
                 device_info=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_info = device_info  # type: list[CreateLoRaNodesTaskRequestDeviceInfo]

    def validate(self):
        if self.device_info:
            for k in self.device_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        result['DeviceInfo'] = []
        if self.device_info is not None:
            for k in self.device_info:
                result['DeviceInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        self.device_info = []
        if m.get('DeviceInfo') is not None:
            for k in m.get('DeviceInfo'):
                temp_model = CreateLoRaNodesTaskRequestDeviceInfo()
                self.device_info.append(temp_model.from_map(k))
        return self


class CreateLoRaNodesTaskResponseBody(TeaModel):
    def __init__(self, task_id=None, request_id=None, error_message=None, code=None, success=None):
        self.task_id = TeaConverter.to_unicode(task_id)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateLoRaNodesTaskResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CreateLoRaNodesTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateLoRaNodesTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOTADynamicUpgradeJobRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = TeaConverter.to_unicode(key)  # type: unicode
        self.value = TeaConverter.to_unicode(value)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateOTADynamicUpgradeJobRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, firmware_id=None,
                 product_key=None, retry_interval=None, retry_count=None, timeout_in_minutes=None, maximum_per_minute=None,
                 overwrite_mode=None, dynamic_mode=None, src_version=None, tag=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.firmware_id = TeaConverter.to_unicode(firmware_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.retry_interval = retry_interval  # type: int
        self.retry_count = retry_count  # type: int
        self.timeout_in_minutes = timeout_in_minutes  # type: int
        self.maximum_per_minute = maximum_per_minute  # type: int
        self.overwrite_mode = overwrite_mode  # type: int
        self.dynamic_mode = dynamic_mode  # type: int
        self.src_version = src_version  # type: list[unicode]
        self.tag = tag  # type: list[CreateOTADynamicUpgradeJobRequestTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.retry_interval is not None:
            result['RetryInterval'] = self.retry_interval
        if self.retry_count is not None:
            result['RetryCount'] = self.retry_count
        if self.timeout_in_minutes is not None:
            result['TimeoutInMinutes'] = self.timeout_in_minutes
        if self.maximum_per_minute is not None:
            result['MaximumPerMinute'] = self.maximum_per_minute
        if self.overwrite_mode is not None:
            result['OverwriteMode'] = self.overwrite_mode
        if self.dynamic_mode is not None:
            result['DynamicMode'] = self.dynamic_mode
        if self.src_version is not None:
            result['SrcVersion'] = self.src_version
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('RetryInterval') is not None:
            self.retry_interval = m.get('RetryInterval')
        if m.get('RetryCount') is not None:
            self.retry_count = m.get('RetryCount')
        if m.get('TimeoutInMinutes') is not None:
            self.timeout_in_minutes = m.get('TimeoutInMinutes')
        if m.get('MaximumPerMinute') is not None:
            self.maximum_per_minute = m.get('MaximumPerMinute')
        if m.get('OverwriteMode') is not None:
            self.overwrite_mode = m.get('OverwriteMode')
        if m.get('DynamicMode') is not None:
            self.dynamic_mode = m.get('DynamicMode')
        if m.get('SrcVersion') is not None:
            self.src_version = m.get('SrcVersion')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateOTADynamicUpgradeJobRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class CreateOTADynamicUpgradeJobResponseBodyData(TeaModel):
    def __init__(self, job_id=None, utc_create=None):
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.utc_create = TeaConverter.to_unicode(utc_create)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class CreateOTADynamicUpgradeJobResponseBody(TeaModel):
    def __init__(self, request_id=None, data=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.data = data  # type: CreateOTADynamicUpgradeJobResponseBodyData
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = CreateOTADynamicUpgradeJobResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateOTADynamicUpgradeJobResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CreateOTADynamicUpgradeJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateOTADynamicUpgradeJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOTAFirmwareRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, firmware_name=None,
                 dest_version=None, firmware_url=None, firmware_sign=None, sign_method=None, firmware_size=None,
                 product_key=None, firmware_desc=None, type=None, src_version=None, module_name=None, need_to_verify=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.firmware_name = TeaConverter.to_unicode(firmware_name)  # type: unicode
        self.dest_version = TeaConverter.to_unicode(dest_version)  # type: unicode
        self.firmware_url = TeaConverter.to_unicode(firmware_url)  # type: unicode
        self.firmware_sign = TeaConverter.to_unicode(firmware_sign)  # type: unicode
        self.sign_method = TeaConverter.to_unicode(sign_method)  # type: unicode
        self.firmware_size = firmware_size  # type: int
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.firmware_desc = TeaConverter.to_unicode(firmware_desc)  # type: unicode
        self.type = type  # type: int
        self.src_version = TeaConverter.to_unicode(src_version)  # type: unicode
        self.module_name = TeaConverter.to_unicode(module_name)  # type: unicode
        self.need_to_verify = need_to_verify  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_name is not None:
            result['FirmwareName'] = self.firmware_name
        if self.dest_version is not None:
            result['DestVersion'] = self.dest_version
        if self.firmware_url is not None:
            result['FirmwareUrl'] = self.firmware_url
        if self.firmware_sign is not None:
            result['FirmwareSign'] = self.firmware_sign
        if self.sign_method is not None:
            result['SignMethod'] = self.sign_method
        if self.firmware_size is not None:
            result['FirmwareSize'] = self.firmware_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.firmware_desc is not None:
            result['FirmwareDesc'] = self.firmware_desc
        if self.type is not None:
            result['Type'] = self.type
        if self.src_version is not None:
            result['SrcVersion'] = self.src_version
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        if self.need_to_verify is not None:
            result['NeedToVerify'] = self.need_to_verify
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareName') is not None:
            self.firmware_name = m.get('FirmwareName')
        if m.get('DestVersion') is not None:
            self.dest_version = m.get('DestVersion')
        if m.get('FirmwareUrl') is not None:
            self.firmware_url = m.get('FirmwareUrl')
        if m.get('FirmwareSign') is not None:
            self.firmware_sign = m.get('FirmwareSign')
        if m.get('SignMethod') is not None:
            self.sign_method = m.get('SignMethod')
        if m.get('FirmwareSize') is not None:
            self.firmware_size = m.get('FirmwareSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('FirmwareDesc') is not None:
            self.firmware_desc = m.get('FirmwareDesc')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('SrcVersion') is not None:
            self.src_version = m.get('SrcVersion')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        if m.get('NeedToVerify') is not None:
            self.need_to_verify = m.get('NeedToVerify')
        return self


class CreateOTAFirmwareResponseBodyData(TeaModel):
    def __init__(self, utc_create=None, firmware_id=None):
        self.utc_create = TeaConverter.to_unicode(utc_create)  # type: unicode
        self.firmware_id = TeaConverter.to_unicode(firmware_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        return self


class CreateOTAFirmwareResponseBody(TeaModel):
    def __init__(self, request_id=None, data=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.data = data  # type: CreateOTAFirmwareResponseBodyData
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = CreateOTAFirmwareResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateOTAFirmwareResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CreateOTAFirmwareResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateOTAFirmwareResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOTAModuleRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, alias_name=None, iot_instance_id=None, module_name=None,
                 desc=None, product_key=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.alias_name = TeaConverter.to_unicode(alias_name)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.module_name = TeaConverter.to_unicode(module_name)  # type: unicode
        self.desc = TeaConverter.to_unicode(desc)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class CreateOTAModuleResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateOTAModuleResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CreateOTAModuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateOTAModuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOTAStaticUpgradeJobRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = TeaConverter.to_unicode(key)  # type: unicode
        self.value = TeaConverter.to_unicode(value)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateOTAStaticUpgradeJobRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, firmware_id=None,
                 product_key=None, target_selection=None, schedule_time=None, retry_interval=None, retry_count=None,
                 timeout_in_minutes=None, maximum_per_minute=None, gray_percent=None, schedule_finish_time=None, overwrite_mode=None,
                 dn_list_file_url=None, src_version=None, target_device_name=None, tag=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.firmware_id = TeaConverter.to_unicode(firmware_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.target_selection = TeaConverter.to_unicode(target_selection)  # type: unicode
        self.schedule_time = schedule_time  # type: long
        self.retry_interval = retry_interval  # type: int
        self.retry_count = retry_count  # type: int
        self.timeout_in_minutes = timeout_in_minutes  # type: int
        self.maximum_per_minute = maximum_per_minute  # type: int
        self.gray_percent = TeaConverter.to_unicode(gray_percent)  # type: unicode
        self.schedule_finish_time = schedule_finish_time  # type: long
        self.overwrite_mode = overwrite_mode  # type: int
        self.dn_list_file_url = TeaConverter.to_unicode(dn_list_file_url)  # type: unicode
        self.src_version = src_version  # type: list[unicode]
        self.target_device_name = target_device_name  # type: list[unicode]
        self.tag = tag  # type: list[CreateOTAStaticUpgradeJobRequestTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.target_selection is not None:
            result['TargetSelection'] = self.target_selection
        if self.schedule_time is not None:
            result['ScheduleTime'] = self.schedule_time
        if self.retry_interval is not None:
            result['RetryInterval'] = self.retry_interval
        if self.retry_count is not None:
            result['RetryCount'] = self.retry_count
        if self.timeout_in_minutes is not None:
            result['TimeoutInMinutes'] = self.timeout_in_minutes
        if self.maximum_per_minute is not None:
            result['MaximumPerMinute'] = self.maximum_per_minute
        if self.gray_percent is not None:
            result['GrayPercent'] = self.gray_percent
        if self.schedule_finish_time is not None:
            result['ScheduleFinishTime'] = self.schedule_finish_time
        if self.overwrite_mode is not None:
            result['OverwriteMode'] = self.overwrite_mode
        if self.dn_list_file_url is not None:
            result['DnListFileUrl'] = self.dn_list_file_url
        if self.src_version is not None:
            result['SrcVersion'] = self.src_version
        if self.target_device_name is not None:
            result['TargetDeviceName'] = self.target_device_name
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('TargetSelection') is not None:
            self.target_selection = m.get('TargetSelection')
        if m.get('ScheduleTime') is not None:
            self.schedule_time = m.get('ScheduleTime')
        if m.get('RetryInterval') is not None:
            self.retry_interval = m.get('RetryInterval')
        if m.get('RetryCount') is not None:
            self.retry_count = m.get('RetryCount')
        if m.get('TimeoutInMinutes') is not None:
            self.timeout_in_minutes = m.get('TimeoutInMinutes')
        if m.get('MaximumPerMinute') is not None:
            self.maximum_per_minute = m.get('MaximumPerMinute')
        if m.get('GrayPercent') is not None:
            self.gray_percent = m.get('GrayPercent')
        if m.get('ScheduleFinishTime') is not None:
            self.schedule_finish_time = m.get('ScheduleFinishTime')
        if m.get('OverwriteMode') is not None:
            self.overwrite_mode = m.get('OverwriteMode')
        if m.get('DnListFileUrl') is not None:
            self.dn_list_file_url = m.get('DnListFileUrl')
        if m.get('SrcVersion') is not None:
            self.src_version = m.get('SrcVersion')
        if m.get('TargetDeviceName') is not None:
            self.target_device_name = m.get('TargetDeviceName')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateOTAStaticUpgradeJobRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class CreateOTAStaticUpgradeJobResponseBodyData(TeaModel):
    def __init__(self, job_id=None, utc_create=None):
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.utc_create = TeaConverter.to_unicode(utc_create)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class CreateOTAStaticUpgradeJobResponseBody(TeaModel):
    def __init__(self, request_id=None, data=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.data = data  # type: CreateOTAStaticUpgradeJobResponseBodyData
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = CreateOTAStaticUpgradeJobResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateOTAStaticUpgradeJobResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CreateOTAStaticUpgradeJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateOTAStaticUpgradeJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOTAVerifyJobRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, firmware_id=None,
                 timeout_in_minutes=None, product_key=None, target_device_name=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.firmware_id = TeaConverter.to_unicode(firmware_id)  # type: unicode
        self.timeout_in_minutes = timeout_in_minutes  # type: int
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.target_device_name = target_device_name  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.timeout_in_minutes is not None:
            result['TimeoutInMinutes'] = self.timeout_in_minutes
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.target_device_name is not None:
            result['TargetDeviceName'] = self.target_device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('TimeoutInMinutes') is not None:
            self.timeout_in_minutes = m.get('TimeoutInMinutes')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('TargetDeviceName') is not None:
            self.target_device_name = m.get('TargetDeviceName')
        return self


class CreateOTAVerifyJobResponseBodyData(TeaModel):
    def __init__(self, job_id=None, utc_create=None):
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.utc_create = TeaConverter.to_unicode(utc_create)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class CreateOTAVerifyJobResponseBody(TeaModel):
    def __init__(self, request_id=None, data=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.data = data  # type: CreateOTAVerifyJobResponseBodyData
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = CreateOTAVerifyJobResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateOTAVerifyJobResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CreateOTAVerifyJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateOTAVerifyJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateProductRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, product_name=None, node_type=None,
                 data_format=None, description=None, aliyun_commodity_code=None, id_2=None, category_id=None,
                 protocol_type=None, net_type=None, join_permission_id=None, resource_group_id=None, auth_type=None,
                 category_key=None, publish_auto=None, validate_type=None, real_tenant_id=None, real_tripartite_key=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_name = TeaConverter.to_unicode(product_name)  # type: unicode
        self.node_type = node_type  # type: int
        self.data_format = data_format  # type: int
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.aliyun_commodity_code = TeaConverter.to_unicode(aliyun_commodity_code)  # type: unicode
        self.id_2 = id_2  # type: bool
        self.category_id = category_id  # type: long
        self.protocol_type = TeaConverter.to_unicode(protocol_type)  # type: unicode
        self.net_type = TeaConverter.to_unicode(net_type)  # type: unicode
        self.join_permission_id = TeaConverter.to_unicode(join_permission_id)  # type: unicode
        self.resource_group_id = TeaConverter.to_unicode(resource_group_id)  # type: unicode
        self.auth_type = TeaConverter.to_unicode(auth_type)  # type: unicode
        self.category_key = TeaConverter.to_unicode(category_key)  # type: unicode
        self.publish_auto = publish_auto  # type: bool
        self.validate_type = validate_type  # type: int
        self.real_tenant_id = TeaConverter.to_unicode(real_tenant_id)  # type: unicode
        self.real_tripartite_key = TeaConverter.to_unicode(real_tripartite_key)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.data_format is not None:
            result['DataFormat'] = self.data_format
        if self.description is not None:
            result['Description'] = self.description
        if self.aliyun_commodity_code is not None:
            result['AliyunCommodityCode'] = self.aliyun_commodity_code
        if self.id_2 is not None:
            result['Id2'] = self.id_2
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.join_permission_id is not None:
            result['JoinPermissionId'] = self.join_permission_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.auth_type is not None:
            result['AuthType'] = self.auth_type
        if self.category_key is not None:
            result['CategoryKey'] = self.category_key
        if self.publish_auto is not None:
            result['PublishAuto'] = self.publish_auto
        if self.validate_type is not None:
            result['ValidateType'] = self.validate_type
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('DataFormat') is not None:
            self.data_format = m.get('DataFormat')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('AliyunCommodityCode') is not None:
            self.aliyun_commodity_code = m.get('AliyunCommodityCode')
        if m.get('Id2') is not None:
            self.id_2 = m.get('Id2')
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('JoinPermissionId') is not None:
            self.join_permission_id = m.get('JoinPermissionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('AuthType') is not None:
            self.auth_type = m.get('AuthType')
        if m.get('CategoryKey') is not None:
            self.category_key = m.get('CategoryKey')
        if m.get('PublishAuto') is not None:
            self.publish_auto = m.get('PublishAuto')
        if m.get('ValidateType') is not None:
            self.validate_type = m.get('ValidateType')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        return self


class CreateProductResponseBodyData(TeaModel):
    def __init__(self, auth_type=None, product_key=None, product_name=None, node_type=None, description=None,
                 id_2=None, product_secret=None, protocol_type=None, data_format=None, aliyun_commodity_code=None):
        self.auth_type = TeaConverter.to_unicode(auth_type)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.product_name = TeaConverter.to_unicode(product_name)  # type: unicode
        self.node_type = node_type  # type: int
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.id_2 = id_2  # type: bool
        self.product_secret = TeaConverter.to_unicode(product_secret)  # type: unicode
        self.protocol_type = TeaConverter.to_unicode(protocol_type)  # type: unicode
        self.data_format = data_format  # type: int
        self.aliyun_commodity_code = TeaConverter.to_unicode(aliyun_commodity_code)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.auth_type is not None:
            result['AuthType'] = self.auth_type
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.description is not None:
            result['Description'] = self.description
        if self.id_2 is not None:
            result['Id2'] = self.id_2
        if self.product_secret is not None:
            result['ProductSecret'] = self.product_secret
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.data_format is not None:
            result['DataFormat'] = self.data_format
        if self.aliyun_commodity_code is not None:
            result['AliyunCommodityCode'] = self.aliyun_commodity_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AuthType') is not None:
            self.auth_type = m.get('AuthType')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Id2') is not None:
            self.id_2 = m.get('Id2')
        if m.get('ProductSecret') is not None:
            self.product_secret = m.get('ProductSecret')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('DataFormat') is not None:
            self.data_format = m.get('DataFormat')
        if m.get('AliyunCommodityCode') is not None:
            self.aliyun_commodity_code = m.get('AliyunCommodityCode')
        return self


class CreateProductResponseBody(TeaModel):
    def __init__(self, request_id=None, data=None, error_message=None, code=None, product_key=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.data = data  # type: CreateProductResponseBodyData
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = CreateProductResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateProductResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CreateProductResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateProductResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateProductTagsRequestProductTag(TeaModel):
    def __init__(self, tag_value=None, tag_key=None):
        self.tag_value = TeaConverter.to_unicode(tag_value)  # type: unicode
        self.tag_key = TeaConverter.to_unicode(tag_key)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        return self


class CreateProductTagsRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, product_key=None,
                 real_tenant_id=None, real_tripartite_key=None, product_tag=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.real_tenant_id = TeaConverter.to_unicode(real_tenant_id)  # type: unicode
        self.real_tripartite_key = TeaConverter.to_unicode(real_tripartite_key)  # type: unicode
        self.product_tag = product_tag  # type: list[CreateProductTagsRequestProductTag]

    def validate(self):
        if self.product_tag:
            for k in self.product_tag:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        result['ProductTag'] = []
        if self.product_tag is not None:
            for k in self.product_tag:
                result['ProductTag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        self.product_tag = []
        if m.get('ProductTag') is not None:
            for k in m.get('ProductTag'):
                temp_model = CreateProductTagsRequestProductTag()
                self.product_tag.append(temp_model.from_map(k))
        return self


class CreateProductTagsResponseBodyInvalidProductTagsProductTag(TeaModel):
    def __init__(self, tag_value=None, tag_key=None):
        self.tag_value = TeaConverter.to_unicode(tag_value)  # type: unicode
        self.tag_key = TeaConverter.to_unicode(tag_key)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        return self


class CreateProductTagsResponseBodyInvalidProductTags(TeaModel):
    def __init__(self, product_tag=None):
        self.product_tag = product_tag  # type: list[CreateProductTagsResponseBodyInvalidProductTagsProductTag]

    def validate(self):
        if self.product_tag:
            for k in self.product_tag:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['ProductTag'] = []
        if self.product_tag is not None:
            for k in self.product_tag:
                result['ProductTag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.product_tag = []
        if m.get('ProductTag') is not None:
            for k in m.get('ProductTag'):
                temp_model = CreateProductTagsResponseBodyInvalidProductTagsProductTag()
                self.product_tag.append(temp_model.from_map(k))
        return self


class CreateProductTagsResponseBody(TeaModel):
    def __init__(self, request_id=None, invalid_product_tags=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.invalid_product_tags = invalid_product_tags  # type: CreateProductTagsResponseBodyInvalidProductTags
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.invalid_product_tags:
            self.invalid_product_tags.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.invalid_product_tags is not None:
            result['InvalidProductTags'] = self.invalid_product_tags.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('InvalidProductTags') is not None:
            temp_model = CreateProductTagsResponseBodyInvalidProductTags()
            self.invalid_product_tags = temp_model.from_map(m['InvalidProductTags'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateProductTagsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CreateProductTagsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateProductTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateProductTopicRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, product_key=None,
                 topic_short_name=None, operation=None, desc=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.topic_short_name = TeaConverter.to_unicode(topic_short_name)  # type: unicode
        self.operation = TeaConverter.to_unicode(operation)  # type: unicode
        self.desc = TeaConverter.to_unicode(desc)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.topic_short_name is not None:
            result['TopicShortName'] = self.topic_short_name
        if self.operation is not None:
            result['Operation'] = self.operation
        if self.desc is not None:
            result['Desc'] = self.desc
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('TopicShortName') is not None:
            self.topic_short_name = m.get('TopicShortName')
        if m.get('Operation') is not None:
            self.operation = m.get('Operation')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        return self


class CreateProductTopicResponseBody(TeaModel):
    def __init__(self, request_id=None, topic_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.topic_id = topic_id  # type: long
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.topic_id is not None:
            result['TopicId'] = self.topic_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TopicId') is not None:
            self.topic_id = m.get('TopicId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateProductTopicResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CreateProductTopicResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateProductTopicResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRuleRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, select=None, short_topic=None,
                 where=None, product_key=None, name=None, rule_desc=None, data_type=None, topic_type=None,
                 resource_group_id=None, topic=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.select = TeaConverter.to_unicode(select)  # type: unicode
        self.short_topic = TeaConverter.to_unicode(short_topic)  # type: unicode
        self.where = TeaConverter.to_unicode(where)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.rule_desc = TeaConverter.to_unicode(rule_desc)  # type: unicode
        self.data_type = TeaConverter.to_unicode(data_type)  # type: unicode
        self.topic_type = topic_type  # type: int
        self.resource_group_id = TeaConverter.to_unicode(resource_group_id)  # type: unicode
        self.topic = TeaConverter.to_unicode(topic)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.select is not None:
            result['Select'] = self.select
        if self.short_topic is not None:
            result['ShortTopic'] = self.short_topic
        if self.where is not None:
            result['Where'] = self.where
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.name is not None:
            result['Name'] = self.name
        if self.rule_desc is not None:
            result['RuleDesc'] = self.rule_desc
        if self.data_type is not None:
            result['DataType'] = self.data_type
        if self.topic_type is not None:
            result['TopicType'] = self.topic_type
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Select') is not None:
            self.select = m.get('Select')
        if m.get('ShortTopic') is not None:
            self.short_topic = m.get('ShortTopic')
        if m.get('Where') is not None:
            self.where = m.get('Where')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RuleDesc') is not None:
            self.rule_desc = m.get('RuleDesc')
        if m.get('DataType') is not None:
            self.data_type = m.get('DataType')
        if m.get('TopicType') is not None:
            self.topic_type = m.get('TopicType')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class CreateRuleResponseBody(TeaModel):
    def __init__(self, request_id=None, rule_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.rule_id = rule_id  # type: long
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateRuleResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CreateRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRuleActionRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, rule_id=None, type=None,
                 configuration=None, error_action_flag=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.rule_id = rule_id  # type: long
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.configuration = TeaConverter.to_unicode(configuration)  # type: unicode
        self.error_action_flag = error_action_flag  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.type is not None:
            result['Type'] = self.type
        if self.configuration is not None:
            result['Configuration'] = self.configuration
        if self.error_action_flag is not None:
            result['ErrorActionFlag'] = self.error_action_flag
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Configuration') is not None:
            self.configuration = m.get('Configuration')
        if m.get('ErrorActionFlag') is not None:
            self.error_action_flag = m.get('ErrorActionFlag')
        return self


class CreateRuleActionResponseBody(TeaModel):
    def __init__(self, action_id=None, request_id=None, error_message=None, code=None, success=None):
        self.action_id = action_id  # type: long
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.action_id is not None:
            result['ActionId'] = self.action_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActionId') is not None:
            self.action_id = m.get('ActionId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateRuleActionResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CreateRuleActionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateRuleActionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSceneRuleRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, rule_name=None, rule_content=None,
                 rule_description=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.rule_name = TeaConverter.to_unicode(rule_name)  # type: unicode
        self.rule_content = TeaConverter.to_unicode(rule_content)  # type: unicode
        self.rule_description = TeaConverter.to_unicode(rule_description)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.rule_content is not None:
            result['RuleContent'] = self.rule_content
        if self.rule_description is not None:
            result['RuleDescription'] = self.rule_description
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('RuleContent') is not None:
            self.rule_content = m.get('RuleContent')
        if m.get('RuleDescription') is not None:
            self.rule_description = m.get('RuleDescription')
        return self


class CreateSceneRuleResponseBody(TeaModel):
    def __init__(self, request_id=None, rule_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.rule_id = TeaConverter.to_unicode(rule_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateSceneRuleResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CreateSceneRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateSceneRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSubscribeRelationRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, product_key=None,
                 device_data_flag=None, device_life_cycle_flag=None, device_status_change_flag=None,
                 device_topo_life_cycle_flag=None, found_device_list_flag=None, mns_configuration=None, type=None, ota_event_flag=None,
                 thing_history_flag=None, device_tag_flag=None, ota_version_flag=None, ota_job_flag=None, consumer_group_ids=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_data_flag = device_data_flag  # type: bool
        self.device_life_cycle_flag = device_life_cycle_flag  # type: bool
        self.device_status_change_flag = device_status_change_flag  # type: bool
        self.device_topo_life_cycle_flag = device_topo_life_cycle_flag  # type: bool
        self.found_device_list_flag = found_device_list_flag  # type: bool
        self.mns_configuration = TeaConverter.to_unicode(mns_configuration)  # type: unicode
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.ota_event_flag = ota_event_flag  # type: bool
        self.thing_history_flag = thing_history_flag  # type: bool
        self.device_tag_flag = device_tag_flag  # type: bool
        self.ota_version_flag = ota_version_flag  # type: bool
        self.ota_job_flag = ota_job_flag  # type: bool
        self.consumer_group_ids = consumer_group_ids  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_data_flag is not None:
            result['DeviceDataFlag'] = self.device_data_flag
        if self.device_life_cycle_flag is not None:
            result['DeviceLifeCycleFlag'] = self.device_life_cycle_flag
        if self.device_status_change_flag is not None:
            result['DeviceStatusChangeFlag'] = self.device_status_change_flag
        if self.device_topo_life_cycle_flag is not None:
            result['DeviceTopoLifeCycleFlag'] = self.device_topo_life_cycle_flag
        if self.found_device_list_flag is not None:
            result['FoundDeviceListFlag'] = self.found_device_list_flag
        if self.mns_configuration is not None:
            result['MnsConfiguration'] = self.mns_configuration
        if self.type is not None:
            result['Type'] = self.type
        if self.ota_event_flag is not None:
            result['OtaEventFlag'] = self.ota_event_flag
        if self.thing_history_flag is not None:
            result['ThingHistoryFlag'] = self.thing_history_flag
        if self.device_tag_flag is not None:
            result['DeviceTagFlag'] = self.device_tag_flag
        if self.ota_version_flag is not None:
            result['OtaVersionFlag'] = self.ota_version_flag
        if self.ota_job_flag is not None:
            result['OtaJobFlag'] = self.ota_job_flag
        if self.consumer_group_ids is not None:
            result['ConsumerGroupIds'] = self.consumer_group_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceDataFlag') is not None:
            self.device_data_flag = m.get('DeviceDataFlag')
        if m.get('DeviceLifeCycleFlag') is not None:
            self.device_life_cycle_flag = m.get('DeviceLifeCycleFlag')
        if m.get('DeviceStatusChangeFlag') is not None:
            self.device_status_change_flag = m.get('DeviceStatusChangeFlag')
        if m.get('DeviceTopoLifeCycleFlag') is not None:
            self.device_topo_life_cycle_flag = m.get('DeviceTopoLifeCycleFlag')
        if m.get('FoundDeviceListFlag') is not None:
            self.found_device_list_flag = m.get('FoundDeviceListFlag')
        if m.get('MnsConfiguration') is not None:
            self.mns_configuration = m.get('MnsConfiguration')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('OtaEventFlag') is not None:
            self.ota_event_flag = m.get('OtaEventFlag')
        if m.get('ThingHistoryFlag') is not None:
            self.thing_history_flag = m.get('ThingHistoryFlag')
        if m.get('DeviceTagFlag') is not None:
            self.device_tag_flag = m.get('DeviceTagFlag')
        if m.get('OtaVersionFlag') is not None:
            self.ota_version_flag = m.get('OtaVersionFlag')
        if m.get('OtaJobFlag') is not None:
            self.ota_job_flag = m.get('OtaJobFlag')
        if m.get('ConsumerGroupIds') is not None:
            self.consumer_group_ids = m.get('ConsumerGroupIds')
        return self


class CreateSubscribeRelationResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateSubscribeRelationResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CreateSubscribeRelationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateSubscribeRelationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateThingModelRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, product_key=None,
                 thing_model_json=None, function_block_id=None, function_block_name=None, real_tenant_id=None,
                 real_tripartite_key=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.thing_model_json = TeaConverter.to_unicode(thing_model_json)  # type: unicode
        self.function_block_id = TeaConverter.to_unicode(function_block_id)  # type: unicode
        self.function_block_name = TeaConverter.to_unicode(function_block_name)  # type: unicode
        self.real_tenant_id = TeaConverter.to_unicode(real_tenant_id)  # type: unicode
        self.real_tripartite_key = TeaConverter.to_unicode(real_tripartite_key)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.thing_model_json is not None:
            result['ThingModelJson'] = self.thing_model_json
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        if self.function_block_name is not None:
            result['FunctionBlockName'] = self.function_block_name
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ThingModelJson') is not None:
            self.thing_model_json = m.get('ThingModelJson')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        if m.get('FunctionBlockName') is not None:
            self.function_block_name = m.get('FunctionBlockName')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        return self


class CreateThingModelResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateThingModelResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CreateThingModelResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateThingModelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateThingScriptRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, script_content=None, iot_instance_id=None,
                 product_key=None, script_type=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.script_content = TeaConverter.to_unicode(script_content)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.script_type = TeaConverter.to_unicode(script_type)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.script_content is not None:
            result['ScriptContent'] = self.script_content
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.script_type is not None:
            result['ScriptType'] = self.script_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('ScriptContent') is not None:
            self.script_content = m.get('ScriptContent')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ScriptType') is not None:
            self.script_type = m.get('ScriptType')
        return self


class CreateThingScriptResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateThingScriptResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CreateThingScriptResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateThingScriptResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTopicRouteTableRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, src_topic=None, dst_topic=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.src_topic = TeaConverter.to_unicode(src_topic)  # type: unicode
        self.dst_topic = dst_topic  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.src_topic is not None:
            result['SrcTopic'] = self.src_topic
        if self.dst_topic is not None:
            result['DstTopic'] = self.dst_topic
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('SrcTopic') is not None:
            self.src_topic = m.get('SrcTopic')
        if m.get('DstTopic') is not None:
            self.dst_topic = m.get('DstTopic')
        return self


class CreateTopicRouteTableResponseBodyFailureTopics(TeaModel):
    def __init__(self, topic=None):
        self.topic = topic  # type: list[dict[unicode, any]]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class CreateTopicRouteTableResponseBody(TeaModel):
    def __init__(self, request_id=None, failure_topics=None, error_message=None, code=None, is_all_succeed=None,
                 success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.failure_topics = failure_topics  # type: CreateTopicRouteTableResponseBodyFailureTopics
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.is_all_succeed = is_all_succeed  # type: bool
        self.success = success  # type: bool

    def validate(self):
        if self.failure_topics:
            self.failure_topics.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.failure_topics is not None:
            result['FailureTopics'] = self.failure_topics.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.is_all_succeed is not None:
            result['IsAllSucceed'] = self.is_all_succeed
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('FailureTopics') is not None:
            temp_model = CreateTopicRouteTableResponseBodyFailureTopics()
            self.failure_topics = temp_model.from_map(m['FailureTopics'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('IsAllSucceed') is not None:
            self.is_all_succeed = m.get('IsAllSucceed')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateTopicRouteTableResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: CreateTopicRouteTableResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateTopicRouteTableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteClientIdsRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_id=None, iot_instance_id=None, auth_config=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.auth_config = TeaConverter.to_unicode(auth_config)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.auth_config is not None:
            result['AuthConfig'] = self.auth_config
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('AuthConfig') is not None:
            self.auth_config = m.get('AuthConfig')
        return self


class DeleteClientIdsResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteClientIdsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: DeleteClientIdsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteClientIdsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteConsumerGroupRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, group_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.group_id = TeaConverter.to_unicode(group_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class DeleteConsumerGroupResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteConsumerGroupResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: DeleteConsumerGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteConsumerGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteConsumerGroupSubscribeRelationRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, consumer_group_id=None, iot_instance_id=None,
                 product_key=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.consumer_group_id = TeaConverter.to_unicode(consumer_group_id)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.consumer_group_id is not None:
            result['ConsumerGroupId'] = self.consumer_group_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('ConsumerGroupId') is not None:
            self.consumer_group_id = m.get('ConsumerGroupId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class DeleteConsumerGroupSubscribeRelationResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteConsumerGroupSubscribeRelationResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: DeleteConsumerGroupSubscribeRelationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteConsumerGroupSubscribeRelationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDeviceRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, product_key=None,
                 device_name=None, iot_id=None, real_tenant_id=None, real_tripartite_key=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.real_tenant_id = TeaConverter.to_unicode(real_tenant_id)  # type: unicode
        self.real_tripartite_key = TeaConverter.to_unicode(real_tripartite_key)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        return self


class DeleteDeviceResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDeviceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: DeleteDeviceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDeviceFileRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, product_key=None,
                 device_name=None, iot_id=None, file_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.file_id = TeaConverter.to_unicode(file_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.file_id is not None:
            result['FileId'] = self.file_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        return self


class DeleteDeviceFileResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDeviceFileResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: DeleteDeviceFileResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDeviceFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDeviceGroupRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, group_id=None,
                 real_tenant_id=None, real_tripartite_key=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.group_id = TeaConverter.to_unicode(group_id)  # type: unicode
        self.real_tenant_id = TeaConverter.to_unicode(real_tenant_id)  # type: unicode
        self.real_tripartite_key = TeaConverter.to_unicode(real_tripartite_key)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        return self


class DeleteDeviceGroupResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDeviceGroupResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: DeleteDeviceGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDeviceGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDevicePropRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, product_key=None,
                 device_name=None, prop_key=None, iot_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.prop_key = TeaConverter.to_unicode(prop_key)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.prop_key is not None:
            result['PropKey'] = self.prop_key
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('PropKey') is not None:
            self.prop_key = m.get('PropKey')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class DeleteDevicePropResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDevicePropResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: DeleteDevicePropResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDevicePropResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEdgeDriverRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, driver_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        return self


class DeleteEdgeDriverResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteEdgeDriverResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: DeleteEdgeDriverResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteEdgeDriverResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEdgeDriverVersionRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, driver_id=None,
                 driver_version=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode
        self.driver_version = TeaConverter.to_unicode(driver_version)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        return self


class DeleteEdgeDriverVersionResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteEdgeDriverVersionResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: DeleteEdgeDriverVersionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteEdgeDriverVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEdgeInstanceRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, instance_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteEdgeInstanceResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteEdgeInstanceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: DeleteEdgeInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteJobRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, job_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class DeleteJobResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteJobResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: DeleteJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteOTAFirmwareRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, firmware_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.firmware_id = TeaConverter.to_unicode(firmware_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        return self


class DeleteOTAFirmwareResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteOTAFirmwareResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: DeleteOTAFirmwareResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteOTAFirmwareResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteOTAModuleRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, product_key=None,
                 module_name=None, auth_config=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.module_name = TeaConverter.to_unicode(module_name)  # type: unicode
        self.auth_config = TeaConverter.to_unicode(auth_config)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        if self.auth_config is not None:
            result['AuthConfig'] = self.auth_config
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        if m.get('AuthConfig') is not None:
            self.auth_config = m.get('AuthConfig')
        return self


class DeleteOTAModuleResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteOTAModuleResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: DeleteOTAModuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteOTAModuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteProductRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, product_key=None,
                 real_tenant_id=None, real_tripartite_key=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.real_tenant_id = TeaConverter.to_unicode(real_tenant_id)  # type: unicode
        self.real_tripartite_key = TeaConverter.to_unicode(real_tripartite_key)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        return self


class DeleteProductResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteProductResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: DeleteProductResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteProductResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteProductTagsRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, product_key=None,
                 real_tenant_id=None, real_tripartite_key=None, product_tag_key=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.real_tenant_id = TeaConverter.to_unicode(real_tenant_id)  # type: unicode
        self.real_tripartite_key = TeaConverter.to_unicode(real_tripartite_key)  # type: unicode
        self.product_tag_key = product_tag_key  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        if self.product_tag_key is not None:
            result['ProductTagKey'] = self.product_tag_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        if m.get('ProductTagKey') is not None:
            self.product_tag_key = m.get('ProductTagKey')
        return self


class DeleteProductTagsResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteProductTagsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: DeleteProductTagsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteProductTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteProductTopicRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, topic_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.topic_id = TeaConverter.to_unicode(topic_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.topic_id is not None:
            result['TopicId'] = self.topic_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('TopicId') is not None:
            self.topic_id = m.get('TopicId')
        return self


class DeleteProductTopicResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteProductTopicResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: DeleteProductTopicResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteProductTopicResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRuleRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, rule_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.rule_id = rule_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DeleteRuleResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteRuleResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: DeleteRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRuleActionRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, action_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.action_id = action_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.action_id is not None:
            result['ActionId'] = self.action_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ActionId') is not None:
            self.action_id = m.get('ActionId')
        return self


class DeleteRuleActionResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteRuleActionResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: DeleteRuleActionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteRuleActionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSceneRuleRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, rule_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.rule_id = TeaConverter.to_unicode(rule_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DeleteSceneRuleResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteSceneRuleResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: DeleteSceneRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteSceneRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSubscribeRelationRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, product_key=None, type=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.type = TeaConverter.to_unicode(type)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DeleteSubscribeRelationResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteSubscribeRelationResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: DeleteSubscribeRelationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteSubscribeRelationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteThingModelRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, resource_group_id=None,
                 product_key=None, function_block_id=None, is_clear_all_function=None, real_tenant_id=None,
                 real_tripartite_key=None, property_identifier=None, service_identifier=None, event_identifier=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.resource_group_id = TeaConverter.to_unicode(resource_group_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.function_block_id = TeaConverter.to_unicode(function_block_id)  # type: unicode
        self.is_clear_all_function = is_clear_all_function  # type: bool
        self.real_tenant_id = TeaConverter.to_unicode(real_tenant_id)  # type: unicode
        self.real_tripartite_key = TeaConverter.to_unicode(real_tripartite_key)  # type: unicode
        self.property_identifier = property_identifier  # type: list[unicode]
        self.service_identifier = service_identifier  # type: list[unicode]
        self.event_identifier = event_identifier  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        if self.is_clear_all_function is not None:
            result['IsClearAllFunction'] = self.is_clear_all_function
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        if self.property_identifier is not None:
            result['PropertyIdentifier'] = self.property_identifier
        if self.service_identifier is not None:
            result['ServiceIdentifier'] = self.service_identifier
        if self.event_identifier is not None:
            result['EventIdentifier'] = self.event_identifier
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        if m.get('IsClearAllFunction') is not None:
            self.is_clear_all_function = m.get('IsClearAllFunction')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        if m.get('PropertyIdentifier') is not None:
            self.property_identifier = m.get('PropertyIdentifier')
        if m.get('ServiceIdentifier') is not None:
            self.service_identifier = m.get('ServiceIdentifier')
        if m.get('EventIdentifier') is not None:
            self.event_identifier = m.get('EventIdentifier')
        return self


class DeleteThingModelResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteThingModelResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: DeleteThingModelResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteThingModelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTopicRouteTableRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, src_topic=None, dst_topic=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.src_topic = TeaConverter.to_unicode(src_topic)  # type: unicode
        self.dst_topic = dst_topic  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.src_topic is not None:
            result['SrcTopic'] = self.src_topic
        if self.dst_topic is not None:
            result['DstTopic'] = self.dst_topic
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('SrcTopic') is not None:
            self.src_topic = m.get('SrcTopic')
        if m.get('DstTopic') is not None:
            self.dst_topic = m.get('DstTopic')
        return self


class DeleteTopicRouteTableResponseBodyFailureTopics(TeaModel):
    def __init__(self, topic=None):
        self.topic = topic  # type: list[dict[unicode, any]]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.topic is not None:
            result['Topic'] = self.topic
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        return self


class DeleteTopicRouteTableResponseBody(TeaModel):
    def __init__(self, request_id=None, failure_topics=None, error_message=None, code=None, is_all_succeed=None,
                 success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.failure_topics = failure_topics  # type: DeleteTopicRouteTableResponseBodyFailureTopics
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.is_all_succeed = is_all_succeed  # type: bool
        self.success = success  # type: bool

    def validate(self):
        if self.failure_topics:
            self.failure_topics.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.failure_topics is not None:
            result['FailureTopics'] = self.failure_topics.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.is_all_succeed is not None:
            result['IsAllSucceed'] = self.is_all_succeed
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('FailureTopics') is not None:
            temp_model = DeleteTopicRouteTableResponseBodyFailureTopics()
            self.failure_topics = temp_model.from_map(m['FailureTopics'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('IsAllSucceed') is not None:
            self.is_all_succeed = m.get('IsAllSucceed')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteTopicRouteTableResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: DeleteTopicRouteTableResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteTopicRouteTableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableSceneRuleRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, rule_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.rule_id = TeaConverter.to_unicode(rule_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class DisableSceneRuleResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DisableSceneRuleResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: DisableSceneRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DisableSceneRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableThingRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, product_key=None,
                 device_name=None, iot_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class DisableThingResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DisableThingResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: DisableThingResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DisableThingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableSceneRuleRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, rule_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.rule_id = TeaConverter.to_unicode(rule_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class EnableSceneRuleResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class EnableSceneRuleResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: EnableSceneRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = EnableSceneRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableThingRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, product_key=None,
                 device_name=None, iot_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class EnableThingResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class EnableThingResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: EnableThingResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = EnableThingResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GenerateDeviceNameListURLRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class GenerateDeviceNameListURLResponseBodyData(TeaModel):
    def __init__(self, key=None, signature=None, host=None, file_url=None, policy=None, object_storage=None,
                 utc_create=None, access_key_id=None):
        self.key = TeaConverter.to_unicode(key)  # type: unicode
        self.signature = TeaConverter.to_unicode(signature)  # type: unicode
        self.host = TeaConverter.to_unicode(host)  # type: unicode
        self.file_url = TeaConverter.to_unicode(file_url)  # type: unicode
        self.policy = TeaConverter.to_unicode(policy)  # type: unicode
        self.object_storage = TeaConverter.to_unicode(object_storage)  # type: unicode
        self.utc_create = TeaConverter.to_unicode(utc_create)  # type: unicode
        self.access_key_id = TeaConverter.to_unicode(access_key_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.signature is not None:
            result['Signature'] = self.signature
        if self.host is not None:
            result['Host'] = self.host
        if self.file_url is not None:
            result['FileUrl'] = self.file_url
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.object_storage is not None:
            result['ObjectStorage'] = self.object_storage
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.access_key_id is not None:
            result['AccessKeyId'] = self.access_key_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Signature') is not None:
            self.signature = m.get('Signature')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('FileUrl') is not None:
            self.file_url = m.get('FileUrl')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('ObjectStorage') is not None:
            self.object_storage = m.get('ObjectStorage')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('AccessKeyId') is not None:
            self.access_key_id = m.get('AccessKeyId')
        return self


class GenerateDeviceNameListURLResponseBody(TeaModel):
    def __init__(self, request_id=None, data=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.data = data  # type: GenerateDeviceNameListURLResponseBodyData
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GenerateDeviceNameListURLResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GenerateDeviceNameListURLResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GenerateDeviceNameListURLResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GenerateDeviceNameListURLResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GenerateFileUploadURLRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, file_suffix=None, biz_code=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.file_suffix = TeaConverter.to_unicode(file_suffix)  # type: unicode
        self.biz_code = TeaConverter.to_unicode(biz_code)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.file_suffix is not None:
            result['FileSuffix'] = self.file_suffix
        if self.biz_code is not None:
            result['BizCode'] = self.biz_code
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FileSuffix') is not None:
            self.file_suffix = m.get('FileSuffix')
        if m.get('BizCode') is not None:
            self.biz_code = m.get('BizCode')
        return self


class GenerateFileUploadURLResponseBodyData(TeaModel):
    def __init__(self, key=None, oss_access_key_id=None, signature=None, host=None, policy=None, object_storage=None):
        self.key = TeaConverter.to_unicode(key)  # type: unicode
        self.oss_access_key_id = TeaConverter.to_unicode(oss_access_key_id)  # type: unicode
        self.signature = TeaConverter.to_unicode(signature)  # type: unicode
        self.host = TeaConverter.to_unicode(host)  # type: unicode
        self.policy = TeaConverter.to_unicode(policy)  # type: unicode
        self.object_storage = TeaConverter.to_unicode(object_storage)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.oss_access_key_id is not None:
            result['OssAccessKeyId'] = self.oss_access_key_id
        if self.signature is not None:
            result['Signature'] = self.signature
        if self.host is not None:
            result['Host'] = self.host
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.object_storage is not None:
            result['ObjectStorage'] = self.object_storage
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('OssAccessKeyId') is not None:
            self.oss_access_key_id = m.get('OssAccessKeyId')
        if m.get('Signature') is not None:
            self.signature = m.get('Signature')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('ObjectStorage') is not None:
            self.object_storage = m.get('ObjectStorage')
        return self


class GenerateFileUploadURLResponseBody(TeaModel):
    def __init__(self, request_id=None, data=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.data = data  # type: GenerateFileUploadURLResponseBodyData
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GenerateFileUploadURLResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GenerateFileUploadURLResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GenerateFileUploadURLResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GenerateFileUploadURLResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GenerateOTAUploadURLRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, file_suffix=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.file_suffix = TeaConverter.to_unicode(file_suffix)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.file_suffix is not None:
            result['FileSuffix'] = self.file_suffix
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FileSuffix') is not None:
            self.file_suffix = m.get('FileSuffix')
        return self


class GenerateOTAUploadURLResponseBodyData(TeaModel):
    def __init__(self, key=None, ossaccess_key_id=None, signature=None, host=None, policy=None, object_storage=None,
                 firmware_url=None, utc_create=None):
        self.key = TeaConverter.to_unicode(key)  # type: unicode
        self.ossaccess_key_id = TeaConverter.to_unicode(ossaccess_key_id)  # type: unicode
        self.signature = TeaConverter.to_unicode(signature)  # type: unicode
        self.host = TeaConverter.to_unicode(host)  # type: unicode
        self.policy = TeaConverter.to_unicode(policy)  # type: unicode
        self.object_storage = TeaConverter.to_unicode(object_storage)  # type: unicode
        self.firmware_url = TeaConverter.to_unicode(firmware_url)  # type: unicode
        self.utc_create = TeaConverter.to_unicode(utc_create)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.ossaccess_key_id is not None:
            result['OSSAccessKeyId'] = self.ossaccess_key_id
        if self.signature is not None:
            result['Signature'] = self.signature
        if self.host is not None:
            result['Host'] = self.host
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.object_storage is not None:
            result['ObjectStorage'] = self.object_storage
        if self.firmware_url is not None:
            result['FirmwareUrl'] = self.firmware_url
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('OSSAccessKeyId') is not None:
            self.ossaccess_key_id = m.get('OSSAccessKeyId')
        if m.get('Signature') is not None:
            self.signature = m.get('Signature')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('ObjectStorage') is not None:
            self.object_storage = m.get('ObjectStorage')
        if m.get('FirmwareUrl') is not None:
            self.firmware_url = m.get('FirmwareUrl')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class GenerateOTAUploadURLResponseBody(TeaModel):
    def __init__(self, request_id=None, data=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.data = data  # type: GenerateOTAUploadURLResponseBodyData
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GenerateOTAUploadURLResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GenerateOTAUploadURLResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GenerateOTAUploadURLResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GenerateOTAUploadURLResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDataAPIServiceDetailRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, api_srn=None, iot_instance_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.api_srn = TeaConverter.to_unicode(api_srn)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.api_srn is not None:
            result['ApiSrn'] = self.api_srn
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('ApiSrn') is not None:
            self.api_srn = m.get('ApiSrn')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        return self


class GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTORequestParamsRequestParams(TeaModel):
    def __init__(self, type=None, required=None, example=None, name=None, desc=None):
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.required = required  # type: bool
        self.example = TeaConverter.to_unicode(example)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.desc = TeaConverter.to_unicode(desc)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.required is not None:
            result['Required'] = self.required
        if self.example is not None:
            result['Example'] = self.example
        if self.name is not None:
            result['Name'] = self.name
        if self.desc is not None:
            result['Desc'] = self.desc
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Required') is not None:
            self.required = m.get('Required')
        if m.get('Example') is not None:
            self.example = m.get('Example')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        return self


class GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTORequestParams(TeaModel):
    def __init__(self, request_params=None):
        self.request_params = request_params  # type: list[GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTORequestParamsRequestParams]

    def validate(self):
        if self.request_params:
            for k in self.request_params:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['RequestParams'] = []
        if self.request_params is not None:
            for k in self.request_params:
                result['RequestParams'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.request_params = []
        if m.get('RequestParams') is not None:
            for k in m.get('RequestParams'):
                temp_model = GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTORequestParamsRequestParams()
                self.request_params.append(temp_model.from_map(k))
        return self


class GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTOResponseParamsResponseParams(TeaModel):
    def __init__(self, type=None, required=None, example=None, name=None, desc=None):
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.required = required  # type: bool
        self.example = TeaConverter.to_unicode(example)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.desc = TeaConverter.to_unicode(desc)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.required is not None:
            result['Required'] = self.required
        if self.example is not None:
            result['Example'] = self.example
        if self.name is not None:
            result['Name'] = self.name
        if self.desc is not None:
            result['Desc'] = self.desc
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Required') is not None:
            self.required = m.get('Required')
        if m.get('Example') is not None:
            self.example = m.get('Example')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        return self


class GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTOResponseParams(TeaModel):
    def __init__(self, response_params=None):
        self.response_params = response_params  # type: list[GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTOResponseParamsResponseParams]

    def validate(self):
        if self.response_params:
            for k in self.response_params:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['ResponseParams'] = []
        if self.response_params is not None:
            for k in self.response_params:
                result['ResponseParams'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.response_params = []
        if m.get('ResponseParams') is not None:
            for k in m.get('ResponseParams'):
                temp_model = GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTOResponseParamsResponseParams()
                self.response_params.append(temp_model.from_map(k))
        return self


class GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTO(TeaModel):
    def __init__(self, request_params=None, origin_sql=None, response_params=None, template_sql=None):
        self.request_params = request_params  # type: GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTORequestParams
        self.origin_sql = TeaConverter.to_unicode(origin_sql)  # type: unicode
        self.response_params = response_params  # type: GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTOResponseParams
        self.template_sql = TeaConverter.to_unicode(template_sql)  # type: unicode

    def validate(self):
        if self.request_params:
            self.request_params.validate()
        if self.response_params:
            self.response_params.validate()

    def to_map(self):
        result = dict()
        if self.request_params is not None:
            result['RequestParams'] = self.request_params.to_map()
        if self.origin_sql is not None:
            result['OriginSql'] = self.origin_sql
        if self.response_params is not None:
            result['ResponseParams'] = self.response_params.to_map()
        if self.template_sql is not None:
            result['TemplateSql'] = self.template_sql
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestParams') is not None:
            temp_model = GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTORequestParams()
            self.request_params = temp_model.from_map(m['RequestParams'])
        if m.get('OriginSql') is not None:
            self.origin_sql = m.get('OriginSql')
        if m.get('ResponseParams') is not None:
            temp_model = GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTOResponseParams()
            self.response_params = temp_model.from_map(m['ResponseParams'])
        if m.get('TemplateSql') is not None:
            self.template_sql = m.get('TemplateSql')
        return self


class GetDataAPIServiceDetailResponseBodyData(TeaModel):
    def __init__(self, display_name=None, status=None, api_srn=None, sql_template_dto=None, description=None,
                 create_time=None, last_update_time=None, request_method=None, date_format=None, request_protocol=None,
                 api_path=None):
        self.display_name = TeaConverter.to_unicode(display_name)  # type: unicode
        self.status = status  # type: int
        self.api_srn = TeaConverter.to_unicode(api_srn)  # type: unicode
        self.sql_template_dto = sql_template_dto  # type: GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTO
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.create_time = create_time  # type: long
        self.last_update_time = last_update_time  # type: long
        self.request_method = TeaConverter.to_unicode(request_method)  # type: unicode
        self.date_format = TeaConverter.to_unicode(date_format)  # type: unicode
        self.request_protocol = TeaConverter.to_unicode(request_protocol)  # type: unicode
        self.api_path = TeaConverter.to_unicode(api_path)  # type: unicode

    def validate(self):
        if self.sql_template_dto:
            self.sql_template_dto.validate()

    def to_map(self):
        result = dict()
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.status is not None:
            result['Status'] = self.status
        if self.api_srn is not None:
            result['ApiSrn'] = self.api_srn
        if self.sql_template_dto is not None:
            result['SqlTemplateDTO'] = self.sql_template_dto.to_map()
        if self.description is not None:
            result['Description'] = self.description
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.last_update_time is not None:
            result['LastUpdateTime'] = self.last_update_time
        if self.request_method is not None:
            result['RequestMethod'] = self.request_method
        if self.date_format is not None:
            result['DateFormat'] = self.date_format
        if self.request_protocol is not None:
            result['RequestProtocol'] = self.request_protocol
        if self.api_path is not None:
            result['ApiPath'] = self.api_path
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ApiSrn') is not None:
            self.api_srn = m.get('ApiSrn')
        if m.get('SqlTemplateDTO') is not None:
            temp_model = GetDataAPIServiceDetailResponseBodyDataSqlTemplateDTO()
            self.sql_template_dto = temp_model.from_map(m['SqlTemplateDTO'])
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('LastUpdateTime') is not None:
            self.last_update_time = m.get('LastUpdateTime')
        if m.get('RequestMethod') is not None:
            self.request_method = m.get('RequestMethod')
        if m.get('DateFormat') is not None:
            self.date_format = m.get('DateFormat')
        if m.get('RequestProtocol') is not None:
            self.request_protocol = m.get('RequestProtocol')
        if m.get('ApiPath') is not None:
            self.api_path = m.get('ApiPath')
        return self


class GetDataAPIServiceDetailResponseBody(TeaModel):
    def __init__(self, request_id=None, data=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.data = data  # type: GetDataAPIServiceDetailResponseBodyData
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetDataAPIServiceDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDataAPIServiceDetailResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetDataAPIServiceDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDataAPIServiceDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDeviceShadowRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, product_key=None,
                 device_name=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class GetDeviceShadowResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, shadow_message=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.shadow_message = TeaConverter.to_unicode(shadow_message)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.shadow_message is not None:
            result['ShadowMessage'] = self.shadow_message
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ShadowMessage') is not None:
            self.shadow_message = m.get('ShadowMessage')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDeviceShadowResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetDeviceShadowResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDeviceShadowResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDeviceStatusRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, product_key=None,
                 device_name=None, iot_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class GetDeviceStatusResponseBodyData(TeaModel):
    def __init__(self, status=None):
        self.status = TeaConverter.to_unicode(status)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class GetDeviceStatusResponseBody(TeaModel):
    def __init__(self, request_id=None, data=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.data = data  # type: GetDeviceStatusResponseBodyData
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetDeviceStatusResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDeviceStatusResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetDeviceStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetDeviceStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetEdgeDriverVersionRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, driver_id=None,
                 driver_version=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode
        self.driver_version = TeaConverter.to_unicode(driver_version)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        return self


class GetEdgeDriverVersionResponseBodyData(TeaModel):
    def __init__(self, gmt_create_timestamp=None, config_check_rule=None, edge_version=None, driver_id=None,
                 gmt_modified_timestamp=None, version_state=None, container_config=None, description=None, driver_config=None,
                 argument=None, driver_version=None, source_config=None):
        self.gmt_create_timestamp = gmt_create_timestamp  # type: long
        self.config_check_rule = TeaConverter.to_unicode(config_check_rule)  # type: unicode
        self.edge_version = TeaConverter.to_unicode(edge_version)  # type: unicode
        self.driver_id = TeaConverter.to_unicode(driver_id)  # type: unicode
        self.gmt_modified_timestamp = gmt_modified_timestamp  # type: long
        self.version_state = TeaConverter.to_unicode(version_state)  # type: unicode
        self.container_config = TeaConverter.to_unicode(container_config)  # type: unicode
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.driver_config = TeaConverter.to_unicode(driver_config)  # type: unicode
        self.argument = TeaConverter.to_unicode(argument)  # type: unicode
        self.driver_version = TeaConverter.to_unicode(driver_version)  # type: unicode
        self.source_config = TeaConverter.to_unicode(source_config)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.config_check_rule is not None:
            result['ConfigCheckRule'] = self.config_check_rule
        if self.edge_version is not None:
            result['EdgeVersion'] = self.edge_version
        if self.driver_id is not None:
            result['DriverId'] = self.driver_id
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.version_state is not None:
            result['VersionState'] = self.version_state
        if self.container_config is not None:
            result['ContainerConfig'] = self.container_config
        if self.description is not None:
            result['Description'] = self.description
        if self.driver_config is not None:
            result['DriverConfig'] = self.driver_config
        if self.argument is not None:
            result['Argument'] = self.argument
        if self.driver_version is not None:
            result['DriverVersion'] = self.driver_version
        if self.source_config is not None:
            result['SourceConfig'] = self.source_config
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('ConfigCheckRule') is not None:
            self.config_check_rule = m.get('ConfigCheckRule')
        if m.get('EdgeVersion') is not None:
            self.edge_version = m.get('EdgeVersion')
        if m.get('DriverId') is not None:
            self.driver_id = m.get('DriverId')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('VersionState') is not None:
            self.version_state = m.get('VersionState')
        if m.get('ContainerConfig') is not None:
            self.container_config = m.get('ContainerConfig')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DriverConfig') is not None:
            self.driver_config = m.get('DriverConfig')
        if m.get('Argument') is not None:
            self.argument = m.get('Argument')
        if m.get('DriverVersion') is not None:
            self.driver_version = m.get('DriverVersion')
        if m.get('SourceConfig') is not None:
            self.source_config = m.get('SourceConfig')
        return self


class GetEdgeDriverVersionResponseBody(TeaModel):
    def __init__(self, request_id=None, data=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.data = data  # type: GetEdgeDriverVersionResponseBodyData
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetEdgeDriverVersionResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetEdgeDriverVersionResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetEdgeDriverVersionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetEdgeDriverVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetEdgeInstanceRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, instance_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetEdgeInstanceResponseBodyData(TeaModel):
    def __init__(self, type=None, gmt_create_timestamp=None, role_arn=None, role_attach_time=None, spec=None,
                 gmt_modified_timestamp=None, tags=None, role_name=None, instance_id=None, gmt_modified=None, role_attach_timestamp=None,
                 latest_deployment_type=None, latest_deployment_status=None, biz_enable=None, gmt_create=None, name=None):
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.gmt_create_timestamp = gmt_create_timestamp  # type: long
        self.role_arn = TeaConverter.to_unicode(role_arn)  # type: unicode
        self.role_attach_time = TeaConverter.to_unicode(role_attach_time)  # type: unicode
        self.spec = spec  # type: int
        self.gmt_modified_timestamp = gmt_modified_timestamp  # type: long
        self.tags = TeaConverter.to_unicode(tags)  # type: unicode
        self.role_name = TeaConverter.to_unicode(role_name)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.gmt_modified = TeaConverter.to_unicode(gmt_modified)  # type: unicode
        self.role_attach_timestamp = role_attach_timestamp  # type: long
        self.latest_deployment_type = TeaConverter.to_unicode(latest_deployment_type)  # type: unicode
        self.latest_deployment_status = latest_deployment_status  # type: int
        self.biz_enable = biz_enable  # type: bool
        self.gmt_create = TeaConverter.to_unicode(gmt_create)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.role_arn is not None:
            result['RoleArn'] = self.role_arn
        if self.role_attach_time is not None:
            result['RoleAttachTime'] = self.role_attach_time
        if self.spec is not None:
            result['Spec'] = self.spec
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.role_name is not None:
            result['RoleName'] = self.role_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.role_attach_timestamp is not None:
            result['RoleAttachTimestamp'] = self.role_attach_timestamp
        if self.latest_deployment_type is not None:
            result['LatestDeploymentType'] = self.latest_deployment_type
        if self.latest_deployment_status is not None:
            result['LatestDeploymentStatus'] = self.latest_deployment_status
        if self.biz_enable is not None:
            result['BizEnable'] = self.biz_enable
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('RoleArn') is not None:
            self.role_arn = m.get('RoleArn')
        if m.get('RoleAttachTime') is not None:
            self.role_attach_time = m.get('RoleAttachTime')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('RoleName') is not None:
            self.role_name = m.get('RoleName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('RoleAttachTimestamp') is not None:
            self.role_attach_timestamp = m.get('RoleAttachTimestamp')
        if m.get('LatestDeploymentType') is not None:
            self.latest_deployment_type = m.get('LatestDeploymentType')
        if m.get('LatestDeploymentStatus') is not None:
            self.latest_deployment_status = m.get('LatestDeploymentStatus')
        if m.get('BizEnable') is not None:
            self.biz_enable = m.get('BizEnable')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class GetEdgeInstanceResponseBody(TeaModel):
    def __init__(self, request_id=None, data=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.data = data  # type: GetEdgeInstanceResponseBodyData
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetEdgeInstanceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetEdgeInstanceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetEdgeInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetEdgeInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetEdgeInstanceDeploymentRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, instance_id=None,
                 deployment_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.instance_id = TeaConverter.to_unicode(instance_id)  # type: unicode
        self.deployment_id = TeaConverter.to_unicode(deployment_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.deployment_id is not None:
            result['DeploymentId'] = self.deployment_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('DeploymentId') is not None:
            self.deployment_id = m.get('DeploymentId')
        return self


class GetEdgeInstanceDeploymentResponseBodyDataTaskListResourceSnapshotList(TeaModel):
    def __init__(self, gmt_create_timestamp=None, status=None, stage=None, gmt_modified_timestamp=None, log=None,
                 gmt_modified=None, operate_type=None, resource_type=None, snapshot_id=None, gmt_completed=None, gmt_create=None,
                 gmt_completed_timestamp=None, resource_id=None, resource_name=None):
        self.gmt_create_timestamp = gmt_create_timestamp  # type: long
        self.status = status  # type: int
        self.stage = stage  # type: int
        self.gmt_modified_timestamp = gmt_modified_timestamp  # type: long
        self.log = TeaConverter.to_unicode(log)  # type: unicode
        self.gmt_modified = TeaConverter.to_unicode(gmt_modified)  # type: unicode
        self.operate_type = operate_type  # type: int
        self.resource_type = TeaConverter.to_unicode(resource_type)  # type: unicode
        self.snapshot_id = TeaConverter.to_unicode(snapshot_id)  # type: unicode
        self.gmt_completed = TeaConverter.to_unicode(gmt_completed)  # type: unicode
        self.gmt_create = TeaConverter.to_unicode(gmt_create)  # type: unicode
        self.gmt_completed_timestamp = gmt_completed_timestamp  # type: long
        self.resource_id = TeaConverter.to_unicode(resource_id)  # type: unicode
        self.resource_name = TeaConverter.to_unicode(resource_name)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.status is not None:
            result['Status'] = self.status
        if self.stage is not None:
            result['Stage'] = self.stage
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.log is not None:
            result['Log'] = self.log
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.operate_type is not None:
            result['OperateType'] = self.operate_type
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.gmt_completed is not None:
            result['GmtCompleted'] = self.gmt_completed
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_completed_timestamp is not None:
            result['GmtCompletedTimestamp'] = self.gmt_completed_timestamp
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_name is not None:
            result['ResourceName'] = self.resource_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Stage') is not None:
            self.stage = m.get('Stage')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('Log') is not None:
            self.log = m.get('Log')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('OperateType') is not None:
            self.operate_type = m.get('OperateType')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        if m.get('GmtCompleted') is not None:
            self.gmt_completed = m.get('GmtCompleted')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtCompletedTimestamp') is not None:
            self.gmt_completed_timestamp = m.get('GmtCompletedTimestamp')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceName') is not None:
            self.resource_name = m.get('ResourceName')
        return self


class GetEdgeInstanceDeploymentResponseBodyDataTaskList(TeaModel):
    def __init__(self, gmt_create_timestamp=None, status=None, resource_snapshot_list=None, stage=None,
                 gateway_id=None, gmt_modified_timestamp=None, gmt_completed=None, gmt_create=None,
                 gmt_completed_timestamp=None, gmt_modified=None, task_id=None):
        self.gmt_create_timestamp = gmt_create_timestamp  # type: long
        self.status = status  # type: int
        self.resource_snapshot_list = resource_snapshot_list  # type: list[GetEdgeInstanceDeploymentResponseBodyDataTaskListResourceSnapshotList]
        self.stage = stage  # type: int
        self.gateway_id = TeaConverter.to_unicode(gateway_id)  # type: unicode
        self.gmt_modified_timestamp = gmt_modified_timestamp  # type: long
        self.gmt_completed = TeaConverter.to_unicode(gmt_completed)  # type: unicode
        self.gmt_create = TeaConverter.to_unicode(gmt_create)  # type: unicode
        self.gmt_completed_timestamp = gmt_completed_timestamp  # type: long
        self.gmt_modified = TeaConverter.to_unicode(gmt_modified)  # type: unicode
        self.task_id = TeaConverter.to_unicode(task_id)  # type: unicode

    def validate(self):
        if self.resource_snapshot_list:
            for k in self.resource_snapshot_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.status is not None:
            result['Status'] = self.status
        result['ResourceSnapshotList'] = []
        if self.resource_snapshot_list is not None:
            for k in self.resource_snapshot_list:
                result['ResourceSnapshotList'].append(k.to_map() if k else None)
        if self.stage is not None:
            result['Stage'] = self.stage
        if self.gateway_id is not None:
            result['GatewayId'] = self.gateway_id
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        if self.gmt_completed is not None:
            result['GmtCompleted'] = self.gmt_completed
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_completed_timestamp is not None:
            result['GmtCompletedTimestamp'] = self.gmt_completed_timestamp
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        self.resource_snapshot_list = []
        if m.get('ResourceSnapshotList') is not None:
            for k in m.get('ResourceSnapshotList'):
                temp_model = GetEdgeInstanceDeploymentResponseBodyDataTaskListResourceSnapshotList()
                self.resource_snapshot_list.append(temp_model.from_map(k))
        if m.get('Stage') is not None:
            self.stage = m.get('Stage')
        if m.get('GatewayId') is not None:
            self.gateway_id = m.get('GatewayId')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        if m.get('GmtCompleted') is not None:
            self.gmt_completed = m.get('GmtCompleted')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtCompletedTimestamp') is not None:
            self.gmt_completed_timestamp = m.get('GmtCompletedTimestamp')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetEdgeInstanceDeploymentResponseBodyData(TeaModel):
    def __init__(self, gmt_create_timestamp=None, type=None, status=None, deployment_id=None, description=None,
                 gmt_modified_timestamp=None, task_list=None, gmt_completed=None, gmt_create=None, gmt_completed_timestamp=None,
                 gmt_modified=None):
        self.gmt_create_timestamp = gmt_create_timestamp  # type: long
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.status = status  # type: int
        self.deployment_id = TeaConverter.to_unicode(deployment_id)  # type: unicode
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.gmt_modified_timestamp = gmt_modified_timestamp  # type: long
        self.task_list = task_list  # type: list[GetEdgeInstanceDeploymentResponseBodyDataTaskList]
        self.gmt_completed = TeaConverter.to_unicode(gmt_completed)  # type: unicode
        self.gmt_create = TeaConverter.to_unicode(gmt_create)  # type: unicode
        self.gmt_completed_timestamp = gmt_completed_timestamp  # type: long
        self.gmt_modified = TeaConverter.to_unicode(gmt_modified)  # type: unicode

    def validate(self):
        if self.task_list:
            for k in self.task_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.gmt_create_timestamp is not None:
            result['GmtCreateTimestamp'] = self.gmt_create_timestamp
        if self.type is not None:
            result['Type'] = self.type
        if self.status is not None:
            result['Status'] = self.status
        if self.deployment_id is not None:
            result['DeploymentId'] = self.deployment_id
        if self.description is not None:
            result['Description'] = self.description
        if self.gmt_modified_timestamp is not None:
            result['GmtModifiedTimestamp'] = self.gmt_modified_timestamp
        result['TaskList'] = []
        if self.task_list is not None:
            for k in self.task_list:
                result['TaskList'].append(k.to_map() if k else None)
        if self.gmt_completed is not None:
            result['GmtCompleted'] = self.gmt_completed
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_completed_timestamp is not None:
            result['GmtCompletedTimestamp'] = self.gmt_completed_timestamp
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GmtCreateTimestamp') is not None:
            self.gmt_create_timestamp = m.get('GmtCreateTimestamp')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('DeploymentId') is not None:
            self.deployment_id = m.get('DeploymentId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GmtModifiedTimestamp') is not None:
            self.gmt_modified_timestamp = m.get('GmtModifiedTimestamp')
        self.task_list = []
        if m.get('TaskList') is not None:
            for k in m.get('TaskList'):
                temp_model = GetEdgeInstanceDeploymentResponseBodyDataTaskList()
                self.task_list.append(temp_model.from_map(k))
        if m.get('GmtCompleted') is not None:
            self.gmt_completed = m.get('GmtCompleted')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtCompletedTimestamp') is not None:
            self.gmt_completed_timestamp = m.get('GmtCompletedTimestamp')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        return self


class GetEdgeInstanceDeploymentResponseBody(TeaModel):
    def __init__(self, request_id=None, data=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.data = data  # type: GetEdgeInstanceDeploymentResponseBodyData
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetEdgeInstanceDeploymentResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetEdgeInstanceDeploymentResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetEdgeInstanceDeploymentResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetEdgeInstanceDeploymentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetGatewayBySubDeviceRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, product_key=None,
                 device_name=None, iot_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class GetGatewayBySubDeviceResponseBodyData(TeaModel):
    def __init__(self, status=None, utc_active=None, product_name=None, device_name=None, utc_create=None,
                 firmware_version=None, gmt_online=None, region=None, iot_id=None, utc_online=None, product_key=None, ip_address=None,
                 node_type=None, device_secret=None, gmt_create=None, gmt_active=None):
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.utc_active = TeaConverter.to_unicode(utc_active)  # type: unicode
        self.product_name = TeaConverter.to_unicode(product_name)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.utc_create = TeaConverter.to_unicode(utc_create)  # type: unicode
        self.firmware_version = TeaConverter.to_unicode(firmware_version)  # type: unicode
        self.gmt_online = TeaConverter.to_unicode(gmt_online)  # type: unicode
        self.region = TeaConverter.to_unicode(region)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.utc_online = TeaConverter.to_unicode(utc_online)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.ip_address = TeaConverter.to_unicode(ip_address)  # type: unicode
        self.node_type = TeaConverter.to_unicode(node_type)  # type: unicode
        self.device_secret = TeaConverter.to_unicode(device_secret)  # type: unicode
        self.gmt_create = TeaConverter.to_unicode(gmt_create)  # type: unicode
        self.gmt_active = TeaConverter.to_unicode(gmt_active)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.utc_active is not None:
            result['UtcActive'] = self.utc_active
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.firmware_version is not None:
            result['FirmwareVersion'] = self.firmware_version
        if self.gmt_online is not None:
            result['GmtOnline'] = self.gmt_online
        if self.region is not None:
            result['region'] = self.region
        if self.iot_id is not None:
            result['iotId'] = self.iot_id
        if self.utc_online is not None:
            result['UtcOnline'] = self.utc_online
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.ip_address is not None:
            result['IpAddress'] = self.ip_address
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.device_secret is not None:
            result['DeviceSecret'] = self.device_secret
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_active is not None:
            result['GmtActive'] = self.gmt_active
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UtcActive') is not None:
            self.utc_active = m.get('UtcActive')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('FirmwareVersion') is not None:
            self.firmware_version = m.get('FirmwareVersion')
        if m.get('GmtOnline') is not None:
            self.gmt_online = m.get('GmtOnline')
        if m.get('region') is not None:
            self.region = m.get('region')
        if m.get('iotId') is not None:
            self.iot_id = m.get('iotId')
        if m.get('UtcOnline') is not None:
            self.utc_online = m.get('UtcOnline')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('IpAddress') is not None:
            self.ip_address = m.get('IpAddress')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('DeviceSecret') is not None:
            self.device_secret = m.get('DeviceSecret')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtActive') is not None:
            self.gmt_active = m.get('GmtActive')
        return self


class GetGatewayBySubDeviceResponseBody(TeaModel):
    def __init__(self, request_id=None, data=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.data = data  # type: GetGatewayBySubDeviceResponseBodyData
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetGatewayBySubDeviceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetGatewayBySubDeviceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetGatewayBySubDeviceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetGatewayBySubDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetLoraNodesTaskRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, task_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.task_id = TeaConverter.to_unicode(task_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetLoraNodesTaskResponseBodySuccessDevEuis(TeaModel):
    def __init__(self, success_dev_eui=None):
        self.success_dev_eui = success_dev_eui  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.success_dev_eui is not None:
            result['SuccessDevEui'] = self.success_dev_eui
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SuccessDevEui') is not None:
            self.success_dev_eui = m.get('SuccessDevEui')
        return self


class GetLoraNodesTaskResponseBody(TeaModel):
    def __init__(self, total_count=None, success_dev_euis=None, task_id=None, request_id=None, error_message=None,
                 success_count=None, task_state=None, code=None, success=None):
        self.total_count = total_count  # type: long
        self.success_dev_euis = success_dev_euis  # type: GetLoraNodesTaskResponseBodySuccessDevEuis
        self.task_id = TeaConverter.to_unicode(task_id)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.success_count = success_count  # type: long
        self.task_state = TeaConverter.to_unicode(task_state)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.success_dev_euis:
            self.success_dev_euis.validate()

    def to_map(self):
        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.success_dev_euis is not None:
            result['SuccessDevEuis'] = self.success_dev_euis.to_map()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.success_count is not None:
            result['SuccessCount'] = self.success_count
        if self.task_state is not None:
            result['TaskState'] = self.task_state
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('SuccessDevEuis') is not None:
            temp_model = GetLoraNodesTaskResponseBodySuccessDevEuis()
            self.success_dev_euis = temp_model.from_map(m['SuccessDevEuis'])
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('SuccessCount') is not None:
            self.success_count = m.get('SuccessCount')
        if m.get('TaskState') is not None:
            self.task_state = m.get('TaskState')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetLoraNodesTaskResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetLoraNodesTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetLoraNodesTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetNodesAddingTaskRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, task_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.task_id = TeaConverter.to_unicode(task_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetNodesAddingTaskResponseBodySuccessDevEuis(TeaModel):
    def __init__(self, success_dev_eui=None):
        self.success_dev_eui = success_dev_eui  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.success_dev_eui is not None:
            result['SuccessDevEui'] = self.success_dev_eui
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SuccessDevEui') is not None:
            self.success_dev_eui = m.get('SuccessDevEui')
        return self


class GetNodesAddingTaskResponseBody(TeaModel):
    def __init__(self, total_count=None, success_dev_euis=None, task_id=None, request_id=None, error_message=None,
                 success_count=None, task_state=None, code=None, success=None):
        self.total_count = total_count  # type: long
        self.success_dev_euis = success_dev_euis  # type: GetNodesAddingTaskResponseBodySuccessDevEuis
        self.task_id = TeaConverter.to_unicode(task_id)  # type: unicode
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.success_count = success_count  # type: long
        self.task_state = TeaConverter.to_unicode(task_state)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.success_dev_euis:
            self.success_dev_euis.validate()

    def to_map(self):
        result = dict()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.success_dev_euis is not None:
            result['SuccessDevEuis'] = self.success_dev_euis.to_map()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.success_count is not None:
            result['SuccessCount'] = self.success_count
        if self.task_state is not None:
            result['TaskState'] = self.task_state
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('SuccessDevEuis') is not None:
            temp_model = GetNodesAddingTaskResponseBodySuccessDevEuis()
            self.success_dev_euis = temp_model.from_map(m['SuccessDevEuis'])
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('SuccessCount') is not None:
            self.success_count = m.get('SuccessCount')
        if m.get('TaskState') is not None:
            self.task_state = m.get('TaskState')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetNodesAddingTaskResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetNodesAddingTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetNodesAddingTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRuleRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, rule_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.rule_id = rule_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class GetRuleResponseBodyRuleInfo(TeaModel):
    def __init__(self, status=None, modified=None, data_type=None, select=None, utc_created=None,
                 create_user_id=None, topic_type=None, where=None, product_key=None, utc_modified=None, topic=None,
                 short_topic=None, rule_desc=None, name=None, created=None, id=None):
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.modified = TeaConverter.to_unicode(modified)  # type: unicode
        self.data_type = TeaConverter.to_unicode(data_type)  # type: unicode
        self.select = TeaConverter.to_unicode(select)  # type: unicode
        self.utc_created = TeaConverter.to_unicode(utc_created)  # type: unicode
        self.create_user_id = create_user_id  # type: long
        self.topic_type = topic_type  # type: int
        self.where = TeaConverter.to_unicode(where)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.utc_modified = TeaConverter.to_unicode(utc_modified)  # type: unicode
        self.topic = TeaConverter.to_unicode(topic)  # type: unicode
        self.short_topic = TeaConverter.to_unicode(short_topic)  # type: unicode
        self.rule_desc = TeaConverter.to_unicode(rule_desc)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.created = TeaConverter.to_unicode(created)  # type: unicode
        self.id = id  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.modified is not None:
            result['Modified'] = self.modified
        if self.data_type is not None:
            result['DataType'] = self.data_type
        if self.select is not None:
            result['Select'] = self.select
        if self.utc_created is not None:
            result['UtcCreated'] = self.utc_created
        if self.create_user_id is not None:
            result['CreateUserId'] = self.create_user_id
        if self.topic_type is not None:
            result['TopicType'] = self.topic_type
        if self.where is not None:
            result['Where'] = self.where
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.topic is not None:
            result['Topic'] = self.topic
        if self.short_topic is not None:
            result['ShortTopic'] = self.short_topic
        if self.rule_desc is not None:
            result['RuleDesc'] = self.rule_desc
        if self.name is not None:
            result['Name'] = self.name
        if self.created is not None:
            result['Created'] = self.created
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Modified') is not None:
            self.modified = m.get('Modified')
        if m.get('DataType') is not None:
            self.data_type = m.get('DataType')
        if m.get('Select') is not None:
            self.select = m.get('Select')
        if m.get('UtcCreated') is not None:
            self.utc_created = m.get('UtcCreated')
        if m.get('CreateUserId') is not None:
            self.create_user_id = m.get('CreateUserId')
        if m.get('TopicType') is not None:
            self.topic_type = m.get('TopicType')
        if m.get('Where') is not None:
            self.where = m.get('Where')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        if m.get('ShortTopic') is not None:
            self.short_topic = m.get('ShortTopic')
        if m.get('RuleDesc') is not None:
            self.rule_desc = m.get('RuleDesc')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Created') is not None:
            self.created = m.get('Created')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class GetRuleResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, rule_info=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.rule_info = rule_info  # type: GetRuleResponseBodyRuleInfo
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.rule_info:
            self.rule_info.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.rule_info is not None:
            result['RuleInfo'] = self.rule_info.to_map()
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RuleInfo') is not None:
            temp_model = GetRuleResponseBodyRuleInfo()
            self.rule_info = temp_model.from_map(m['RuleInfo'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetRuleResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRuleActionRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, action_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.action_id = action_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.action_id is not None:
            result['ActionId'] = self.action_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ActionId') is not None:
            self.action_id = m.get('ActionId')
        return self


class GetRuleActionResponseBodyRuleActionInfo(TeaModel):
    def __init__(self, type=None, configuration=None, error_action_flag=None, id=None, rule_id=None):
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.configuration = TeaConverter.to_unicode(configuration)  # type: unicode
        self.error_action_flag = error_action_flag  # type: bool
        self.id = id  # type: long
        self.rule_id = rule_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.configuration is not None:
            result['Configuration'] = self.configuration
        if self.error_action_flag is not None:
            result['ErrorActionFlag'] = self.error_action_flag
        if self.id is not None:
            result['Id'] = self.id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Configuration') is not None:
            self.configuration = m.get('Configuration')
        if m.get('ErrorActionFlag') is not None:
            self.error_action_flag = m.get('ErrorActionFlag')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class GetRuleActionResponseBody(TeaModel):
    def __init__(self, request_id=None, rule_action_info=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.rule_action_info = rule_action_info  # type: GetRuleActionResponseBodyRuleActionInfo
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.rule_action_info:
            self.rule_action_info.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.rule_action_info is not None:
            result['RuleActionInfo'] = self.rule_action_info.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RuleActionInfo') is not None:
            temp_model = GetRuleActionResponseBodyRuleActionInfo()
            self.rule_action_info = temp_model.from_map(m['RuleActionInfo'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetRuleActionResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetRuleActionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetRuleActionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSceneRuleRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, rule_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.rule_id = TeaConverter.to_unicode(rule_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class GetSceneRuleResponseBodyData(TeaModel):
    def __init__(self, rule_status=None, rule_content=None, gmt_create=None, gmt_modified=None,
                 rule_description=None, rule_name=None):
        self.rule_status = rule_status  # type: int
        self.rule_content = TeaConverter.to_unicode(rule_content)  # type: unicode
        self.gmt_create = gmt_create  # type: long
        self.gmt_modified = gmt_modified  # type: long
        self.rule_description = TeaConverter.to_unicode(rule_description)  # type: unicode
        self.rule_name = TeaConverter.to_unicode(rule_name)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.rule_status is not None:
            result['RuleStatus'] = self.rule_status
        if self.rule_content is not None:
            result['RuleContent'] = self.rule_content
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.rule_description is not None:
            result['RuleDescription'] = self.rule_description
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RuleStatus') is not None:
            self.rule_status = m.get('RuleStatus')
        if m.get('RuleContent') is not None:
            self.rule_content = m.get('RuleContent')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('RuleDescription') is not None:
            self.rule_description = m.get('RuleDescription')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        return self


class GetSceneRuleResponseBody(TeaModel):
    def __init__(self, request_id=None, data=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.data = data  # type: GetSceneRuleResponseBodyData
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetSceneRuleResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetSceneRuleResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetSceneRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetSceneRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetThingModelTslRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, resource_group_id=None,
                 product_key=None, model_version=None, simple=None, function_block_id=None, real_tenant_id=None,
                 real_tripartite_key=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.resource_group_id = TeaConverter.to_unicode(resource_group_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.model_version = TeaConverter.to_unicode(model_version)  # type: unicode
        self.simple = simple  # type: bool
        self.function_block_id = TeaConverter.to_unicode(function_block_id)  # type: unicode
        self.real_tenant_id = TeaConverter.to_unicode(real_tenant_id)  # type: unicode
        self.real_tripartite_key = TeaConverter.to_unicode(real_tripartite_key)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.model_version is not None:
            result['ModelVersion'] = self.model_version
        if self.simple is not None:
            result['Simple'] = self.simple
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ModelVersion') is not None:
            self.model_version = m.get('ModelVersion')
        if m.get('Simple') is not None:
            self.simple = m.get('Simple')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        return self


class GetThingModelTslResponseBodyData(TeaModel):
    def __init__(self, tsl_str=None, tsl_uri=None):
        self.tsl_str = TeaConverter.to_unicode(tsl_str)  # type: unicode
        self.tsl_uri = TeaConverter.to_unicode(tsl_uri)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.tsl_str is not None:
            result['TslStr'] = self.tsl_str
        if self.tsl_uri is not None:
            result['TslUri'] = self.tsl_uri
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TslStr') is not None:
            self.tsl_str = m.get('TslStr')
        if m.get('TslUri') is not None:
            self.tsl_uri = m.get('TslUri')
        return self


class GetThingModelTslResponseBody(TeaModel):
    def __init__(self, request_id=None, data=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.data = data  # type: GetThingModelTslResponseBodyData
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetThingModelTslResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetThingModelTslResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetThingModelTslResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetThingModelTslResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetThingModelTslPublishedRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, product_key=None,
                 resource_group_id=None, simple=None, model_version=None, function_block_id=None, real_tenant_id=None,
                 real_tripartite_key=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.resource_group_id = TeaConverter.to_unicode(resource_group_id)  # type: unicode
        self.simple = simple  # type: bool
        self.model_version = TeaConverter.to_unicode(model_version)  # type: unicode
        self.function_block_id = TeaConverter.to_unicode(function_block_id)  # type: unicode
        self.real_tenant_id = TeaConverter.to_unicode(real_tenant_id)  # type: unicode
        self.real_tripartite_key = TeaConverter.to_unicode(real_tripartite_key)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.simple is not None:
            result['Simple'] = self.simple
        if self.model_version is not None:
            result['ModelVersion'] = self.model_version
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('Simple') is not None:
            self.simple = m.get('Simple')
        if m.get('ModelVersion') is not None:
            self.model_version = m.get('ModelVersion')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        return self


class GetThingModelTslPublishedResponseBodyData(TeaModel):
    def __init__(self, tsl_str=None, tsl_uri=None):
        self.tsl_str = TeaConverter.to_unicode(tsl_str)  # type: unicode
        self.tsl_uri = TeaConverter.to_unicode(tsl_uri)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.tsl_str is not None:
            result['TslStr'] = self.tsl_str
        if self.tsl_uri is not None:
            result['TslUri'] = self.tsl_uri
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TslStr') is not None:
            self.tsl_str = m.get('TslStr')
        if m.get('TslUri') is not None:
            self.tsl_uri = m.get('TslUri')
        return self


class GetThingModelTslPublishedResponseBody(TeaModel):
    def __init__(self, request_id=None, data=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.data = data  # type: GetThingModelTslPublishedResponseBodyData
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetThingModelTslPublishedResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetThingModelTslPublishedResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetThingModelTslPublishedResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetThingModelTslPublishedResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetThingScriptRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, product_key=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class GetThingScriptResponseBodyData(TeaModel):
    def __init__(self, script_type=None, script_url=None):
        self.script_type = TeaConverter.to_unicode(script_type)  # type: unicode
        self.script_url = TeaConverter.to_unicode(script_url)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.script_type is not None:
            result['ScriptType'] = self.script_type
        if self.script_url is not None:
            result['ScriptUrl'] = self.script_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ScriptType') is not None:
            self.script_type = m.get('ScriptType')
        if m.get('ScriptUrl') is not None:
            self.script_url = m.get('ScriptUrl')
        return self


class GetThingScriptResponseBody(TeaModel):
    def __init__(self, request_id=None, data=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.data = data  # type: GetThingScriptResponseBodyData
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetThingScriptResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetThingScriptResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetThingScriptResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetThingScriptResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetThingTemplateRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, resource_group_id=None,
                 category_key=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.resource_group_id = TeaConverter.to_unicode(resource_group_id)  # type: unicode
        self.category_key = TeaConverter.to_unicode(category_key)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.category_key is not None:
            result['CategoryKey'] = self.category_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('CategoryKey') is not None:
            self.category_key = m.get('CategoryKey')
        return self


class GetThingTemplateResponseBody(TeaModel):
    def __init__(self, request_id=None, thing_model_json=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.thing_model_json = TeaConverter.to_unicode(thing_model_json)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.thing_model_json is not None:
            result['ThingModelJSON'] = self.thing_model_json
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ThingModelJSON') is not None:
            self.thing_model_json = m.get('ThingModelJSON')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetThingTemplateResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetThingTemplateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetThingTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetThingTopoRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, page_size=None, product_key=None,
                 device_name=None, page_no=None, iot_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.page_size = page_size  # type: int
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.page_no = page_no  # type: int
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class GetThingTopoResponseBodyDataListDeviceInfo(TeaModel):
    def __init__(self, product_key=None, device_name=None, iot_id=None):
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class GetThingTopoResponseBodyDataList(TeaModel):
    def __init__(self, device_info=None):
        self.device_info = device_info  # type: list[GetThingTopoResponseBodyDataListDeviceInfo]

    def validate(self):
        if self.device_info:
            for k in self.device_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['deviceInfo'] = []
        if self.device_info is not None:
            for k in self.device_info:
                result['deviceInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.device_info = []
        if m.get('deviceInfo') is not None:
            for k in m.get('deviceInfo'):
                temp_model = GetThingTopoResponseBodyDataListDeviceInfo()
                self.device_info.append(temp_model.from_map(k))
        return self


class GetThingTopoResponseBodyData(TeaModel):
    def __init__(self, current_page=None, list=None, page_size=None, page_count=None, total=None):
        self.current_page = current_page  # type: int
        self.list = list  # type: GetThingTopoResponseBodyDataList
        self.page_size = page_size  # type: int
        self.page_count = page_count  # type: long
        self.total = total  # type: long

    def validate(self):
        if self.list:
            self.list.validate()

    def to_map(self):
        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.list is not None:
            result['List'] = self.list.to_map()
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('List') is not None:
            temp_model = GetThingTopoResponseBodyDataList()
            self.list = temp_model.from_map(m['List'])
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetThingTopoResponseBody(TeaModel):
    def __init__(self, request_id=None, data=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.data = data  # type: GetThingTopoResponseBodyData
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = GetThingTopoResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetThingTopoResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: GetThingTopoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetThingTopoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ImportThingModelTslRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, resource_group_id=None,
                 product_key=None, tsl_str=None, tsl_url=None, function_block_id=None, function_block_name=None,
                 real_tenant_id=None, real_tripartite_key=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.resource_group_id = TeaConverter.to_unicode(resource_group_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.tsl_str = TeaConverter.to_unicode(tsl_str)  # type: unicode
        self.tsl_url = TeaConverter.to_unicode(tsl_url)  # type: unicode
        self.function_block_id = TeaConverter.to_unicode(function_block_id)  # type: unicode
        self.function_block_name = TeaConverter.to_unicode(function_block_name)  # type: unicode
        self.real_tenant_id = TeaConverter.to_unicode(real_tenant_id)  # type: unicode
        self.real_tripartite_key = TeaConverter.to_unicode(real_tripartite_key)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.tsl_str is not None:
            result['TslStr'] = self.tsl_str
        if self.tsl_url is not None:
            result['TslUrl'] = self.tsl_url
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        if self.function_block_name is not None:
            result['FunctionBlockName'] = self.function_block_name
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('TslStr') is not None:
            self.tsl_str = m.get('TslStr')
        if m.get('TslUrl') is not None:
            self.tsl_url = m.get('TslUrl')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        if m.get('FunctionBlockName') is not None:
            self.function_block_name = m.get('FunctionBlockName')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        return self


class ImportThingModelTslResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ImportThingModelTslResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: ImportThingModelTslResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ImportThingModelTslResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InvokeDataAPIServiceRequestParam(TeaModel):
    def __init__(self, param_name=None, param_type=None, param_value=None, list_param_type=None,
                 list_param_value=None):
        self.param_name = TeaConverter.to_unicode(param_name)  # type: unicode
        self.param_type = TeaConverter.to_unicode(param_type)  # type: unicode
        self.param_value = TeaConverter.to_unicode(param_value)  # type: unicode
        self.list_param_type = TeaConverter.to_unicode(list_param_type)  # type: unicode
        self.list_param_value = list_param_value  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.param_name is not None:
            result['ParamName'] = self.param_name
        if self.param_type is not None:
            result['ParamType'] = self.param_type
        if self.param_value is not None:
            result['ParamValue'] = self.param_value
        if self.list_param_type is not None:
            result['ListParamType'] = self.list_param_type
        if self.list_param_value is not None:
            result['ListParamValue'] = self.list_param_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ParamName') is not None:
            self.param_name = m.get('ParamName')
        if m.get('ParamType') is not None:
            self.param_type = m.get('ParamType')
        if m.get('ParamValue') is not None:
            self.param_value = m.get('ParamValue')
        if m.get('ListParamType') is not None:
            self.list_param_type = m.get('ListParamType')
        if m.get('ListParamValue') is not None:
            self.list_param_value = m.get('ListParamValue')
        return self


class InvokeDataAPIServiceRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, api_srn=None, iot_instance_id=None, param=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.api_srn = TeaConverter.to_unicode(api_srn)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.param = param  # type: list[InvokeDataAPIServiceRequestParam]

    def validate(self):
        if self.param:
            for k in self.param:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.api_srn is not None:
            result['ApiSrn'] = self.api_srn
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        result['Param'] = []
        if self.param is not None:
            for k in self.param:
                result['Param'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('ApiSrn') is not None:
            self.api_srn = m.get('ApiSrn')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        self.param = []
        if m.get('Param') is not None:
            for k in m.get('Param'):
                temp_model = InvokeDataAPIServiceRequestParam()
                self.param.append(temp_model.from_map(k))
        return self


class InvokeDataAPIServiceResponseBodyDataResultList(TeaModel):
    def __init__(self, result_list=None):
        self.result_list = result_list  # type: list[dict[unicode, any]]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.result_list is not None:
            result['ResultList'] = self.result_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResultList') is not None:
            self.result_list = m.get('ResultList')
        return self


class InvokeDataAPIServiceResponseBodyDataFieldNameList(TeaModel):
    def __init__(self, field_name_list=None):
        self.field_name_list = field_name_list  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.field_name_list is not None:
            result['FieldNameList'] = self.field_name_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FieldNameList') is not None:
            self.field_name_list = m.get('FieldNameList')
        return self


class InvokeDataAPIServiceResponseBodyData(TeaModel):
    def __init__(self, result_list=None, api_srn=None, field_name_list=None, page_no=None, page_size=None):
        self.result_list = result_list  # type: InvokeDataAPIServiceResponseBodyDataResultList
        self.api_srn = TeaConverter.to_unicode(api_srn)  # type: unicode
        self.field_name_list = field_name_list  # type: InvokeDataAPIServiceResponseBodyDataFieldNameList
        self.page_no = page_no  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        if self.result_list:
            self.result_list.validate()
        if self.field_name_list:
            self.field_name_list.validate()

    def to_map(self):
        result = dict()
        if self.result_list is not None:
            result['ResultList'] = self.result_list.to_map()
        if self.api_srn is not None:
            result['ApiSrn'] = self.api_srn
        if self.field_name_list is not None:
            result['FieldNameList'] = self.field_name_list.to_map()
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResultList') is not None:
            temp_model = InvokeDataAPIServiceResponseBodyDataResultList()
            self.result_list = temp_model.from_map(m['ResultList'])
        if m.get('ApiSrn') is not None:
            self.api_srn = m.get('ApiSrn')
        if m.get('FieldNameList') is not None:
            temp_model = InvokeDataAPIServiceResponseBodyDataFieldNameList()
            self.field_name_list = temp_model.from_map(m['FieldNameList'])
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class InvokeDataAPIServiceResponseBody(TeaModel):
    def __init__(self, request_id=None, data=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.data = data  # type: InvokeDataAPIServiceResponseBodyData
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = InvokeDataAPIServiceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class InvokeDataAPIServiceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: InvokeDataAPIServiceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = InvokeDataAPIServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InvokeThingServiceRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, product_key=None,
                 device_name=None, identifier=None, args=None, iot_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.identifier = TeaConverter.to_unicode(identifier)  # type: unicode
        self.args = TeaConverter.to_unicode(args)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.args is not None:
            result['Args'] = self.args
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('Args') is not None:
            self.args = m.get('Args')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class InvokeThingServiceResponseBodyData(TeaModel):
    def __init__(self, message_id=None, result=None):
        self.message_id = TeaConverter.to_unicode(message_id)  # type: unicode
        self.result = TeaConverter.to_unicode(result)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        if self.result is not None:
            result['Result'] = self.result
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        return self


class InvokeThingServiceResponseBody(TeaModel):
    def __init__(self, request_id=None, data=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.data = data  # type: InvokeThingServiceResponseBodyData
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Data') is not None:
            temp_model = InvokeThingServiceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class InvokeThingServiceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: InvokeThingServiceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = InvokeThingServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InvokeThingsServiceRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, product_key=None, identifier=None,
                 args=None, device_name=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.identifier = TeaConverter.to_unicode(identifier)  # type: unicode
        self.args = TeaConverter.to_unicode(args)  # type: unicode
        self.device_name = device_name  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.args is not None:
            result['Args'] = self.args
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('Args') is not None:
            self.args = m.get('Args')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class InvokeThingsServiceResponseBody(TeaModel):
    def __init__(self, request_id=None, error_message=None, code=None, success=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class InvokeThingsServiceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: InvokeThingsServiceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = InvokeThingsServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListJobRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, status=None, page_size=None,
                 current_page=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.page_size = page_size  # type: int
        self.current_page = current_page  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.status is not None:
            result['Status'] = self.status
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class ListJobResponseBodyDataData(TeaModel):
    def __init__(self, job_id=None, job_name=None, utc_create=None, utc_modified=None, status=None, description=None,
                 type=None):
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.job_name = TeaConverter.to_unicode(job_name)  # type: unicode
        self.utc_create = TeaConverter.to_unicode(utc_create)  # type: unicode
        self.utc_modified = TeaConverter.to_unicode(utc_modified)  # type: unicode
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.type = TeaConverter.to_unicode(type)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.status is not None:
            result['Status'] = self.status
        if self.description is not None:
            result['Description'] = self.description
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ListJobResponseBodyData(TeaModel):
    def __init__(self, data=None):
        self.data = data  # type: list[ListJobResponseBodyDataData]

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = ListJobResponseBodyDataData()
                self.data.append(temp_model.from_map(k))
        return self


class ListJobResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, total=None, page_size=None,
                 page=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.total = total  # type: int
        self.page_size = page_size  # type: int
        self.page = page  # type: int
        self.data = data  # type: ListJobResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page is not None:
            result['Page'] = self.page
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('Data') is not None:
            temp_model = ListJobResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListJobResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: ListJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListOTAFirmwareRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, product_key=None, page_size=None,
                 current_page=None, dest_version=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.page_size = page_size  # type: int
        self.current_page = current_page  # type: int
        self.dest_version = TeaConverter.to_unicode(dest_version)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dest_version is not None:
            result['DestVersion'] = self.dest_version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DestVersion') is not None:
            self.dest_version = m.get('DestVersion')
        return self


class ListOTAFirmwareResponseBodyFirmwareInfoSimpleFirmwareInfo(TeaModel):
    def __init__(self, firmware_name=None, firmware_id=None, src_version=None, dest_version=None, utc_create=None,
                 utc_modified=None, status=None, firmware_desc=None, firmware_sign=None, firmware_size=None, firmware_url=None,
                 product_key=None, sign_method=None, product_name=None, type=None, module_name=None):
        self.firmware_name = TeaConverter.to_unicode(firmware_name)  # type: unicode
        self.firmware_id = TeaConverter.to_unicode(firmware_id)  # type: unicode
        self.src_version = TeaConverter.to_unicode(src_version)  # type: unicode
        self.dest_version = TeaConverter.to_unicode(dest_version)  # type: unicode
        self.utc_create = TeaConverter.to_unicode(utc_create)  # type: unicode
        self.utc_modified = TeaConverter.to_unicode(utc_modified)  # type: unicode
        self.status = status  # type: int
        self.firmware_desc = TeaConverter.to_unicode(firmware_desc)  # type: unicode
        self.firmware_sign = TeaConverter.to_unicode(firmware_sign)  # type: unicode
        self.firmware_size = firmware_size  # type: int
        self.firmware_url = TeaConverter.to_unicode(firmware_url)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.sign_method = TeaConverter.to_unicode(sign_method)  # type: unicode
        self.product_name = TeaConverter.to_unicode(product_name)  # type: unicode
        self.type = type  # type: int
        self.module_name = TeaConverter.to_unicode(module_name)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.firmware_name is not None:
            result['FirmwareName'] = self.firmware_name
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.src_version is not None:
            result['SrcVersion'] = self.src_version
        if self.dest_version is not None:
            result['DestVersion'] = self.dest_version
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.status is not None:
            result['Status'] = self.status
        if self.firmware_desc is not None:
            result['FirmwareDesc'] = self.firmware_desc
        if self.firmware_sign is not None:
            result['FirmwareSign'] = self.firmware_sign
        if self.firmware_size is not None:
            result['FirmwareSize'] = self.firmware_size
        if self.firmware_url is not None:
            result['FirmwareUrl'] = self.firmware_url
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.sign_method is not None:
            result['SignMethod'] = self.sign_method
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.type is not None:
            result['Type'] = self.type
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FirmwareName') is not None:
            self.firmware_name = m.get('FirmwareName')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('SrcVersion') is not None:
            self.src_version = m.get('SrcVersion')
        if m.get('DestVersion') is not None:
            self.dest_version = m.get('DestVersion')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('FirmwareDesc') is not None:
            self.firmware_desc = m.get('FirmwareDesc')
        if m.get('FirmwareSign') is not None:
            self.firmware_sign = m.get('FirmwareSign')
        if m.get('FirmwareSize') is not None:
            self.firmware_size = m.get('FirmwareSize')
        if m.get('FirmwareUrl') is not None:
            self.firmware_url = m.get('FirmwareUrl')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('SignMethod') is not None:
            self.sign_method = m.get('SignMethod')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        return self


class ListOTAFirmwareResponseBodyFirmwareInfo(TeaModel):
    def __init__(self, simple_firmware_info=None):
        self.simple_firmware_info = simple_firmware_info  # type: list[ListOTAFirmwareResponseBodyFirmwareInfoSimpleFirmwareInfo]

    def validate(self):
        if self.simple_firmware_info:
            for k in self.simple_firmware_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['SimpleFirmwareInfo'] = []
        if self.simple_firmware_info is not None:
            for k in self.simple_firmware_info:
                result['SimpleFirmwareInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.simple_firmware_info = []
        if m.get('SimpleFirmwareInfo') is not None:
            for k in m.get('SimpleFirmwareInfo'):
                temp_model = ListOTAFirmwareResponseBodyFirmwareInfoSimpleFirmwareInfo()
                self.simple_firmware_info.append(temp_model.from_map(k))
        return self


class ListOTAFirmwareResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, total=None, page_size=None,
                 page_count=None, current_page=None, firmware_info=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.total = total  # type: int
        self.page_size = page_size  # type: int
        self.page_count = page_count  # type: int
        self.current_page = current_page  # type: int
        self.firmware_info = firmware_info  # type: ListOTAFirmwareResponseBodyFirmwareInfo

    def validate(self):
        if self.firmware_info:
            self.firmware_info.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.firmware_info is not None:
            result['FirmwareInfo'] = self.firmware_info.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('FirmwareInfo') is not None:
            temp_model = ListOTAFirmwareResponseBodyFirmwareInfo()
            self.firmware_info = temp_model.from_map(m['FirmwareInfo'])
        return self


class ListOTAFirmwareResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: ListOTAFirmwareResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListOTAFirmwareResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListOTAJobByDeviceRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, firmware_id=None, page_size=None,
                 product_key=None, device_name=None, current_page=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.firmware_id = TeaConverter.to_unicode(firmware_id)  # type: unicode
        self.page_size = page_size  # type: int
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.current_page = current_page  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class ListOTAJobByDeviceResponseBodyDataSimpleOTAJobInfoTagsOtaTagDTO(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = TeaConverter.to_unicode(key)  # type: unicode
        self.value = TeaConverter.to_unicode(value)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListOTAJobByDeviceResponseBodyDataSimpleOTAJobInfoTags(TeaModel):
    def __init__(self, ota_tag_dto=None):
        self.ota_tag_dto = ota_tag_dto  # type: list[ListOTAJobByDeviceResponseBodyDataSimpleOTAJobInfoTagsOtaTagDTO]

    def validate(self):
        if self.ota_tag_dto:
            for k in self.ota_tag_dto:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['OtaTagDTO'] = []
        if self.ota_tag_dto is not None:
            for k in self.ota_tag_dto:
                result['OtaTagDTO'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.ota_tag_dto = []
        if m.get('OtaTagDTO') is not None:
            for k in m.get('OtaTagDTO'):
                temp_model = ListOTAJobByDeviceResponseBodyDataSimpleOTAJobInfoTagsOtaTagDTO()
                self.ota_tag_dto.append(temp_model.from_map(k))
        return self


class ListOTAJobByDeviceResponseBodyDataSimpleOTAJobInfo(TeaModel):
    def __init__(self, job_id=None, utc_create=None, utc_modified=None, product_key=None, firmware_id=None,
                 utc_start_time=None, utc_end_time=None, job_status=None, job_type=None, target_selection=None,
                 selection_type=None, tags=None):
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.utc_create = TeaConverter.to_unicode(utc_create)  # type: unicode
        self.utc_modified = TeaConverter.to_unicode(utc_modified)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.firmware_id = TeaConverter.to_unicode(firmware_id)  # type: unicode
        self.utc_start_time = TeaConverter.to_unicode(utc_start_time)  # type: unicode
        self.utc_end_time = TeaConverter.to_unicode(utc_end_time)  # type: unicode
        self.job_status = TeaConverter.to_unicode(job_status)  # type: unicode
        self.job_type = TeaConverter.to_unicode(job_type)  # type: unicode
        self.target_selection = TeaConverter.to_unicode(target_selection)  # type: unicode
        self.selection_type = TeaConverter.to_unicode(selection_type)  # type: unicode
        self.tags = tags  # type: ListOTAJobByDeviceResponseBodyDataSimpleOTAJobInfoTags

    def validate(self):
        if self.tags:
            self.tags.validate()

    def to_map(self):
        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.utc_start_time is not None:
            result['UtcStartTime'] = self.utc_start_time
        if self.utc_end_time is not None:
            result['UtcEndTime'] = self.utc_end_time
        if self.job_status is not None:
            result['JobStatus'] = self.job_status
        if self.job_type is not None:
            result['JobType'] = self.job_type
        if self.target_selection is not None:
            result['TargetSelection'] = self.target_selection
        if self.selection_type is not None:
            result['SelectionType'] = self.selection_type
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('UtcStartTime') is not None:
            self.utc_start_time = m.get('UtcStartTime')
        if m.get('UtcEndTime') is not None:
            self.utc_end_time = m.get('UtcEndTime')
        if m.get('JobStatus') is not None:
            self.job_status = m.get('JobStatus')
        if m.get('JobType') is not None:
            self.job_type = m.get('JobType')
        if m.get('TargetSelection') is not None:
            self.target_selection = m.get('TargetSelection')
        if m.get('SelectionType') is not None:
            self.selection_type = m.get('SelectionType')
        if m.get('Tags') is not None:
            temp_model = ListOTAJobByDeviceResponseBodyDataSimpleOTAJobInfoTags()
            self.tags = temp_model.from_map(m['Tags'])
        return self


class ListOTAJobByDeviceResponseBodyData(TeaModel):
    def __init__(self, simple_otajob_info=None):
        self.simple_otajob_info = simple_otajob_info  # type: list[ListOTAJobByDeviceResponseBodyDataSimpleOTAJobInfo]

    def validate(self):
        if self.simple_otajob_info:
            for k in self.simple_otajob_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['SimpleOTAJobInfo'] = []
        if self.simple_otajob_info is not None:
            for k in self.simple_otajob_info:
                result['SimpleOTAJobInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.simple_otajob_info = []
        if m.get('SimpleOTAJobInfo') is not None:
            for k in m.get('SimpleOTAJobInfo'):
                temp_model = ListOTAJobByDeviceResponseBodyDataSimpleOTAJobInfo()
                self.simple_otajob_info.append(temp_model.from_map(k))
        return self


class ListOTAJobByDeviceResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, total=None, page_size=None,
                 page_count=None, current_page=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.total = total  # type: int
        self.page_size = page_size  # type: int
        self.page_count = page_count  # type: int
        self.current_page = current_page  # type: int
        self.data = data  # type: ListOTAJobByDeviceResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Data') is not None:
            temp_model = ListOTAJobByDeviceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListOTAJobByDeviceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: ListOTAJobByDeviceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListOTAJobByDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListOTAJobByFirmwareRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, firmware_id=None, page_size=None,
                 current_page=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.firmware_id = TeaConverter.to_unicode(firmware_id)  # type: unicode
        self.page_size = page_size  # type: int
        self.current_page = current_page  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class ListOTAJobByFirmwareResponseBodyDataSimpleOTAJobInfoTagsOtaTagDTO(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = TeaConverter.to_unicode(key)  # type: unicode
        self.value = TeaConverter.to_unicode(value)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListOTAJobByFirmwareResponseBodyDataSimpleOTAJobInfoTags(TeaModel):
    def __init__(self, ota_tag_dto=None):
        self.ota_tag_dto = ota_tag_dto  # type: list[ListOTAJobByFirmwareResponseBodyDataSimpleOTAJobInfoTagsOtaTagDTO]

    def validate(self):
        if self.ota_tag_dto:
            for k in self.ota_tag_dto:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['OtaTagDTO'] = []
        if self.ota_tag_dto is not None:
            for k in self.ota_tag_dto:
                result['OtaTagDTO'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.ota_tag_dto = []
        if m.get('OtaTagDTO') is not None:
            for k in m.get('OtaTagDTO'):
                temp_model = ListOTAJobByFirmwareResponseBodyDataSimpleOTAJobInfoTagsOtaTagDTO()
                self.ota_tag_dto.append(temp_model.from_map(k))
        return self


class ListOTAJobByFirmwareResponseBodyDataSimpleOTAJobInfo(TeaModel):
    def __init__(self, job_id=None, utc_create=None, utc_modified=None, product_key=None, firmware_id=None,
                 utc_start_time=None, utc_end_time=None, job_status=None, job_type=None, target_selection=None,
                 selection_type=None, tags=None):
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.utc_create = TeaConverter.to_unicode(utc_create)  # type: unicode
        self.utc_modified = TeaConverter.to_unicode(utc_modified)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.firmware_id = TeaConverter.to_unicode(firmware_id)  # type: unicode
        self.utc_start_time = TeaConverter.to_unicode(utc_start_time)  # type: unicode
        self.utc_end_time = TeaConverter.to_unicode(utc_end_time)  # type: unicode
        self.job_status = TeaConverter.to_unicode(job_status)  # type: unicode
        self.job_type = TeaConverter.to_unicode(job_type)  # type: unicode
        self.target_selection = TeaConverter.to_unicode(target_selection)  # type: unicode
        self.selection_type = TeaConverter.to_unicode(selection_type)  # type: unicode
        self.tags = tags  # type: ListOTAJobByFirmwareResponseBodyDataSimpleOTAJobInfoTags

    def validate(self):
        if self.tags:
            self.tags.validate()

    def to_map(self):
        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.utc_start_time is not None:
            result['UtcStartTime'] = self.utc_start_time
        if self.utc_end_time is not None:
            result['UtcEndTime'] = self.utc_end_time
        if self.job_status is not None:
            result['JobStatus'] = self.job_status
        if self.job_type is not None:
            result['JobType'] = self.job_type
        if self.target_selection is not None:
            result['TargetSelection'] = self.target_selection
        if self.selection_type is not None:
            result['SelectionType'] = self.selection_type
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('UtcStartTime') is not None:
            self.utc_start_time = m.get('UtcStartTime')
        if m.get('UtcEndTime') is not None:
            self.utc_end_time = m.get('UtcEndTime')
        if m.get('JobStatus') is not None:
            self.job_status = m.get('JobStatus')
        if m.get('JobType') is not None:
            self.job_type = m.get('JobType')
        if m.get('TargetSelection') is not None:
            self.target_selection = m.get('TargetSelection')
        if m.get('SelectionType') is not None:
            self.selection_type = m.get('SelectionType')
        if m.get('Tags') is not None:
            temp_model = ListOTAJobByFirmwareResponseBodyDataSimpleOTAJobInfoTags()
            self.tags = temp_model.from_map(m['Tags'])
        return self


class ListOTAJobByFirmwareResponseBodyData(TeaModel):
    def __init__(self, simple_otajob_info=None):
        self.simple_otajob_info = simple_otajob_info  # type: list[ListOTAJobByFirmwareResponseBodyDataSimpleOTAJobInfo]

    def validate(self):
        if self.simple_otajob_info:
            for k in self.simple_otajob_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['SimpleOTAJobInfo'] = []
        if self.simple_otajob_info is not None:
            for k in self.simple_otajob_info:
                result['SimpleOTAJobInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.simple_otajob_info = []
        if m.get('SimpleOTAJobInfo') is not None:
            for k in m.get('SimpleOTAJobInfo'):
                temp_model = ListOTAJobByFirmwareResponseBodyDataSimpleOTAJobInfo()
                self.simple_otajob_info.append(temp_model.from_map(k))
        return self


class ListOTAJobByFirmwareResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, total=None, page_size=None,
                 page_count=None, current_page=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.total = total  # type: int
        self.page_size = page_size  # type: int
        self.page_count = page_count  # type: int
        self.current_page = current_page  # type: int
        self.data = data  # type: ListOTAJobByFirmwareResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Data') is not None:
            temp_model = ListOTAJobByFirmwareResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListOTAJobByFirmwareResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: ListOTAJobByFirmwareResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListOTAJobByFirmwareResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListOTAModuleByProductRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, product_key=None,
                 auth_config=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.auth_config = TeaConverter.to_unicode(auth_config)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.auth_config is not None:
            result['AuthConfig'] = self.auth_config
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('AuthConfig') is not None:
            self.auth_config = m.get('AuthConfig')
        return self


class ListOTAModuleByProductResponseBodyData(TeaModel):
    def __init__(self, product_key=None, module_name=None, alias_name=None, desc=None, gmt_create=None,
                 gmt_modified=None):
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.module_name = TeaConverter.to_unicode(module_name)  # type: unicode
        self.alias_name = TeaConverter.to_unicode(alias_name)  # type: unicode
        self.desc = TeaConverter.to_unicode(desc)  # type: unicode
        self.gmt_create = TeaConverter.to_unicode(gmt_create)  # type: unicode
        self.gmt_modified = TeaConverter.to_unicode(gmt_modified)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.desc is not None:
            result['Desc'] = self.desc
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        return self


class ListOTAModuleByProductResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: list[ListOTAModuleByProductResponseBodyData]

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListOTAModuleByProductResponseBodyData()
                self.data.append(temp_model.from_map(k))
        return self


class ListOTAModuleByProductResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: ListOTAModuleByProductResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListOTAModuleByProductResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListOTAModuleVersionsByDeviceRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, page_size=None, product_key=None,
                 device_name=None, iot_id=None, current_page=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.page_size = page_size  # type: int
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.current_page = current_page  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class ListOTAModuleVersionsByDeviceResponseBodyDataSimpleOTAModuleInfo(TeaModel):
    def __init__(self, product_key=None, device_name=None, iot_id=None, module_version=None, module_name=None):
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.module_version = TeaConverter.to_unicode(module_version)  # type: unicode
        self.module_name = TeaConverter.to_unicode(module_name)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.module_version is not None:
            result['ModuleVersion'] = self.module_version
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('ModuleVersion') is not None:
            self.module_version = m.get('ModuleVersion')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        return self


class ListOTAModuleVersionsByDeviceResponseBodyData(TeaModel):
    def __init__(self, simple_otamodule_info=None):
        self.simple_otamodule_info = simple_otamodule_info  # type: list[ListOTAModuleVersionsByDeviceResponseBodyDataSimpleOTAModuleInfo]

    def validate(self):
        if self.simple_otamodule_info:
            for k in self.simple_otamodule_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['SimpleOTAModuleInfo'] = []
        if self.simple_otamodule_info is not None:
            for k in self.simple_otamodule_info:
                result['SimpleOTAModuleInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.simple_otamodule_info = []
        if m.get('SimpleOTAModuleInfo') is not None:
            for k in m.get('SimpleOTAModuleInfo'):
                temp_model = ListOTAModuleVersionsByDeviceResponseBodyDataSimpleOTAModuleInfo()
                self.simple_otamodule_info.append(temp_model.from_map(k))
        return self


class ListOTAModuleVersionsByDeviceResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, total=None, page_size=None,
                 page_count=None, current_page=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.total = total  # type: int
        self.page_size = page_size  # type: int
        self.page_count = page_count  # type: int
        self.current_page = current_page  # type: int
        self.data = data  # type: ListOTAModuleVersionsByDeviceResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Data') is not None:
            temp_model = ListOTAModuleVersionsByDeviceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListOTAModuleVersionsByDeviceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: ListOTAModuleVersionsByDeviceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListOTAModuleVersionsByDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListOTATaskByJobRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, page_size=None, task_status=None,
                 job_id=None, current_page=None, device_names=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.page_size = page_size  # type: int
        self.task_status = TeaConverter.to_unicode(task_status)  # type: unicode
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.current_page = current_page  # type: int
        self.device_names = device_names  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.device_names is not None:
            result['DeviceNames'] = self.device_names
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DeviceNames') is not None:
            self.device_names = m.get('DeviceNames')
        return self


class ListOTATaskByJobResponseBodyDataSimpleOTATaskInfo(TeaModel):
    def __init__(self, task_id=None, utc_modified=None, product_key=None, firmware_id=None, task_status=None,
                 job_id=None, product_name=None, device_name=None, src_version=None, dest_version=None, task_desc=None,
                 progress=None, iot_id=None, utc_create=None):
        self.task_id = TeaConverter.to_unicode(task_id)  # type: unicode
        self.utc_modified = TeaConverter.to_unicode(utc_modified)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.firmware_id = TeaConverter.to_unicode(firmware_id)  # type: unicode
        self.task_status = TeaConverter.to_unicode(task_status)  # type: unicode
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.product_name = TeaConverter.to_unicode(product_name)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.src_version = TeaConverter.to_unicode(src_version)  # type: unicode
        self.dest_version = TeaConverter.to_unicode(dest_version)  # type: unicode
        self.task_desc = TeaConverter.to_unicode(task_desc)  # type: unicode
        self.progress = TeaConverter.to_unicode(progress)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.utc_create = TeaConverter.to_unicode(utc_create)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.firmware_id is not None:
            result['FirmwareId'] = self.firmware_id
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.src_version is not None:
            result['SrcVersion'] = self.src_version
        if self.dest_version is not None:
            result['DestVersion'] = self.dest_version
        if self.task_desc is not None:
            result['TaskDesc'] = self.task_desc
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('FirmwareId') is not None:
            self.firmware_id = m.get('FirmwareId')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('SrcVersion') is not None:
            self.src_version = m.get('SrcVersion')
        if m.get('DestVersion') is not None:
            self.dest_version = m.get('DestVersion')
        if m.get('TaskDesc') is not None:
            self.task_desc = m.get('TaskDesc')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        return self


class ListOTATaskByJobResponseBodyData(TeaModel):
    def __init__(self, simple_otatask_info=None):
        self.simple_otatask_info = simple_otatask_info  # type: list[ListOTATaskByJobResponseBodyDataSimpleOTATaskInfo]

    def validate(self):
        if self.simple_otatask_info:
            for k in self.simple_otatask_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['SimpleOTATaskInfo'] = []
        if self.simple_otatask_info is not None:
            for k in self.simple_otatask_info:
                result['SimpleOTATaskInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.simple_otatask_info = []
        if m.get('SimpleOTATaskInfo') is not None:
            for k in m.get('SimpleOTATaskInfo'):
                temp_model = ListOTATaskByJobResponseBodyDataSimpleOTATaskInfo()
                self.simple_otatask_info.append(temp_model.from_map(k))
        return self


class ListOTATaskByJobResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, total=None, page_size=None,
                 page_count=None, current_page=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.total = total  # type: int
        self.page_size = page_size  # type: int
        self.page_count = page_count  # type: int
        self.current_page = current_page  # type: int
        self.data = data  # type: ListOTATaskByJobResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Data') is not None:
            temp_model = ListOTATaskByJobResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListOTATaskByJobResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: ListOTATaskByJobResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListOTATaskByJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListProductByTagsRequestProductTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = TeaConverter.to_unicode(tag_key)  # type: unicode
        self.tag_value = TeaConverter.to_unicode(tag_value)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class ListProductByTagsRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, current_page=None, page_size=None,
                 product_tag=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.product_tag = product_tag  # type: list[ListProductByTagsRequestProductTag]

    def validate(self):
        if self.product_tag:
            for k in self.product_tag:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['ProductTag'] = []
        if self.product_tag is not None:
            for k in self.product_tag:
                result['ProductTag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.product_tag = []
        if m.get('ProductTag') is not None:
            for k in m.get('ProductTag'):
                temp_model = ListProductByTagsRequestProductTag()
                self.product_tag.append(temp_model.from_map(k))
        return self


class ListProductByTagsResponseBodyProductInfosProductInfo(TeaModel):
    def __init__(self, product_name=None, product_key=None, create_time=None, description=None, node_type=None):
        self.product_name = TeaConverter.to_unicode(product_name)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.create_time = create_time  # type: long
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.node_type = node_type  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        return self


class ListProductByTagsResponseBodyProductInfos(TeaModel):
    def __init__(self, product_info=None):
        self.product_info = product_info  # type: list[ListProductByTagsResponseBodyProductInfosProductInfo]

    def validate(self):
        if self.product_info:
            for k in self.product_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['ProductInfo'] = []
        if self.product_info is not None:
            for k in self.product_info:
                result['ProductInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.product_info = []
        if m.get('ProductInfo') is not None:
            for k in m.get('ProductInfo'):
                temp_model = ListProductByTagsResponseBodyProductInfosProductInfo()
                self.product_info.append(temp_model.from_map(k))
        return self


class ListProductByTagsResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None, product_infos=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.product_infos = product_infos  # type: ListProductByTagsResponseBodyProductInfos

    def validate(self):
        if self.product_infos:
            self.product_infos.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.product_infos is not None:
            result['ProductInfos'] = self.product_infos.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ProductInfos') is not None:
            temp_model = ListProductByTagsResponseBodyProductInfos()
            self.product_infos = temp_model.from_map(m['ProductInfos'])
        return self


class ListProductByTagsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: ListProductByTagsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListProductByTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListProductTagsRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, product_key=None,
                 real_tenant_id=None, real_tripartite_key=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.real_tenant_id = TeaConverter.to_unicode(real_tenant_id)  # type: unicode
        self.real_tripartite_key = TeaConverter.to_unicode(real_tripartite_key)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        return self


class ListProductTagsResponseBodyDataProductTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = TeaConverter.to_unicode(tag_key)  # type: unicode
        self.tag_value = TeaConverter.to_unicode(tag_value)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class ListProductTagsResponseBodyData(TeaModel):
    def __init__(self, product_tag=None):
        self.product_tag = product_tag  # type: list[ListProductTagsResponseBodyDataProductTag]

    def validate(self):
        if self.product_tag:
            for k in self.product_tag:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['ProductTag'] = []
        if self.product_tag is not None:
            for k in self.product_tag:
                result['ProductTag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.product_tag = []
        if m.get('ProductTag') is not None:
            for k in m.get('ProductTag'):
                temp_model = ListProductTagsResponseBodyDataProductTag()
                self.product_tag.append(temp_model.from_map(k))
        return self


class ListProductTagsResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.data = data  # type: ListProductTagsResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListProductTagsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListProductTagsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: ListProductTagsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListProductTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListRuleRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, current_page=None, page_size=None,
                 search_name=None, resource_group_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.search_name = TeaConverter.to_unicode(search_name)  # type: unicode
        self.resource_group_id = TeaConverter.to_unicode(resource_group_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.search_name is not None:
            result['SearchName'] = self.search_name
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SearchName') is not None:
            self.search_name = m.get('SearchName')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class ListRuleResponseBodyDataRuleInfo(TeaModel):
    def __init__(self, id=None, select=None, topic=None, short_topic=None, where=None, status=None,
                 create_user_id=None, product_key=None, name=None, data_type=None, rule_desc=None, created=None, utc_created=None,
                 modified=None, utc_modified=None):
        self.id = id  # type: long
        self.select = TeaConverter.to_unicode(select)  # type: unicode
        self.topic = TeaConverter.to_unicode(topic)  # type: unicode
        self.short_topic = TeaConverter.to_unicode(short_topic)  # type: unicode
        self.where = TeaConverter.to_unicode(where)  # type: unicode
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.create_user_id = create_user_id  # type: long
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.data_type = TeaConverter.to_unicode(data_type)  # type: unicode
        self.rule_desc = TeaConverter.to_unicode(rule_desc)  # type: unicode
        self.created = TeaConverter.to_unicode(created)  # type: unicode
        self.utc_created = TeaConverter.to_unicode(utc_created)  # type: unicode
        self.modified = TeaConverter.to_unicode(modified)  # type: unicode
        self.utc_modified = TeaConverter.to_unicode(utc_modified)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.select is not None:
            result['Select'] = self.select
        if self.topic is not None:
            result['Topic'] = self.topic
        if self.short_topic is not None:
            result['ShortTopic'] = self.short_topic
        if self.where is not None:
            result['Where'] = self.where
        if self.status is not None:
            result['Status'] = self.status
        if self.create_user_id is not None:
            result['CreateUserId'] = self.create_user_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.name is not None:
            result['Name'] = self.name
        if self.data_type is not None:
            result['DataType'] = self.data_type
        if self.rule_desc is not None:
            result['RuleDesc'] = self.rule_desc
        if self.created is not None:
            result['Created'] = self.created
        if self.utc_created is not None:
            result['UtcCreated'] = self.utc_created
        if self.modified is not None:
            result['Modified'] = self.modified
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Select') is not None:
            self.select = m.get('Select')
        if m.get('Topic') is not None:
            self.topic = m.get('Topic')
        if m.get('ShortTopic') is not None:
            self.short_topic = m.get('ShortTopic')
        if m.get('Where') is not None:
            self.where = m.get('Where')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('CreateUserId') is not None:
            self.create_user_id = m.get('CreateUserId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('DataType') is not None:
            self.data_type = m.get('DataType')
        if m.get('RuleDesc') is not None:
            self.rule_desc = m.get('RuleDesc')
        if m.get('Created') is not None:
            self.created = m.get('Created')
        if m.get('UtcCreated') is not None:
            self.utc_created = m.get('UtcCreated')
        if m.get('Modified') is not None:
            self.modified = m.get('Modified')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        return self


class ListRuleResponseBodyData(TeaModel):
    def __init__(self, rule_info=None):
        self.rule_info = rule_info  # type: list[ListRuleResponseBodyDataRuleInfo]

    def validate(self):
        if self.rule_info:
            for k in self.rule_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['RuleInfo'] = []
        if self.rule_info is not None:
            for k in self.rule_info:
                result['RuleInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.rule_info = []
        if m.get('RuleInfo') is not None:
            for k in m.get('RuleInfo'):
                temp_model = ListRuleResponseBodyDataRuleInfo()
                self.rule_info.append(temp_model.from_map(k))
        return self


class ListRuleResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, page=None, total=None,
                 page_size=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.page = page  # type: int
        self.total = total  # type: int
        self.page_size = page_size  # type: int
        self.data = data  # type: ListRuleResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.page is not None:
            result['Page'] = self.page
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Data') is not None:
            temp_model = ListRuleResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListRuleResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: ListRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListRuleActionsRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, rule_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.rule_id = rule_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class ListRuleActionsResponseBodyRuleActionListRuleActionInfo(TeaModel):
    def __init__(self, id=None, rule_id=None, type=None, configuration=None, error_action_flag=None):
        self.id = id  # type: long
        self.rule_id = rule_id  # type: long
        self.type = TeaConverter.to_unicode(type)  # type: unicode
        self.configuration = TeaConverter.to_unicode(configuration)  # type: unicode
        self.error_action_flag = error_action_flag  # type: bool

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.type is not None:
            result['Type'] = self.type
        if self.configuration is not None:
            result['Configuration'] = self.configuration
        if self.error_action_flag is not None:
            result['ErrorActionFlag'] = self.error_action_flag
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Configuration') is not None:
            self.configuration = m.get('Configuration')
        if m.get('ErrorActionFlag') is not None:
            self.error_action_flag = m.get('ErrorActionFlag')
        return self


class ListRuleActionsResponseBodyRuleActionList(TeaModel):
    def __init__(self, rule_action_info=None):
        self.rule_action_info = rule_action_info  # type: list[ListRuleActionsResponseBodyRuleActionListRuleActionInfo]

    def validate(self):
        if self.rule_action_info:
            for k in self.rule_action_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['RuleActionInfo'] = []
        if self.rule_action_info is not None:
            for k in self.rule_action_info:
                result['RuleActionInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.rule_action_info = []
        if m.get('RuleActionInfo') is not None:
            for k in m.get('RuleActionInfo'):
                temp_model = ListRuleActionsResponseBodyRuleActionListRuleActionInfo()
                self.rule_action_info.append(temp_model.from_map(k))
        return self


class ListRuleActionsResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, rule_action_list=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.rule_action_list = rule_action_list  # type: ListRuleActionsResponseBodyRuleActionList

    def validate(self):
        if self.rule_action_list:
            self.rule_action_list.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.rule_action_list is not None:
            result['RuleActionList'] = self.rule_action_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('RuleActionList') is not None:
            temp_model = ListRuleActionsResponseBodyRuleActionList()
            self.rule_action_list = temp_model.from_map(m['RuleActionList'])
        return self


class ListRuleActionsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: ListRuleActionsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListRuleActionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListTaskRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, limit=None, job_id=None,
                 next_token=None, device=None, status=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.limit = limit  # type: int
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.next_token = TeaConverter.to_unicode(next_token)  # type: unicode
        self.device = TeaConverter.to_unicode(device)  # type: unicode
        self.status = TeaConverter.to_unicode(status)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.limit is not None:
            result['Limit'] = self.limit
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.device is not None:
            result['Device'] = self.device
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('Limit') is not None:
            self.limit = m.get('Limit')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Device') is not None:
            self.device = m.get('Device')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListTaskResponseBodyDataData(TeaModel):
    def __init__(self, job_id=None, job_name=None, task_id=None, product_key=None, device_name=None, iot_id=None,
                 progress=None, utc_queue_time=None, utc_modified=None, status=None):
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.job_name = TeaConverter.to_unicode(job_name)  # type: unicode
        self.task_id = TeaConverter.to_unicode(task_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.progress = TeaConverter.to_unicode(progress)  # type: unicode
        self.utc_queue_time = TeaConverter.to_unicode(utc_queue_time)  # type: unicode
        self.utc_modified = TeaConverter.to_unicode(utc_modified)  # type: unicode
        self.status = TeaConverter.to_unicode(status)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.utc_queue_time is not None:
            result['UtcQueueTime'] = self.utc_queue_time
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('UtcQueueTime') is not None:
            self.utc_queue_time = m.get('UtcQueueTime')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListTaskResponseBodyData(TeaModel):
    def __init__(self, data=None):
        self.data = data  # type: list[ListTaskResponseBodyDataData]

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = ListTaskResponseBodyDataData()
                self.data.append(temp_model.from_map(k))
        return self


class ListTaskResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, next_token=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.next_token = TeaConverter.to_unicode(next_token)  # type: unicode
        self.data = data  # type: ListTaskResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('Data') is not None:
            temp_model = ListTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListTaskResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: ListTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListTaskByPageRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, page_size=None, page_no=None,
                 job_id=None, device=None, status=None, device_name=None, job_name=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.page_size = TeaConverter.to_unicode(page_size)  # type: unicode
        self.page_no = TeaConverter.to_unicode(page_no)  # type: unicode
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.device = TeaConverter.to_unicode(device)  # type: unicode
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.job_name = TeaConverter.to_unicode(job_name)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.device is not None:
            result['Device'] = self.device
        if self.status is not None:
            result['Status'] = self.status
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.job_name is not None:
            result['JobName'] = self.job_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Device') is not None:
            self.device = m.get('Device')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        return self


class ListTaskByPageResponseBodyDataData(TeaModel):
    def __init__(self, job_id=None, job_name=None, task_id=None, product_key=None, device_name=None, iot_id=None,
                 progress=None, utc_queue_time=None, utc_modified=None, status_detail=None, status=None, product_name=None):
        self.job_id = TeaConverter.to_unicode(job_id)  # type: unicode
        self.job_name = TeaConverter.to_unicode(job_name)  # type: unicode
        self.task_id = TeaConverter.to_unicode(task_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.progress = progress  # type: int
        self.utc_queue_time = TeaConverter.to_unicode(utc_queue_time)  # type: unicode
        self.utc_modified = TeaConverter.to_unicode(utc_modified)  # type: unicode
        self.status_detail = TeaConverter.to_unicode(status_detail)  # type: unicode
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.product_name = TeaConverter.to_unicode(product_name)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.job_name is not None:
            result['JobName'] = self.job_name
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.utc_queue_time is not None:
            result['UtcQueueTime'] = self.utc_queue_time
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.status_detail is not None:
            result['StatusDetail'] = self.status_detail
        if self.status is not None:
            result['Status'] = self.status
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('JobName') is not None:
            self.job_name = m.get('JobName')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('UtcQueueTime') is not None:
            self.utc_queue_time = m.get('UtcQueueTime')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('StatusDetail') is not None:
            self.status_detail = m.get('StatusDetail')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        return self


class ListTaskByPageResponseBodyData(TeaModel):
    def __init__(self, data=None):
        self.data = data  # type: list[ListTaskByPageResponseBodyDataData]

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['data'] = []
        if self.data is not None:
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('data') is not None:
            for k in m.get('data'):
                temp_model = ListTaskByPageResponseBodyDataData()
                self.data.append(temp_model.from_map(k))
        return self


class ListTaskByPageResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, total=None, page_size=None,
                 page_count=None, page=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.total = total  # type: int
        self.page_size = page_size  # type: int
        self.page_count = page_count  # type: int
        self.page = page  # type: int
        self.data = data  # type: ListTaskByPageResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.page is not None:
            result['Page'] = self.page
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('Data') is not None:
            temp_model = ListTaskByPageResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListTaskByPageResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: ListTaskByPageResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListTaskByPageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListThingModelVersionRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, resource_group_id=None,
                 product_key=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.resource_group_id = TeaConverter.to_unicode(resource_group_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        return self


class ListThingModelVersionResponseBodyDataModelVersions(TeaModel):
    def __init__(self, model_version=None, description=None, gmt_create=None):
        self.model_version = TeaConverter.to_unicode(model_version)  # type: unicode
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.gmt_create = gmt_create  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.model_version is not None:
            result['ModelVersion'] = self.model_version
        if self.description is not None:
            result['Description'] = self.description
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ModelVersion') is not None:
            self.model_version = m.get('ModelVersion')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        return self


class ListThingModelVersionResponseBodyData(TeaModel):
    def __init__(self, model_versions=None):
        self.model_versions = model_versions  # type: list[ListThingModelVersionResponseBodyDataModelVersions]

    def validate(self):
        if self.model_versions:
            for k in self.model_versions:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['ModelVersions'] = []
        if self.model_versions is not None:
            for k in self.model_versions:
                result['ModelVersions'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.model_versions = []
        if m.get('ModelVersions') is not None:
            for k in m.get('ModelVersions'):
                temp_model = ListThingModelVersionResponseBodyDataModelVersions()
                self.model_versions.append(temp_model.from_map(k))
        return self


class ListThingModelVersionResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: ListThingModelVersionResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = ListThingModelVersionResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class ListThingModelVersionResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: ListThingModelVersionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListThingModelVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListThingTemplatesRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, resource_group_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.resource_group_id = TeaConverter.to_unicode(resource_group_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class ListThingTemplatesResponseBodyData(TeaModel):
    def __init__(self, category_key=None, category_name=None):
        self.category_key = TeaConverter.to_unicode(category_key)  # type: unicode
        self.category_name = TeaConverter.to_unicode(category_name)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.category_key is not None:
            result['CategoryKey'] = self.category_key
        if self.category_name is not None:
            result['CategoryName'] = self.category_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CategoryKey') is not None:
            self.category_key = m.get('CategoryKey')
        if m.get('CategoryName') is not None:
            self.category_name = m.get('CategoryName')
        return self


class ListThingTemplatesResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: list[ListThingTemplatesResponseBodyData]

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListThingTemplatesResponseBodyData()
                self.data.append(temp_model.from_map(k))
        return self


class ListThingTemplatesResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: ListThingTemplatesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListThingTemplatesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class NotifyAddThingTopoRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, device_list_str=None,
                 gw_iot_id=None, gw_product_key=None, gw_device_name=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.device_list_str = TeaConverter.to_unicode(device_list_str)  # type: unicode
        self.gw_iot_id = TeaConverter.to_unicode(gw_iot_id)  # type: unicode
        self.gw_product_key = TeaConverter.to_unicode(gw_product_key)  # type: unicode
        self.gw_device_name = TeaConverter.to_unicode(gw_device_name)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.device_list_str is not None:
            result['DeviceListStr'] = self.device_list_str
        if self.gw_iot_id is not None:
            result['GwIotId'] = self.gw_iot_id
        if self.gw_product_key is not None:
            result['GwProductKey'] = self.gw_product_key
        if self.gw_device_name is not None:
            result['GwDeviceName'] = self.gw_device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('DeviceListStr') is not None:
            self.device_list_str = m.get('DeviceListStr')
        if m.get('GwIotId') is not None:
            self.gw_iot_id = m.get('GwIotId')
        if m.get('GwProductKey') is not None:
            self.gw_product_key = m.get('GwProductKey')
        if m.get('GwDeviceName') is not None:
            self.gw_device_name = m.get('GwDeviceName')
        return self


class NotifyAddThingTopoResponseBodyData(TeaModel):
    def __init__(self, message_id=None):
        self.message_id = TeaConverter.to_unicode(message_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        return self


class NotifyAddThingTopoResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.data = data  # type: NotifyAddThingTopoResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = NotifyAddThingTopoResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class NotifyAddThingTopoResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: NotifyAddThingTopoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = NotifyAddThingTopoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class PubRequestUserProp(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = TeaConverter.to_unicode(key)  # type: unicode
        self.value = TeaConverter.to_unicode(value)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class PubRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, product_key=None, qos=None,
                 topic_full_name=None, message_content=None, response_topic=None, correlation_data=None, user_prop=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.qos = qos  # type: int
        self.topic_full_name = TeaConverter.to_unicode(topic_full_name)  # type: unicode
        self.message_content = TeaConverter.to_unicode(message_content)  # type: unicode
        self.response_topic = TeaConverter.to_unicode(response_topic)  # type: unicode
        self.correlation_data = TeaConverter.to_unicode(correlation_data)  # type: unicode
        self.user_prop = user_prop  # type: list[PubRequestUserProp]

    def validate(self):
        if self.user_prop:
            for k in self.user_prop:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.qos is not None:
            result['Qos'] = self.qos
        if self.topic_full_name is not None:
            result['TopicFullName'] = self.topic_full_name
        if self.message_content is not None:
            result['MessageContent'] = self.message_content
        if self.response_topic is not None:
            result['ResponseTopic'] = self.response_topic
        if self.correlation_data is not None:
            result['CorrelationData'] = self.correlation_data
        result['UserProp'] = []
        if self.user_prop is not None:
            for k in self.user_prop:
                result['UserProp'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Qos') is not None:
            self.qos = m.get('Qos')
        if m.get('TopicFullName') is not None:
            self.topic_full_name = m.get('TopicFullName')
        if m.get('MessageContent') is not None:
            self.message_content = m.get('MessageContent')
        if m.get('ResponseTopic') is not None:
            self.response_topic = m.get('ResponseTopic')
        if m.get('CorrelationData') is not None:
            self.correlation_data = m.get('CorrelationData')
        self.user_prop = []
        if m.get('UserProp') is not None:
            for k in m.get('UserProp'):
                temp_model = PubRequestUserProp()
                self.user_prop.append(temp_model.from_map(k))
        return self


class PubResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, message_id=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.message_id = TeaConverter.to_unicode(message_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        return self


class PubResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: PubResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = PubResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class PubBroadcastRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, product_key=None,
                 topic_full_name=None, message_content=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.topic_full_name = TeaConverter.to_unicode(topic_full_name)  # type: unicode
        self.message_content = TeaConverter.to_unicode(message_content)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.topic_full_name is not None:
            result['TopicFullName'] = self.topic_full_name
        if self.message_content is not None:
            result['MessageContent'] = self.message_content
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('TopicFullName') is not None:
            self.topic_full_name = m.get('TopicFullName')
        if m.get('MessageContent') is not None:
            self.message_content = m.get('MessageContent')
        return self


class PubBroadcastResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, message_id=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.message_id = message_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.message_id is not None:
            result['MessageId'] = self.message_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('MessageId') is not None:
            self.message_id = m.get('MessageId')
        return self


class PubBroadcastResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: PubBroadcastResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = PubBroadcastResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class PublishThingModelRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, resource_group_id=None,
                 product_key=None, model_version=None, description=None, real_tenant_id=None, real_tripartite_key=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.resource_group_id = TeaConverter.to_unicode(resource_group_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.model_version = TeaConverter.to_unicode(model_version)  # type: unicode
        self.description = TeaConverter.to_unicode(description)  # type: unicode
        self.real_tenant_id = TeaConverter.to_unicode(real_tenant_id)  # type: unicode
        self.real_tripartite_key = TeaConverter.to_unicode(real_tripartite_key)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.model_version is not None:
            result['ModelVersion'] = self.model_version
        if self.description is not None:
            result['Description'] = self.description
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ModelVersion') is not None:
            self.model_version = m.get('ModelVersion')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        return self


class PublishThingModelResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        return self


class PublishThingModelResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: PublishThingModelResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = PublishThingModelResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryAppDeviceListRequestTagList(TeaModel):
    def __init__(self, tag_name=None, tag_value=None):
        self.tag_name = TeaConverter.to_unicode(tag_name)  # type: unicode
        self.tag_value = TeaConverter.to_unicode(tag_value)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.tag_name is not None:
            result['TagName'] = self.tag_name
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagName') is not None:
            self.tag_name = m.get('TagName')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class QueryAppDeviceListRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, page_size=None,
                 product_key_list=None, category_key_list=None, app_key=None, tag_list=None, current_page=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.page_size = page_size  # type: int
        self.product_key_list = product_key_list  # type: list[unicode]
        self.category_key_list = category_key_list  # type: list[unicode]
        self.app_key = TeaConverter.to_unicode(app_key)  # type: unicode
        self.tag_list = tag_list  # type: list[QueryAppDeviceListRequestTagList]
        self.current_page = current_page  # type: int

    def validate(self):
        if self.tag_list:
            for k in self.tag_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key_list is not None:
            result['ProductKeyList'] = self.product_key_list
        if self.category_key_list is not None:
            result['CategoryKeyList'] = self.category_key_list
        if self.app_key is not None:
            result['AppKey'] = self.app_key
        result['TagList'] = []
        if self.tag_list is not None:
            for k in self.tag_list:
                result['TagList'].append(k.to_map() if k else None)
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKeyList') is not None:
            self.product_key_list = m.get('ProductKeyList')
        if m.get('CategoryKeyList') is not None:
            self.category_key_list = m.get('CategoryKeyList')
        if m.get('AppKey') is not None:
            self.app_key = m.get('AppKey')
        self.tag_list = []
        if m.get('TagList') is not None:
            for k in m.get('TagList'):
                temp_model = QueryAppDeviceListRequestTagList()
                self.tag_list.append(temp_model.from_map(k))
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class QueryAppDeviceListResponseBodyDataData(TeaModel):
    def __init__(self, product_name=None, product_key=None, device_name=None, node_type=None, status=None,
                 active_time=None, last_online_time=None, create_time=None, child_device_count=None, utc_active_time=None,
                 utc_last_online_time=None, utc_create_time=None):
        self.product_name = TeaConverter.to_unicode(product_name)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.node_type = node_type  # type: int
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.active_time = TeaConverter.to_unicode(active_time)  # type: unicode
        self.last_online_time = TeaConverter.to_unicode(last_online_time)  # type: unicode
        self.create_time = TeaConverter.to_unicode(create_time)  # type: unicode
        self.child_device_count = child_device_count  # type: long
        self.utc_active_time = TeaConverter.to_unicode(utc_active_time)  # type: unicode
        self.utc_last_online_time = TeaConverter.to_unicode(utc_last_online_time)  # type: unicode
        self.utc_create_time = TeaConverter.to_unicode(utc_create_time)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.status is not None:
            result['Status'] = self.status
        if self.active_time is not None:
            result['ActiveTime'] = self.active_time
        if self.last_online_time is not None:
            result['LastOnlineTime'] = self.last_online_time
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.child_device_count is not None:
            result['ChildDeviceCount'] = self.child_device_count
        if self.utc_active_time is not None:
            result['UtcActiveTime'] = self.utc_active_time
        if self.utc_last_online_time is not None:
            result['UtcLastOnlineTime'] = self.utc_last_online_time
        if self.utc_create_time is not None:
            result['UtcCreateTime'] = self.utc_create_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ActiveTime') is not None:
            self.active_time = m.get('ActiveTime')
        if m.get('LastOnlineTime') is not None:
            self.last_online_time = m.get('LastOnlineTime')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ChildDeviceCount') is not None:
            self.child_device_count = m.get('ChildDeviceCount')
        if m.get('UtcActiveTime') is not None:
            self.utc_active_time = m.get('UtcActiveTime')
        if m.get('UtcLastOnlineTime') is not None:
            self.utc_last_online_time = m.get('UtcLastOnlineTime')
        if m.get('UtcCreateTime') is not None:
            self.utc_create_time = m.get('UtcCreateTime')
        return self


class QueryAppDeviceListResponseBodyData(TeaModel):
    def __init__(self, data=None):
        self.data = data  # type: list[QueryAppDeviceListResponseBodyDataData]

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = QueryAppDeviceListResponseBodyDataData()
                self.data.append(temp_model.from_map(k))
        return self


class QueryAppDeviceListResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None, page=None, page_size=None,
                 page_count=None, total=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.page = page  # type: int
        self.page_size = page_size  # type: int
        self.page_count = page_count  # type: int
        self.total = total  # type: int
        self.data = data  # type: QueryAppDeviceListResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.total is not None:
            result['Total'] = self.total
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Data') is not None:
            temp_model = QueryAppDeviceListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryAppDeviceListResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: QueryAppDeviceListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryAppDeviceListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryBatchRegisterDeviceStatusRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, product_key=None, apply_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.apply_id = apply_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.apply_id is not None:
            result['ApplyId'] = self.apply_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ApplyId') is not None:
            self.apply_id = m.get('ApplyId')
        return self


class QueryBatchRegisterDeviceStatusResponseBodyDataValidList(TeaModel):
    def __init__(self, name=None):
        self.name = name  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class QueryBatchRegisterDeviceStatusResponseBodyDataInvalidList(TeaModel):
    def __init__(self, name=None):
        self.name = name  # type: list[unicode]

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class QueryBatchRegisterDeviceStatusResponseBodyData(TeaModel):
    def __init__(self, status=None, valid_list=None, invalid_list=None):
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.valid_list = valid_list  # type: QueryBatchRegisterDeviceStatusResponseBodyDataValidList
        self.invalid_list = invalid_list  # type: QueryBatchRegisterDeviceStatusResponseBodyDataInvalidList

    def validate(self):
        if self.valid_list:
            self.valid_list.validate()
        if self.invalid_list:
            self.invalid_list.validate()

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.valid_list is not None:
            result['ValidList'] = self.valid_list.to_map()
        if self.invalid_list is not None:
            result['InvalidList'] = self.invalid_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ValidList') is not None:
            temp_model = QueryBatchRegisterDeviceStatusResponseBodyDataValidList()
            self.valid_list = temp_model.from_map(m['ValidList'])
        if m.get('InvalidList') is not None:
            temp_model = QueryBatchRegisterDeviceStatusResponseBodyDataInvalidList()
            self.invalid_list = temp_model.from_map(m['InvalidList'])
        return self


class QueryBatchRegisterDeviceStatusResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: QueryBatchRegisterDeviceStatusResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryBatchRegisterDeviceStatusResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryBatchRegisterDeviceStatusResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: QueryBatchRegisterDeviceStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryBatchRegisterDeviceStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryCertUrlByApplyIdRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, apply_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.apply_id = apply_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.apply_id is not None:
            result['ApplyId'] = self.apply_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ApplyId') is not None:
            self.apply_id = m.get('ApplyId')
        return self


class QueryCertUrlByApplyIdResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, cert_url=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.cert_url = TeaConverter.to_unicode(cert_url)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.cert_url is not None:
            result['CertUrl'] = self.cert_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('CertUrl') is not None:
            self.cert_url = m.get('CertUrl')
        return self


class QueryCertUrlByApplyIdResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: QueryCertUrlByApplyIdResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryCertUrlByApplyIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryClientIdsRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_id=None, iot_instance_id=None, auth_config=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.auth_config = TeaConverter.to_unicode(auth_config)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.auth_config is not None:
            result['AuthConfig'] = self.auth_config
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('AuthConfig') is not None:
            self.auth_config = m.get('AuthConfig')
        return self


class QueryClientIdsResponseBodyDataDynamicRegClientIds(TeaModel):
    def __init__(self, client_id=None, create_time=None):
        self.client_id = TeaConverter.to_unicode(client_id)  # type: unicode
        self.create_time = create_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.client_id is not None:
            result['ClientId'] = self.client_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientId') is not None:
            self.client_id = m.get('ClientId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        return self


class QueryClientIdsResponseBodyData(TeaModel):
    def __init__(self, iot_id=None, dynamic_reg_client_ids=None):
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.dynamic_reg_client_ids = dynamic_reg_client_ids  # type: list[QueryClientIdsResponseBodyDataDynamicRegClientIds]

    def validate(self):
        if self.dynamic_reg_client_ids:
            for k in self.dynamic_reg_client_ids:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        result['DynamicRegClientIds'] = []
        if self.dynamic_reg_client_ids is not None:
            for k in self.dynamic_reg_client_ids:
                result['DynamicRegClientIds'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        self.dynamic_reg_client_ids = []
        if m.get('DynamicRegClientIds') is not None:
            for k in m.get('DynamicRegClientIds'):
                temp_model = QueryClientIdsResponseBodyDataDynamicRegClientIds()
                self.dynamic_reg_client_ids.append(temp_model.from_map(k))
        return self


class QueryClientIdsResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: QueryClientIdsResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryClientIdsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryClientIdsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: QueryClientIdsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryClientIdsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryConsumerGroupByGroupIdRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, group_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.group_id = TeaConverter.to_unicode(group_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class QueryConsumerGroupByGroupIdResponseBodyData(TeaModel):
    def __init__(self, group_id=None, group_name=None, create_time=None):
        self.group_id = TeaConverter.to_unicode(group_id)  # type: unicode
        self.group_name = TeaConverter.to_unicode(group_name)  # type: unicode
        self.create_time = TeaConverter.to_unicode(create_time)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        return self


class QueryConsumerGroupByGroupIdResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.data = data  # type: QueryConsumerGroupByGroupIdResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryConsumerGroupByGroupIdResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryConsumerGroupByGroupIdResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: QueryConsumerGroupByGroupIdResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryConsumerGroupByGroupIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryConsumerGroupListRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, page_size=None, current_page=None,
                 fuzzy=None, group_name=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.page_size = page_size  # type: int
        self.current_page = current_page  # type: int
        self.fuzzy = fuzzy  # type: bool
        self.group_name = TeaConverter.to_unicode(group_name)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.fuzzy is not None:
            result['Fuzzy'] = self.fuzzy
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Fuzzy') is not None:
            self.fuzzy = m.get('Fuzzy')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class QueryConsumerGroupListResponseBodyDataConsumerGroupDTO(TeaModel):
    def __init__(self, group_id=None, group_name=None, create_time=None):
        self.group_id = TeaConverter.to_unicode(group_id)  # type: unicode
        self.group_name = TeaConverter.to_unicode(group_name)  # type: unicode
        self.create_time = TeaConverter.to_unicode(create_time)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        return self


class QueryConsumerGroupListResponseBodyData(TeaModel):
    def __init__(self, consumer_group_dto=None):
        self.consumer_group_dto = consumer_group_dto  # type: list[QueryConsumerGroupListResponseBodyDataConsumerGroupDTO]

    def validate(self):
        if self.consumer_group_dto:
            for k in self.consumer_group_dto:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['ConsumerGroupDTO'] = []
        if self.consumer_group_dto is not None:
            for k in self.consumer_group_dto:
                result['ConsumerGroupDTO'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.consumer_group_dto = []
        if m.get('ConsumerGroupDTO') is not None:
            for k in m.get('ConsumerGroupDTO'):
                temp_model = QueryConsumerGroupListResponseBodyDataConsumerGroupDTO()
                self.consumer_group_dto.append(temp_model.from_map(k))
        return self


class QueryConsumerGroupListResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, page_size=None, page_count=None,
                 total=None, current_page=None, code=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.page_size = page_size  # type: int
        self.page_count = page_count  # type: int
        self.total = total  # type: int
        self.current_page = current_page  # type: int
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.data = data  # type: QueryConsumerGroupListResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.total is not None:
            result['Total'] = self.total
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryConsumerGroupListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryConsumerGroupListResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: QueryConsumerGroupListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryConsumerGroupListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryConsumerGroupStatusRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, group_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.group_id = TeaConverter.to_unicode(group_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class QueryConsumerGroupStatusResponseBodyClientConnectionStatusListConsumerGroupClientConnectionInfo(TeaModel):
    def __init__(self, client_id=None, client_ip_port=None, online_time=None):
        self.client_id = TeaConverter.to_unicode(client_id)  # type: unicode
        self.client_ip_port = TeaConverter.to_unicode(client_ip_port)  # type: unicode
        self.online_time = online_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.client_id is not None:
            result['ClientId'] = self.client_id
        if self.client_ip_port is not None:
            result['ClientIpPort'] = self.client_ip_port
        if self.online_time is not None:
            result['OnlineTime'] = self.online_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientId') is not None:
            self.client_id = m.get('ClientId')
        if m.get('ClientIpPort') is not None:
            self.client_ip_port = m.get('ClientIpPort')
        if m.get('OnlineTime') is not None:
            self.online_time = m.get('OnlineTime')
        return self


class QueryConsumerGroupStatusResponseBodyClientConnectionStatusList(TeaModel):
    def __init__(self, consumer_group_client_connection_info=None):
        self.consumer_group_client_connection_info = consumer_group_client_connection_info  # type: list[QueryConsumerGroupStatusResponseBodyClientConnectionStatusListConsumerGroupClientConnectionInfo]

    def validate(self):
        if self.consumer_group_client_connection_info:
            for k in self.consumer_group_client_connection_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['ConsumerGroupClientConnectionInfo'] = []
        if self.consumer_group_client_connection_info is not None:
            for k in self.consumer_group_client_connection_info:
                result['ConsumerGroupClientConnectionInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.consumer_group_client_connection_info = []
        if m.get('ConsumerGroupClientConnectionInfo') is not None:
            for k in m.get('ConsumerGroupClientConnectionInfo'):
                temp_model = QueryConsumerGroupStatusResponseBodyClientConnectionStatusListConsumerGroupClientConnectionInfo()
                self.consumer_group_client_connection_info.append(temp_model.from_map(k))
        return self


class QueryConsumerGroupStatusResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, accumulation_count=None,
                 consumer_speed=None, last_consumer_time=None, code=None, client_connection_status_list=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.accumulation_count = accumulation_count  # type: int
        self.consumer_speed = consumer_speed  # type: int
        self.last_consumer_time = TeaConverter.to_unicode(last_consumer_time)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.client_connection_status_list = client_connection_status_list  # type: QueryConsumerGroupStatusResponseBodyClientConnectionStatusList

    def validate(self):
        if self.client_connection_status_list:
            self.client_connection_status_list.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.accumulation_count is not None:
            result['AccumulationCount'] = self.accumulation_count
        if self.consumer_speed is not None:
            result['ConsumerSpeed'] = self.consumer_speed
        if self.last_consumer_time is not None:
            result['LastConsumerTime'] = self.last_consumer_time
        if self.code is not None:
            result['Code'] = self.code
        if self.client_connection_status_list is not None:
            result['ClientConnectionStatusList'] = self.client_connection_status_list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('AccumulationCount') is not None:
            self.accumulation_count = m.get('AccumulationCount')
        if m.get('ConsumerSpeed') is not None:
            self.consumer_speed = m.get('ConsumerSpeed')
        if m.get('LastConsumerTime') is not None:
            self.last_consumer_time = m.get('LastConsumerTime')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ClientConnectionStatusList') is not None:
            temp_model = QueryConsumerGroupStatusResponseBodyClientConnectionStatusList()
            self.client_connection_status_list = temp_model.from_map(m['ClientConnectionStatusList'])
        return self


class QueryConsumerGroupStatusResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: QueryConsumerGroupStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryConsumerGroupStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDetailSceneRuleLogRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, rule_id=None, start_time=None,
                 end_time=None, trace_id=None, page_size=None, current_page=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.rule_id = TeaConverter.to_unicode(rule_id)  # type: unicode
        self.start_time = start_time  # type: int
        self.end_time = end_time  # type: int
        self.trace_id = TeaConverter.to_unicode(trace_id)  # type: unicode
        self.page_size = page_size  # type: int
        self.current_page = current_page  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class QueryDetailSceneRuleLogResponseBodyDataLogList(TeaModel):
    def __init__(self, code=None, message=None, pk_dn=None):
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.message = TeaConverter.to_unicode(message)  # type: unicode
        self.pk_dn = TeaConverter.to_unicode(pk_dn)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.pk_dn is not None:
            result['PkDn'] = self.pk_dn
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PkDn') is not None:
            self.pk_dn = m.get('PkDn')
        return self


class QueryDetailSceneRuleLogResponseBodyData(TeaModel):
    def __init__(self, total=None, page_size=None, current_page=None, log_list=None):
        self.total = total  # type: int
        self.page_size = page_size  # type: int
        self.current_page = current_page  # type: int
        self.log_list = log_list  # type: list[QueryDetailSceneRuleLogResponseBodyDataLogList]

    def validate(self):
        if self.log_list:
            for k in self.log_list:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['LogList'] = []
        if self.log_list is not None:
            for k in self.log_list:
                result['LogList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.log_list = []
        if m.get('LogList') is not None:
            for k in m.get('LogList'):
                temp_model = QueryDetailSceneRuleLogResponseBodyDataLogList()
                self.log_list.append(temp_model.from_map(k))
        return self


class QueryDetailSceneRuleLogResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, error_message=None, code=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.data = data  # type: QueryDetailSceneRuleLogResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryDetailSceneRuleLogResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDetailSceneRuleLogResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: QueryDetailSceneRuleLogResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDetailSceneRuleLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, page_size=None, product_key=None,
                 current_page=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.page_size = page_size  # type: int
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.current_page = current_page  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class QueryDeviceResponseBodyDataDeviceInfo(TeaModel):
    def __init__(self, device_id=None, device_secret=None, product_key=None, device_status=None, device_name=None,
                 device_type=None, gmt_create=None, gmt_modified=None, utc_create=None, utc_modified=None, iot_id=None,
                 nickname=None):
        self.device_id = TeaConverter.to_unicode(device_id)  # type: unicode
        self.device_secret = TeaConverter.to_unicode(device_secret)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_status = TeaConverter.to_unicode(device_status)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.device_type = TeaConverter.to_unicode(device_type)  # type: unicode
        self.gmt_create = TeaConverter.to_unicode(gmt_create)  # type: unicode
        self.gmt_modified = TeaConverter.to_unicode(gmt_modified)  # type: unicode
        self.utc_create = TeaConverter.to_unicode(utc_create)  # type: unicode
        self.utc_modified = TeaConverter.to_unicode(utc_modified)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.nickname = TeaConverter.to_unicode(nickname)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.device_id is not None:
            result['DeviceId'] = self.device_id
        if self.device_secret is not None:
            result['DeviceSecret'] = self.device_secret
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_status is not None:
            result['DeviceStatus'] = self.device_status
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_type is not None:
            result['DeviceType'] = self.device_type
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.nickname is not None:
            result['Nickname'] = self.nickname
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeviceId') is not None:
            self.device_id = m.get('DeviceId')
        if m.get('DeviceSecret') is not None:
            self.device_secret = m.get('DeviceSecret')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceStatus') is not None:
            self.device_status = m.get('DeviceStatus')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DeviceType') is not None:
            self.device_type = m.get('DeviceType')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('Nickname') is not None:
            self.nickname = m.get('Nickname')
        return self


class QueryDeviceResponseBodyData(TeaModel):
    def __init__(self, device_info=None):
        self.device_info = device_info  # type: list[QueryDeviceResponseBodyDataDeviceInfo]

    def validate(self):
        if self.device_info:
            for k in self.device_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['DeviceInfo'] = []
        if self.device_info is not None:
            for k in self.device_info:
                result['DeviceInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.device_info = []
        if m.get('DeviceInfo') is not None:
            for k in m.get('DeviceInfo'):
                temp_model = QueryDeviceResponseBodyDataDeviceInfo()
                self.device_info.append(temp_model.from_map(k))
        return self


class QueryDeviceResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, total=None, page_size=None,
                 page_count=None, page=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.total = total  # type: int
        self.page_size = page_size  # type: int
        self.page_count = page_count  # type: int
        self.page = page  # type: int
        self.data = data  # type: QueryDeviceResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total is not None:
            result['Total'] = self.total
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.page is not None:
            result['Page'] = self.page
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('Data') is not None:
            temp_model = QueryDeviceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: QueryDeviceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceBySQLRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, sql=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.sql = TeaConverter.to_unicode(sql)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.sql is not None:
            result['SQL'] = self.sql
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('SQL') is not None:
            self.sql = m.get('SQL')
        return self


class QueryDeviceBySQLResponseBodyDataGroups(TeaModel):
    def __init__(self, group_id=None):
        self.group_id = TeaConverter.to_unicode(group_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class QueryDeviceBySQLResponseBodyDataTags(TeaModel):
    def __init__(self, tag_name=None, tag_value=None):
        self.tag_name = TeaConverter.to_unicode(tag_name)  # type: unicode
        self.tag_value = TeaConverter.to_unicode(tag_value)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.tag_name is not None:
            result['TagName'] = self.tag_name
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagName') is not None:
            self.tag_name = m.get('TagName')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class QueryDeviceBySQLResponseBodyDataOTAModules(TeaModel):
    def __init__(self, module_name=None, firmware_version=None):
        self.module_name = TeaConverter.to_unicode(module_name)  # type: unicode
        self.firmware_version = TeaConverter.to_unicode(firmware_version)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        if self.firmware_version is not None:
            result['FirmwareVersion'] = self.firmware_version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        if m.get('FirmwareVersion') is not None:
            self.firmware_version = m.get('FirmwareVersion')
        return self


class QueryDeviceBySQLResponseBodyData(TeaModel):
    def __init__(self, product_key=None, device_name=None, nickname=None, status=None, active_time=None, iot_id=None,
                 gmt_create=None, gmt_modified=None, groups=None, tags=None, otamodules=None):
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.nickname = TeaConverter.to_unicode(nickname)  # type: unicode
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.active_time = TeaConverter.to_unicode(active_time)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.gmt_create = TeaConverter.to_unicode(gmt_create)  # type: unicode
        self.gmt_modified = TeaConverter.to_unicode(gmt_modified)  # type: unicode
        self.groups = groups  # type: list[QueryDeviceBySQLResponseBodyDataGroups]
        self.tags = tags  # type: list[QueryDeviceBySQLResponseBodyDataTags]
        self.otamodules = otamodules  # type: list[QueryDeviceBySQLResponseBodyDataOTAModules]

    def validate(self):
        if self.groups:
            for k in self.groups:
                if k:
                    k.validate()
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()
        if self.otamodules:
            for k in self.otamodules:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.nickname is not None:
            result['Nickname'] = self.nickname
        if self.status is not None:
            result['Status'] = self.status
        if self.active_time is not None:
            result['ActiveTime'] = self.active_time
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        result['Groups'] = []
        if self.groups is not None:
            for k in self.groups:
                result['Groups'].append(k.to_map() if k else None)
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        result['OTAModules'] = []
        if self.otamodules is not None:
            for k in self.otamodules:
                result['OTAModules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Nickname') is not None:
            self.nickname = m.get('Nickname')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ActiveTime') is not None:
            self.active_time = m.get('ActiveTime')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        self.groups = []
        if m.get('Groups') is not None:
            for k in m.get('Groups'):
                temp_model = QueryDeviceBySQLResponseBodyDataGroups()
                self.groups.append(temp_model.from_map(k))
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = QueryDeviceBySQLResponseBodyDataTags()
                self.tags.append(temp_model.from_map(k))
        self.otamodules = []
        if m.get('OTAModules') is not None:
            for k in m.get('OTAModules'):
                temp_model = QueryDeviceBySQLResponseBodyDataOTAModules()
                self.otamodules.append(temp_model.from_map(k))
        return self


class QueryDeviceBySQLResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, total_count=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.total_count = total_count  # type: long
        self.data = data  # type: list[QueryDeviceBySQLResponseBodyData]

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = QueryDeviceBySQLResponseBodyData()
                self.data.append(temp_model.from_map(k))
        return self


class QueryDeviceBySQLResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: QueryDeviceBySQLResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceBySQLResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceByStatusRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, product_key=None, status=None,
                 current_page=None, page_size=None, biz_tenant_id=None, resource_group_id=None, real_tenant_id=None,
                 real_tripartite_key=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.status = status  # type: int
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int
        self.biz_tenant_id = TeaConverter.to_unicode(biz_tenant_id)  # type: unicode
        self.resource_group_id = TeaConverter.to_unicode(resource_group_id)  # type: unicode
        self.real_tenant_id = TeaConverter.to_unicode(real_tenant_id)  # type: unicode
        self.real_tripartite_key = TeaConverter.to_unicode(real_tripartite_key)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.status is not None:
            result['Status'] = self.status
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.biz_tenant_id is not None:
            result['BizTenantId'] = self.biz_tenant_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('BizTenantId') is not None:
            self.biz_tenant_id = m.get('BizTenantId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        return self


class QueryDeviceByStatusResponseBodyDataSimpleDeviceInfo(TeaModel):
    def __init__(self, product_key=None, device_name=None, status=None, iot_id=None, nickname=None, gmt_create=None,
                 gmt_modified=None, utc_create=None, utc_modified=None, device_secret=None):
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.nickname = TeaConverter.to_unicode(nickname)  # type: unicode
        self.gmt_create = TeaConverter.to_unicode(gmt_create)  # type: unicode
        self.gmt_modified = TeaConverter.to_unicode(gmt_modified)  # type: unicode
        self.utc_create = TeaConverter.to_unicode(utc_create)  # type: unicode
        self.utc_modified = TeaConverter.to_unicode(utc_modified)  # type: unicode
        self.device_secret = TeaConverter.to_unicode(device_secret)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.status is not None:
            result['Status'] = self.status
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.nickname is not None:
            result['Nickname'] = self.nickname
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.utc_modified is not None:
            result['UtcModified'] = self.utc_modified
        if self.device_secret is not None:
            result['DeviceSecret'] = self.device_secret
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('Nickname') is not None:
            self.nickname = m.get('Nickname')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('UtcModified') is not None:
            self.utc_modified = m.get('UtcModified')
        if m.get('DeviceSecret') is not None:
            self.device_secret = m.get('DeviceSecret')
        return self


class QueryDeviceByStatusResponseBodyData(TeaModel):
    def __init__(self, simple_device_info=None):
        self.simple_device_info = simple_device_info  # type: list[QueryDeviceByStatusResponseBodyDataSimpleDeviceInfo]

    def validate(self):
        if self.simple_device_info:
            for k in self.simple_device_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['SimpleDeviceInfo'] = []
        if self.simple_device_info is not None:
            for k in self.simple_device_info:
                result['SimpleDeviceInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.simple_device_info = []
        if m.get('SimpleDeviceInfo') is not None:
            for k in m.get('SimpleDeviceInfo'):
                temp_model = QueryDeviceByStatusResponseBodyDataSimpleDeviceInfo()
                self.simple_device_info.append(temp_model.from_map(k))
        return self


class QueryDeviceByStatusResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, page=None, page_size=None,
                 page_count=None, total=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.page = page  # type: int
        self.page_size = page_size  # type: int
        self.page_count = page_count  # type: int
        self.total = total  # type: int
        self.data = data  # type: QueryDeviceByStatusResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.total is not None:
            result['Total'] = self.total
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Data') is not None:
            temp_model = QueryDeviceByStatusResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceByStatusResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: QueryDeviceByStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceByStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceByTagsRequestTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = TeaConverter.to_unicode(tag_key)  # type: unicode
        self.tag_value = TeaConverter.to_unicode(tag_value)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class QueryDeviceByTagsRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, tag=None, current_page=None,
                 page_size=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.tag = tag  # type: list[QueryDeviceByTagsRequestTag]
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = QueryDeviceByTagsRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class QueryDeviceByTagsResponseBodyDataSimpleDeviceInfo(TeaModel):
    def __init__(self, product_name=None, product_key=None, device_name=None, iot_id=None):
        self.product_name = TeaConverter.to_unicode(product_name)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        return self


class QueryDeviceByTagsResponseBodyData(TeaModel):
    def __init__(self, simple_device_info=None):
        self.simple_device_info = simple_device_info  # type: list[QueryDeviceByTagsResponseBodyDataSimpleDeviceInfo]

    def validate(self):
        if self.simple_device_info:
            for k in self.simple_device_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['SimpleDeviceInfo'] = []
        if self.simple_device_info is not None:
            for k in self.simple_device_info:
                result['SimpleDeviceInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.simple_device_info = []
        if m.get('SimpleDeviceInfo') is not None:
            for k in m.get('SimpleDeviceInfo'):
                temp_model = QueryDeviceByTagsResponseBodyDataSimpleDeviceInfo()
                self.simple_device_info.append(temp_model.from_map(k))
        return self


class QueryDeviceByTagsResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, page=None, page_size=None,
                 page_count=None, total=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.page = page  # type: int
        self.page_size = page_size  # type: int
        self.page_count = page_count  # type: int
        self.total = total  # type: int
        self.data = data  # type: QueryDeviceByTagsResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.total is not None:
            result['Total'] = self.total
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Data') is not None:
            temp_model = QueryDeviceByTagsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceByTagsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: QueryDeviceByTagsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceByTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceCertRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, product_key=None,
                 device_name=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class QueryDeviceCertResponseBodyDeviceCertInfo(TeaModel):
    def __init__(self, status=None, certificate=None, private_key=None, cert_sn=None):
        self.status = status  # type: int
        self.certificate = TeaConverter.to_unicode(certificate)  # type: unicode
        self.private_key = TeaConverter.to_unicode(private_key)  # type: unicode
        self.cert_sn = TeaConverter.to_unicode(cert_sn)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.certificate is not None:
            result['Certificate'] = self.certificate
        if self.private_key is not None:
            result['PrivateKey'] = self.private_key
        if self.cert_sn is not None:
            result['CertSN'] = self.cert_sn
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Certificate') is not None:
            self.certificate = m.get('Certificate')
        if m.get('PrivateKey') is not None:
            self.private_key = m.get('PrivateKey')
        if m.get('CertSN') is not None:
            self.cert_sn = m.get('CertSN')
        return self


class QueryDeviceCertResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, device_cert_info=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.device_cert_info = device_cert_info  # type: QueryDeviceCertResponseBodyDeviceCertInfo

    def validate(self):
        if self.device_cert_info:
            self.device_cert_info.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.device_cert_info is not None:
            result['DeviceCertInfo'] = self.device_cert_info.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('DeviceCertInfo') is not None:
            temp_model = QueryDeviceCertResponseBodyDeviceCertInfo()
            self.device_cert_info = temp_model.from_map(m['DeviceCertInfo'])
        return self


class QueryDeviceCertResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: QueryDeviceCertResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceCertResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceDesiredPropertyRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, product_key=None,
                 device_name=None, identifier=None, iot_id=None, function_block_id=None, real_tenant_id=None,
                 real_tripartite_key=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.identifier = identifier  # type: list[unicode]
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.function_block_id = TeaConverter.to_unicode(function_block_id)  # type: unicode
        self.real_tenant_id = TeaConverter.to_unicode(real_tenant_id)  # type: unicode
        self.real_tripartite_key = TeaConverter.to_unicode(real_tripartite_key)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.function_block_id is not None:
            result['FunctionBlockId'] = self.function_block_id
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('FunctionBlockId') is not None:
            self.function_block_id = m.get('FunctionBlockId')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        return self


class QueryDeviceDesiredPropertyResponseBodyDataListDesiredPropertyInfo(TeaModel):
    def __init__(self, unit=None, identifier=None, data_type=None, time=None, value=None, name=None, version=None):
        self.unit = TeaConverter.to_unicode(unit)  # type: unicode
        self.identifier = TeaConverter.to_unicode(identifier)  # type: unicode
        self.data_type = TeaConverter.to_unicode(data_type)  # type: unicode
        self.time = TeaConverter.to_unicode(time)  # type: unicode
        self.value = TeaConverter.to_unicode(value)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.version = version  # type: long

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.unit is not None:
            result['Unit'] = self.unit
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.data_type is not None:
            result['DataType'] = self.data_type
        if self.time is not None:
            result['Time'] = self.time
        if self.value is not None:
            result['Value'] = self.value
        if self.name is not None:
            result['Name'] = self.name
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Unit') is not None:
            self.unit = m.get('Unit')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('DataType') is not None:
            self.data_type = m.get('DataType')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class QueryDeviceDesiredPropertyResponseBodyDataList(TeaModel):
    def __init__(self, desired_property_info=None):
        self.desired_property_info = desired_property_info  # type: list[QueryDeviceDesiredPropertyResponseBodyDataListDesiredPropertyInfo]

    def validate(self):
        if self.desired_property_info:
            for k in self.desired_property_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['DesiredPropertyInfo'] = []
        if self.desired_property_info is not None:
            for k in self.desired_property_info:
                result['DesiredPropertyInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.desired_property_info = []
        if m.get('DesiredPropertyInfo') is not None:
            for k in m.get('DesiredPropertyInfo'):
                temp_model = QueryDeviceDesiredPropertyResponseBodyDataListDesiredPropertyInfo()
                self.desired_property_info.append(temp_model.from_map(k))
        return self


class QueryDeviceDesiredPropertyResponseBodyData(TeaModel):
    def __init__(self, list=None):
        self.list = list  # type: QueryDeviceDesiredPropertyResponseBodyDataList

    def validate(self):
        if self.list:
            self.list.validate()

    def to_map(self):
        result = dict()
        if self.list is not None:
            result['List'] = self.list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('List') is not None:
            temp_model = QueryDeviceDesiredPropertyResponseBodyDataList()
            self.list = temp_model.from_map(m['List'])
        return self


class QueryDeviceDesiredPropertyResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: QueryDeviceDesiredPropertyResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryDeviceDesiredPropertyResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceDesiredPropertyResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: QueryDeviceDesiredPropertyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceDesiredPropertyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceDetailRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, product_key=None,
                 device_name=None, iot_id=None, real_tenant_id=None, real_tripartite_key=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.real_tenant_id = TeaConverter.to_unicode(real_tenant_id)  # type: unicode
        self.real_tripartite_key = TeaConverter.to_unicode(real_tripartite_key)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        return self


class QueryDeviceDetailResponseBodyData(TeaModel):
    def __init__(self, iot_id=None, product_key=None, product_name=None, device_name=None, device_secret=None,
                 firmware_version=None, gmt_create=None, utc_create=None, gmt_active=None, utc_active=None, gmt_online=None,
                 utc_online=None, status=None, ip_address=None, node_type=None, region=None, owner=None, nickname=None):
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.product_name = TeaConverter.to_unicode(product_name)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.device_secret = TeaConverter.to_unicode(device_secret)  # type: unicode
        self.firmware_version = TeaConverter.to_unicode(firmware_version)  # type: unicode
        self.gmt_create = TeaConverter.to_unicode(gmt_create)  # type: unicode
        self.utc_create = TeaConverter.to_unicode(utc_create)  # type: unicode
        self.gmt_active = TeaConverter.to_unicode(gmt_active)  # type: unicode
        self.utc_active = TeaConverter.to_unicode(utc_active)  # type: unicode
        self.gmt_online = TeaConverter.to_unicode(gmt_online)  # type: unicode
        self.utc_online = TeaConverter.to_unicode(utc_online)  # type: unicode
        self.status = TeaConverter.to_unicode(status)  # type: unicode
        self.ip_address = TeaConverter.to_unicode(ip_address)  # type: unicode
        self.node_type = node_type  # type: int
        self.region = TeaConverter.to_unicode(region)  # type: unicode
        self.owner = owner  # type: bool
        self.nickname = TeaConverter.to_unicode(nickname)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.device_secret is not None:
            result['DeviceSecret'] = self.device_secret
        if self.firmware_version is not None:
            result['FirmwareVersion'] = self.firmware_version
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.gmt_active is not None:
            result['GmtActive'] = self.gmt_active
        if self.utc_active is not None:
            result['UtcActive'] = self.utc_active
        if self.gmt_online is not None:
            result['GmtOnline'] = self.gmt_online
        if self.utc_online is not None:
            result['UtcOnline'] = self.utc_online
        if self.status is not None:
            result['Status'] = self.status
        if self.ip_address is not None:
            result['IpAddress'] = self.ip_address
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.region is not None:
            result['Region'] = self.region
        if self.owner is not None:
            result['Owner'] = self.owner
        if self.nickname is not None:
            result['Nickname'] = self.nickname
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('DeviceSecret') is not None:
            self.device_secret = m.get('DeviceSecret')
        if m.get('FirmwareVersion') is not None:
            self.firmware_version = m.get('FirmwareVersion')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('GmtActive') is not None:
            self.gmt_active = m.get('GmtActive')
        if m.get('UtcActive') is not None:
            self.utc_active = m.get('UtcActive')
        if m.get('GmtOnline') is not None:
            self.gmt_online = m.get('GmtOnline')
        if m.get('UtcOnline') is not None:
            self.utc_online = m.get('UtcOnline')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('IpAddress') is not None:
            self.ip_address = m.get('IpAddress')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Owner') is not None:
            self.owner = m.get('Owner')
        if m.get('Nickname') is not None:
            self.nickname = m.get('Nickname')
        return self


class QueryDeviceDetailResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: QueryDeviceDetailResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryDeviceDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceDetailResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: QueryDeviceDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceEventDataRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, page_size=None, product_key=None,
                 device_name=None, start_time=None, identifier=None, event_type=None, asc=None, iot_id=None, end_time=None,
                 real_tenant_id=None, real_tripartite_key=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.page_size = page_size  # type: int
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.start_time = start_time  # type: long
        self.identifier = TeaConverter.to_unicode(identifier)  # type: unicode
        self.event_type = TeaConverter.to_unicode(event_type)  # type: unicode
        self.asc = asc  # type: int
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.end_time = end_time  # type: long
        self.real_tenant_id = TeaConverter.to_unicode(real_tenant_id)  # type: unicode
        self.real_tripartite_key = TeaConverter.to_unicode(real_tripartite_key)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.asc is not None:
            result['Asc'] = self.asc
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('Asc') is not None:
            self.asc = m.get('Asc')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        return self


class QueryDeviceEventDataResponseBodyDataListEventInfo(TeaModel):
    def __init__(self, time=None, identifier=None, name=None, event_type=None, output_data=None):
        self.time = TeaConverter.to_unicode(time)  # type: unicode
        self.identifier = TeaConverter.to_unicode(identifier)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.event_type = TeaConverter.to_unicode(event_type)  # type: unicode
        self.output_data = TeaConverter.to_unicode(output_data)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.time is not None:
            result['Time'] = self.time
        if self.identifier is not None:
            result['Identifier'] = self.identifier
        if self.name is not None:
            result['Name'] = self.name
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.output_data is not None:
            result['OutputData'] = self.output_data
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('Identifier') is not None:
            self.identifier = m.get('Identifier')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('OutputData') is not None:
            self.output_data = m.get('OutputData')
        return self


class QueryDeviceEventDataResponseBodyDataList(TeaModel):
    def __init__(self, event_info=None):
        self.event_info = event_info  # type: list[QueryDeviceEventDataResponseBodyDataListEventInfo]

    def validate(self):
        if self.event_info:
            for k in self.event_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['EventInfo'] = []
        if self.event_info is not None:
            for k in self.event_info:
                result['EventInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.event_info = []
        if m.get('EventInfo') is not None:
            for k in m.get('EventInfo'):
                temp_model = QueryDeviceEventDataResponseBodyDataListEventInfo()
                self.event_info.append(temp_model.from_map(k))
        return self


class QueryDeviceEventDataResponseBodyData(TeaModel):
    def __init__(self, next_time=None, next_valid=None, list=None):
        self.next_time = next_time  # type: long
        self.next_valid = next_valid  # type: bool
        self.list = list  # type: QueryDeviceEventDataResponseBodyDataList

    def validate(self):
        if self.list:
            self.list.validate()

    def to_map(self):
        result = dict()
        if self.next_time is not None:
            result['NextTime'] = self.next_time
        if self.next_valid is not None:
            result['NextValid'] = self.next_valid
        if self.list is not None:
            result['List'] = self.list.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NextTime') is not None:
            self.next_time = m.get('NextTime')
        if m.get('NextValid') is not None:
            self.next_valid = m.get('NextValid')
        if m.get('List') is not None:
            temp_model = QueryDeviceEventDataResponseBodyDataList()
            self.list = temp_model.from_map(m['List'])
        return self


class QueryDeviceEventDataResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: QueryDeviceEventDataResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryDeviceEventDataResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceEventDataResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: QueryDeviceEventDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceEventDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceFileRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, product_key=None,
                 device_name=None, iot_id=None, file_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.file_id = TeaConverter.to_unicode(file_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.file_id is not None:
            result['FileId'] = self.file_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        return self


class QueryDeviceFileResponseBodyData(TeaModel):
    def __init__(self, file_id=None, name=None, size=None, utc_created_on=None, download_url=None):
        self.file_id = TeaConverter.to_unicode(file_id)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.size = TeaConverter.to_unicode(size)  # type: unicode
        self.utc_created_on = TeaConverter.to_unicode(utc_created_on)  # type: unicode
        self.download_url = TeaConverter.to_unicode(download_url)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.name is not None:
            result['Name'] = self.name
        if self.size is not None:
            result['Size'] = self.size
        if self.utc_created_on is not None:
            result['UtcCreatedOn'] = self.utc_created_on
        if self.download_url is not None:
            result['DownloadUrl'] = self.download_url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('UtcCreatedOn') is not None:
            self.utc_created_on = m.get('UtcCreatedOn')
        if m.get('DownloadUrl') is not None:
            self.download_url = m.get('DownloadUrl')
        return self


class QueryDeviceFileResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: QueryDeviceFileResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryDeviceFileResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceFileResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: QueryDeviceFileResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceFileResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceFileListRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, page_size=None, product_key=None,
                 device_name=None, iot_id=None, current_page=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.page_size = page_size  # type: int
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode
        self.iot_id = TeaConverter.to_unicode(iot_id)  # type: unicode
        self.current_page = current_page  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        if self.iot_id is not None:
            result['IotId'] = self.iot_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        if m.get('IotId') is not None:
            self.iot_id = m.get('IotId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class QueryDeviceFileListResponseBodyDataFileSummary(TeaModel):
    def __init__(self, file_id=None, name=None, size=None, utc_created_on=None):
        self.file_id = TeaConverter.to_unicode(file_id)  # type: unicode
        self.name = TeaConverter.to_unicode(name)  # type: unicode
        self.size = TeaConverter.to_unicode(size)  # type: unicode
        self.utc_created_on = TeaConverter.to_unicode(utc_created_on)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.file_id is not None:
            result['FileId'] = self.file_id
        if self.name is not None:
            result['Name'] = self.name
        if self.size is not None:
            result['Size'] = self.size
        if self.utc_created_on is not None:
            result['UtcCreatedOn'] = self.utc_created_on
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FileId') is not None:
            self.file_id = m.get('FileId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('UtcCreatedOn') is not None:
            self.utc_created_on = m.get('UtcCreatedOn')
        return self


class QueryDeviceFileListResponseBodyData(TeaModel):
    def __init__(self, file_summary=None):
        self.file_summary = file_summary  # type: list[QueryDeviceFileListResponseBodyDataFileSummary]

    def validate(self):
        if self.file_summary:
            for k in self.file_summary:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['FileSummary'] = []
        if self.file_summary is not None:
            for k in self.file_summary:
                result['FileSummary'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.file_summary = []
        if m.get('FileSummary') is not None:
            for k in m.get('FileSummary'):
                temp_model = QueryDeviceFileListResponseBodyDataFileSummary()
                self.file_summary.append(temp_model.from_map(k))
        return self


class QueryDeviceFileListResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, current_page=None,
                 page_count=None, page_size=None, total=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.current_page = current_page  # type: int
        self.page_count = page_count  # type: int
        self.page_size = page_size  # type: int
        self.total = total  # type: int
        self.data = data  # type: QueryDeviceFileListResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total is not None:
            result['Total'] = self.total
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Data') is not None:
            temp_model = QueryDeviceFileListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceFileListResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: QueryDeviceFileListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceFileListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceGroupByDeviceRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, product_key=None,
                 device_name=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.product_key = TeaConverter.to_unicode(product_key)  # type: unicode
        self.device_name = TeaConverter.to_unicode(device_name)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.product_key is not None:
            result['ProductKey'] = self.product_key
        if self.device_name is not None:
            result['DeviceName'] = self.device_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('ProductKey') is not None:
            self.product_key = m.get('ProductKey')
        if m.get('DeviceName') is not None:
            self.device_name = m.get('DeviceName')
        return self


class QueryDeviceGroupByDeviceResponseBodyGroupInfosGroupInfo(TeaModel):
    def __init__(self, group_id=None, group_name=None, utc_create=None, group_desc=None):
        self.group_id = TeaConverter.to_unicode(group_id)  # type: unicode
        self.group_name = TeaConverter.to_unicode(group_name)  # type: unicode
        self.utc_create = TeaConverter.to_unicode(utc_create)  # type: unicode
        self.group_desc = TeaConverter.to_unicode(group_desc)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.group_desc is not None:
            result['GroupDesc'] = self.group_desc
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('GroupDesc') is not None:
            self.group_desc = m.get('GroupDesc')
        return self


class QueryDeviceGroupByDeviceResponseBodyGroupInfos(TeaModel):
    def __init__(self, group_info=None):
        self.group_info = group_info  # type: list[QueryDeviceGroupByDeviceResponseBodyGroupInfosGroupInfo]

    def validate(self):
        if self.group_info:
            for k in self.group_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['GroupInfo'] = []
        if self.group_info is not None:
            for k in self.group_info:
                result['GroupInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.group_info = []
        if m.get('GroupInfo') is not None:
            for k in m.get('GroupInfo'):
                temp_model = QueryDeviceGroupByDeviceResponseBodyGroupInfosGroupInfo()
                self.group_info.append(temp_model.from_map(k))
        return self


class QueryDeviceGroupByDeviceResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, group_infos=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.group_infos = group_infos  # type: QueryDeviceGroupByDeviceResponseBodyGroupInfos

    def validate(self):
        if self.group_infos:
            self.group_infos.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.group_infos is not None:
            result['GroupInfos'] = self.group_infos.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('GroupInfos') is not None:
            temp_model = QueryDeviceGroupByDeviceResponseBodyGroupInfos()
            self.group_infos = temp_model.from_map(m['GroupInfos'])
        return self


class QueryDeviceGroupByDeviceResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: QueryDeviceGroupByDeviceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceGroupByDeviceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceGroupByTagsRequestTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = TeaConverter.to_unicode(tag_key)  # type: unicode
        self.tag_value = TeaConverter.to_unicode(tag_value)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class QueryDeviceGroupByTagsRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, tag=None, current_page=None,
                 page_size=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.tag = tag  # type: list[QueryDeviceGroupByTagsRequestTag]
        self.current_page = current_page  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = QueryDeviceGroupByTagsRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class QueryDeviceGroupByTagsResponseBodyDataDeviceGroup(TeaModel):
    def __init__(self, group_id=None, group_name=None):
        self.group_id = TeaConverter.to_unicode(group_id)  # type: unicode
        self.group_name = TeaConverter.to_unicode(group_name)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class QueryDeviceGroupByTagsResponseBodyData(TeaModel):
    def __init__(self, device_group=None):
        self.device_group = device_group  # type: list[QueryDeviceGroupByTagsResponseBodyDataDeviceGroup]

    def validate(self):
        if self.device_group:
            for k in self.device_group:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['DeviceGroup'] = []
        if self.device_group is not None:
            for k in self.device_group:
                result['DeviceGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.device_group = []
        if m.get('DeviceGroup') is not None:
            for k in m.get('DeviceGroup'):
                temp_model = QueryDeviceGroupByTagsResponseBodyDataDeviceGroup()
                self.device_group.append(temp_model.from_map(k))
        return self


class QueryDeviceGroupByTagsResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, page=None, page_size=None,
                 page_count=None, total=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.page = page  # type: int
        self.page_size = page_size  # type: int
        self.page_count = page_count  # type: int
        self.total = total  # type: int
        self.data = data  # type: QueryDeviceGroupByTagsResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.total is not None:
            result['Total'] = self.total
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Data') is not None:
            temp_model = QueryDeviceGroupByTagsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceGroupByTagsResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: QueryDeviceGroupByTagsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceGroupByTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceGroupInfoRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, group_id=None,
                 real_tenant_id=None, real_tripartite_key=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.group_id = TeaConverter.to_unicode(group_id)  # type: unicode
        self.real_tenant_id = TeaConverter.to_unicode(real_tenant_id)  # type: unicode
        self.real_tripartite_key = TeaConverter.to_unicode(real_tripartite_key)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.real_tenant_id is not None:
            result['RealTenantId'] = self.real_tenant_id
        if self.real_tripartite_key is not None:
            result['RealTripartiteKey'] = self.real_tripartite_key
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('RealTenantId') is not None:
            self.real_tenant_id = m.get('RealTenantId')
        if m.get('RealTripartiteKey') is not None:
            self.real_tripartite_key = m.get('RealTripartiteKey')
        return self


class QueryDeviceGroupInfoResponseBodyData(TeaModel):
    def __init__(self, group_id=None, utc_create=None, group_name=None, group_desc=None, device_count=None,
                 device_active=None, device_online=None):
        self.group_id = TeaConverter.to_unicode(group_id)  # type: unicode
        self.utc_create = TeaConverter.to_unicode(utc_create)  # type: unicode
        self.group_name = TeaConverter.to_unicode(group_name)  # type: unicode
        self.group_desc = TeaConverter.to_unicode(group_desc)  # type: unicode
        self.device_count = device_count  # type: int
        self.device_active = device_active  # type: int
        self.device_online = device_online  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.group_desc is not None:
            result['GroupDesc'] = self.group_desc
        if self.device_count is not None:
            result['DeviceCount'] = self.device_count
        if self.device_active is not None:
            result['DeviceActive'] = self.device_active
        if self.device_online is not None:
            result['DeviceOnline'] = self.device_online
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('GroupDesc') is not None:
            self.group_desc = m.get('GroupDesc')
        if m.get('DeviceCount') is not None:
            self.device_count = m.get('DeviceCount')
        if m.get('DeviceActive') is not None:
            self.device_active = m.get('DeviceActive')
        if m.get('DeviceOnline') is not None:
            self.device_online = m.get('DeviceOnline')
        return self


class QueryDeviceGroupInfoResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: QueryDeviceGroupInfoResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryDeviceGroupInfoResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceGroupInfoResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: QueryDeviceGroupInfoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceGroupInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceGroupListRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, page_size=None,
                 super_group_id=None, group_name=None, current_page=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.page_size = page_size  # type: int
        self.super_group_id = TeaConverter.to_unicode(super_group_id)  # type: unicode
        self.group_name = TeaConverter.to_unicode(group_name)  # type: unicode
        self.current_page = current_page  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.super_group_id is not None:
            result['SuperGroupId'] = self.super_group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SuperGroupId') is not None:
            self.super_group_id = m.get('SuperGroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class QueryDeviceGroupListResponseBodyDataGroupInfo(TeaModel):
    def __init__(self, group_id=None, utc_create=None, group_name=None, group_desc=None):
        self.group_id = TeaConverter.to_unicode(group_id)  # type: unicode
        self.utc_create = TeaConverter.to_unicode(utc_create)  # type: unicode
        self.group_name = TeaConverter.to_unicode(group_name)  # type: unicode
        self.group_desc = TeaConverter.to_unicode(group_desc)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.utc_create is not None:
            result['UtcCreate'] = self.utc_create
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.group_desc is not None:
            result['GroupDesc'] = self.group_desc
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('UtcCreate') is not None:
            self.utc_create = m.get('UtcCreate')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('GroupDesc') is not None:
            self.group_desc = m.get('GroupDesc')
        return self


class QueryDeviceGroupListResponseBodyData(TeaModel):
    def __init__(self, group_info=None):
        self.group_info = group_info  # type: list[QueryDeviceGroupListResponseBodyDataGroupInfo]

    def validate(self):
        if self.group_info:
            for k in self.group_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['GroupInfo'] = []
        if self.group_info is not None:
            for k in self.group_info:
                result['GroupInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.group_info = []
        if m.get('GroupInfo') is not None:
            for k in m.get('GroupInfo'):
                temp_model = QueryDeviceGroupListResponseBodyDataGroupInfo()
                self.group_info.append(temp_model.from_map(k))
        return self


class QueryDeviceGroupListResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, current_page=None,
                 page_count=None, page_size=None, total=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.current_page = current_page  # type: int
        self.page_count = page_count  # type: int
        self.page_size = page_size  # type: int
        self.total = total  # type: int
        self.data = data  # type: QueryDeviceGroupListResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total is not None:
            result['Total'] = self.total
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Data') is not None:
            temp_model = QueryDeviceGroupListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceGroupListResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: QueryDeviceGroupListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceGroupListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceGroupTagListRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, group_id=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.group_id = TeaConverter.to_unicode(group_id)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        return self


class QueryDeviceGroupTagListResponseBodyDataGroupTagInfo(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = TeaConverter.to_unicode(tag_key)  # type: unicode
        self.tag_value = TeaConverter.to_unicode(tag_value)  # type: unicode

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class QueryDeviceGroupTagListResponseBodyData(TeaModel):
    def __init__(self, group_tag_info=None):
        self.group_tag_info = group_tag_info  # type: list[QueryDeviceGroupTagListResponseBodyDataGroupTagInfo]

    def validate(self):
        if self.group_tag_info:
            for k in self.group_tag_info:
                if k:
                    k.validate()

    def to_map(self):
        result = dict()
        result['GroupTagInfo'] = []
        if self.group_tag_info is not None:
            for k in self.group_tag_info:
                result['GroupTagInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.group_tag_info = []
        if m.get('GroupTagInfo') is not None:
            for k in m.get('GroupTagInfo'):
                temp_model = QueryDeviceGroupTagListResponseBodyDataGroupTagInfo()
                self.group_tag_info.append(temp_model.from_map(k))
        return self


class QueryDeviceGroupTagListResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None, code=None, error_message=None, data=None):
        self.request_id = TeaConverter.to_unicode(request_id)  # type: unicode
        self.success = success  # type: bool
        self.code = TeaConverter.to_unicode(code)  # type: unicode
        self.error_message = TeaConverter.to_unicode(error_message)  # type: unicode
        self.data = data  # type: QueryDeviceGroupTagListResponseBodyData

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.code is not None:
            result['Code'] = self.code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.data is not None:
            result['Data'] = self.data.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Data') is not None:
            temp_model = QueryDeviceGroupTagListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        return self


class QueryDeviceGroupTagListResponse(TeaModel):
    def __init__(self, headers=None, body=None):
        self.headers = headers  # type: dict[unicode, unicode]
        self.body = body  # type: QueryDeviceGroupTagListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = QueryDeviceGroupTagListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDeviceListByDeviceGroupRequest(TeaModel):
    def __init__(self, api_product=None, api_revision=None, iot_instance_id=None, group_id=None, page_size=None,
                 current_page=None):
        self.api_product = TeaConverter.to_unicode(api_product)  # type: unicode
        self.api_revision = TeaConverter.to_unicode(api_revision)  # type: unicode
        self.iot_instance_id = TeaConverter.to_unicode(iot_instance_id)  # type: unicode
        self.group_id = TeaConverter.to_unicode(group_id)  # type: unicode
        self.page_size = page_size  # type: int
        self.current_page = current_page  # type: int

    def validate(self):
        pass

    def to_map(self):
        result = dict()
        if self.api_product is not None:
            result['ApiProduct'] = self.api_product
        if self.api_revision is not None:
            result['ApiRevision'] = self.api_revision
        if self.iot_instance_id is not None:
            result['IotInstanceId'] = self.iot_instance_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ApiProduct') is not None:
            self.api_product = m.get('ApiProduct')
        if m.get('ApiRevision') is not None:
            self.api_revision = m.get('ApiRevision')
        if m.get('IotInstanceId') is not None:
            self.iot_instance_id = m.get('IotInstanceId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        return self


class QueryDeviceListByDeviceGroupResponseBodyDataSimpleDeviceInfo(TeaModel):
    def __init__(self, product_name=None, product_key=None, device_name=None, iot_id=None):
        sel