"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setupSmithyBuild = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const path = require("path");
const smithy_build_project_1 = require("./smithy-build-project");
/**
 * Adds the common subprojects for building a Smithy model into an OpenAPI spec
 */
const setupSmithyBuild = (project, options) => {
    const { serviceName } = options.serviceName;
    const smithyBuildDir = "smithy";
    const smithyBuildOutputSubDir = "output";
    // Create the smithy build project, responsible for transforming the model into an OpenAPI spec
    const smithyBuild = new smithy_build_project_1.SmithyBuildProject({
        name: `${project.name}-smithy-build`,
        parent: project,
        outdir: smithyBuildDir,
        serviceName: options.serviceName,
        smithyBuildOptions: options.smithyBuildOptions,
        buildOutputDir: smithyBuildOutputSubDir,
    });
    smithyBuild.synth();
    const smithyBuildOutputDir = path.join(smithyBuildDir, smithyBuildOutputSubDir);
    // Ignore smithy build output by default
    if (options.ignoreSmithyBuildOutput ?? true) {
        project.gitignore.addPatterns(smithyBuildOutputDir);
    }
    // Ignore gradle wrapper by default
    if (options.ignoreGradleWrapper ?? true) {
        project.gitignore.addPatterns(path.join(smithyBuildDir, "gradle"));
        project.gitignore.addPatterns(path.join(smithyBuildDir, "gradlew"));
        project.gitignore.addPatterns(path.join(smithyBuildDir, "gradlew.bat"));
    }
    // Ignore the .gradle directory
    project.gitignore.addPatterns(path.join(smithyBuildDir, ".gradle"));
    project.gitignore.addPatterns(path.join(smithyBuildDir, "build"));
    return {
        // Generated spec is written to output/<projection id>/<plugin id>/<service name>.openapi.json
        generatedSpecFilePath: path.join(smithyBuild.smithyBuildOutputPath, "openapi", "openapi", `${serviceName}.openapi.json`),
    };
};
exports.setupSmithyBuild = setupSmithyBuild;
//# sourceMappingURL=data:application/json;base64,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