"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SmithyGeneratedOutput = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const projen_1 = require("projen");
const util_1 = require("projen/lib/util");
/**
 * Component for parsing the yaml OpenAPI spec as a single json object, resolving references etc.
 */
class SmithyGeneratedOutput extends projen_1.Component {
    constructor(project, options) {
        super(project);
        this.options = options;
    }
    synthesize() {
        super.synthesize();
        const { smithyBuildConfigPath, modelPath, outputPath, gradleProjectPath } = this.options;
        // Run smithy generation
        (0, util_1.exec)(`./gradlew -p ${gradleProjectPath} generate -Pconfig=${smithyBuildConfigPath} -Pdiscover=${modelPath} -Poutput=${outputPath}`, {
            cwd: gradleProjectPath,
        });
    }
}
exports.SmithyGeneratedOutput = SmithyGeneratedOutput;
//# sourceMappingURL=data:application/json;base64,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