/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
import { TypeScriptProjectOptions } from "projen/lib/typescript";
import { OpenApiGatewayTsProject, OpenApiGatewayTsProjectOptions } from "./open-api-gateway-ts-project";
import { SmithyApiGatewayProjectOptions } from "./types";
/**
 * Configuration for the SmithyApiGatewayTsProject
 */
export interface SmithyApiGatewayTsProjectOptions extends TypeScriptProjectOptions, SmithyApiGatewayProjectOptions {
}
/**
 * Synthesizes a Typescript Project with a Smithy model, generated clients, a CDK construct for deploying the API
 * with API Gateway, and generated lambda handler wrappers for type-safe handling of requests.
 *
 * @pjid smithy-api-gateway-ts
 * @deprecated Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.
 */
export declare class SmithyApiGatewayTsProject extends OpenApiGatewayTsProject {
    constructor(options: SmithyApiGatewayTsProjectOptions);
    protected preConstruct(options: OpenApiGatewayTsProjectOptions): OpenApiGatewayTsProjectOptions;
}
