/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
import { PythonProjectOptions } from "projen/lib/python";
import { OpenApiGatewayPythonProject, OpenApiGatewayPythonProjectOptions } from "./open-api-gateway-python-project";
import { SmithyApiGatewayProjectOptions } from "./types";
/**
 * Configuration for the SmithyApiGatewayPythonProject
 */
export interface SmithyApiGatewayPythonProjectOptions extends PythonProjectOptions, SmithyApiGatewayProjectOptions {
}
/**
 * Synthesizes a Python Project with a Smithy model, generated clients, a CDK construct for deploying the API
 * with API Gateway, and generated lambda handler wrappers for type-safe handling of requests.
 *
 * @pjid smithy-api-gateway-py
 * @deprecated Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.
 */
export declare class SmithyApiGatewayPythonProject extends OpenApiGatewayPythonProject {
    constructor(options: SmithyApiGatewayPythonProjectOptions);
    protected preConstruct(options: OpenApiGatewayPythonProjectOptions): OpenApiGatewayPythonProjectOptions;
}
