import { Project, YamlFile } from "projen";
import { TypeScriptProject, TypeScriptProjectOptions } from "projen/lib/typescript";
import { OpenApiGatewayProjectOptions } from "./types";
/**
 * Configuration for the OpenApiGatewayTsProject
 */
export interface OpenApiGatewayTsProjectOptions extends TypeScriptProjectOptions, OpenApiGatewayProjectOptions {
}
/**
 * Synthesizes a Typescript Project with an OpenAPI spec, generated clients, a CDK construct for deploying the API
 * with API Gateway, and generated lambda handler wrappers for type-safe handling of requests.
 *
 * @pjid open-api-gateway-ts
 * @deprecated Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.
 */
export declare class OpenApiGatewayTsProject extends TypeScriptProject {
    /**
     * A reference to the generated typescript client
     */
    readonly generatedTypescriptClient: TypeScriptProject;
    /**
     * References to the client projects that were generated, keyed by language
     */
    readonly generatedClients: {
        [language: string]: Project;
    };
    /**
     * The directory in which the OpenAPI spec file(s) reside, relative to the project srcdir
     */
    readonly specDir: string;
    /**
     * The directory in which the api generated code will reside, relative to the project srcdir
     */
    readonly apiSrcDir: string;
    /**
     * The name of the spec file
     */
    readonly specFileName: string;
    /**
     * The directory in which generated client code will be generated, relative to the outdir of this project
     */
    readonly generatedCodeDir: string;
    /**
     * Force to generate code and docs even if there were no changes in spec
     */
    readonly forceGenerateCodeAndDocs: boolean;
    /**
     * Reference to the PNPM workspace yaml file which adds the dependency between this project and the generated
     * typescript client when this project is used in a monorepo, and the package manager is PNPM.
     */
    readonly pnpmWorkspace?: YamlFile;
    private readonly hasParent;
    constructor(projectOptions: OpenApiGatewayTsProjectOptions);
    /**
     * This method provides inheritors a chance to synthesize extra resources prior to those created by this project.
     * Return any options you wish to change, other than typescript project options.
     */
    protected preConstruct(options: OpenApiGatewayTsProjectOptions): OpenApiGatewayTsProjectOptions;
    /**
     * @inheritDoc
     */
    preSynthesize(): void;
    /**
     * @inheritDoc
     */
    postSynthesize(): void;
    /**
     * Executes commands to link the native (ie typescript) client such that updates to the generated client are reflected
     * in this project's node_modules (when not managed by a monorepo)
     * @private
     */
    private executeLinkNativeClientCommands;
}
