import { Project } from "projen";
import { PythonProject, PythonProjectOptions } from "projen/lib/python";
import { OpenApiGatewayProjectOptions } from "./types";
/**
 * Configuration for the OpenApiGatewayPythonProject
 */
export interface OpenApiGatewayPythonProjectOptions extends PythonProjectOptions, OpenApiGatewayProjectOptions {
}
/**
 * Synthesizes a Python Project with an OpenAPI spec, generated clients, a CDK construct for deploying the API
 * with API Gateway, and generated lambda handler wrappers for type-safe handling of requests.
 *
 * @pjid open-api-gateway-py
 * @deprecated Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.
 */
export declare class OpenApiGatewayPythonProject extends PythonProject {
    /**
     * A reference to the generated python client
     */
    readonly generatedPythonClient: PythonProject;
    /**
     * References to the client projects that were generated, keyed by language
     */
    readonly generatedClients: {
        [language: string]: Project;
    };
    /**
     * The directory in which the OpenAPI spec file(s) reside, relative to the project srcdir
     */
    readonly specDir: string;
    /**
     * The directory in which the api generated code will reside, relative to the project srcdir
     */
    readonly apiSrcDir: string;
    /**
     * The name of the spec file
     */
    readonly specFileName: string;
    /**
     * The directory in which generated client code will be generated, relative to the outdir of this project
     */
    readonly generatedCodeDir: string;
    /**
     * Force to generate code and docs even if there were no changes in spec
     */
    readonly forceGenerateCodeAndDocs?: boolean;
    private readonly hasParent;
    constructor(projectOptions: OpenApiGatewayPythonProjectOptions);
    /**
     * This method provides inheritors a chance to synthesize extra resources prior to those created by this project.
     * Return any options you wish to change, other than python project options.
     */
    protected preConstruct(options: OpenApiGatewayPythonProjectOptions): OpenApiGatewayPythonProjectOptions;
}
