import { Project } from "projen";
import { JavaProject, JavaProjectOptions } from "projen/lib/java";
import { OpenApiGatewayProjectOptions } from "./types";
/**
 * Configuration for the OpenApiGatewayJavaProject
 */
export interface OpenApiGatewayJavaProjectOptions extends JavaProjectOptions, OpenApiGatewayProjectOptions {
}
/**
 * Synthesizes a Java Project with an OpenAPI spec, generated clients, a CDK construct for deploying the API
 * with API Gateway, and generated lambda handler wrappers for type-safe handling of requests.
 *
 * @pjid open-api-gateway-java
 * @deprecated Please use TypeSafeApiProject instead. This will be removed in the PDK GA 1.0 release.
 */
export declare class OpenApiGatewayJavaProject extends JavaProject {
    /**
     * A reference to the generated java client
     */
    readonly generatedJavaClient: JavaProject;
    /**
     * References to the client projects that were generated, keyed by language
     */
    readonly generatedClients: {
        [language: string]: Project;
    };
    /**
     * The directory in which the OpenAPI spec file(s) reside, relative to the project srcdir
     */
    readonly specDir: string;
    /**
     * The directory in which the api generated code will reside, relative to the project srcdir. This will also be used
     * as the package for the api project.
     */
    readonly apiSrcDir: string;
    /**
     * The name of the spec file
     */
    readonly specFileName: string;
    /**
     * The directory in which generated client code will be generated, relative to the outdir of this project
     */
    readonly generatedCodeDir: string;
    /**
     * Force to generate code and docs even if there were no changes in spec
     */
    readonly forceGenerateCodeAndDocs?: boolean;
    private readonly hasParent;
    constructor(projectOptions: OpenApiGatewayJavaProjectOptions);
    /**
     * This method provides inheritors a chance to synthesize extra resources prior to those created by this project.
     * Return any options you wish to change, other than java project options.
     */
    protected preConstruct(options: OpenApiGatewayJavaProjectOptions): OpenApiGatewayJavaProjectOptions;
}
