"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DocsProject = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const log4js_1 = require("log4js");
const projen_1 = require("projen");
const generated_html_redoc_docs_1 = require("./components/docs/generated-html-redoc-docs");
const generated_html2_docs_1 = require("./components/docs/generated-html2-docs");
const generated_markdown_docs_1 = require("./components/docs/generated-markdown-docs");
const generated_plantuml_docs_1 = require("./components/docs/generated-plantuml-docs");
const languages_1 = require("../languages");
const logger = (0, log4js_1.getLogger)();
/**
 * Project containing generated OpenApi docs
 */
class DocsProject extends projen_1.Project {
    constructor(options) {
        super(options);
        // HACK: remove all components but the ones we are registering - removes .gitignore, tasks, etc since these are
        // unused and a distraction for end-users!
        // @ts-ignore
        this._components = [];
        // Generate docs in all specified formats
        options.formatConfigs.forEach((formatConfig) => {
            logger.trace(`${formatConfig.documentationFormat} :: generate = ${formatConfig.generate}`);
            if (formatConfig.generate) {
                this.generateDocs(formatConfig.documentationFormat, options.specPath);
            }
        });
    }
    /**
     * Generates the docs in the given format
     */
    generateDocs(format, specPath) {
        switch (format) {
            case languages_1.DocumentationFormat.HTML2:
                return new generated_html2_docs_1.GeneratedHtml2Docs(this, { specPath });
            case languages_1.DocumentationFormat.MARKDOWN:
                return new generated_markdown_docs_1.GeneratedMarkdownDocs(this, { specPath });
            case languages_1.DocumentationFormat.PLANTUML:
                return new generated_plantuml_docs_1.GeneratedPlantUmlDocs(this, { specPath });
            case languages_1.DocumentationFormat.HTML_REDOC:
                return new generated_html_redoc_docs_1.GeneratedHtmlRedocDocs(this, { specPath });
            default:
                throw new Error(`Unsupported documentation format ${format}`);
        }
    }
}
exports.DocsProject = DocsProject;
//# sourceMappingURL=data:application/json;base64,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