"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedTypescriptClientSourceCode = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const path = require("path");
const fs_extra_1 = require("fs-extra");
const log4js_1 = require("log4js");
const projen_1 = require("projen");
const utils_1 = require("./utils");
const languages_1 = require("../../languages");
const logger = (0, log4js_1.getLogger)();
/**
 * Generates the typescript client using OpenAPI Generator
 */
class GeneratedTypescriptClientSourceCode extends projen_1.Component {
    constructor(project, options) {
        super(project);
        this.options = options;
    }
    /**
     * @inheritDoc
     */
    synthesize() {
        super.synthesize();
        if (this.options.invokeGenerator) {
            // Generate the typescript client
            logger.debug("Generating typescript client...");
            (0, utils_1.invokeOpenApiGenerator)({
                generator: "typescript-fetch",
                specPath: this.options.specPath,
                outputPath: this.project.outdir,
                generatorDirectory: languages_1.ClientLanguage.TYPESCRIPT,
                additionalProperties: {
                    npmName: this.project.package.packageName,
                    typescriptThreePlus: "true",
                    useSingleParameter: "true",
                    supportsES6: "true",
                },
                srcDir: this.project.srcdir,
                normalizers: {
                    KEEP_ONLY_FIRST_TAG_IN_OPERATION: true,
                },
            });
            // Write an index.ts which exposes the additional generated file OperationConfig.ts, which contains handler wrappers
            // and other generated code used by the construct.
            (0, fs_extra_1.writeFileSync)(path.join(this.project.outdir, "src", "index.ts"), [
                "/* tslint:disable */",
                "/* eslint-disable */",
                "export * from './runtime';",
                "export * from './apis';",
                "export * from './models';",
                "export * from './apis/DefaultApi/OperationConfig';",
            ].join("\n"));
        }
    }
}
exports.GeneratedTypescriptClientSourceCode = GeneratedTypescriptClientSourceCode;
//# sourceMappingURL=data:application/json;base64,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