"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedPythonClientSourceCode = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const log4js_1 = require("log4js");
const projen_1 = require("projen");
const utils_1 = require("./utils");
const languages_1 = require("../../languages");
const logger = (0, log4js_1.getLogger)();
/**
 * Generates the python client using OpenAPI Generator
 */
class GeneratedPythonClientSourceCode extends projen_1.Component {
    constructor(project, options) {
        super(project);
        this.options = options;
    }
    /**
     * @inheritDoc
     */
    synthesize() {
        super.synthesize();
        if (this.options.invokeGenerator) {
            // Generate the python client
            logger.debug("Generating python client...");
            (0, utils_1.invokeOpenApiGenerator)({
                generator: "python",
                specPath: this.options.specPath,
                outputPath: this.project.outdir,
                generatorDirectory: languages_1.ClientLanguage.PYTHON,
                additionalProperties: {
                    packageName: this.project.moduleName,
                    projectName: this.project.name,
                },
                // Tell the generator where python source files live
                srcDir: this.project.moduleName,
                normalizers: {
                    KEEP_ONLY_FIRST_TAG_IN_OPERATION: true,
                },
            });
        }
    }
}
exports.GeneratedPythonClientSourceCode = GeneratedPythonClientSourceCode;
//# sourceMappingURL=data:application/json;base64,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