"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedJavaClientSourceCode = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const path = require("path");
const log4js_1 = require("log4js");
const projen_1 = require("projen");
const utils_1 = require("./utils");
const languages_1 = require("../../languages");
const logger = (0, log4js_1.getLogger)();
/**
 * Generates the java client using OpenAPI Generator
 */
class GeneratedJavaClientSourceCode extends projen_1.Component {
    constructor(project, options) {
        super(project);
        this.options = options;
    }
    /**
     * @inheritDoc
     */
    synthesize() {
        super.synthesize();
        if (this.options.invokeGenerator) {
            const javaProject = this.project;
            const invokerPackage = `${javaProject.pom.groupId}.${javaProject.name}.client`;
            // Generate the java client
            logger.debug("Generating java client...");
            (0, utils_1.invokeOpenApiGenerator)({
                generator: "java",
                specPath: this.options.specPath,
                outputPath: this.project.outdir,
                generatorDirectory: languages_1.ClientLanguage.JAVA,
                additionalProperties: {
                    useSingleRequestParameter: "true",
                    groupId: javaProject.pom.groupId,
                    artifactId: javaProject.pom.artifactId,
                    artifactVersion: javaProject.pom.version,
                    invokerPackage,
                    apiPackage: `${invokerPackage}.api`,
                    modelPackage: `${invokerPackage}.model`,
                    hideGenerationTimestamp: "true",
                    additionalModelTypeAnnotations: [
                        "@lombok.AllArgsConstructor",
                        // Regular lombok builder is not used since an abstract base schema class is also annotated
                        "@lombok.experimental.SuperBuilder",
                    ].join("\\ "),
                },
                srcDir: path.join("src", "main", "java", ...invokerPackage.split(".")),
                normalizers: {
                    KEEP_ONLY_FIRST_TAG_IN_OPERATION: true,
                },
            });
        }
    }
}
exports.GeneratedJavaClientSourceCode = GeneratedJavaClientSourceCode;
//# sourceMappingURL=data:application/json;base64,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