"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedHtml2Docs = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const path = require("path");
const projen_1 = require("projen");
const utils_1 = require("../utils");
/**
 * Generates the html2 documentation using OpenAPI Generator
 */
class GeneratedHtml2Docs extends projen_1.Component {
    constructor(project, options) {
        super(project);
        this.options = options;
    }
    /**
     * @inheritDoc
     */
    synthesize() {
        super.synthesize();
        // Generate the html2 docs
        (0, utils_1.invokeOpenApiGenerator)({
            generator: "html2",
            specPath: this.options.specPath,
            outputPath: path.join(this.project.outdir, "html2"),
            generatorDirectory: utils_1.NonClientGeneratorDirectory.DOCS,
        });
    }
}
exports.GeneratedHtml2Docs = GeneratedHtml2Docs;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2VuZXJhdGVkLWh0bWwyLWRvY3MuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi9zcmMvcHJvamVjdC9jb2RlZ2VuL2NvbXBvbmVudHMvZG9jcy9nZW5lcmF0ZWQtaHRtbDItZG9jcy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQTtzQ0FDc0M7QUFDdEMsNkJBQTZCO0FBQzdCLG1DQUE0QztBQUM1QyxvQ0FBK0U7QUFZL0U7O0dBRUc7QUFDSCxNQUFhLGtCQUFtQixTQUFRLGtCQUFTO0lBRy9DLFlBQVksT0FBZ0IsRUFBRSxPQUFrQztRQUM5RCxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUM7UUFDZixJQUFJLENBQUMsT0FBTyxHQUFHLE9BQU8sQ0FBQztJQUN6QixDQUFDO0lBRUQ7O09BRUc7SUFDSCxVQUFVO1FBQ1IsS0FBSyxDQUFDLFVBQVUsRUFBRSxDQUFDO1FBRW5CLDBCQUEwQjtRQUMxQixJQUFBLDhCQUFzQixFQUFDO1lBQ3JCLFNBQVMsRUFBRSxPQUFPO1lBQ2xCLFFBQVEsRUFBRSxJQUFJLENBQUMsT0FBTyxDQUFDLFFBQVE7WUFDL0IsVUFBVSxFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxNQUFNLEVBQUUsT0FBTyxDQUFDO1lBQ25ELGtCQUFrQixFQUFFLG1DQUEyQixDQUFDLElBQUk7U0FDckQsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztDQUNGO0FBdEJELGdEQXNCQyIsInNvdXJjZXNDb250ZW50IjpbIi8qISBDb3B5cmlnaHQgW0FtYXpvbi5jb21dKGh0dHA6Ly9hbWF6b24uY29tLyksIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG5TUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMCAqL1xuaW1wb3J0ICogYXMgcGF0aCBmcm9tIFwicGF0aFwiO1xuaW1wb3J0IHsgQ29tcG9uZW50LCBQcm9qZWN0IH0gZnJvbSBcInByb2plblwiO1xuaW1wb3J0IHsgaW52b2tlT3BlbkFwaUdlbmVyYXRvciwgTm9uQ2xpZW50R2VuZXJhdG9yRGlyZWN0b3J5IH0gZnJvbSBcIi4uL3V0aWxzXCI7XG5cbi8qKlxuICogQ29uZmlndXJhdGlvbiBmb3IgdGhlIEdlbmVyYXRlZEh0bWwyRG9jcyBjb21wb25lbnRcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBHZW5lcmF0ZWRIdG1sMkRvY3NPcHRpb25zIHtcbiAgLyoqXG4gICAqIEFic29sdXRlIHBhdGggdG8gdGhlIE9wZW5BUEkgc3BlY2lmaWNhdGlvbiAoc3BlYy55YW1sKVxuICAgKi9cbiAgcmVhZG9ubHkgc3BlY1BhdGg6IHN0cmluZztcbn1cblxuLyoqXG4gKiBHZW5lcmF0ZXMgdGhlIGh0bWwyIGRvY3VtZW50YXRpb24gdXNpbmcgT3BlbkFQSSBHZW5lcmF0b3JcbiAqL1xuZXhwb3J0IGNsYXNzIEdlbmVyYXRlZEh0bWwyRG9jcyBleHRlbmRzIENvbXBvbmVudCB7XG4gIHByaXZhdGUgb3B0aW9uczogR2VuZXJhdGVkSHRtbDJEb2NzT3B0aW9ucztcblxuICBjb25zdHJ1Y3Rvcihwcm9qZWN0OiBQcm9qZWN0LCBvcHRpb25zOiBHZW5lcmF0ZWRIdG1sMkRvY3NPcHRpb25zKSB7XG4gICAgc3VwZXIocHJvamVjdCk7XG4gICAgdGhpcy5vcHRpb25zID0gb3B0aW9ucztcbiAgfVxuXG4gIC8qKlxuICAgKiBAaW5oZXJpdERvY1xuICAgKi9cbiAgc3ludGhlc2l6ZSgpIHtcbiAgICBzdXBlci5zeW50aGVzaXplKCk7XG5cbiAgICAvLyBHZW5lcmF0ZSB0aGUgaHRtbDIgZG9jc1xuICAgIGludm9rZU9wZW5BcGlHZW5lcmF0b3Ioe1xuICAgICAgZ2VuZXJhdG9yOiBcImh0bWwyXCIsXG4gICAgICBzcGVjUGF0aDogdGhpcy5vcHRpb25zLnNwZWNQYXRoLFxuICAgICAgb3V0cHV0UGF0aDogcGF0aC5qb2luKHRoaXMucHJvamVjdC5vdXRkaXIsIFwiaHRtbDJcIiksXG4gICAgICBnZW5lcmF0b3JEaXJlY3Rvcnk6IE5vbkNsaWVudEdlbmVyYXRvckRpcmVjdG9yeS5ET0NTLFxuICAgIH0pO1xuICB9XG59XG4iXX0=