"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedHtmlRedocDocs = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const path = require("path");
const projen_1 = require("projen");
const utils_1 = require("../utils");
/**
 * Generates html documentation using Redoc
 */
class GeneratedHtmlRedocDocs extends projen_1.Component {
    constructor(project, options) {
        super(project);
        this.options = options;
    }
    /**
     * @inheritDoc
     */
    synthesize() {
        super.synthesize();
        (0, utils_1.invokeCustomDocsGenerator)({
            generator: "html-redoc",
            args: `--spec-path ${this.options.specPath} --output-path ${path.join(this.project.outdir, "html_redoc", "index.html")}`,
        });
    }
}
exports.GeneratedHtmlRedocDocs = GeneratedHtmlRedocDocs;
//# sourceMappingURL=data:application/json;base64,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