"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getAuthorizerFunctions = void 0;
const api_gateway_auth_1 = require("./api-gateway-auth");
const predicates_1 = require("../authorizers/predicates");
/**
 * Return all lambda functions used as authorizers, labelled by authorizer id
 */
const getAuthorizerFunctions = (options) => (0, api_gateway_auth_1.getAllAuthorizers)(options.integrations, options.defaultAuthorizer)
    .filter((authorizer) => (0, predicates_1.isCustomAuthorizer)(authorizer))
    .map((authorizer) => ({
    label: authorizer.authorizerId,
    function: authorizer.function,
}));
exports.getAuthorizerFunctions = getAuthorizerFunctions;
//# sourceMappingURL=data:application/json;base64,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