"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isNoneAuthorizer = exports.isIamAuthorizer = exports.isCognitoAuthorizer = exports.isCustomAuthorizer = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const aws_apigateway_1 = require("aws-cdk-lib/aws-apigateway");
/**
 * Predicate for narrowing an authorizer to CustomAuthorizer
 */
const isCustomAuthorizer = (authorizer) => authorizer.authorizationType === aws_apigateway_1.AuthorizationType.CUSTOM;
exports.isCustomAuthorizer = isCustomAuthorizer;
/**
 * Predicate for narrowing an authorizer to CognitoAuthorizer
 */
const isCognitoAuthorizer = (authorizer) => authorizer.authorizationType === aws_apigateway_1.AuthorizationType.COGNITO;
exports.isCognitoAuthorizer = isCognitoAuthorizer;
/**
 * Predicate for narrowing an authorizer to IamAuthorizer
 */
const isIamAuthorizer = (authorizer) => authorizer.authorizationType === aws_apigateway_1.AuthorizationType.IAM;
exports.isIamAuthorizer = isIamAuthorizer;
/**
 * Predicate for narrowing an authorizer to NoneAuthorizer
 */
const isNoneAuthorizer = (authorizer) => authorizer.authorizationType === aws_apigateway_1.AuthorizationType.NONE;
exports.isNoneAuthorizer = isNoneAuthorizer;
//# sourceMappingURL=data:application/json;base64,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